/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MultiphaseRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = 5376322220596462295L;
    private final AffineFunction[] mRanking;
    private final int mPhases;

    public MultiphaseRankingFunction(AffineFunction[] affineFunctionArray) {
        this.mRanking = affineFunctionArray;
        this.mPhases = affineFunctionArray.length;
        assert (this.mPhases > 0);
    }

    @Override
    public String getName() {
        return this.mRanking.length + "-phase";
    }

    @Override
    public Set<IProgramVar> getVariables() {
        LinkedHashSet<IProgramVar> linkedHashSet = new LinkedHashSet<IProgramVar>();
        AffineFunction[] affineFunctionArray = this.mRanking;
        int n = this.mRanking.length;
        int n2 = 0;
        while (n2 < n) {
            AffineFunction affineFunction = affineFunctionArray[n2];
            linkedHashSet.addAll(affineFunction.getVariables());
            ++n2;
        }
        return linkedHashSet;
    }

    public AffineFunction[] getComponents() {
        return this.mRanking;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mRanking.length);
        stringBuilder.append("-phase ranking function:\n");
        int n = 0;
        while (n < this.mPhases) {
            stringBuilder.append("  f" + n);
            stringBuilder.append(" = ");
            stringBuilder.append(this.mRanking[n]);
            if (n < this.mPhases - 1) {
                stringBuilder.append("\n");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        BigInteger bigInteger = BigInteger.ZERO;
        Term term = SmtUtils.constructIntValue((Script)script, (BigInteger)bigInteger);
        Term term2 = this.mRanking[this.mRanking.length - 1].asTerm(script);
        int n = this.mRanking.length - 2;
        while (n >= 0) {
            bigInteger = bigInteger.add(BigInteger.ONE);
            Term term3 = this.mRanking[n].asTerm(script);
            Term term4 = script.term(">", new Term[]{term3, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
            term = script.term("ite", new Term[]{term4, SmtUtils.constructIntValue((Script)script, (BigInteger)bigInteger), term});
            term2 = script.term("ite", new Term[]{term4, term3, term2});
            --n;
        }
        return new Term[]{term, term2};
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> map) {
        Ordinal ordinal = Ordinal.ZERO;
        int n = 0;
        while (n < this.mPhases) {
            Rational rational = this.mRanking[n].evaluate(map);
            if (rational.compareTo(Rational.ZERO) > 0) {
                return ordinal.add(Ordinal.fromInteger(rational.ceil().numerator()));
            }
            ordinal = ordinal.add(Ordinal.OMEGA);
            ++n;
        }
        assert (false);
        return ordinal;
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.fromInteger(BigInteger.valueOf(this.mPhases)).mult(Ordinal.OMEGA);
    }
}

