/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;

public class CompareCode
implements ICode {
    private final EMatching mEMatching;
    private final int mFirstRegIndex;
    private final int mSecondRegIndex;
    private final ICode mRemainingCode;

    public CompareCode(EMatching eMatching, int n, int n2, ICode iCode) {
        this.mEMatching = eMatching;
        this.mFirstRegIndex = n;
        this.mSecondRegIndex = n2;
        this.mRemainingCode = iCode;
    }

    @Override
    public void execute(CCTerm[] cCTermArray, int n) {
        CCTerm cCTerm = cCTermArray[this.mFirstRegIndex];
        CCTerm cCTerm2 = cCTermArray[this.mSecondRegIndex];
        if (this.mEMatching.getQuantTheory().getCClosure().isEqSet(cCTerm, cCTerm2)) {
            int n2 = this.mEMatching.getQuantTheory().getCClosure().getDecideLevelForPath(cCTerm, cCTerm2);
            this.mEMatching.addCode(this.mRemainingCode, cCTermArray, n2 > n ? n2 : n);
        } else {
            this.mEMatching.installCompareTrigger(cCTerm, cCTerm2, this.mRemainingCode, cCTermArray, n);
        }
    }

    public String toString() {
        return "compare(r" + this.mFirstRegIndex + ", r" + this.mSecondRegIndex + ",\n" + this.mRemainingCode.toString() + ")";
    }
}

