/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Horn3Clause;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.IntArray;
import java.util.Iterator;

final class Horn3Array
implements Iterable<Horn3Clause> {
    private final int mNumVars;
    private final IntArray mAx;
    private final IntArray mAy;
    private final IntArray mAz;

    Horn3Array(int n) {
        this.mNumVars = n;
        this.mAx = new IntArray();
        this.mAy = new IntArray();
        this.mAz = new IntArray();
    }

    void add(int n, int n2, int n3) {
        assert (n >= 0 && n < this.mNumVars);
        assert (n2 >= 0 && n2 < this.mNumVars);
        assert (n3 >= 0 && n3 < this.mNumVars);
        this.mAx.add(n);
        this.mAy.add(n2);
        this.mAz.add(n3);
    }

    int size() {
        return this.mAx.size();
    }

    Horn3Clause get(int n, Horn3Clause horn3Clause) {
        if (n < 0 || n >= this.mAx.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        horn3Clause.mX = this.mAx.get(n);
        horn3Clause.mY = this.mAy.get(n);
        horn3Clause.mZ = this.mAz.get(n);
        return horn3Clause;
    }

    @Override
    public Iterator<Horn3Clause> iterator() {
        return new Horn3Iterator(this);
    }

    private static final class Horn3Iterator
    implements Iterator<Horn3Clause> {
        private final Horn3Clause mH3c;
        private final Horn3Array mH3a;
        private int mIdx;

        Horn3Iterator(Horn3Array horn3Array) {
            this.mH3a = horn3Array;
            this.mH3c = new Horn3Clause(-1, -1, -1);
            this.mIdx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.mIdx < this.mH3a.size();
        }

        @Override
        public Horn3Clause next() {
            this.mH3a.get(this.mIdx++, this.mH3c);
            return this.mH3c;
        }
    }
}

