/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.PetriNetUtils;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.ProjectToSubnet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.FinitePrefix;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ICoRelation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoveRedundantFlow<LETTER, PLACE, CRSF extends IStateFactory<PLACE> & IPetriNet2FiniteAutomatonStateFactory<PLACE>>
extends UnaryNetOperation<LETTER, PLACE, CRSF> {
    private static final boolean DEBUG_LOG_RESTRICTOR_INFORMATION = false;
    private static final boolean MOUNTAIN_COCK_HEURISTIC = false;
    private final IPetriNet<LETTER, PLACE> mOperand;
    private final FinitePrefix<LETTER, PLACE> mFinitePrefixOperation;
    private final BranchingProcess<LETTER, PLACE> mFinPre;
    private final HashRelation<Transition<LETTER, PLACE>, PLACE> mRedundantSelfloopFlow = new HashRelation();
    private final BoundedPetriNet<LETTER, PLACE> mResult;
    private final Set<PLACE> mRedundantPlaces;
    private final Set<PLACE> mEligibleRedundancyCandidates;
    private final Set<PLACE> mEligibleRestrictorCandidates;
    private int mRestrictorConditionChecks = 0;
    private final NestedMap2<PLACE, PLACE, Boolean> mRestrictorPlaceCache = new NestedMap2();
    private final Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> mInput2projected;

    public RemoveRedundantFlow(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        this(automataLibraryServices, iPetriNet, null, null, null);
    }

    public RemoveRedundantFlow(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet, BranchingProcess<LETTER, PLACE> branchingProcess, Set<PLACE> set, Set<PLACE> set2) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        super(automataLibraryServices);
        this.mOperand = iPetriNet;
        this.mEligibleRedundancyCandidates = set;
        this.mEligibleRestrictorCandidates = set2;
        this.printStartMessage();
        if (branchingProcess != null) {
            this.mFinitePrefixOperation = null;
            this.mFinPre = branchingProcess;
        } else {
            this.mFinitePrefixOperation = new FinitePrefix<LETTER, PLACE>(automataLibraryServices, iPetriNet);
            this.mFinPre = this.mFinitePrefixOperation.getResult();
        }
        HashRelation hashRelation = new HashRelation();
        for (Transition<LETTER, PLACE> transition : iPetriNet.getTransitions()) {
            for (Object e : transition.getPredecessors()) {
                boolean bl;
                if (!this.isEligibleRedundancyCandidate(e) || !(bl = this.isFlowRedundant(transition, e, hashRelation))) continue;
                hashRelation.addPair(transition, e);
                if (!transition.getSuccessors().contains(e)) continue;
                this.mRedundantSelfloopFlow.addPair(transition, e);
            }
        }
        this.mRedundantPlaces = iPetriNet.getPlaces().stream().filter(object -> this.isRedundantPlace(object, iPetriNet, hashRelation)).collect(Collectors.toSet());
        ProjectToSubnet<LETTER, PLACE> projectToSubnet = new ProjectToSubnet<LETTER, PLACE>(automataLibraryServices, iPetriNet, this.mRedundantSelfloopFlow, this.mRedundantPlaces);
        this.mInput2projected = projectToSubnet.getTransitionMapping();
        this.mResult = projectToSubnet.getResult();
        this.printExitMessage();
    }

    private boolean isEligibleRedundancyCandidate(PLACE PLACE) {
        return this.mEligibleRedundancyCandidates == null || this.mEligibleRedundancyCandidates.contains(PLACE);
    }

    private boolean isEligibleRestrictorCandidate(PLACE PLACE) {
        return this.mEligibleRestrictorCandidates == null || this.mEligibleRestrictorCandidates.contains(PLACE);
    }

    private boolean isRedundantPlace(PLACE PLACE, IPetriNet<LETTER, PLACE> iPetriNet, HashRelation<Transition<LETTER, PLACE>, PLACE> hashRelation) {
        if (iPetriNet.isAccepting(PLACE)) {
            return false;
        }
        Set set = iPetriNet.getSuccessors(PLACE);
        if (set.isEmpty()) {
            return false;
        }
        for (Transition transition : set) {
            if (hashRelation.containsPair(transition, PLACE)) continue;
            return false;
        }
        return true;
    }

    private boolean isFlowRedundant(Transition<LETTER, PLACE> transition, PLACE PLACE, HashRelation<Transition<LETTER, PLACE>, PLACE> hashRelation) throws AutomataOperationCanceledException {
        for (Object e : transition.getPredecessors()) {
            if (!this.isEligibleRestrictorCandidate(e) || e.equals(PLACE) || hashRelation.containsPair(transition, e)) continue;
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            boolean bl = this.isRestrictorPlace(PLACE, e);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean isRestrictorPlace(PLACE PLACE, PLACE PLACE2) {
        Boolean bl = (Boolean)this.mRestrictorPlaceCache.get(PLACE, PLACE2);
        if (bl == null) {
            bl = this.checkRestrictorPlace(PLACE, PLACE2);
            this.mRestrictorPlaceCache.put(PLACE, PLACE2, (Object)bl);
        }
        return bl;
    }

    private boolean checkRestrictorPlace(PLACE PLACE, PLACE PLACE2) {
        for (Condition<LETTER, PLACE> condition : this.mFinPre.place2cond(PLACE2)) {
            boolean bl;
            if (condition.getPredecessorEvent().isCutoffEvent() || (bl = this.isRestrictorCondition(condition, PLACE, this.mFinPre.getCoRelation()))) continue;
            return false;
        }
        return true;
    }

    private boolean isRestrictorCondition(Condition<LETTER, PLACE> condition2, PLACE PLACE, ICoRelation<LETTER, PLACE> iCoRelation) {
        ++this.mRestrictorConditionChecks;
        Optional<Condition> optional = condition2.getPredecessorEvent().getConditionMark().stream().filter(condition -> condition.getPlace().equals(PLACE)).findAny();
        if (!optional.isPresent()) {
            return false;
        }
        boolean bl = optional.get().getSuccessorEvents().stream().allMatch(event -> !iCoRelation.isInCoRelation(condition2, (Event)event));
        return bl;
    }

    @Override
    public BoundedPetriNet<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    @Override
    protected IPetriNet<LETTER, PLACE> getOperand() {
        return this.mOperand;
    }

    public HashRelation<Transition<LETTER, PLACE>, PLACE> getRedundantSelfloopFlow() {
        return this.mRedundantSelfloopFlow;
    }

    public Set<PLACE> getRedundantPlaces() {
        return this.mRedundantPlaces;
    }

    public Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> getOld2projected() {
        return this.mInput2projected;
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Testing correctness of " + this.getOperationName()));
        }
        boolean bl = PetriNetUtils.isEquivalent(this.mServices, CRSF, this.mOperand, this.mResult);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ", result has " + this.mResult.sizeInformation() + ", removed " + this.mRedundantSelfloopFlow.size() + " selfloop flow, removed " + this.mRedundantPlaces.size() + " redundant places.";
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        if (this.mFinitePrefixOperation != null) {
            automataOperationStatistics.addAllStatistics(this.mFinitePrefixOperation.getAutomataOperationStatistics());
        }
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_REMOVED_PLACES, this.mOperand.getPlaces().size() - this.mResult.getPlaces().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_REMOVED_TRANSITIONS, this.mOperand.getTransitions().size() - this.mResult.getTransitions().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_REMOVED_FLOW, this.mOperand.flowSize() - this.mResult.flowSize());
        automataOperationStatistics.addKeyValuePair(StatisticsType.RESTRICTOR_CONDITION_CHECKS, this.mRestrictorConditionChecks);
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_ALPHABET, this.mResult.getAlphabet().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_PLACES, this.mResult.getPlaces().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_TRANSITIONS, this.mResult.getTransitions().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_FLOW, this.mResult.flowSize());
        return automataOperationStatistics;
    }
}

