/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.util.Arrays;

public class LexicographicCounter {
    private final int[] mNumberOfValues;
    private final int[] mCounter;
    private final int mNumberOfValuesProduct;

    public LexicographicCounter(int[] nArray) {
        this.mNumberOfValues = nArray;
        this.mNumberOfValuesProduct = Arrays.stream(this.mNumberOfValues).reduce(1, (n, n2) -> n * n2);
        this.mCounter = new int[this.mNumberOfValues.length];
    }

    public int[] getCurrentValue() {
        return this.mCounter;
    }

    public void increment() {
        int n = 0;
        while (n < this.mNumberOfValues.length) {
            int n2 = n;
            this.mCounter[n2] = this.mCounter[n2] + 1;
            if (this.mCounter[n] < this.mNumberOfValues[n]) {
                return;
            }
            this.mCounter[n] = 0;
            ++n;
        }
    }

    public boolean isZero() {
        boolean bl = Arrays.stream(this.mCounter).allMatch(n -> n == 0);
        return bl;
    }

    public int getNumberOfValuesProduct() {
        return this.mNumberOfValuesProduct;
    }

    public String toString() {
        return "Current value=" + Arrays.toString(this.mCounter) + ", mNumberOfValues=" + Arrays.toString(this.mNumberOfValues);
    }
}

