/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc.eldarica;

import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IEquation;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IIntFormula;
import ap.parser.IIntLit;
import ap.parser.IIntRelation;
import ap.parser.IPlus;
import ap.parser.ISortedVariable;
import ap.parser.ITerm;
import ap.parser.ITimes;
import ap.terfor.preds.Predicate;
import ap.types.Sort;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import java.math.BigInteger;
import scala.Enumeration;

class Backtranslator {
    private final Script mScript;
    private final BidirectionalMap<HcPredicateSymbol, Predicate> mPredicateMap;

    Backtranslator(Script script, BidirectionalMap<HcPredicateSymbol, Predicate> bidirectionalMap) {
        this.mScript = script;
        this.mPredicateMap = bidirectionalMap;
    }

    public HcPredicateSymbol translatePredicate(Predicate predicate) {
        return (HcPredicateSymbol)this.mPredicateMap.inverse().get((Object)predicate);
    }

    public Term translateFormula(IFormula iFormula, IBoundVariableContext iBoundVariableContext) {
        if (iFormula instanceof IBinFormula) {
            return this.translateBinFormula((IBinFormula)iFormula, iBoundVariableContext);
        }
        if (iFormula instanceof IIntFormula) {
            return this.translateIntFormula((IIntFormula)iFormula, iBoundVariableContext);
        }
        if (iFormula instanceof IEquation) {
            return this.translateEquation((IEquation)iFormula, iBoundVariableContext);
        }
        throw new UnsupportedOperationException(iFormula.toString());
    }

    private Term translateEquation(IEquation iEquation, IBoundVariableContext iBoundVariableContext) {
        Term term = this.translateTermInternal(iEquation.left(), iBoundVariableContext);
        Term term2 = this.translateTermInternal(iEquation.right(), iBoundVariableContext);
        return SmtUtils.binaryEquality((Script)this.mScript, (Term)term, (Term)term2);
    }

    private Term translateIntFormula(IIntFormula iIntFormula, IBoundVariableContext iBoundVariableContext) {
        Term term = this.translateTerm(iIntFormula.t(), this.getIntSort(), iBoundVariableContext);
        Enumeration.Value value = iIntFormula.rel();
        if (IIntRelation.EqZero().equals((Object)value)) {
            return SmtUtils.binaryEquality((Script)this.mScript, (Term)term, (Term)this.numeral(BigInteger.ZERO));
        }
        if (IIntRelation.GeqZero().equals((Object)value)) {
            return SmtUtils.geq((Script)this.mScript, (Term)term, (Term)this.numeral(BigInteger.ZERO));
        }
        throw new UnsupportedOperationException("Unknown integer relation: " + String.valueOf(value));
    }

    private Term translateBinFormula(IBinFormula iBinFormula, IBoundVariableContext iBoundVariableContext) {
        Term term = this.translateFormula(iBinFormula.f1(), iBoundVariableContext);
        Term term2 = this.translateFormula(iBinFormula.f2(), iBoundVariableContext);
        Enumeration.Value value = iBinFormula.j();
        if (IBinJunctor.Or().equals((Object)value)) {
            return SmtUtils.or((Script)this.mScript, (Term[])new Term[]{term, term2});
        }
        if (IBinJunctor.And().equals((Object)value)) {
            return SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term, term2});
        }
        if (IBinJunctor.Eqv().equals((Object)value)) {
            return SmtUtils.binaryBooleanEquality((Script)this.mScript, (Term)term, (Term)term2);
        }
        throw new UnsupportedOperationException("Unknown binary operator: " + String.valueOf(value));
    }

    public Term translateTerm(ITerm iTerm, Sort sort, IBoundVariableContext iBoundVariableContext) {
        if (SmtSortUtils.isBoolSort((Sort)sort)) {
            IFormula iFormula = new Sort.MultipleValueBool$().isTrue(iTerm);
            return this.translateFormula(iFormula, iBoundVariableContext);
        }
        Term term = this.translateTermInternal(iTerm, iBoundVariableContext);
        if (SmtSortUtils.isBoolSort((Sort)term.getSort())) {
            Term term2 = this.numeral(BigInteger.ZERO);
            Term term3 = this.numeral(BigInteger.ONE);
            return SmtUtils.ite((Script)this.mScript, (Term)term, (Term)term2, (Term)term3);
        }
        assert (term.getSort().equals(sort)) : "Translated term has sort " + String.valueOf(term.getSort()) + " instead of " + String.valueOf(sort);
        return term;
    }

    private Term translateTermInternal(ITerm iTerm, IBoundVariableContext iBoundVariableContext) {
        IFunApp iFunApp;
        if (iTerm instanceof IPlus) {
            IPlus iPlus = (IPlus)iTerm;
            Term term = this.translateTerm(iPlus.t1(), this.getIntSort(), iBoundVariableContext);
            Term term2 = this.translateTerm(iPlus.t2(), this.getIntSort(), iBoundVariableContext);
            return SmtUtils.sum((Script)this.mScript, (Sort)this.getIntSort(), (Term[])new Term[]{term, term2});
        }
        if (iTerm instanceof ITimes) {
            ITimes iTimes = (ITimes)iTerm;
            Rational rational = Rational.valueOf((BigInteger)iTimes.coeff().bigIntValue(), (BigInteger)BigInteger.ONE);
            Term term = this.translateTerm(iTimes.subterm(), this.getIntSort(), iBoundVariableContext);
            return SmtUtils.mul((Script)this.mScript, (Rational)rational, (Term)term);
        }
        if (iTerm instanceof ISortedVariable) {
            ISortedVariable iSortedVariable = (ISortedVariable)iTerm;
            return iBoundVariableContext.getBoundVariable(iSortedVariable.index());
        }
        if (iTerm instanceof IFunApp) {
            iFunApp = (IFunApp)iTerm;
            Term term = this.translateStore(iFunApp, iBoundVariableContext);
            if (term != null) {
                return term;
            }
            Term term3 = this.translateConstArray(iFunApp, iBoundVariableContext);
            if (term3 != null) {
                return term3;
            }
            Term term4 = this.translateBoolLit(iFunApp);
            if (term4 != null) {
                return term4;
            }
        }
        if (iTerm instanceof IIntLit) {
            iFunApp = ((IIntLit)iTerm).value();
            return this.numeral(iFunApp.bigIntValue());
        }
        throw new IllegalArgumentException("Unknown term: " + iTerm.toString());
    }

    private Term translateStore(IFunApp iFunApp, IBoundVariableContext iBoundVariableContext) {
        if (!"store".equals(iFunApp.fun().name()) || iFunApp.fun().arity() != 3) {
            return null;
        }
        Term term = this.translateTermInternal((ITerm)iFunApp.args().apply(0), iBoundVariableContext);
        Term term2 = this.translateTermInternal((ITerm)iFunApp.args().apply(1), iBoundVariableContext);
        Term term3 = this.translateTermInternal((ITerm)iFunApp.args().apply(2), iBoundVariableContext);
        return SmtUtils.store((Script)this.mScript, (Term)term, (Term)term2, (Term)term3);
    }

    private Term translateConstArray(IFunApp iFunApp, IBoundVariableContext iBoundVariableContext) {
        if (!"const".equals(iFunApp.fun().name()) || iFunApp.fun().arity() != 1) {
            return null;
        }
        Term term = this.translateTermInternal((ITerm)iFunApp.args().apply(0), iBoundVariableContext);
        return this.mScript.term("const", null, SmtSortUtils.getArraySort((Script)this.mScript, (Sort)this.getIntSort(), (Sort)term.getSort()), new Term[]{term});
    }

    private Term translateBoolLit(IFunApp iFunApp) {
        String string;
        switch (string = iFunApp.fun().name()) {
            case "true": 
            case "false": {
                assert (iFunApp.args().isEmpty()) : "unexpected parameters for function " + string;
                return this.mScript.term(string, new Term[0]);
            }
        }
        return null;
    }

    private Term numeral(BigInteger bigInteger) {
        return SmtUtils.constructIntegerValue((Script)this.mScript, (Sort)this.getIntSort(), (BigInteger)bigInteger);
    }

    private Sort getIntSort() {
        return SmtSortUtils.getIntSort((Script)this.mScript);
    }

    public static interface IBoundVariableContext {
        public Term getBoundVariable(int var1);
    }
}

