/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.referee;

import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.referee.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.referee.RefereeObserver;
import de.uni_freiburg.informatik.ultimate.plugins.generator.referee.preferences.RefereePreferenceInitializer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Referee
implements IGenerator {
    private static final String PLUGIN_NAME = "Referee";
    private static final String PLUGIN_ID = Activator.PLUGIN_ID;
    private RefereeObserver mObserver;
    private List<IObserver> mObservers;
    private ModelType mInputDefinition;
    private IUltimateServiceProvider mServices;

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public void init() {
        this.mObserver = new RefereeObserver(this.mServices);
        this.mObservers = Collections.singletonList(this.mObserver);
    }

    public ITool.ModelQuery getModelQuery() {
        return ITool.ModelQuery.ALL;
    }

    public List<String> getDesiredToolIds() {
        return Collections.emptyList();
    }

    public void setInputDefinition(ModelType modelType) {
        this.mInputDefinition = modelType;
    }

    public List<IObserver> getObservers() {
        return this.mObservers;
    }

    public ModelType getOutputDefinition() {
        return new ModelType(Activator.PLUGIN_ID, this.mInputDefinition.getType(), (Collection)this.mInputDefinition.getFileNames());
    }

    public IElement getModel() {
        return this.mObserver.getRootOfNewModel();
    }

    public boolean isGuiRequired() {
        return false;
    }

    public IPreferenceInitializer getPreferences() {
        return new RefereePreferenceInitializer();
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
    }

    public void finish() {
    }
}

