/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.RenameProcedureSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BoogieDeclarations {
    private final ILogger mLogger;
    private final List<Axiom> mAxioms = new ArrayList<Axiom>();
    private final List<TypeDeclaration> mTypeDeclarations = new ArrayList<TypeDeclaration>();
    private final List<ConstDeclaration> mConstDeclarations = new ArrayList<ConstDeclaration>();
    private final List<FunctionDeclaration> mFunctionDeclarations = new ArrayList<FunctionDeclaration>();
    private final List<VariableDeclaration> mGlobalVarDeclarations = new ArrayList<VariableDeclaration>();
    private final Map<String, Procedure> mProcSpecification = new HashMap<String, Procedure>();
    private final Map<String, Procedure> mProcImplementation = new HashMap<String, Procedure>();
    private final Map<String, List<RequiresSpecification>> mRequires = new HashMap<String, List<RequiresSpecification>>();
    private final Map<String, List<RequiresSpecification>> mRequiresNonFree = new HashMap<String, List<RequiresSpecification>>();
    private final Map<String, List<EnsuresSpecification>> mEnsures = new HashMap<String, List<EnsuresSpecification>>();
    private final Map<String, List<EnsuresSpecification>> mEnsuresNonFree = new HashMap<String, List<EnsuresSpecification>>();
    private final Map<String, Set<String>> mModifiedVars = new HashMap<String, Set<String>>();

    public BoogieDeclarations(Collection<Declaration> collection, ILogger iLogger) {
        this.mLogger = iLogger;
        for (Declaration declaration : collection) {
            if (declaration instanceof Axiom) {
                this.mAxioms.add((Axiom)declaration);
                continue;
            }
            if (declaration instanceof TypeDeclaration) {
                this.mTypeDeclarations.add((TypeDeclaration)declaration);
                continue;
            }
            if (declaration instanceof ConstDeclaration) {
                this.mConstDeclarations.add((ConstDeclaration)declaration);
                continue;
            }
            if (declaration instanceof FunctionDeclaration) {
                this.mFunctionDeclarations.add((FunctionDeclaration)declaration);
                continue;
            }
            if (declaration instanceof VariableDeclaration) {
                this.mGlobalVarDeclarations.add((VariableDeclaration)declaration);
                continue;
            }
            if (declaration instanceof Procedure) {
                Procedure procedure = (Procedure)declaration;
                if (procedure.getSpecification() != null && procedure.getBody() != null) {
                    this.mLogger.info((Object)String.format("Specification and implementation of procedure %s given in one single declaration", procedure.getIdentifier()));
                }
                if (procedure.getSpecification() != null) {
                    this.mLogger.info((Object)("Found specification of procedure " + procedure.getIdentifier()));
                    if (this.mProcSpecification.containsKey(procedure.getIdentifier())) {
                        throw new UnsupportedOperationException("Procedure" + procedure.getIdentifier() + "declarated twice");
                    }
                    this.mProcSpecification.put(procedure.getIdentifier(), procedure);
                }
                if (procedure.getBody() == null) continue;
                this.mLogger.info((Object)("Found implementation of procedure " + procedure.getIdentifier()));
                if (this.mProcImplementation.containsKey(procedure.getIdentifier())) {
                    throw new UnsupportedOperationException("File contains two implementations of procedure" + procedure.getIdentifier());
                }
                this.mProcImplementation.put(procedure.getIdentifier(), procedure);
                continue;
            }
            throw new AssertionError((Object)("Unknown Declaration" + String.valueOf(declaration)));
        }
        for (Procedure procedure : this.mProcSpecification.values()) {
            this.extractContract(procedure.getIdentifier());
        }
    }

    public BoogieDeclarations(Declaration[] declarationArray, ILogger iLogger) {
        this(Arrays.asList(declarationArray), iLogger);
    }

    public BoogieDeclarations(Unit unit, ILogger iLogger) {
        this(unit.getDeclarations(), iLogger);
    }

    private void extractContract(String string) {
        Specification[] specificationArray;
        Object object;
        Procedure procedure;
        Procedure procedure2 = this.mProcSpecification.get(string);
        if (procedure2 != (procedure = this.mProcImplementation.get(string)) && procedure != null) {
            object = new RenameProcedureSpec();
            specificationArray = ((RenameProcedureSpec)((Object)object)).renameSpecs(procedure2, procedure);
        } else {
            specificationArray = procedure2.getSpecification();
        }
        object = new ArrayList();
        ArrayList<EnsuresSpecification> arrayList = new ArrayList<EnsuresSpecification>();
        ArrayList<EnsuresSpecification> arrayList2 = new ArrayList<EnsuresSpecification>();
        ArrayList<EnsuresSpecification> arrayList3 = new ArrayList<EnsuresSpecification>();
        HashSet<String> hashSet = new HashSet<String>();
        Specification[] specificationArray2 = specificationArray;
        int n = specificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Specification specification = specificationArray2[n2];
            if (specification instanceof EnsuresSpecification) {
                var14_14 = (EnsuresSpecification)specification;
                object.add(var14_14);
                if (!var14_14.isFree()) {
                    arrayList.add(var14_14);
                }
            } else if (specification instanceof RequiresSpecification) {
                var14_14 = (RequiresSpecification)specification;
                arrayList2.add(var14_14);
                if (!var14_14.isFree()) {
                    arrayList3.add(var14_14);
                }
            } else {
                if (specification instanceof LoopInvariantSpecification) {
                    this.mLogger.debug((Object)("Found LoopInvariantSpecification" + String.valueOf(specification) + "but this plugin does not use loop invariants."));
                    throw new IllegalArgumentException("LoopInvariantSpecification may not occur in procedure constract");
                }
                if (specification instanceof ModifiesSpecification) {
                    var14_14 = (ModifiesSpecification)specification;
                    VariableLHS[] variableLHSArray = var14_14.getIdentifiers();
                    int n3 = variableLHSArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        VariableLHS variableLHS = variableLHSArray[n4];
                        String string2 = variableLHS.getIdentifier();
                        hashSet.add(string2);
                        ++n4;
                    }
                } else {
                    throw new UnsupportedOperationException("Unknown type of specification)");
                }
            }
            this.mEnsures.put(string, (List<EnsuresSpecification>)object);
            this.mEnsuresNonFree.put(string, arrayList);
            this.mRequires.put(string, arrayList2);
            this.mRequiresNonFree.put(string, arrayList3);
            ++n2;
        }
        this.mModifiedVars.put(string, hashSet);
    }

    public List<Axiom> getAxioms() {
        return this.mAxioms;
    }

    public List<TypeDeclaration> getTypeDeclarations() {
        return this.mTypeDeclarations;
    }

    public List<ConstDeclaration> getConstDeclarations() {
        return this.mConstDeclarations;
    }

    public List<FunctionDeclaration> getFunctionDeclarations() {
        return this.mFunctionDeclarations;
    }

    public List<VariableDeclaration> getGlobalVarDeclarations() {
        return this.mGlobalVarDeclarations;
    }

    public Map<String, Procedure> getProcSpecification() {
        return this.mProcSpecification;
    }

    public Map<String, Procedure> getProcImplementation() {
        return this.mProcImplementation;
    }

    public Map<String, List<RequiresSpecification>> getRequires() {
        return this.mRequires;
    }

    public Map<String, List<RequiresSpecification>> getRequiresNonFree() {
        return this.mRequiresNonFree;
    }

    public Map<String, List<EnsuresSpecification>> getEnsures() {
        return this.mEnsures;
    }

    public Map<String, List<EnsuresSpecification>> getEnsuresNonFree() {
        return this.mEnsuresNonFree;
    }

    public Map<String, Set<String>> getModifiedVars() {
        return this.mModifiedVars;
    }
}

