/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public final class HashDeque<E>
implements Deque<E> {
    private final Deque<E> mDeque = new ArrayDeque();
    private final Set<E> mSet = new HashSet();

    @Override
    public E pop() {
        E e = this.mDeque.pop();
        this.mSet.remove(e);
        return e;
    }

    @Override
    public void push(E e) {
        if (this.mSet.add(e)) {
            this.mDeque.push(e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.mSet.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.mDeque.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.mDeque.toArray(TArray);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mSet.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            if (!this.mSet.add(e)) continue;
            this.mDeque.add(e);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = this.mSet.removeAll(collection);
        this.mDeque.removeAll(collection);
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = this.mSet.retainAll(collection);
        this.mDeque.retainAll(collection);
        return bl;
    }

    @Override
    public void clear() {
        this.mSet.clear();
        this.mDeque.clear();
    }

    @Override
    public void addFirst(E e) {
        if (this.mSet.add(e)) {
            this.mDeque.addFirst(e);
        }
    }

    @Override
    public void addLast(E e) {
        if (this.mSet.add(e)) {
            this.mDeque.addLast(e);
        }
    }

    @Override
    public boolean offerFirst(E e) {
        if (this.mSet.add(e)) {
            return this.mDeque.offerFirst(e);
        }
        return false;
    }

    @Override
    public boolean offerLast(E e) {
        if (this.mSet.add(e)) {
            return this.mDeque.offerLast(e);
        }
        return false;
    }

    @Override
    public E removeFirst() {
        E e = this.mDeque.removeFirst();
        this.mSet.remove(e);
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.mDeque.removeLast();
        this.mSet.remove(e);
        return e;
    }

    @Override
    public E pollFirst() {
        E e = this.mDeque.pollFirst();
        if (e != null) {
            this.mSet.remove(e);
        }
        return e;
    }

    @Override
    public E pollLast() {
        E e = this.mDeque.pollLast();
        if (e != null) {
            this.mSet.remove(e);
        }
        return e;
    }

    @Override
    public E getFirst() {
        return this.mDeque.getFirst();
    }

    @Override
    public E getLast() {
        return this.mDeque.getLast();
    }

    @Override
    public E peekFirst() {
        return this.mDeque.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.mDeque.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        if (this.mSet.remove(object)) {
            return this.mDeque.removeFirstOccurrence(object);
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        if (this.mSet.remove(object)) {
            return this.mDeque.removeLastOccurrence(object);
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        if (this.mSet.add(e)) {
            return this.mDeque.add(e);
        }
        return false;
    }

    @Override
    public boolean offer(E e) {
        if (this.mSet.add(e)) {
            return this.mDeque.offer(e);
        }
        return false;
    }

    @Override
    public E remove() {
        E e = this.mDeque.remove();
        this.mSet.remove(e);
        return e;
    }

    @Override
    public E poll() {
        E e = this.mDeque.poll();
        this.mSet.remove(e);
        return e;
    }

    @Override
    public E element() {
        return this.mDeque.element();
    }

    @Override
    public E peek() {
        return this.mDeque.peek();
    }

    @Override
    public boolean remove(Object object) {
        if (this.mSet.remove(object)) {
            return this.mDeque.remove(object);
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return this.mSet.contains(object);
    }

    @Override
    public int size() {
        return this.mSet.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mDeque.iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.mDeque.descendingIterator();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mDeque);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HashDeque hashDeque = (HashDeque)object;
        return !(this.mDeque == null ? hashDeque.mDeque != null : !this.mDeque.equals(hashDeque.mDeque));
    }

    public String toString() {
        return this.mDeque.toString();
    }
}

