/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GlobalInvariant;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GlobalLTLInvariant;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.TypeInvariant;
import java.util.List;
import java.util.function.Predicate;

public abstract sealed class Invariant
extends ACSLNode
permits GlobalLTLInvariant, TypeInvariant, GlobalInvariant {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Invariant.class);
    String identifier;
    Expression formula;

    public Invariant(String string, Expression expression) {
        this.identifier = string;
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Invariant: " + String.valueOf(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Invariant").append('[');
        stringBuffer.append(this.identifier);
        stringBuffer.append(',').append(this.formula);
        return stringBuffer.append(']').toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Expression getFormula() {
        return this.formula;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.formula);
        return list;
    }

    @Override
    public abstract void accept(ACSLVisitor var1);

    @Override
    public abstract Invariant accept(ACSLTransformer var1);
}

