/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseBlockEncoder;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class MaximizeFinalStates
extends BaseBlockEncoder<IcfgLocation> {
    private int mNewAcceptingStates = 0;
    private final Consumer<IcfgLocation> mFunMarkAsAccepting;
    private final Predicate<IcfgLocation> mFunIsAccepting;

    public MaximizeFinalStates(IUltimateServiceProvider iUltimateServiceProvider, Consumer<IcfgLocation> consumer, Predicate<IcfgLocation> predicate, BlockEncodingBacktranslator blockEncodingBacktranslator, ILogger iLogger) {
        super(iLogger, iUltimateServiceProvider, blockEncodingBacktranslator);
        this.mFunMarkAsAccepting = consumer;
        this.mFunIsAccepting = predicate;
    }

    @Override
    protected BasicIcfg<IcfgLocation> createResult(BasicIcfg<IcfgLocation> basicIcfg) {
        int n = this.processInternal(basicIcfg);
        this.mNewAcceptingStates += n;
        while (n > 0) {
            n = this.processInternal(basicIcfg);
            this.mNewAcceptingStates += n;
        }
        this.mLogger.info((Object)(this.mNewAcceptingStates + " new accepting states"));
        return basicIcfg;
    }

    private int processInternal(BasicIcfg<IcfgLocation> basicIcfg) {
        ArrayDeque<IcfgLocation> arrayDeque = new ArrayDeque<IcfgLocation>();
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        int n = 0;
        arrayDeque.addAll(basicIcfg.getInitialNodes());
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            if (hashSet.contains(icfgLocation)) continue;
            hashSet.add(icfgLocation);
            if (this.mFunIsAccepting.test(icfgLocation)) {
                arrayDeque.addAll(this.getSuccessors(icfgLocation));
                continue;
            }
            List<IcfgLocation> list = this.getSuccessors(icfgLocation);
            if (list.isEmpty()) continue;
            boolean bl = true;
            for (IcfgLocation icfgLocation2 : list) {
                bl = bl && this.mFunIsAccepting.test(icfgLocation2);
                arrayDeque.add(icfgLocation2);
            }
            if (!bl) continue;
            this.mFunMarkAsAccepting.accept(icfgLocation);
            ++n;
        }
        return n;
    }

    public int getNewAcceptingStates() {
        return this.mNewAcceptingStates;
    }

    @Override
    public boolean isGraphStructureChanged() {
        return this.mNewAcceptingStates > 0;
    }
}

