/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class BinaryExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(BinaryExpression.class);
    Operator operator;
    Expression left;
    Expression right;

    public BinaryExpression(Operator operator, Expression expression, Expression expression2) {
        this.operator = operator;
        this.left = expression;
        this.right = expression2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BinaryExpression: " + String.valueOf(this);
    }

    public BinaryExpression(ACSLType aCSLType, Operator operator, Expression expression, Expression expression2) {
        super(aCSLType);
        this.operator = operator;
        this.left = expression;
        this.right = expression2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BinaryExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BinaryExpression").append('[');
        stringBuffer.append((Object)this.operator);
        stringBuffer.append(',').append(this.left);
        stringBuffer.append(',').append(this.right);
        return stringBuffer.append(']').toString();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.left);
        list.add(this.right);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.left != null) {
                this.left.accept(aCSLVisitor);
            }
            if (this.right != null) {
                this.right.accept(aCSLVisitor);
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.left != null) {
            expression2 = this.left.accept(aCSLTransformer);
        }
        Expression expression3 = null;
        if (this.right != null) {
            expression3 = this.right.accept(aCSLTransformer);
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.left != expression2 || this.right != expression3 || this.type != aCSLType) {
            return new BinaryExpression(aCSLType, this.operator, expression2, expression3);
        }
        return this;
    }

    public static enum Operator {
        LOGICIFF,
        LOGICIMPLIES,
        LOGICAND,
        LOGICOR,
        LOGICXOR,
        COMPLT,
        COMPGT,
        COMPLEQ,
        COMPGEQ,
        COMPEQ,
        COMPNEQ,
        COMPPO,
        BITVECCONCAT,
        ARITHPLUS,
        ARITHMINUS,
        ARITHMUL,
        ARITHDIV,
        ARITHMOD,
        BITAND,
        BITOR,
        BITIMPLIES,
        BITIFF,
        BITXOR,
        BITSHIFTLEFT,
        BITSHIFTRIGHT,
        LTLUNTIL,
        LTLRELEASE,
        LTLWEAKUNTIL;

    }
}

