/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.mso;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.mso.MSODAlphabetSymbol;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MSODUtils {
    public static final String SET_OF_INT_SORT = "SetOfInt";

    private MSODUtils() {
        throw new UnsupportedOperationException("Instantiation of utility class.");
    }

    public static Sort getSetOfIntSort(Script script) {
        return script.sort(SET_OF_INT_SORT, new Sort[0]);
    }

    public static boolean isSetOfIntSort(Sort sort) {
        return sort.getName().equals(SET_OF_INT_SORT);
    }

    public static boolean isIntConstant(Term term) {
        return SmtUtils.isConstant((Term)term) && SmtSortUtils.isIntSort((Sort)term.getSort());
    }

    public static boolean isSetOfIntConstant(Term term) {
        return SmtUtils.isConstant((Term)term) && MSODUtils.isSetOfIntSort(term.getSort());
    }

    public static boolean isIntTermVariable(Term term) {
        return term instanceof TermVariable && SmtSortUtils.isIntSort((Sort)term.getSort());
    }

    public static boolean isSetOfIntTermVariable(Term term) {
        return term instanceof TermVariable && MSODUtils.isSetOfIntSort(term.getSort());
    }

    public static boolean isConstant(Term term) {
        return MSODUtils.isIntConstant(term) || MSODUtils.isSetOfIntConstant(term);
    }

    public static boolean isTermVariable(Term term) {
        return MSODUtils.isIntTermVariable(term) || MSODUtils.isSetOfIntTermVariable(term);
    }

    public static boolean isConstantOrTermVariable(Term term) {
        return MSODUtils.isConstant(term) || MSODUtils.isTermVariable(term);
    }

    public static boolean isIntConstantOrTermVariable(Term term) {
        return MSODUtils.isIntConstant(term) || MSODUtils.isIntTermVariable(term);
    }

    public static boolean isSetOfIntConstantOrTermVariable(Term term) {
        return MSODUtils.isSetOfIntConstant(term) || MSODUtils.isSetOfIntTermVariable(term);
    }

    public static Term intConstant(Script script, int n) {
        return SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.valueOf(n));
    }

    public static Set<MSODAlphabetSymbol> createAlphabet(List<Term> list) {
        HashSet<MSODAlphabetSymbol> hashSet = new HashSet<MSODAlphabetSymbol>();
        int n = 0;
        while (n < (int)Math.pow(2.0, list.size())) {
            MSODAlphabetSymbol mSODAlphabetSymbol = new MSODAlphabetSymbol();
            int n2 = 0;
            while (n2 < list.size()) {
                int n3;
                mSODAlphabetSymbol.add(list.get(n2), (n3 = n / (int)Math.pow(2.0, n2) % 2) == 1);
                ++n2;
            }
            hashSet.add(mSODAlphabetSymbol);
            ++n;
        }
        return hashSet;
    }

    public static Set<MSODAlphabetSymbol> mergeAlphabets(Set<MSODAlphabetSymbol> set, Set<MSODAlphabetSymbol> set2) {
        HashSet<Term> hashSet = new HashSet<Term>();
        if (!set.isEmpty()) {
            hashSet.addAll(set.iterator().next().getMap().keySet());
        }
        if (!set2.isEmpty()) {
            hashSet.addAll(set2.iterator().next().getMap().keySet());
        }
        return MSODUtils.createAlphabet(new ArrayList<Term>(hashSet));
    }

    public static Set<MSODAlphabetSymbol> allMatchesAlphabet(Set<MSODAlphabetSymbol> set, Boolean bl, Term ... termArray) {
        HashSet<MSODAlphabetSymbol> hashSet = new HashSet<MSODAlphabetSymbol>();
        set.stream().filter(mSODAlphabetSymbol -> mSODAlphabetSymbol.allMatches(bl, termArray)).forEach(mSODAlphabetSymbol -> {
            boolean bl = hashSet.add((MSODAlphabetSymbol)mSODAlphabetSymbol);
        });
        return hashSet;
    }

    public static Set<String> hierarchicalPredecessorsIncoming(INestedWordAutomaton<MSODAlphabetSymbol, String> iNestedWordAutomaton, String string, MSODAlphabetSymbol mSODAlphabetSymbol) {
        HashSet<String> hashSet = new HashSet<String>();
        for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.internalPredecessors((Object)string, (Object)mSODAlphabetSymbol)) {
            hashSet.add((String)incomingInternalTransition.getPred());
        }
        return hashSet;
    }

    public static String automatonToString(AutomataLibraryServices automataLibraryServices, IAutomaton<?, ?> iAutomaton) {
        return AutomatonDefinitionPrinter.toString((AutomataLibraryServices)automataLibraryServices, (String)"", iAutomaton);
    }
}

