/*
 * Decompiled with CFR 0.152.
 */
package ap.proof.goal;

import ap.proof.goal.SymbolWeights;
import ap.terfor.ConstantTerm;
import ap.terfor.TerFor;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.equations.EquationSet;
import ap.terfor.inequalities.InEqConj;
import ap.terfor.linearcombination.LinearCombination;
import ap.terfor.preds.Atom;
import ap.terfor.preds.PredConj;
import ap.terfor.preds.Predicate;
import ap.util.Seqs$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class SymbolWeights$ {
    public static SymbolWeights$ MODULE$;
    private final SymbolWeights DEFAULT;

    static {
        new SymbolWeights$();
    }

    public SymbolWeights DEFAULT() {
        return this.DEFAULT;
    }

    public SymbolWeights symbolFrequencies(TerFor t) {
        HashMap consts = new HashMap();
        HashMap preds = new HashMap();
        this.countSymbols(t, (scala.collection.mutable.Map<ConstantTerm, Object>)consts, (scala.collection.mutable.Map<Predicate, Object>)preds);
        return new SymbolWeights(consts, preds){
            private final HashMap consts$1;
            private final HashMap preds$1;

            public int maxWeight(TerFor t) {
                return SymbolWeights.maxWeight$(this, t);
            }

            public Option<Object> minAbbrevWeight(TerFor f) {
                return SymbolWeights.minAbbrevWeight$(this, f);
            }

            public int apply(ConstantTerm c) {
                return BoxesRunTime.unboxToInt((Object)this.consts$1.apply((Object)c));
            }

            public int apply(Predicate p) {
                return BoxesRunTime.unboxToInt((Object)this.preds$1.apply((Object)p));
            }

            public Option<Object> abbrevWeight(Predicate p) {
                return None$.MODULE$;
            }

            public String toString() {
                return new StringBuilder(1).append(this.consts$1.toString()).append("\n").append(this.preds$1.toString()).toString();
            }
            {
                this.consts$1 = consts$1;
                this.preds$1 = preds$1;
                SymbolWeights.$init$(this);
            }
        };
    }

    public SymbolWeights normSymbolFrequencies(Iterable<TerFor> exprs, int maxW) {
        HashMap consts = new HashMap();
        HashMap preds = new HashMap();
        exprs.foreach((Function1 & Serializable & scala.Serializable)t -> {
            SymbolWeights$.MODULE$.countSymbols(t, (scala.collection.mutable.Map<ConstantTerm, Object>)consts, (scala.collection.mutable.Map<Predicate, Object>)preds);
            return BoxedUnit.UNIT;
        });
        Map nConsts = this.normalise((Map)consts, maxW);
        Map nPreds = this.normalise((Map)preds, maxW);
        return new SymbolWeights(nConsts, maxW, nPreds){
            private final Map nConsts$1;
            private final int maxW$1;
            private final Map nPreds$1;

            public int maxWeight(TerFor t) {
                return SymbolWeights.maxWeight$(this, t);
            }

            public Option<Object> minAbbrevWeight(TerFor f) {
                return SymbolWeights.minAbbrevWeight$(this, f);
            }

            public int apply(ConstantTerm c) {
                return BoxesRunTime.unboxToInt((Object)this.nConsts$1.getOrElse((Object)c, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.maxW$1 / 2));
            }

            public int apply(Predicate p) {
                return BoxesRunTime.unboxToInt((Object)this.nPreds$1.getOrElse((Object)p, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.maxW$1 / 2));
            }

            public Option<Object> abbrevWeight(Predicate p) {
                return None$.MODULE$;
            }

            public String toString() {
                return new StringBuilder(1).append(this.nConsts$1.toString()).append("\n").append(this.nPreds$1.toString()).toString();
            }
            {
                this.nConsts$1 = nConsts$1;
                this.maxW$1 = maxW$1;
                this.nPreds$1 = nPreds$1;
                SymbolWeights.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(ap.proof.goal.SymbolWeights$$anon$3 ), $anonfun$apply$2(ap.proof.goal.SymbolWeights$$anon$3 )}, serializedLambda);
            }
        };
    }

    private void countSymbols(TerFor t, scala.collection.mutable.Map<ConstantTerm, Object> consts, scala.collection.mutable.Map<Predicate, Object> preds) {
        TerFor terFor = t;
        if (terFor instanceof LinearCombination) {
            LinearCombination linearCombination = (LinearCombination)terFor;
            this.inc((Iterable)linearCombination.constants(), (scala.collection.mutable.Map)consts);
            return;
        }
        if (terFor instanceof EquationSet) {
            EquationSet equationSet = (EquationSet)terFor;
            equationSet.foreach((Function1 & Serializable & scala.Serializable)lc -> {
                SymbolWeights$.MODULE$.countSymbols(lc, (scala.collection.mutable.Map<ConstantTerm, Object>)consts, (scala.collection.mutable.Map<Predicate, Object>)preds);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (terFor instanceof InEqConj) {
            InEqConj inEqConj = (InEqConj)terFor;
            inEqConj.foreach((Function1 & Serializable & scala.Serializable)lc -> {
                SymbolWeights$.MODULE$.countSymbols(lc, (scala.collection.mutable.Map<ConstantTerm, Object>)consts, (scala.collection.mutable.Map<Predicate, Object>)preds);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (terFor instanceof Atom) {
            Atom atom = (Atom)terFor;
            this.inc(atom.pred(), preds);
            atom.foreach((Function1 & Serializable & scala.Serializable)arg -> {
                SymbolWeights$.MODULE$.countSymbols(arg, (scala.collection.mutable.Map<ConstantTerm, Object>)consts, (scala.collection.mutable.Map<Predicate, Object>)preds);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (terFor instanceof PredConj) {
            PredConj predConj = (PredConj)terFor;
            predConj.positiveLits().foreach((Function1 & Serializable & scala.Serializable)a -> {
                SymbolWeights$.MODULE$.countSymbols(a, (scala.collection.mutable.Map<ConstantTerm, Object>)consts, (scala.collection.mutable.Map<Predicate, Object>)preds);
                return BoxedUnit.UNIT;
            });
            predConj.negativeLits().foreach((Function1 & Serializable & scala.Serializable)a -> {
                SymbolWeights$.MODULE$.countSymbols(a, (scala.collection.mutable.Map<ConstantTerm, Object>)consts, (scala.collection.mutable.Map<Predicate, Object>)preds);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (terFor instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)terFor;
            this.countSymbols(conjunction.arithConj().positiveEqs(), consts, preds);
            this.countSymbols(conjunction.arithConj().negativeEqs(), consts, preds);
            this.countSymbols(conjunction.arithConj().inEqs(), consts, preds);
            this.countSymbols(conjunction.predConj(), consts, preds);
            conjunction.negatedConjs().foreach((Function1 & Serializable & scala.Serializable)c -> {
                SymbolWeights$.MODULE$.countSymbols(c, (scala.collection.mutable.Map<ConstantTerm, Object>)consts, (scala.collection.mutable.Map<Predicate, Object>)preds);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)terFor);
    }

    private <A> void inc(A sym, scala.collection.mutable.Map<A, Object> counts) {
        counts.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(sym), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)counts.getOrElse(sym, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1))));
    }

    private <A> void inc(Iterable<A> syms, scala.collection.mutable.Map<A, Object> counts) {
        syms.foreach((Function1 & Serializable & scala.Serializable)sym -> {
            SymbolWeights$.MODULE$.inc(sym, counts);
            return BoxedUnit.UNIT;
        });
    }

    private <A> Map<A, Object> normalise(Map<A, Object> weights, int maxWeight) {
        int oldMax = Seqs$.MODULE$.max((Iterator<Object>)weights.iterator().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SymbolWeights$.$anonfun$normalise$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)SymbolWeights$.$anonfun$normalise$2(x$1))));
        HashMap res = new HashMap();
        weights.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SymbolWeights$.$anonfun$normalise$3(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                Object x = tuple2._1();
                int weight = tuple2._2$mcI$sp();
                return res.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), (Object)BoxesRunTime.boxToInteger((int)(weight * maxWeight / oldMax))));
            }
            throw new MatchError((Object)tuple2);
        });
        return res;
    }

    public static final /* synthetic */ boolean $anonfun$normalise$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ int $anonfun$normalise$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int weight = tuple2._2$mcI$sp();
            return weight;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$normalise$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    private SymbolWeights$() {
        MODULE$ = this;
        this.DEFAULT = new SymbolWeights(){

            public int maxWeight(TerFor t) {
                return SymbolWeights.maxWeight$(this, t);
            }

            public Option<Object> minAbbrevWeight(TerFor f) {
                return SymbolWeights.minAbbrevWeight$(this, f);
            }

            public int apply(ConstantTerm c) {
                return 0;
            }

            public int apply(Predicate p) {
                return 0;
            }

            public Option<Object> abbrevWeight(Predicate p) {
                return None$.MODULE$;
            }
            {
                SymbolWeights.$init$(this);
            }
        };
    }
}

