/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDeckerAutomatonFilteredStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.ComplementDeterministicNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.DeterminizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IntersectNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.ProductNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.TotalizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DifferenceDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IOpWithDelayedDeadEndRemoval;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import java.util.Iterator;
import java.util.Map;

public final class Difference<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>>
implements IOpWithDelayedDeadEndRemoval<LETTER, STATE> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final IStateDeterminizer<LETTER, STATE> mStateDeterminizer;
    private IntersectNwa<LETTER, STATE> mIntersect;
    private NestedWordAutomatonReachableStates<LETTER, STATE> mResult;
    private DoubleDeckerAutomatonFilteredStates<LETTER, STATE> mResultWOdeadEnds;
    private final ISinkStateFactory<STATE> mStateFactory;
    private final IIntersectionStateFactory<STATE> mStateFactoryIntersection;
    private DeterminizeNwa<LETTER, STATE> mSndDeterminized;
    private ComplementDeterministicNwa<LETTER, STATE> mSndComplemented;

    public <SF extends ISinkStateFactory<STATE> & IIntersectionStateFactory<STATE>> Difference(AutomataLibraryServices automataLibraryServices, SF SF, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2, IStateDeterminizer<LETTER, STATE> iStateDeterminizer, boolean bl) throws AutomataLibraryException {
        super(automataLibraryServices);
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        this.mStateFactory = SF;
        this.mStateFactoryIntersection = SF;
        this.mStateDeterminizer = iStateDeterminizer;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.computeDifference(SF, bl);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    public Difference(AutomataLibraryServices automataLibraryServices, INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        this(automataLibraryServices, (ISinkStateFactory<STATE> & IIntersectionStateFactory<STATE>)iNwaInclusionStateFactory, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2, new PowersetDeterminizer<LETTER, STATE>(iNwaOutgoingLetterAndTransitionProvider2, true, iNwaInclusionStateFactory), false);
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Result " + this.mResult.sizeInformation();
    }

    private <SF extends IIntersectionStateFactory<STATE> & IEmptyStackStateFactory<STATE>> void computeDifference(SF SF, boolean bl) throws AutomataLibraryException {
        if (this.hasSeveralInitialStates(this.mSndOperand)) {
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)"Subtrahend was not deterministic. Computing result with determinization.");
            }
        } else if (this.mStateDeterminizer instanceof PowersetDeterminizer) {
            TotalizeNwa<LETTER, ISinkStateFactory<STATE>> totalizeNwa = new TotalizeNwa<LETTER, ISinkStateFactory<STATE>>(this.mSndOperand, this.mStateFactory, true);
            ComplementDeterministicNwa<LETTER, ISinkStateFactory<STATE>> complementDeterministicNwa = new ComplementDeterministicNwa<LETTER, ISinkStateFactory<STATE>>(totalizeNwa);
            IntersectNwa<LETTER, ISinkStateFactory<STATE>> intersectNwa = new IntersectNwa<LETTER, ISinkStateFactory<STATE>>(this.mFstOperand, complementDeterministicNwa, SF, bl);
            NestedWordAutomatonReachableStates<LETTER, ISinkStateFactory<STATE>> nestedWordAutomatonReachableStates = new NestedWordAutomatonReachableStates<LETTER, ISinkStateFactory<STATE>>(this.mServices, intersectNwa);
            if (!totalizeNwa.nonDeterminismInInputDetected()) {
                this.mSndComplemented = complementDeterministicNwa;
                this.mIntersect = intersectNwa;
                this.mResult = nestedWordAutomatonReachableStates;
                if (this.mLogger.isInfoEnabled()) {
                    this.mLogger.info((Object)"Subtrahend was deterministic. Have not used determinization.");
                }
                return;
            }
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)"Subtrahend was not deterministic. Recomputing result with determinization.");
            }
        }
        this.mSndDeterminized = new DeterminizeNwa<LETTER, STATE>(this.mServices, this.mSndOperand, this.mStateDeterminizer, this.mStateFactory, null, true);
        this.mSndComplemented = new ComplementDeterministicNwa<LETTER, STATE>(this.mSndDeterminized);
        this.mIntersect = new IntersectNwa<LETTER, STATE>(this.mFstOperand, this.mSndComplemented, SF, bl);
        this.mResult = new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, this.mIntersect);
    }

    private boolean hasSeveralInitialStates(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        Iterator iterator = iNwaOutgoingLetterAndTransitionProvider.getInitialStates().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        iterator.next();
        return iterator.hasNext();
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondComplemented() {
        return this.mSndComplemented;
    }

    @Override
    public IDoubleDeckerAutomaton<LETTER, STATE> getResult() {
        if (this.mResultWOdeadEnds == null) {
            return this.mResult;
        }
        return this.mResultWOdeadEnds;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton = new RemoveUnreachable<LETTER, STATE>(this.mServices, this.mFstOperand).getResult();
        Object object = new DifferenceDD<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, iDoubleDeckerAutomaton, this.mSndOperand, new PowersetDeterminizer<LETTER, STATE>(this.mSndOperand, true, iNwaInclusionStateFactory), false, false).getResult();
        boolean bl = true;
        assert (bl &= new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, object, this.mResult).getResult().booleanValue());
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mFstOperand, this.mSndOperand);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }

    @Override
    public boolean removeDeadEnds() throws AutomataOperationCanceledException {
        this.mResult.computeDeadEnds();
        this.mResultWOdeadEnds = new DoubleDeckerAutomatonFilteredStates<LETTER, STATE>(this.mServices, this.mResult, this.mResult.getWithOutDeadEnds());
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("With dead ends: " + this.mResult.getStates().size()));
            this.mLogger.info((Object)("Without dead ends: " + this.mResultWOdeadEnds.getStates().size()));
        }
        return this.mResult.getStates().size() != this.mResultWOdeadEnds.getStates().size();
    }

    @Override
    public long getDeadEndRemovalTime() {
        return 0L;
    }

    @Override
    public Iterable<IOpWithDelayedDeadEndRemoval.UpDownEntry<STATE>> getRemovedUpDownEntry() {
        return this.mResult.getWithOutDeadEnds().getRemovedUpDownEntry();
    }

    public Map<STATE, Map<STATE, ProductNwa.ProductState>> getFst2snd2res() {
        return this.mIntersect.getFst2snd2res();
    }
}

