/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Predicate;

public final class UltimateNormalFormUtils {
    private UltimateNormalFormUtils() {
    }

    private static boolean rootRespectsUltimateNormalForm(ConstantTerm constantTerm) {
        if (SmtSortUtils.isBitvecSort(constantTerm.getSort())) {
            if (constantTerm.getValue() instanceof BigInteger) {
                return true;
            }
            assert (false) : "ConstantTerms that have bitvector sort have to use BigInteger";
            return false;
        }
        if (SmtSortUtils.isNumericSort(constantTerm.getSort())) {
            if (constantTerm.getValue() instanceof Rational) {
                return true;
            }
            assert (false) : "ConstantTerms have to use Rationals";
            return false;
        }
        assert (false) : "We support only ConstantTerms whose Sort is a numeric sort or a bitvector sort";
        return false;
    }

    private static boolean rootRespectsUltimateNormalForm(ApplicationTerm applicationTerm) {
        int n;
        Term[] termArray;
        Term term;
        Term term2;
        if ("distinct".equals(applicationTerm.getFunction().getName())) {
            assert (false) : "use not and equals";
            return false;
        }
        if (applicationTerm.getFunction().getName().equals("select")) {
            term2 = applicationTerm.getParameters()[0];
            term = applicationTerm.getParameters()[1];
            if (term.equals(SmtUtils.getArrayStoreIdx(term2))) {
                assert (false) : "select-over-store with same index should have been removed";
                return false;
            }
        }
        if (applicationTerm.getFunction().getName().equals("store")) {
            term2 = applicationTerm.getParameters()[0];
            term = applicationTerm.getParameters()[1];
            if (term.equals(SmtUtils.getArrayStoreIdx(term2))) {
                assert (false) : "select-over-store with same index should have been removed";
                return false;
            }
        }
        if (applicationTerm.getFunction().getName().equals("+")) {
            termArray = applicationTerm.getParameters();
            n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                term2 = termArray[n2];
                if (SmtUtils.isIntegerLiteral(BigInteger.ZERO, term2)) {
                    assert (false) : "zero is neutral element of plus operator";
                    return false;
                }
                ++n2;
            }
        }
        if (applicationTerm.getFunction().getName().equals("bvadd")) {
            termArray = applicationTerm.getParameters();
            n = termArray.length;
            int n3 = 0;
            while (n3 < n) {
                term2 = termArray[n3];
                if (BitvectorUtils.isBitvectorConstant(BigInteger.ZERO, term2)) {
                    assert (false) : "zero is neutral element of plus operator";
                    return false;
                }
                ++n3;
            }
        }
        if (applicationTerm.getFunction().getName().equals("bvand")) {
            termArray = applicationTerm.getParameters();
            n = termArray.length;
            int n4 = 0;
            while (n4 < n) {
                term2 = termArray[n4];
                if (BitvectorUtils.isBitvectorConstant(BigInteger.ZERO, term2)) {
                    assert (false) : "zero is absorbing element of bvand operator";
                    return false;
                }
                ++n4;
            }
        }
        if (SmtUtils.isUnaryNumericMinus(applicationTerm.getFunction())) {
            term2 = applicationTerm.getParameters()[0];
            if (term2 instanceof ConstantTerm) {
                return true;
            }
            if (term2 instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
                if (applicationTerm2.getFunction().getName().equals("+")) {
                    assert (false) : "must not be argument of unary minus " + applicationTerm2.getFunction().getName();
                    return false;
                }
                return true;
            }
            if (term2 instanceof TermVariable) {
                return true;
            }
            throw new AssertionError((Object)("Illegal kind of term " + term2.getClass().getSimpleName()));
        }
        if (applicationTerm.getFunction().getName().equals("or")) {
            if (Arrays.asList(applicationTerm.getParameters()).stream().anyMatch(SmtUtils::isTrueLiteral)) {
                assert (false) : "true is absorbing for or: " + String.valueOf(applicationTerm);
                return false;
            }
            if (Arrays.asList(applicationTerm.getParameters()).stream().anyMatch(SmtUtils::isFalseLiteral)) {
                assert (false) : "disjunction with false is identity: " + String.valueOf(applicationTerm);
                return false;
            }
        }
        if (applicationTerm.getFunction().getName().equals("and")) {
            if (Arrays.asList(applicationTerm.getParameters()).stream().anyMatch(SmtUtils::isFalseLiteral)) {
                assert (false) : "false is absorbing for and: " + String.valueOf(applicationTerm);
                return false;
            }
            if (Arrays.asList(applicationTerm.getParameters()).stream().anyMatch(SmtUtils::isTrueLiteral)) {
                assert (false) : "conjunction with true is identity: " + String.valueOf(applicationTerm);
                return false;
            }
        }
        return true;
    }

    private static boolean rootRespectsUltimateNormalForm(Term term) {
        if (term instanceof ApplicationTerm) {
            return UltimateNormalFormUtils.rootRespectsUltimateNormalForm((ApplicationTerm)term);
        }
        if (term instanceof ConstantTerm) {
            return UltimateNormalFormUtils.rootRespectsUltimateNormalForm((ConstantTerm)term);
        }
        return true;
    }

    public static boolean respectsUltimateNormalForm(Term term2) {
        Predicate<Term> predicate = term -> !UltimateNormalFormUtils.rootRespectsUltimateNormalForm(term);
        return !new SubtermPropertyChecker(predicate).isSatisfiedBySomeSubterm(term2);
    }
}

