/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.OverapproxVariable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.List;
import java.util.function.BinaryOperator;

public class BitabsTranslation {
    private final TypeSizes mTypeSizes;

    public BitabsTranslation(TypeSizes typeSizes) {
        this.mTypeSizes = typeSizes;
    }

    public ExpressionResult abstractAnd(ILocation iLocation, Expression expression, Expression expression2, CPrimitive cPrimitive, AuxVarInfoBuilder auxVarInfoBuilder) {
        Object object;
        Expression expression3;
        Expression expression4;
        Expression expression5;
        Expression expression6;
        List<Expression> list;
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(expression, cPrimitive);
        BigInteger bigInteger2 = this.mTypeSizes.extractIntegerValue(expression2, cPrimitive);
        if (bigInteger != null && bigInteger2 != null) {
            return BitabsTranslation.handleConstants(bigInteger, bigInteger2, BigInteger::and, iLocation, cPrimitive);
        }
        Expression expression7 = this.tryToHandleAndExactlyForOneConstant(iLocation, expression2, bigInteger, cPrimitive);
        if (expression7 != null) {
            return new ExpressionResult(new RValue(expression7, cPrimitive));
        }
        Expression expression8 = this.tryToHandleAndExactlyForOneConstant(iLocation, expression, bigInteger2, cPrimitive);
        if (expression8 != null) {
            return new ExpressionResult(new RValue(expression8, cPrimitive));
        }
        IntegerLiteral integerLiteral = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, "0");
        AuxVarInfo auxVarInfo = auxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.BITWISE);
        Expression expression9 = this.applyWraparoundIfNecessary(iLocation, (Expression)auxVarInfo.getExp(), cPrimitive);
        Expression expression10 = this.applyWraparoundIfNecessary(iLocation, expression, cPrimitive);
        Expression expression11 = this.applyWraparoundIfNecessary(iLocation, expression2, cPrimitive);
        Expression expression12 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLEQ, (Expression)expression9, (Expression)expression10);
        Expression expression13 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLEQ, (Expression)expression9, (Expression)expression11);
        if (this.mTypeSizes.isUnsigned(cPrimitive)) {
            list = List.of(expression12, expression13);
        } else {
            expression6 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression, (Expression)integerLiteral);
            expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression2, (Expression)integerLiteral);
            expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression, (Expression)integerLiteral), (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression2, (Expression)integerLiteral));
            expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression6, (Expression)expression5);
            object = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)expression, (Expression)expression2);
            Expression expression14 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression2, (Expression)integerLiteral);
            Expression expression15 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression6, (Expression)expression14), (Expression)expression12);
            Expression expression16 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression, (Expression)integerLiteral);
            Expression expression17 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression16, (Expression)expression5), (Expression)expression13);
            Expression expression18 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression3, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression9, (Expression)integerLiteral));
            Expression expression19 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression4, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGT, (Expression)expression9, (Expression)object));
            BigInteger bigInteger3 = this.mTypeSizes.getMinValueOfPrimitiveType(cPrimitive);
            Expression expression20 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression9, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger3.toString()));
            list = List.of(expression15, expression17, expression18, expression19, expression20);
        }
        expression6 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression10, (Expression)integerLiteral);
        expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression11, (Expression)integerLiteral);
        expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression10, (Expression)expression11);
        expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression6, (Expression)expression5);
        object = List.of(new Pair((Object)expression3, (Object)integerLiteral), new Pair((Object)expression4, (Object)expression));
        return BitabsTranslation.buildExpressionResult(iLocation, "bitwiseAnd", cPrimitive, auxVarInfo, (List<Pair<Expression, Expression>>)object, list);
    }

    private static boolean endsWithOnes(BigInteger bigInteger) {
        return bigInteger.signum() > 0 && bigInteger.and(bigInteger.add(BigInteger.ONE)).signum() == 0;
    }

    private Expression tryToHandleAndExactlyForOneConstant(ILocation iLocation, Expression expression, BigInteger bigInteger, CPrimitive cPrimitive) {
        BigInteger bigInteger2;
        if (bigInteger == null) {
            return null;
        }
        if (bigInteger.signum() == 0) {
            return ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)"0");
        }
        BigInteger bigInteger3 = bigInteger2 = this.mTypeSizes.isUnsigned(cPrimitive) ? this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive) : BigInteger.ONE.negate();
        if (bigInteger2.equals(bigInteger)) {
            return expression;
        }
        if (BitabsTranslation.endsWithOnes(bigInteger)) {
            IntegerLiteral integerLiteral = ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger.add(BigInteger.ONE).toString());
            return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMOD, (Expression)expression, (Expression)integerLiteral);
        }
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger);
        if (BitabsTranslation.endsWithOnes(bigInteger4)) {
            IntegerLiteral integerLiteral = ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger4.add(BigInteger.ONE).toString());
            Expression expression2 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMOD, (Expression)expression, (Expression)integerLiteral);
            return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMINUS, (Expression)expression, (Expression)expression2);
        }
        return null;
    }

    public ExpressionResult abstractOr(ILocation iLocation, Expression expression, Expression expression2, CPrimitive cPrimitive, AuxVarInfoBuilder auxVarInfoBuilder) {
        Object object;
        Expression expression3;
        Expression expression4;
        Expression expression5;
        Expression expression6;
        List<Expression> list;
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(expression, cPrimitive);
        BigInteger bigInteger2 = this.mTypeSizes.extractIntegerValue(expression2, cPrimitive);
        if (bigInteger != null && bigInteger2 != null) {
            return BitabsTranslation.handleConstants(bigInteger, bigInteger2, BigInteger::or, iLocation, cPrimitive);
        }
        Expression expression7 = this.tryToHandleAndExactlyForOneConstant(iLocation, expression2, bigInteger, cPrimitive);
        if (expression7 != null) {
            Expression expression8 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)expression, (Expression)expression2);
            return new ExpressionResult(new RValue(ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMINUS, (Expression)expression8, (Expression)expression7), cPrimitive));
        }
        Expression expression9 = this.tryToHandleAndExactlyForOneConstant(iLocation, expression, bigInteger2, cPrimitive);
        if (expression9 != null) {
            Expression expression10 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)expression, (Expression)expression2);
            return new ExpressionResult(new RValue(ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMINUS, (Expression)expression10, (Expression)expression9), cPrimitive));
        }
        IntegerLiteral integerLiteral = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, "0");
        AuxVarInfo auxVarInfo = auxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.BITWISE);
        Expression expression11 = this.applyWraparoundIfNecessary(iLocation, (Expression)auxVarInfo.getExp(), cPrimitive);
        Expression expression12 = this.applyWraparoundIfNecessary(iLocation, expression, cPrimitive);
        Expression expression13 = this.applyWraparoundIfNecessary(iLocation, expression2, cPrimitive);
        Expression expression14 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression11, (Expression)expression12);
        Expression expression15 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression11, (Expression)expression13);
        Expression expression16 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)expression12, (Expression)expression13);
        Expression expression17 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLEQ, (Expression)expression11, (Expression)expression16);
        if (this.mTypeSizes.isUnsigned(cPrimitive)) {
            list = List.of(expression14, expression15, expression17);
        } else {
            expression6 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression, (Expression)integerLiteral);
            expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression2, (Expression)integerLiteral);
            expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression6, (Expression)expression5);
            expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression, (Expression)integerLiteral), (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression2, (Expression)integerLiteral));
            object = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression2, (Expression)integerLiteral);
            Expression expression18 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression6, (Expression)object), (Expression)expression15);
            Expression expression19 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression, (Expression)integerLiteral);
            Expression expression20 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression19, (Expression)expression5), (Expression)expression14);
            Expression expression21 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression4, (Expression)expression17);
            Expression expression22 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression3, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression11, (Expression)integerLiteral));
            BigInteger bigInteger3 = this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive);
            Expression expression23 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLEQ, (Expression)expression11, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger3.toString()));
            list = List.of(expression18, expression20, expression21, expression22, expression23);
        }
        expression6 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression12, (Expression)integerLiteral);
        expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression13, (Expression)integerLiteral);
        expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression12, (Expression)expression13);
        expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression6, (Expression)expression4);
        object = List.of(new Pair((Object)expression3, (Object)expression2), new Pair((Object)expression5, (Object)expression));
        return BitabsTranslation.buildExpressionResult(iLocation, "bitwiseOr", cPrimitive, auxVarInfo, (List<Pair<Expression, Expression>>)object, list);
    }

    public ExpressionResult abstractXor(ILocation iLocation, Expression expression, Expression expression2, CPrimitive cPrimitive, AuxVarInfoBuilder auxVarInfoBuilder) {
        Object object;
        Expression expression3;
        Expression expression4;
        Expression expression5;
        List<Expression> list;
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(expression, cPrimitive);
        BigInteger bigInteger2 = this.mTypeSizes.extractIntegerValue(expression2, cPrimitive);
        if (bigInteger != null && bigInteger2 != null) {
            return BitabsTranslation.handleConstants(bigInteger, bigInteger2, BigInteger::xor, iLocation, cPrimitive);
        }
        Expression expression6 = this.tryToHandleAndExactlyForOneConstant(iLocation, expression2, bigInteger, cPrimitive);
        if (expression6 != null) {
            Expression expression7 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)expression, (Expression)expression2);
            Expression expression8 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMUL, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)"2"), (Expression)expression6);
            return new ExpressionResult(new RValue(ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMINUS, (Expression)expression7, (Expression)expression8), cPrimitive));
        }
        Expression expression9 = this.tryToHandleAndExactlyForOneConstant(iLocation, expression, bigInteger2, cPrimitive);
        if (expression9 != null) {
            Expression expression10 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)expression, (Expression)expression2);
            Expression expression11 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMUL, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)"2"), (Expression)expression9);
            return new ExpressionResult(new RValue(ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMINUS, (Expression)expression10, (Expression)expression11), cPrimitive));
        }
        IntegerLiteral integerLiteral = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, "0");
        AuxVarInfo auxVarInfo = auxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.BITWISE);
        Expression expression12 = this.applyWraparoundIfNecessary(iLocation, (Expression)auxVarInfo.getExp(), cPrimitive);
        Expression expression13 = this.applyWraparoundIfNecessary(iLocation, expression, cPrimitive);
        Expression expression14 = this.applyWraparoundIfNecessary(iLocation, expression2, cPrimitive);
        Expression expression15 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)expression13, (Expression)expression14);
        Expression expression16 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLEQ, (Expression)expression12, (Expression)expression15);
        if (this.mTypeSizes.isUnsigned(cPrimitive)) {
            list = List.of(expression16);
        } else {
            expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression, (Expression)integerLiteral);
            expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression2, (Expression)integerLiteral);
            expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression, (Expression)integerLiteral);
            object = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression2, (Expression)integerLiteral);
            Expression expression17 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression5, (Expression)expression4);
            Expression expression18 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGT, (Expression)expression, (Expression)integerLiteral), (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGT, (Expression)expression2, (Expression)integerLiteral));
            Expression expression19 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLT, (Expression)expression12, (Expression)integerLiteral);
            Expression expression20 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGT, (Expression)expression12, (Expression)integerLiteral);
            Expression expression21 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression17, (Expression)expression20);
            Expression expression22 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression18, (Expression)expression20);
            Expression expression23 = ExpressionFactory.or((ILocation)iLocation, List.of(expression5, object, expression19));
            Expression expression24 = ExpressionFactory.or((ILocation)iLocation, List.of(expression3, expression4, expression19));
            Expression expression25 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression17, (Expression)expression16);
            BigInteger bigInteger3 = this.mTypeSizes.getMinValueOfPrimitiveType(cPrimitive);
            Expression expression26 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGEQ, (Expression)expression12, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger3.toString()));
            BigInteger bigInteger4 = this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive);
            Expression expression27 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPLEQ, (Expression)expression12, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger4.toString()));
            list = List.of(expression21, expression22, expression23, expression24, expression25, expression26, expression27);
        }
        expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression13, (Expression)integerLiteral);
        expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression14, (Expression)integerLiteral);
        expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression13, (Expression)expression14);
        object = List.of(new Pair((Object)expression5, (Object)expression2), new Pair((Object)expression4, (Object)expression), new Pair((Object)expression3, (Object)integerLiteral));
        return BitabsTranslation.buildExpressionResult(iLocation, "bitwiseOr", cPrimitive, auxVarInfo, (List<Pair<Expression, Expression>>)object, list);
    }

    public ExpressionResult abstractLeftShift(ILocation iLocation, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2, AuxVarInfoBuilder auxVarInfoBuilder) {
        return this.abstractShift(iLocation, expression, cPrimitive, expression2, cPrimitive2, auxVarInfoBuilder, "shiftLeft", BinaryExpression.Operator.ARITHMUL, BinaryExpression.Operator.COMPGT);
    }

    public ExpressionResult abstractRightShift(ILocation iLocation, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2, AuxVarInfoBuilder auxVarInfoBuilder) {
        return this.abstractShift(iLocation, expression, cPrimitive, expression2, cPrimitive2, auxVarInfoBuilder, "shiftRight", BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.COMPLT);
    }

    private Integer extractShiftValue(Expression expression, CPrimitive cPrimitive) {
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(expression, cPrimitive);
        if (bigInteger == null || bigInteger.signum() < 0) {
            return null;
        }
        try {
            return bigInteger.intValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }

    private ExpressionResult abstractShift(ILocation iLocation, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2, AuxVarInfoBuilder auxVarInfoBuilder, String string, BinaryExpression.Operator operator, BinaryExpression.Operator operator2) {
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(expression, cPrimitive);
        Integer n = this.extractShiftValue(expression2, cPrimitive2);
        if (BigInteger.ZERO.equals(bigInteger) || Integer.valueOf(0).equals(n)) {
            return new ExpressionResult(new RValue(expression, cPrimitive));
        }
        Expression expression3 = this.applyWraparoundIfNecessary(iLocation, expression, cPrimitive);
        if (n != null) {
            Expression expression4 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.TWO.pow(n));
            Expression expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)operator, (Expression)expression3, (Expression)expression4);
            return new ExpressionResult(new RValue(expression5, cPrimitive));
        }
        AuxVarInfo auxVarInfo = auxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.BITWISE);
        IntegerLiteral integerLiteral = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, "0");
        Expression expression6 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression3, (Expression)integerLiteral);
        Expression expression7 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)this.applyWraparoundIfNecessary(iLocation, expression2, cPrimitive2), (Expression)integerLiteral);
        Expression expression8 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression6, (Expression)expression7);
        Expression expression9 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)operator2, (Expression)this.applyWraparoundIfNecessary(iLocation, (Expression)auxVarInfo.getExp(), cPrimitive), (Expression)expression3);
        return BitabsTranslation.buildExpressionResult(iLocation, string, cPrimitive, auxVarInfo, List.of(new Pair((Object)expression8, (Object)expression)), this.mTypeSizes.isUnsigned(cPrimitive) ? List.of() : List.of(expression9));
    }

    private Expression applyWraparoundIfNecessary(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        if (!this.mTypeSizes.isUnsigned(cPrimitive)) {
            return expression;
        }
        BigInteger bigInteger = this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive).add(BigInteger.ONE);
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.ARITHMOD, (Expression)expression, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)bigInteger.toString()));
    }

    private static ExpressionResult handleConstants(BigInteger bigInteger, BigInteger bigInteger2, BinaryOperator<BigInteger> binaryOperator, ILocation iLocation, CPrimitive cPrimitive) {
        BigInteger bigInteger3 = (BigInteger)binaryOperator.apply(bigInteger, bigInteger2);
        return new ExpressionResult(new RValue((Expression)new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, bigInteger3.toString()), cPrimitive));
    }

    private static ExpressionResult buildExpressionResult(ILocation iLocation, String string, CPrimitive cPrimitive, AuxVarInfo auxVarInfo, List<Pair<Expression, Expression>> list, List<Expression> list2) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        IdentifierExpression identifierExpression = auxVarInfo.getExp();
        expressionResultBuilder.setLrValue(new RValue((Expression)identifierExpression, cPrimitive));
        VariableLHS variableLHS = auxVarInfo.getLhs();
        HavocStatement havocStatement = new HavocStatement(iLocation, new VariableLHS[]{variableLHS});
        AssumeStatement assumeStatement = new AssumeStatement(iLocation, ExpressionFactory.and((ILocation)iLocation, list2));
        AtomicStatement atomicStatement = new AtomicStatement(iLocation, new Statement[]{havocStatement, assumeStatement});
        new OverapproxVariable(string, iLocation).annotate((IElement)atomicStatement);
        int n = list.size() - 1;
        while (n >= 0) {
            Pair<Expression, Expression> pair = list.get(n);
            AssignmentStatement assignmentStatement = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression)((Expression)pair.getSecond()));
            Statement statement = StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)((Expression)pair.getFirst()), (Statement[])new Statement[]{assignmentStatement}, (Statement[])new Statement[]{atomicStatement});
            atomicStatement = statement;
            --n;
        }
        return expressionResultBuilder.addStatement((Statement)atomicStatement).build();
    }
}

