/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;

public class ModelFormatter {
    private final String mLineSep = System.getProperty("line.separator");
    private final StringBuilder mString = new StringBuilder("(");
    private int mIndent = 0;
    private final Theory mTheory;

    private void newline() {
        this.mString.append(this.mLineSep);
        int n = 0;
        while (n < this.mIndent) {
            this.mString.append(' ');
            ++n;
        }
    }

    public ModelFormatter(Theory theory) {
        this.mTheory = theory;
    }

    public void appendComment(String string) {
        this.mIndent += 2;
        this.newline();
        this.mString.append(";; ").append(string);
        this.mIndent -= 2;
    }

    public void appendSortInterpretation(SortInterpretation sortInterpretation, Sort sort) {
        Term term = sortInterpretation.toSMTLIB(this.mTheory, sort);
        if (term != null) {
            this.mIndent += 2;
            this.newline();
            this.mString.append(term);
            this.mIndent -= 2;
        }
    }

    public void appendValue(FunctionSymbol functionSymbol, TermVariable[] termVariableArray, Term term) {
        this.mIndent += 2;
        this.newline();
        Sort[] sortArray = functionSymbol.getParameterSorts();
        this.mString.append("(define-fun ").append(PrintTerm.quoteIdentifier((String)functionSymbol.getName())).append(" (");
        int n = 0;
        while (n < termVariableArray.length) {
            this.mString.append('(').append(termVariableArray[n]).append(' ').append(sortArray[n]).append(')');
            ++n;
        }
        this.mString.append(") ").append(functionSymbol.getReturnSort());
        this.mIndent += 2;
        this.appendFunctionValue(term);
        this.mString.append(')');
        this.mIndent -= 2;
        this.mIndent -= 2;
    }

    private void appendFunctionValue(Term term) {
        int n = 0;
        while (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("ite")) {
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            this.newline();
            this.mString.append("(ite ").append(termArray[0].toStringDirect()).append(' ').append(termArray[1].toStringDirect());
            term = termArray[2];
            ++n;
        }
        if (n > 0) {
            this.mIndent += 2;
            this.newline();
            this.mString.append(term.toStringDirect());
            int n2 = 0;
            while (n2 < n) {
                this.mString.append(')');
                ++n2;
            }
            this.mIndent -= 2;
        } else {
            this.newline();
            this.mString.append(term.toStringDirect());
        }
    }

    public String finish() {
        return this.mString.append(')').toString();
    }
}

