/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.ChannelOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.FrontEndOptions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.LoggerOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.SolverOptions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.VerbosityOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class OptionMap {
    private static final String DIAG_OUTPUT_CHANNEL_DESC = "Where to print diagnostic output to.  Use \"stdout\" for standard output and \"stderr\" for standard error.";
    private final LinkedHashMap<String, Option> mOptions;
    private final LinkedHashMap<String, String> mAliases;
    private final SolverOptions mSolverOptions;
    private final FrontEndOptions mFrontEndOptions;
    private final LogProxy mLogger;
    private boolean mOnline;

    public OptionMap(LogProxy logProxy) {
        this(logProxy, false);
    }

    public OptionMap(LogProxy logProxy, boolean bl) {
        this.mOptions = new LinkedHashMap();
        this.mAliases = new LinkedHashMap();
        this.mSolverOptions = new SolverOptions(this, logProxy);
        this.mLogger = logProxy;
        this.addOption(":diagnostic-output-channel", new LoggerOption(DIAG_OUTPUT_CHANNEL_DESC, logProxy));
        this.mOnline = false;
        this.mFrontEndOptions = new FrontEndOptions(this, bl);
    }

    private OptionMap(LogProxy logProxy, LinkedHashMap<String, Option> linkedHashMap, LinkedHashMap<String, String> linkedHashMap2) {
        this.mOptions = linkedHashMap;
        this.mAliases = linkedHashMap2;
        this.mSolverOptions = new SolverOptions(this);
        this.mFrontEndOptions = new FrontEndOptions(this);
        this.mLogger = logProxy;
        this.mOnline = false;
    }

    public void started() {
        for (Option option : this.mOptions.values()) {
            option.started();
        }
    }

    public void setOnline() {
        this.mOnline = true;
    }

    public final LogProxy getLogProxy() {
        return this.mLogger;
    }

    public final SolverOptions getSolverOptions() {
        return this.mSolverOptions;
    }

    public final FrontEndOptions getFrontEndOptions() {
        return this.mFrontEndOptions;
    }

    public void addOption(String string, Option option) {
        this.mOptions.put(string, option);
    }

    public void addAlias(String string, String string2) {
        this.mAliases.put(string, string2);
    }

    public Object get(String string) {
        Option option;
        if (this.mAliases.containsKey(string)) {
            string = this.mAliases.get(string);
        }
        if ((option = this.mOptions.get(string)) == null) {
            throw new UnsupportedOperationException();
        }
        return option.get();
    }

    public void set(String string, Object object) {
        Option option;
        if (this.mAliases.containsKey(string)) {
            string = this.mAliases.get(string);
        }
        if ((option = this.mOptions.get(string)) == null) {
            throw new UnsupportedOperationException();
        }
        if (this.mOnline && !option.isOnlineModifiable()) {
            throw new SMTLIBException("Option " + string + " can only be changed before setting the logic");
        }
        option.set(object);
    }

    public String[] getInfo() {
        String[] stringArray = new String[this.mOptions.size() + this.mAliases.size()];
        int n = 0;
        for (String string : this.mOptions.keySet()) {
            stringArray[n++] = string;
        }
        for (String string : this.mAliases.keySet()) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public Object[] getInfo(String string, boolean bl) {
        Option option;
        if (this.mAliases.containsKey(string)) {
            string = this.mAliases.get(string);
        }
        if ((option = this.mOptions.get(string)) == null) {
            throw new UnsupportedOperationException();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(":description");
        arrayList.add(new QuotedObject(option.getDescription(), bl));
        arrayList.add(":default");
        arrayList.add(option.defaultValue());
        if (option.isOnlineModifiable()) {
            arrayList.add(":online-modifiable");
        }
        return arrayList.toArray();
    }

    public void reset() {
        this.mOnline = false;
        for (Option option : this.mOptions.values()) {
            option.reset();
        }
    }

    public OptionMap copy(CopyMode copyMode) {
        LinkedHashMap<String, Option> linkedHashMap = new LinkedHashMap<String, Option>();
        for (Map.Entry<String, Option> entry : this.mOptions.entrySet()) {
            Option option = entry.getValue().copy();
            switch (copyMode) {
                case CURRENT_VALUE: {
                    break;
                }
                case RESET_EXCEPT_CHANNELS: {
                    if (option instanceof VerbosityOption || option instanceof ChannelOption) break;
                }
                default: {
                    option.reset();
                }
            }
            linkedHashMap.put(entry.getKey(), option);
        }
        return new OptionMap(this.mLogger, linkedHashMap, new LinkedHashMap<String, String>(this.mAliases));
    }

    public Option getOption(String string) {
        return this.mOptions.get(string);
    }

    public static enum CopyMode {
        CURRENT_VALUE,
        RESET_TO_DEFAULT,
        RESET_EXCEPT_CHANNELS;

    }
}

