/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.FunctionDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModelDescription
implements Model {
    private final Map<String, FunctionDefinition> mDefinitions;

    public ModelDescription(Set<FunctionDefinition> set) {
        this.mDefinitions = set.stream().collect(Collectors.toMap(functionDefinition -> functionDefinition.getName().getName(), Function.identity()));
    }

    public Term evaluate(Term term) {
        throw new UnsupportedOperationException();
    }

    public Map<Term, Term> evaluate(Term[] termArray) {
        throw new UnsupportedOperationException();
    }

    public Set<FunctionSymbol> getDefinedFunctions() {
        return this.mDefinitions.values().stream().map(FunctionDefinition::getName).collect(Collectors.toSet());
    }

    public Term getFunctionDefinition(String string, TermVariable[] termVariableArray) {
        FunctionDefinition functionDefinition = this.getFunctionDefinition(string);
        TermVariable[] termVariableArray2 = functionDefinition.getParams();
        assert (termVariableArray2.length == termVariableArray.length) : "Number of parameters does not match arity of " + string;
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        int n = 0;
        while (n < termVariableArray.length) {
            assert (Objects.equals(termVariableArray2[n].getSort(), termVariableArray[n].getSort()));
            hashMap.put(termVariableArray2[n], termVariableArray[n]);
            ++n;
        }
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        formulaUnLet.addSubstitutions(hashMap);
        return formulaUnLet.transform(functionDefinition.getBody());
    }

    private FunctionDefinition getFunctionDefinition(String string) {
        return this.mDefinitions.get(string);
    }

    public String toString() {
        return this.mDefinitions.values().stream().map(Object::toString).collect(Collectors.joining("\n"));
    }
}

