/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.IInterpolantAutomatonBuilder;
import java.util.Iterator;
import java.util.List;

public class StraightLineInterpolantAutomatonBuilder<LETTER>
implements IInterpolantAutomatonBuilder<LETTER, IPredicate> {
    private final NestedWordAutomaton<LETTER, IPredicate> mResult;

    public StraightLineInterpolantAutomatonBuilder(IUltimateServiceProvider iUltimateServiceProvider, Word<LETTER> word, VpAlphabet<LETTER> vpAlphabet, List<TracePredicates> list, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, InitialAndAcceptingStateMode initialAndAcceptingStateMode) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty list of interpolant sequences is not allowed.");
        }
        assert (StraightLineInterpolantAutomatonBuilder.sequencesHaveSamePrePostconditions(list)) : "The interpolant sequences should have the same pre- and postconditions.";
        this.mResult = this.constructInterpolantAutomaton(iUltimateServiceProvider, vpAlphabet, list, NestedWord.nestedWord(word), iEmptyStackStateFactory, initialAndAcceptingStateMode);
    }

    @Override
    public NestedWordAutomaton<LETTER, IPredicate> getResult() {
        return this.mResult;
    }

    private NestedWordAutomaton<LETTER, IPredicate> constructInterpolantAutomaton(IUltimateServiceProvider iUltimateServiceProvider, VpAlphabet<LETTER> vpAlphabet, List<TracePredicates> list, NestedWord<LETTER> nestedWord, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, InitialAndAcceptingStateMode initialAndAcceptingStateMode) {
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(iUltimateServiceProvider), vpAlphabet, iEmptyStackStateFactory);
        this.addStatesAccordingToPredicates(nestedWordAutomaton, list, nestedWord, initialAndAcceptingStateMode);
        this.addBasicTransitions(nestedWordAutomaton, list, nestedWord);
        return nestedWordAutomaton;
    }

    private void addStatesAccordingToPredicates(NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton, List<TracePredicates> list, NestedWord<LETTER> nestedWord, InitialAndAcceptingStateMode initialAndAcceptingStateMode) {
        IPredicate iPredicate2 = list.get(0).getPrecondition();
        boolean bl = this.isStateAccepting(initialAndAcceptingStateMode, iPredicate2);
        nestedWordAutomaton.addState(true, bl, (Object)iPredicate2);
        for (TracePredicates tracePredicates : list) {
            int n = 1;
            while (n < nestedWord.length() + 1) {
                IPredicate iPredicate = tracePredicates.getPredicate(n);
                if (!nestedWordAutomaton.getStates().contains(iPredicate)) {
                    this.isStateAccepting(initialAndAcceptingStateMode, iPredicate);
                    nestedWordAutomaton.addState(false, StraightLineInterpolantAutomatonBuilder.isFalsePredicate(iPredicate), (Object)iPredicate);
                }
                ++n;
            }
        }
    }

    private boolean isStateAccepting(InitialAndAcceptingStateMode initialAndAcceptingStateMode, IPredicate iPredicate) throws AssertionError {
        return switch (initialAndAcceptingStateMode) {
            case InitialAndAcceptingStateMode.ALL_INITIAL_ALL_ACCEPTING -> true;
            case InitialAndAcceptingStateMode.ONLY_FIRST_INITIAL_ONLY_FALSE_ACCEPTING -> StraightLineInterpolantAutomatonBuilder.isFalsePredicate(iPredicate);
            default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)initialAndAcceptingStateMode)));
        };
    }

    private static boolean isFalsePredicate(IPredicate iPredicate) {
        return SmtUtils.isFalseLiteral((Term)iPredicate.getFormula());
    }

    private void addBasicTransitions(NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton, List<TracePredicates> list, NestedWord<LETTER> nestedWord) {
        for (TracePredicates tracePredicates : list) {
            int n = 0;
            while (n < nestedWord.length()) {
                this.addTransition(nestedWordAutomaton, tracePredicates, nestedWord, n);
                ++n;
            }
        }
    }

    private void addTransition(NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton, TracePredicates tracePredicates, NestedWord<LETTER> nestedWord, int n) {
        Object object = nestedWord.getSymbol(n);
        IPredicate iPredicate = tracePredicates.getPredicate(n + 1);
        if (nestedWord.isCallPosition(n)) {
            IPredicate iPredicate2 = tracePredicates.getPredicate(n);
            if (!nestedWordAutomaton.containsCallTransition((Object)iPredicate2, object, (Object)iPredicate)) {
                nestedWordAutomaton.addCallTransition((Object)iPredicate2, object, (Object)iPredicate);
            }
        } else if (nestedWord.isReturnPosition(n)) {
            int n2;
            IPredicate iPredicate3;
            IPredicate iPredicate4 = tracePredicates.getPredicate(n);
            if (!nestedWordAutomaton.containsReturnTransition((Object)iPredicate4, (Object)(iPredicate3 = tracePredicates.getPredicate(n2 = nestedWord.getCallPosition(n))), object, (Object)iPredicate)) {
                nestedWordAutomaton.addReturnTransition((Object)iPredicate4, (Object)iPredicate3, object, (Object)iPredicate);
            }
        } else {
            IPredicate iPredicate5 = tracePredicates.getPredicate(n);
            if (!nestedWordAutomaton.containsInternalTransition((Object)iPredicate5, object, (Object)iPredicate)) {
                nestedWordAutomaton.addInternalTransition((Object)iPredicate5, object, (Object)iPredicate);
            }
        }
    }

    private static boolean sequencesHaveSamePrePostconditions(List<TracePredicates> list) {
        Iterator<TracePredicates> iterator = list.iterator();
        TracePredicates tracePredicates = iterator.next();
        IPredicate iPredicate = tracePredicates.getPrecondition();
        IPredicate iPredicate2 = tracePredicates.getPostcondition();
        while (iterator.hasNext()) {
            TracePredicates tracePredicates2 = iterator.next();
            if (iPredicate == tracePredicates2.getPrecondition() && iPredicate2 == tracePredicates2.getPostcondition()) continue;
            return false;
        }
        return true;
    }

    public static enum InitialAndAcceptingStateMode {
        ONLY_FIRST_INITIAL_ONLY_FALSE_ACCEPTING,
        ALL_INITIAL_ALL_ACCEPTING;

    }
}

