/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;

public class FunctionDefinition {
    private final FunctionSymbol mName;
    private final TermVariable[] mParams;
    private final Term mBody;

    public FunctionDefinition(FunctionSymbol functionSymbol, TermVariable[] termVariableArray, Term term) {
        this.mName = functionSymbol;
        this.mParams = termVariableArray;
        this.mBody = term;
    }

    public FunctionSymbol getName() {
        return this.mName;
    }

    public TermVariable[] getParams() {
        return this.mParams;
    }

    public Sort getReturnSort() {
        return this.mName.getReturnSort();
    }

    public Term getBody() {
        return this.mBody;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(define-fun ");
        stringBuilder.append(this.mName);
        stringBuilder.append(" (");
        TermVariable[] termVariableArray = this.mParams;
        int n = this.mParams.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            stringBuilder.append("(");
            stringBuilder.append(termVariable.toString());
            stringBuilder.append(" ");
            stringBuilder.append(termVariable.getSort());
            stringBuilder.append(") ");
            ++n2;
        }
        stringBuilder.append(") ");
        stringBuilder.append(this.getReturnSort());
        stringBuilder.append(" ");
        stringBuilder.append(this.mBody);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

