/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import com.github.jhoenicke.javacup.runtime.SimpleSymbolFactory;
import com.github.jhoenicke.javacup.runtime.Symbol;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ConstantTermNormalizer;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Lexer;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Parser;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;

public class TermParseUtils {
    private TermParseUtils() {
    }

    public static Term parseTerm(Script script, String string) {
        List<Symbol> list;
        SimpleSymbolFactory simpleSymbolFactory = new SimpleSymbolFactory();
        Lexer lexer = new Lexer(new StringReader(string));
        lexer.setSymbolFactory(simpleSymbolFactory);
        try {
            list = Executor.parseSexpr(lexer);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"IOException but there is neither input nor output");
        }
        Parser parser = new Parser();
        parser.setScript(script);
        list.add(0, new Symbol(57));
        parser.setAnswer(list);
        try {
            Symbol symbol = parser.parse();
            Term term = (Term)symbol.value;
            return new ConstantTermNormalizer().transform(term);
        }
        catch (SMTLIBException sMTLIBException) {
            throw sMTLIBException;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            String string2 = String.format("Wrapping exception %s with message %s", exception.getClass(), exception.getMessage());
            throw new SMTLIBException(string2, (Throwable)exception);
        }
    }
}

