/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.testgen;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TestStep {
    final Map<IdentifierExpression, Collection<Expression>> mInputAssignment;
    final Map<IdentifierExpression, Collection<Expression>> mOutputAssignment;
    final Map<IdentifierExpression, Collection<Expression>> mWaitForAssignment;
    final Collection<Expression> mWaitTime;

    public TestStep(Map<IdentifierExpression, Collection<Expression>> map, Map<IdentifierExpression, Collection<Expression>> map2, Map<IdentifierExpression, Collection<Expression>> map3, Collection<Expression> collection) {
        this.mInputAssignment = map;
        this.mOutputAssignment = map2;
        this.mWaitForAssignment = map3;
        this.mWaitTime = collection;
    }

    public Map<IdentifierExpression, Collection<Expression>> getInputAssignment() {
        return Collections.unmodifiableMap(this.mInputAssignment);
    }

    public Map<IdentifierExpression, Collection<Expression>> getOutputAssignment() {
        return Collections.unmodifiableMap(this.mOutputAssignment);
    }

    public Map<IdentifierExpression, Collection<Expression>> getWaitForAssignment() {
        return Collections.unmodifiableMap(this.mWaitForAssignment);
    }

    public Collection<Expression> getWaitTime() {
        return Collections.unmodifiableCollection(this.mWaitTime);
    }

    public boolean hasOutput() {
        return !this.mOutputAssignment.isEmpty();
    }

    public Set<String> getIdentifier() {
        HashSet<String> hashSet = new HashSet<String>();
        this.mInputAssignment.keySet().forEach(identifierExpression -> {
            boolean bl = hashSet.add(identifierExpression.getIdentifier());
        });
        this.mOutputAssignment.keySet().forEach(identifierExpression -> {
            boolean bl = hashSet.add(identifierExpression.getIdentifier());
        });
        this.mWaitForAssignment.keySet().forEach(identifierExpression -> {
            boolean bl = hashSet.add(identifierExpression.getIdentifier());
        });
        return hashSet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nSet Inputs:\n");
        for (Map.Entry<IdentifierExpression, Collection<Expression>> entry : this.mInputAssignment.entrySet()) {
            stringBuilder.append("\t");
            stringBuilder.append(entry.getKey().getIdentifier());
            stringBuilder.append(" := ");
            stringBuilder.append(TestStep.formatIdentToValue(entry.getValue()));
            stringBuilder.append("\n");
        }
        if (this.mOutputAssignment.size() > 0) {
            stringBuilder.append("Observe: \n");
            for (Map.Entry<IdentifierExpression, Collection<Expression>> entry : this.mOutputAssignment.entrySet()) {
                stringBuilder.append("\t");
                stringBuilder.append(entry.getKey().getIdentifier());
                stringBuilder.append(" == ");
                stringBuilder.append(TestStep.formatIdentToValue(entry.getValue()));
                stringBuilder.append("\n");
            }
        }
        if (this.mWaitForAssignment.size() > 0) {
            stringBuilder.append("Wait " + TestStep.formatIdentToValue(this.mWaitTime) + "for output:\n");
            for (Map.Entry<IdentifierExpression, Collection<Expression>> entry : this.mWaitForAssignment.entrySet()) {
                stringBuilder.append("\t");
                stringBuilder.append(entry.getKey().getIdentifier());
                stringBuilder.append(" == ");
                stringBuilder.append(TestStep.formatIdentToValue(entry.getValue()));
                stringBuilder.append("\n");
            }
        } else {
            stringBuilder.append("For the following " + TestStep.formatIdentToValue(this.mWaitTime) + "time Units");
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n ");
        return stringBuilder.toString();
    }

    private static String formatIdentToValue(Collection<Expression> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Expression expression : collection) {
            stringBuilder.append(TestStep.formatLiteral(expression));
        }
        stringBuilder.append("  ");
        return stringBuilder.toString();
    }

    private static String formatLiteral(Expression expression) {
        if (expression instanceof BooleanLiteral) {
            return Boolean.toString(((BooleanLiteral)expression).getValue());
        }
        if (expression instanceof IntegerLiteral) {
            return ((IntegerLiteral)expression).getValue();
        }
        if (expression instanceof RealLiteral) {
            return ((RealLiteral)expression).getValue();
        }
        return "not antomic";
    }
}

