/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class NamedType
extends ASTType {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(NamedType.class);
    String name;
    ASTType[] typeArgs;

    public NamedType(ILocation iLocation, String string, ASTType[] aSTTypeArray) {
        super(iLocation);
        this.name = string;
        this.typeArgs = aSTTypeArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid NamedType: " + String.valueOf((Object)this);
    }

    public NamedType(ILocation iLocation, IBoogieType iBoogieType, String string, ASTType[] aSTTypeArray) {
        super(iLocation, iBoogieType);
        this.name = string;
        this.typeArgs = aSTTypeArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid NamedType: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NamedType").append('[');
        stringBuffer.append(this.name);
        stringBuffer.append(',');
        if (this.typeArgs == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.typeArgs.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.typeArgs[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getName() {
        return this.name;
    }

    public ASTType[] getTypeArgs() {
        return this.typeArgs;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.typeArgs != null) {
            list.addAll(Arrays.asList(this.typeArgs));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((ASTType)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.typeArgs != null) {
            ASTType[] aSTTypeArray = this.typeArgs;
            int n = this.typeArgs.length;
            int n2 = 0;
            while (n2 < n) {
                ASTType aSTType = aSTTypeArray[n2];
                aSTType.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    @Override
    public ASTType accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        ASTType aSTType = generatedBoogieAstTransformer.transform(this);
        if (aSTType != this) {
            return aSTType;
        }
        boolean bl = false;
        ArrayList<ASTType> arrayList = new ArrayList<ASTType>();
        if (this.typeArgs != null) {
            ASTType[] aSTTypeArray = this.typeArgs;
            int n = this.typeArgs.length;
            int n2 = 0;
            while (n2 < n) {
                ASTType aSTType2 = aSTTypeArray[n2];
                ASTType aSTType3 = aSTType2.accept(generatedBoogieAstTransformer);
                bl = bl || aSTType3 != aSTType2;
                arrayList.add(aSTType3);
                ++n2;
            }
        }
        if (bl) {
            return new NamedType(this.loc, this.boogieType, this.name, arrayList.toArray(new ASTType[0]));
        }
        return this;
    }
}

