/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.CachingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.AbsIntPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.AbstractInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.PathProgram;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbsIntBaseInterpolantGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbsIntPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PathProgramCache;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.AbsIntNonSmtInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.AbsIntStraightLineInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.AbsIntTotalInterpolationAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.IInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.predicates.AbsIntHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.weakener.AbsIntPredicateInterpolantSequenceWeakener;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import de.uni_freiburg.informatik.ultimate.util.statistics.IKeyedStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class CegarAbsIntRunner<LETTER extends IIcfgTransition<?>> {
    private static final boolean USE_INTERPOLANT_WEAKENER = true;
    private static final boolean DEBUG_PRINT_TRACE = false;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final CfgSmtToolkit mCsToolkit;
    private final IIcfg<?> mRoot;
    private final TraceAbstractionPreferenceInitializer.AbstractInterpretationMode mMode;
    private final boolean mAlwaysRefine;
    private final PathProgramCache<LETTER> mPathProgramCache;
    private final TAPreferences mTaPreferences;
    private final AbsIntStatisticsGenerator mStats = new AbsIntStatisticsGenerator();
    private final AbsIntCurrentIteration<?> mCurrentIteration;
    private final IPredicateUnifier mPredicateUnifierSmt;

    public CegarAbsIntRunner(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<?> iIcfg, PathProgramCache<LETTER> pathProgramCache, TAPreferences tAPreferences, Word<LETTER> word, IPredicateUnifier iPredicateUnifier) {
        this.mServices = iUltimateServiceProvider;
        this.mTaPreferences = tAPreferences;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mRoot = iIcfg;
        this.mPathProgramCache = pathProgramCache;
        this.mCsToolkit = iIcfg.getCfgSmtToolkit();
        this.mPredicateUnifierSmt = Objects.requireNonNull(iPredicateUnifier);
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mAlwaysRefine = iPreferenceProvider.getBoolean("Refine always when using abstract interpretation");
        this.mMode = (TraceAbstractionPreferenceInitializer.AbstractInterpretationMode)iPreferenceProvider.getEnum("Abstract interpretation Mode", TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.class);
        this.checkSettings();
        this.mCurrentIteration = this.generateFixpoints(word);
        if (this.hasShownInfeasibility()) {
            this.mStats.increment(AbsIntStats.WAS_STRONG);
        }
    }

    private AbsIntCurrentIteration<?> generateFixpoints(Word<LETTER> word) {
        assert (word != null) : "Cannot run AI on empty counterexample";
        if (!this.mRoot.getLocationClass().equals(BoogieIcfgLocation.class)) {
            throw new UnsupportedOperationException("AbsInt only supports BoogieIcfgLocations and Codeblocks at the moment");
        }
        if (IcfgUtils.isConcurrent(this.mRoot)) {
            throw new UnsupportedOperationException("AbsInt currently does not support concurrent programs");
        }
        if (this.mMode == TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.NONE) {
            return null;
        }
        this.mStats.resume(AbsIntStats.TIME);
        try {
            int n = this.mPathProgramCache.getPathProgramCount(word);
            if (n > 1) {
                this.mLogger.info((Object)"Skipping current iteration for AI because we have already analyzed this path program");
                return null;
            }
            Set set = word.asSet();
            if (!this.containsLoop(set) && this.mTaPreferences.getRefinementStrategy() != TraceAbstractionPreferenceInitializer.RefinementStrategy.TOOTHLESS_TAIPAN) {
                this.mLogger.info((Object)"Skipping current iteration for AI because the path program does not contain any loops");
                return null;
            }
            int n2 = this.mStats.increment(AbsIntStats.ITERATIONS) + 1;
            IProgressMonitorService iProgressMonitorService = this.mServices.getProgressMonitorService();
            this.mLogger.info((Object)("Running AI on error trace of length " + word.length()));
            PathProgram pathProgram = PathProgram.constructPathProgram((String)("absint-pp-iter-" + n2), this.mRoot, (Set)set, Collections.emptySet(), icfgLocation -> true).getPathProgram();
            IAbstractInterpretationResult iAbstractInterpretationResult = AbstractInterpreter.runWithoutTimeoutAndResults((IIcfg)pathProgram, (IProgressAwareTimer)iProgressMonitorService, (IUltimateServiceProvider)this.mServices);
            if (iAbstractInterpretationResult == null) {
                return null;
            }
            AbsIntCurrentIteration absIntCurrentIteration = new AbsIntCurrentIteration(word, iAbstractInterpretationResult, pathProgram);
            return absIntCurrentIteration;
        }
        finally {
            this.mStats.stop(AbsIntStats.TIME);
        }
    }

    public boolean hasShownInfeasibility() {
        return this.mMode != TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.NONE && this.mCurrentIteration != null && !this.mCurrentIteration.hasReachedError();
    }

    public boolean isDisabled() {
        return this.mMode == TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.NONE;
    }

    public CachingHoareTripleChecker getHoareTripleChecker() {
        if (this.mCurrentIteration == null) {
            throw CegarAbsIntRunner.createNoFixpointsException();
        }
        return this.mCurrentIteration.getHoareTripleChecker();
    }

    public IPredicateUnifier getPredicateUnifier() {
        if (this.mCurrentIteration == null) {
            throw CegarAbsIntRunner.createNoFixpointsException();
        }
        return this.mCurrentIteration.getPredicateUnifier();
    }

    public IInterpolatingTraceCheck<LETTER> getInterpolantGenerator() {
        if (this.mCurrentIteration == null) {
            return new AbsIntFailedInterpolantGenerator(this.mPredicateUnifierSmt, null, InterpolantComputationStatus.ItpErrorStatus.ALGORITHM_FAILED, CegarAbsIntRunner.createNoFixpointsException());
        }
        return this.mCurrentIteration.getInterpolantGenerator();
    }

    public IInterpolantAutomatonBuilder<LETTER, IPredicate> createInterpolantAutomatonBuilder(IPredicateUnifier iPredicateUnifier, INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton, Counterexample<LETTER> counterexample, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory) {
        if (this.mCurrentIteration == null) {
            throw CegarAbsIntRunner.createNoFixpointsException();
        }
        this.mStats.resume(AbsIntStats.TIME);
        try {
            this.mLogger.info((Object)("Constructing AI automaton with mode " + String.valueOf((Object)this.mMode)));
            SmtUtils.SimplificationTechnique simplificationTechnique = this.mTaPreferences.getSimplificationTechnique();
            AbsIntNonSmtInterpolantAutomatonBuilder<LETTER> absIntNonSmtInterpolantAutomatonBuilder = switch (this.mMode) {
                case TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.NONE -> throw new AssertionError((Object)"Mode should have been checked earlier");
                case TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.USE_PATH_PROGRAM -> new AbsIntNonSmtInterpolantAutomatonBuilder<LETTER>(this.mServices, iNestedWordAutomaton, iPredicateUnifier, this.mCsToolkit.getManagedScript(), this.mRoot.getCfgSmtToolkit().getSymbolTable(), counterexample, simplificationTechnique, iEmptyStackStateFactory);
                case TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.USE_PREDICATES -> new AbsIntStraightLineInterpolantAutomatonBuilder<LETTER>(this.mServices, iNestedWordAutomaton, this.mCurrentIteration.getResult(), iPredicateUnifier, this.mCsToolkit, counterexample.getWord(), simplificationTechnique, this.mRoot.getCfgSmtToolkit().getSymbolTable(), iEmptyStackStateFactory);
                case TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.USE_CANONICAL -> throw new UnsupportedOperationException("Canonical interpolant automaton generation not yet implemented.");
                case TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.USE_TOTAL -> new AbsIntTotalInterpolationAutomatonBuilder<LETTER>(this.mServices, iNestedWordAutomaton, this.mCurrentIteration.getResult(), iPredicateUnifier, this.mCsToolkit, counterexample.getWord(), this.mRoot.getCfgSmtToolkit().getSymbolTable(), iEmptyStackStateFactory);
                default -> throw new UnsupportedOperationException("AI mode " + String.valueOf((Object)this.mMode) + " not yet implemented");
            };
            return absIntNonSmtInterpolantAutomatonBuilder;
        }
        finally {
            this.mStats.stop(AbsIntStats.TIME);
        }
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStats;
    }

    private void checkSettings() {
        if (this.mMode == TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.USE_PATH_PROGRAM && this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("Interpolant automaton enhancement", TAPreferences.InterpolantAutomatonEnhancement.class) != TAPreferences.InterpolantAutomatonEnhancement.NONE) {
            throw new IllegalArgumentException("If using \"Abstract interpretation Mode\"=" + String.valueOf((Object)TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.USE_PATH_PROGRAM) + " you also have to use \"Interpolant automaton enhancement\"=" + String.valueOf((Object)TAPreferences.InterpolantAutomatonEnhancement.NONE));
        }
        if (this.mMode == TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.NONE && this.mAlwaysRefine) {
            throw new IllegalArgumentException("If using \"Abstract interpretation Mode\"=" + String.valueOf((Object)TraceAbstractionPreferenceInitializer.AbstractInterpretationMode.NONE) + " you cannot use \"Refine always when using abstract interpretation\"=true");
        }
    }

    private boolean containsLoop(Set<LETTER> set) {
        HashSet hashSet = new HashSet();
        return set.stream().anyMatch(iIcfgTransition -> !hashSet.add(iIcfgTransition.getTarget()));
    }

    private static UnsupportedOperationException createNoFixpointsException() {
        return new UnsupportedOperationException("AbsInt can only provide a hoare triple checker if it generated fixpoints");
    }

    static /* synthetic */ CfgSmtToolkit access$0(CegarAbsIntRunner cegarAbsIntRunner) {
        return cegarAbsIntRunner.mCsToolkit;
    }

    private final class AbsIntCurrentIteration<STATE extends IAbstractState<STATE>> {
        private final Word<LETTER> mCex;
        private final IAbstractInterpretationResult<STATE, LETTER, ?> mResult;
        private IInterpolatingTraceCheck<LETTER> mInterpolantGenerator;
        private CachingHoareTripleChecker mHtc;
        private final AbsIntPredicate<STATE> mFalsePredicate;
        private final AbsIntPredicate<STATE> mTruePredicate;
        private final IPredicateUnifier mPredicateUnifierAbsInt;
        private final PathProgram mPathProgram;

        public AbsIntCurrentIteration(Word<LETTER> word, IAbstractInterpretationResult<STATE, LETTER, ?> iAbstractInterpretationResult, PathProgram pathProgram) {
            this.mPathProgram = Objects.requireNonNull(pathProgram);
            this.mCex = Objects.requireNonNull(word);
            this.mResult = Objects.requireNonNull(iAbstractInterpretationResult);
            this.mFalsePredicate = new AbsIntPredicate(CegarAbsIntRunner.this.mPredicateUnifierSmt.getFalsePredicate(), this.mResult.getUsedDomain().createBottomState());
            this.mTruePredicate = new AbsIntPredicate(CegarAbsIntRunner.this.mPredicateUnifierSmt.getTruePredicate(), this.mResult.getUsedDomain().createTopState());
            this.mPredicateUnifierAbsInt = new AbsIntPredicateUnifier(CegarAbsIntRunner.this.mLogger, CegarAbsIntRunner.this.mServices, CegarAbsIntRunner.this.mCsToolkit.getManagedScript(), CegarAbsIntRunner.this.mPredicateUnifierSmt.getPredicateFactory(), CegarAbsIntRunner.this.mCsToolkit.getSymbolTable(), new IPredicate[]{this.mFalsePredicate, this.mTruePredicate});
        }

        public IPredicateUnifier getPredicateUnifier() {
            return this.mPredicateUnifierAbsInt;
        }

        public IAbstractInterpretationResult<STATE, LETTER, ?> getResult() {
            return this.mResult;
        }

        public boolean hasReachedError() {
            return this.mResult.hasReachedError();
        }

        public CachingHoareTripleChecker getHoareTripleChecker() {
            if (this.mHtc == null) {
                this.mHtc = this.createHoareTripleChecker(false);
            }
            return this.mHtc;
        }

        private CachingHoareTripleChecker createHoareTripleChecker(boolean bl) {
            AbsIntHoareTripleChecker absIntHoareTripleChecker = new AbsIntHoareTripleChecker(CegarAbsIntRunner.this.mLogger, CegarAbsIntRunner.this.mServices, this.mResult.getUsedDomain(), this.mResult.getUsedVariableProvider(), this.mPredicateUnifierAbsInt, CegarAbsIntRunner.this.mCsToolkit, bl);
            return new CachingHoareTripleChecker(CegarAbsIntRunner.this.mServices, absIntHoareTripleChecker, this.mPredicateUnifierAbsInt);
        }

        public IInterpolatingTraceCheck<LETTER> getInterpolantGenerator() {
            if (this.mInterpolantGenerator == null) {
                this.mInterpolantGenerator = this.createInterpolantGenerator();
            }
            return this.mInterpolantGenerator;
        }

        private IInterpolatingTraceCheck<LETTER> createInterpolantGenerator() {
            if (this.mResult.hasReachedError()) {
                return new AbsIntFailedInterpolantGenerator(this.mPredicateUnifierAbsInt, this.mCex, InterpolantComputationStatus.ItpErrorStatus.ALGORITHM_FAILED, null);
            }
            try {
                CegarAbsIntRunner.this.mLogger.info((Object)"Generating AbsInt predicates");
                List list = this.constructTraceFromWord(this.mCex, this.mPathProgram);
                List<AbsIntPredicate<STATE>> list2 = this.generateAbsIntPredicates(list);
                assert (this.isInductive(list, list2, (IHoareTripleChecker)this.createHoareTripleChecker(true))) : "Sequence of interpolants not inductive (before weakening)!";
                Object object = this.createHoareTripleChecker(true);
                List<AbsIntPredicate<STATE>> list3 = this.weakenPredicates(list2, list, (IHoareTripleChecker)object);
                assert (this.isInductive(list, list3, (IHoareTripleChecker)object)) : "Sequence of interpolants not inductive (after weakening)!";
                CegarAbsIntRunner.this.mLogger.info((Object)"Unifying AI predicates");
                object = this.unifyPredicates(list3);
                CegarAbsIntRunner.this.mLogger.info((Object)("We unified " + list3.size() + " AI predicates to " + object.size()));
                if (CegarAbsIntRunner.this.mLogger.isDebugEnabled()) {
                    CegarAbsIntRunner.this.mLogger.debug((Object)"Interpolant sequence:");
                    CegarAbsIntRunner.this.mLogger.debug(object);
                }
                assert (this.mCex.length() - 1 == object.size()) : "Word has length " + this.mCex.length() + " but interpolant sequence has length " + object.size();
                assert (this.isInductive(list, (List<AbsIntPredicate<STATE>>)object, (IHoareTripleChecker)this.getHoareTripleChecker())) : "Sequence of interpolants not inductive (after unification)";
                CegarAbsIntRunner.this.mLogger.info((Object)"Finished generation of AbsInt predicates");
                return new AbsIntInterpolantGenerator(this.mPredicateUnifierAbsInt, this.mCex, object.toArray(new IPredicate[object.size()]), this.getHoareTripleChecker(), this.mTruePredicate, this.mFalsePredicate);
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "generating AI predicates"));
                throw toolchainCanceledException;
            }
        }

        private List<AbsIntPredicate<STATE>> unifyPredicates(List<AbsIntPredicate<STATE>> list) {
            return list.stream().map(absIntPredicate -> this.getPredicateFromStates(absIntPredicate.getAbstractStates(), CegarAbsIntRunner.this.mCsToolkit.getManagedScript().getScript())).collect(Collectors.toList());
        }

        private List<AbsIntPredicate<STATE>> weakenPredicates(List<AbsIntPredicate<STATE>> list, List<LETTER> list2, IHoareTripleChecker iHoareTripleChecker) {
            return new AbsIntPredicateInterpolantSequenceWeakener(CegarAbsIntRunner.this.mLogger, iHoareTripleChecker, list, list2, this.mTruePredicate, this.mFalsePredicate, CegarAbsIntRunner.this.mCsToolkit.getManagedScript().getScript(), this.mPredicateUnifierAbsInt.getPredicateFactory(), CegarAbsIntRunner.this.mStats).getResult();
        }

        private List<LETTER> constructTraceFromWord(Word<LETTER> word, PathProgram pathProgram) {
            Object object;
            HashMap<IcfgEdge, Object> hashMap = new HashMap<IcfgEdge, Object>();
            IcfgEdgeIterator icfgEdgeIterator = new IcfgEdgeIterator((IIcfg)pathProgram);
            while (icfgEdgeIterator.hasNext()) {
                object = icfgEdgeIterator.next();
                hashMap.put(object.getLabel(), object);
            }
            object = new ArrayList(word.length());
            for (IIcfgTransition iIcfgTransition : word.asList()) {
                IIcfgTransition iIcfgTransition2 = (IIcfgTransition)hashMap.get(iIcfgTransition);
                assert (iIcfgTransition2 != null) : "Path program construction broken";
                object.add(iIcfgTransition2);
            }
            assert (object.size() == word.length());
            return object;
        }

        private boolean isInductive(List<LETTER> list, List<AbsIntPredicate<STATE>> list2, IHoareTripleChecker iHoareTripleChecker) {
            CegarAbsIntRunner.this.mLogger.debug((Object)"Checking inductivity of AbsInt predicates");
            if (list.isEmpty()) {
                return true;
            }
            assert (list.size() == list2.size() + 1) : "trace size does not match interpolants size";
            ArrayList<AbsIntPredicate<STATE>> arrayList = new ArrayList<AbsIntPredicate<STATE>>();
            arrayList.add(this.mTruePredicate);
            arrayList.addAll(list2);
            arrayList.add(this.mFalsePredicate);
            Iterator iterator = list.iterator();
            Iterator iterator2 = arrayList.iterator();
            AbsIntPredicate absIntPredicate = null;
            AbsIntPredicate absIntPredicate2 = (AbsIntPredicate)iterator2.next();
            ArrayDeque<AbsIntPredicate> arrayDeque = new ArrayDeque<AbsIntPredicate>();
            while (iterator2.hasNext()) {
                IncrementalPlicationChecker.Validity validity;
                IPredicate iPredicate;
                absIntPredicate = absIntPredicate2;
                absIntPredicate2 = (AbsIntPredicate)iterator2.next();
                IIcfgTransition iIcfgTransition = (IIcfgTransition)iterator.next();
                assert (iIcfgTransition != null);
                if (iIcfgTransition instanceof IInternalAction) {
                    if (CegarAbsIntRunner.this.mLogger.isDebugEnabled()) {
                        CegarAbsIntRunner.this.mLogger.debug((Object)String.format("Checking {%s} %s {%s}", absIntPredicate, iIcfgTransition, absIntPredicate2));
                    }
                    iPredicate = null;
                    validity = iHoareTripleChecker.checkInternal((IPredicate)absIntPredicate, (IInternalAction)iIcfgTransition, (IPredicate)absIntPredicate2);
                } else if (iIcfgTransition instanceof ICallAction) {
                    if (CegarAbsIntRunner.this.mLogger.isDebugEnabled()) {
                        CegarAbsIntRunner.this.mLogger.debug((Object)String.format("Checking {%s} %s {%s}", absIntPredicate, iIcfgTransition, absIntPredicate2));
                    }
                    arrayDeque.addFirst(absIntPredicate);
                    iPredicate = null;
                    validity = iHoareTripleChecker.checkCall((IPredicate)absIntPredicate, (ICallAction)iIcfgTransition, (IPredicate)absIntPredicate2);
                } else if (iIcfgTransition instanceof IReturnAction) {
                    iPredicate = (IPredicate)arrayDeque.removeFirst();
                    if (CegarAbsIntRunner.this.mLogger.isDebugEnabled()) {
                        CegarAbsIntRunner.this.mLogger.debug((Object)String.format("Checking {%s} {%s} %s {%s}", absIntPredicate, iPredicate, iIcfgTransition, absIntPredicate2));
                    }
                    validity = iHoareTripleChecker.checkReturn((IPredicate)absIntPredicate, iPredicate, (IReturnAction)iIcfgTransition, (IPredicate)absIntPredicate2);
                } else {
                    throw new UnsupportedOperationException("Unknown transition type " + String.valueOf(iIcfgTransition.getClass()));
                }
                if (validity == IncrementalPlicationChecker.Validity.VALID) continue;
                CegarAbsIntRunner.this.mLogger.fatal((Object)("Inductivity check failed! Result is " + String.valueOf(validity) + " for " + iIcfgTransition.getClass().getSimpleName() + " transition"));
                CegarAbsIntRunner.this.mLogger.fatal((Object)("Prestate:       " + absIntPredicate.toString()));
                if (iPredicate != null) {
                    CegarAbsIntRunner.this.mLogger.fatal((Object)("HierState:      " + iPredicate.toString()));
                }
                if (iIcfgTransition instanceof IReturnAction) {
                    IReturnAction iReturnAction = (IReturnAction)iIcfgTransition;
                    CegarAbsIntRunner.this.mLogger.fatal((Object)("Transition(R) : " + String.valueOf(iReturnAction.getAssignmentOfReturn())));
                    CegarAbsIntRunner.this.mLogger.fatal((Object)("Transition(LV): " + String.valueOf(iReturnAction.getLocalVarsAssignmentOfCall())));
                } else {
                    CegarAbsIntRunner.this.mLogger.fatal((Object)("Transition    : " + String.valueOf(iIcfgTransition.getTransformula())));
                }
                CegarAbsIntRunner.this.mLogger.fatal((Object)("Poststate:      " + absIntPredicate2.toString()));
                return false;
            }
            return true;
        }

        private List<AbsIntPredicate<STATE>> generateAbsIntPredicates(List<LETTER> list) {
            IIcfgTransition iIcfgTransition2;
            ArrayList<AbsIntPredicate<STATE>> arrayList = new ArrayList<AbsIntPredicate<STATE>>();
            ArrayDeque<IIcfgTransition> arrayDeque = new ArrayDeque<IIcfgTransition>();
            Script script = CegarAbsIntRunner.this.mCsToolkit.getManagedScript().getScript();
            Set set = Collections.emptySet();
            for (IIcfgTransition iIcfgTransition2 : list) {
                if (iIcfgTransition2 instanceof ICallAction) {
                    arrayDeque.addFirst(iIcfgTransition2);
                } else if (iIcfgTransition2 instanceof IReturnAction) {
                    arrayDeque.removeFirst();
                }
                Set set2 = this.mResult.getPostStates(arrayDeque, (Object)iIcfgTransition2, set);
                AbsIntPredicate<STATE> absIntPredicate = this.getNonUnifiedPredicateFromStates(set2, script);
                if (CegarAbsIntRunner.this.mLogger.isDebugEnabled()) {
                    CegarAbsIntRunner.this.mLogger.debug((Object)String.format("[%s] %s %s", iIcfgTransition2.hashCode(), iIcfgTransition2, absIntPredicate));
                }
                set = set2;
                arrayList.add(absIntPredicate);
            }
            iIcfgTransition2 = (AbsIntPredicate)arrayList.remove(arrayList.size() - 1);
            assert (iIcfgTransition2.getFormula().toString().equals("false"));
            return arrayList;
        }

        private AbsIntPredicate<STATE> getPredicateFromStates(Set<STATE> set, Script script) {
            if (set.isEmpty()) {
                return this.mFalsePredicate;
            }
            DisjunctiveAbstractState disjunctiveAbstractState = DisjunctiveAbstractState.createDisjunction(set);
            BasicPredicate basicPredicate = CegarAbsIntRunner.this.mPredicateUnifierSmt.getPredicateFactory().newPredicate(disjunctiveAbstractState.getTerm(script));
            IPredicate iPredicate = this.mPredicateUnifierAbsInt.getOrConstructPredicate((IPredicate)new AbsIntPredicate((IPredicate)basicPredicate, (IAbstractState)disjunctiveAbstractState));
            if (iPredicate.equals(this.mFalsePredicate)) {
                return this.mFalsePredicate;
            }
            if (iPredicate.equals(this.mTruePredicate)) {
                return this.mTruePredicate;
            }
            assert (iPredicate instanceof AbsIntPredicate);
            return (AbsIntPredicate)iPredicate;
        }

        private AbsIntPredicate<STATE> getNonUnifiedPredicateFromStates(Set<STATE> set, Script script) {
            if (set.isEmpty()) {
                return this.mFalsePredicate;
            }
            BasicPredicateFactory basicPredicateFactory = this.mPredicateUnifierAbsInt.getPredicateFactory();
            DisjunctiveAbstractState disjunctiveAbstractState = DisjunctiveAbstractState.createDisjunction(set).compact();
            BasicPredicate basicPredicate = basicPredicateFactory.newPredicate(disjunctiveAbstractState.getTerm(script));
            return new AbsIntPredicate((IPredicate)basicPredicate, (IAbstractState)disjunctiveAbstractState);
        }
    }

    private static final class AbsIntFailedInterpolantGenerator<L extends IAction>
    extends AbsIntBaseInterpolantGenerator<L> {
        private final TraceCheckReasonUnknown mReason;

        private AbsIntFailedInterpolantGenerator(IPredicateUnifier iPredicateUnifier, Word<L> word, InterpolantComputationStatus.ItpErrorStatus itpErrorStatus, Exception exception) {
            super(iPredicateUnifier, word, null, null, new InterpolantComputationStatus(itpErrorStatus, (Throwable)exception));
            this.mReason = new TraceCheckReasonUnknown(TraceCheckReasonUnknown.Reason.SOLVER_RESPONSE_OTHER, exception, TraceCheckReasonUnknown.ExceptionHandlingCategory.KNOWN_IGNORE);
        }

        public Map<Integer, IPredicate> getPendingContexts() {
            throw new UnsupportedOperationException();
        }

        public IPredicate[] getInterpolants() {
            throw new UnsupportedOperationException();
        }

        public boolean isPerfectSequence() {
            return false;
        }

        @Override
        public CachingHoareTripleChecker getHoareTripleChecker() {
            throw new UnsupportedOperationException();
        }

        public Script.LBool isCorrect() {
            return Script.LBool.UNKNOWN;
        }

        public boolean providesRcfgProgramExecution() {
            return false;
        }

        public IProgramExecution<L, Term> getRcfgProgramExecution() {
            throw new UnsupportedOperationException();
        }

        public TraceCheckReasonUnknown getTraceCheckReasonUnknown() {
            return this.mReason;
        }

        public boolean wasTracecheckFinishedNormally() {
            return true;
        }

        public IStatisticsDataProvider getStatistics() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class AbsIntInterpolantGenerator<L extends IAction>
    extends AbsIntBaseInterpolantGenerator<L> {
        private final IPredicate[] mInterpolants;
        private final CachingHoareTripleChecker mHtc;

        private AbsIntInterpolantGenerator(IPredicateUnifier iPredicateUnifier, Word<L> word, IPredicate[] iPredicateArray, CachingHoareTripleChecker cachingHoareTripleChecker, AbsIntPredicate<?> absIntPredicate, AbsIntPredicate<?> absIntPredicate2) {
            super(iPredicateUnifier, word, absIntPredicate, absIntPredicate2, new InterpolantComputationStatus());
            this.mInterpolants = Objects.requireNonNull(iPredicateArray);
            this.mHtc = Objects.requireNonNull(cachingHoareTripleChecker);
        }

        @Override
        public CachingHoareTripleChecker getHoareTripleChecker() {
            return this.mHtc;
        }

        public Map<Integer, IPredicate> getPendingContexts() {
            return null;
        }

        public IPredicate[] getInterpolants() {
            return this.mInterpolants;
        }

        public boolean isPerfectSequence() {
            return true;
        }

        public Script.LBool isCorrect() {
            return Script.LBool.UNSAT;
        }

        public boolean providesRcfgProgramExecution() {
            return false;
        }

        public IProgramExecution<L, Term> getRcfgProgramExecution() {
            throw new UnsupportedOperationException();
        }

        public TraceCheckReasonUnknown getTraceCheckReasonUnknown() {
            throw new UnsupportedOperationException();
        }

        public boolean wasTracecheckFinishedNormally() {
            return true;
        }

        public IStatisticsDataProvider getStatistics() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class AbsIntStatisticsGenerator
    implements IStatisticsDataProvider {
        private static final StatisticsType<AbsIntStats> TYPE = new StatisticsType(AbsIntStats.class);
        private final Map<AbsIntStats, Integer> mIntCounters = new EnumMap<AbsIntStats, Integer>(AbsIntStats.class);
        private final Map<AbsIntStats, Double> mRatioSum = new EnumMap<AbsIntStats, Double>(AbsIntStats.class);
        private final Map<AbsIntStats, Integer> mRatioFrequency = new EnumMap<AbsIntStats, Integer>(AbsIntStats.class);
        private final Benchmark mStopwatches = new Benchmark();

        public IStatisticsType getBenchmarkType() {
            return TYPE;
        }

        public Collection<String> getKeys() {
            return TYPE.getKeys();
        }

        public Object getValue(String string) {
            return this.getValue(AbsIntStats.valueOf(string));
        }

        public Object getValue(AbsIntStats absIntStats) {
            switch (absIntStats.getType()) {
                case COUNTER: {
                    return this.mIntCounters.getOrDefault((Object)absIntStats, 0);
                }
                case RATIO: {
                    return this.mRatioSum.getOrDefault((Object)absIntStats, 0.0) / (double)this.mRatioFrequency.getOrDefault((Object)absIntStats, 1).intValue();
                }
                case TIMER: {
                    return (long)this.mStopwatches.getElapsedTime(absIntStats.getName(), TimeUnit.NANOSECONDS);
                }
            }
            throw new UnsupportedOperationException("Unsupported key type " + String.valueOf(absIntStats.getType()));
        }

        public int increment(AbsIntStats absIntStats) {
            return this.add(absIntStats, 1);
        }

        public int add(AbsIntStats absIntStats, int n) {
            assert (absIntStats.getType() == KeyType.COUNTER);
            int n2 = this.mIntCounters.getOrDefault((Object)absIntStats, 0);
            Integer n3 = this.mIntCounters.put(absIntStats, n2 + n);
            if (n3 == null) {
                return 0;
            }
            return n3;
        }

        public void addRatio(AbsIntStats absIntStats, double d) {
            assert (absIntStats.getType() == KeyType.RATIO);
            this.mRatioSum.put(absIntStats, this.mRatioSum.getOrDefault((Object)absIntStats, 0.0) + d);
            this.mRatioFrequency.put(absIntStats, this.mRatioFrequency.getOrDefault((Object)absIntStats, 0) + 1);
        }

        public void start(AbsIntStats absIntStats) {
            assert (absIntStats.getType() == KeyType.TIMER);
            this.mStopwatches.start(absIntStats.getName());
        }

        public void stop(AbsIntStats absIntStats) {
            assert (absIntStats.getType() == KeyType.TIMER);
            this.mStopwatches.stop(absIntStats.getName());
        }

        public void resume(AbsIntStats absIntStats) {
            assert (absIntStats.getType() == KeyType.TIMER);
            this.mStopwatches.register(absIntStats.getName());
            this.mStopwatches.unpause(absIntStats.getName());
        }
    }

    public static enum AbsIntStats implements IKeyedStatisticsElement
    {
        TIME(KeyType.TIMER),
        ITERATIONS(KeyType.COUNTER),
        WAS_STRONG(KeyType.COUNTER),
        WEAKENING_RATIO(KeyType.RATIO),
        AVG_VARS_REMOVED_DURING_WEAKENING(KeyType.RATIO),
        AVG_WEAKENED_CONJUNCTS(KeyType.RATIO);

        private final KeyType mType;

        private AbsIntStats(KeyType keyType) {
            this.mType = keyType;
        }

        public KeyType getType() {
            return this.mType;
        }

        public String getName() {
            return this.name();
        }
    }
}

