/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementFkvStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementNcsbStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IConcurrentProductStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISenwaStateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.MLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PredicateFactoryForInterpolantAutomata
implements ISenwaStateFactory<IPredicate>,
IBlackWhiteStateFactory<IPredicate>,
IBuchiComplementFkvStateFactory<IPredicate>,
IBuchiComplementNcsbStateFactory<IPredicate>,
IConcurrentProductStateFactory<IPredicate>,
IPetriNet2FiniteAutomatonStateFactory<IPredicate>,
IMinimizationStateFactory<IPredicate>,
IDeterminizeStateFactory<IPredicate> {
    protected final boolean mPreserveTerms;
    private final IPredicate mEmtpyStack;
    protected final ManagedScript mMgdScript;
    protected final PredicateFactory mPredicateFactory;

    public PredicateFactoryForInterpolantAutomata(ManagedScript managedScript, PredicateFactory predicateFactory, boolean bl) {
        this.mPreserveTerms = bl;
        this.mMgdScript = managedScript;
        this.mPredicateFactory = predicateFactory;
        this.mEmtpyStack = this.mPredicateFactory.newEmptyStackPredicate();
    }

    public IPredicate determinize(Map<IPredicate, Set<IPredicate>> map) {
        if (this.mPreserveTerms) {
            IPredicate iPredicate2;
            ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
            for (IPredicate iPredicate2 : map.keySet()) {
                for (IPredicate iPredicate3 : map.get(iPredicate2)) {
                    if (this.mPredicateFactory.isDontCare(iPredicate3)) {
                        return this.mPredicateFactory.newDontCarePredicate(null);
                    }
                    arrayList.add(iPredicate3);
                }
            }
            iPredicate2 = this.mPredicateFactory.and(arrayList);
            return iPredicate2;
        }
        return this.mPredicateFactory.newDontCarePredicate(null);
    }

    public IPredicate createSinkStateContent() {
        return this.mPredicateFactory.newPredicate(this.mMgdScript.getScript().term("true", new Term[0]));
    }

    public IPredicate createEmptyStackState() {
        return this.mEmtpyStack;
    }

    public IPredicate merge(Collection<IPredicate> collection) {
        return this.mPredicateFactory.or(collection);
    }

    public IPredicate senwa(IPredicate iPredicate, IPredicate iPredicate2) {
        assert (false) : "still used?";
        return this.mPredicateFactory.newDontCarePredicate(((SPredicate)iPredicate2).getProgramPoint());
    }

    public IPredicate buchiComplementFkv(LevelRankingState<?, IPredicate> levelRankingState) {
        return this.mPredicateFactory.newDebugPredicate(levelRankingState.toString());
    }

    public IPredicate buchiComplementNcsb(LevelRankingState<?, IPredicate> levelRankingState) {
        return this.buchiComplementFkv(levelRankingState);
    }

    public IPredicate concurrentProduct(IPredicate iPredicate, IPredicate iPredicate2) {
        IMLPredicate iMLPredicate;
        IcfgLocation[] icfgLocationArray;
        if (!(iPredicate2 instanceof ISLPredicate)) {
            throw new IllegalArgumentException("has to be predicate with single location");
        }
        if (iPredicate instanceof ISLPredicate) {
            icfgLocationArray = new IcfgLocation[2];
            icfgLocationArray[0] = ((ISLPredicate)iPredicate).getProgramPoint();
        } else if (iPredicate instanceof IMLPredicate) {
            iMLPredicate = (IMLPredicate)iPredicate;
            int n = iMLPredicate.getProgramPoints().length + 1;
            icfgLocationArray = Arrays.copyOf(iMLPredicate.getProgramPoints(), n);
        } else {
            throw new UnsupportedOperationException();
        }
        iMLPredicate = ((ISLPredicate)iPredicate2).getProgramPoint();
        icfgLocationArray[icfgLocationArray.length - 1] = iMLPredicate;
        Term term = this.mPredicateFactory.and(new IPredicate[]{iPredicate, iPredicate2}).getFormula();
        MLPredicate mLPredicate = this.mPredicateFactory.newMLPredicate(icfgLocationArray, term);
        return mLPredicate;
    }

    public IPredicate getContentOnPetriNet2FiniteAutomaton(Marking<IPredicate> marking) {
        throw new UnsupportedOperationException("State factory operation not implemented!");
    }

    public IPredicate getBlackContent(IPredicate iPredicate) {
        return this.mPredicateFactory.newDebugPredicate("Black: " + String.valueOf(iPredicate));
    }
}

