/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.translator;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieExpressionTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.Activator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PatternContainer;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PeaResultUtil;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2Pea;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2PeaAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2PeaTransformer;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.Req2Pea;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.ReqInOutGuesser;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.CDDTranslator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.PeaLocationAnnotation;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import de.uni_freiburg.informatik.ultimate.util.simplifier.NormalFormTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Req2BoogieTranslator {
    public static final String PROCEDURE_NAME = "myProcedure";
    private static final String DOUBLE_ZERO = Double.toString(0.0);
    private final Unit mUnit;
    private final List<PatternType.ReqPeas> mReqPeas;
    private final BoogieLocation mUnitLocation;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final NormalFormTransformer<Expression> mNormalFormTransformer;
    private final IReqSymbolTable mSymboltable;
    private IReq2PeaAnnotator mReqCheckAnnotator;
    private final boolean mBuildHistoryVars;

    public Req2BoogieTranslator(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, List<PatternType<?>> list) {
        this(iUltimateServiceProvider, iLogger, list, new ArrayList<IReq2PeaTransformer>());
    }

    public Req2BoogieTranslator(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, List<PatternType<?>> list, List<IReq2PeaTransformer> list2) {
        Object object;
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mBuildHistoryVars = iPreferenceProvider.getBoolean("Generate history vars ('v) in Encoding");
        this.mNormalFormTransformer = new NormalFormTransformer((INormalFormable)new BoogieExpressionTransformer());
        List<PatternType<?>> list3 = list.stream().filter(patternType -> !(patternType instanceof DeclarationPattern)).collect(Collectors.toList());
        List list4 = list3.stream().map(PatternType::getId).collect(Collectors.toMap(string -> string, string -> 1, (n, n2) -> n + n2)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).collect(Collectors.toList());
        if (!list4.isEmpty()) {
            PeaResultUtil peaResultUtil = new PeaResultUtil(this.mLogger, this.mServices);
            for (Map.Entry entry2 : list4) {
                peaResultUtil.typeError((String)entry2.getKey(), String.format("Requirement id \"%s\" occurs %s times", entry2.getKey(), entry2.getValue()));
            }
            this.mUnitLocation = null;
            this.mUnit = null;
            this.mReqPeas = null;
            this.mSymboltable = null;
            return;
        }
        List<DeclarationPattern> list5 = list.stream().filter(DeclarationPattern.class::isInstance).map(DeclarationPattern.class::cast).collect(Collectors.toList());
        if (iPreferenceProvider.getBoolean("Use heuristic to find input/output definitions (if none are given)")) {
            object = new ReqInOutGuesser(iLogger, this.mServices, list5, list3);
            list5 = ((ReqInOutGuesser)object).getInitializationPatterns();
            list3 = ((ReqInOutGuesser)object).getRequirements();
        }
        if ((object = this.createReq2Pea(list2, list5, list3)).hasErrors()) {
            this.mUnitLocation = null;
            this.mUnit = null;
            this.mReqPeas = null;
            this.mSymboltable = null;
            return;
        }
        this.mReqPeas = object.getReqPeas();
        this.mSymboltable = object.getSymboltable();
        this.mReqCheckAnnotator = object.getAnnotator();
        this.mUnitLocation = new BoogieLocation("", -1, -1, -1, -1);
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>(this.mSymboltable.getDeclarations());
        arrayList.add(this.generateProcedure(list5));
        this.mUnit = new Unit((ILocation)this.mUnitLocation, arrayList.toArray(new Declaration[arrayList.size()]));
        Req2BoogieTranslator.annotateContainedPatternSet(this.mUnit, this.mReqPeas, list5);
    }

    private IReq2Pea createReq2Pea(List<IReq2PeaTransformer> list, List<DeclarationPattern> list2, List<PatternType<?>> list3) {
        IReq2Pea iReq2Pea = new Req2Pea(this.mServices, this.mLogger, list2, list3);
        for (IReq2PeaTransformer iReq2PeaTransformer : list) {
            if (iReq2Pea.hasErrors()) break;
            iReq2Pea = iReq2PeaTransformer.transform(iReq2Pea, list2, list3);
        }
        return iReq2Pea;
    }

    private static void annotateContainedPatternSet(Unit unit, List<PatternType.ReqPeas> list, List<DeclarationPattern> list2) {
        ArrayList<DeclarationPattern> arrayList = new ArrayList<DeclarationPattern>(list2);
        list.stream().map(PatternType.ReqPeas::getPattern).forEachOrdered(arrayList::add);
        new PatternContainer(arrayList).annotate((IElement)unit);
    }

    public Unit getUnit() {
        return this.mUnit;
    }

    private List<Statement> genClockPlusDelta(Collection<String> collection) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        IdentifierExpression identifierExpression = this.mSymboltable.getIdentifierExpression(this.mSymboltable.getDeltaVarName());
        for (String string : collection) {
            VariableLHS variableLHS = this.mSymboltable.getVariableLhs(string);
            IdentifierExpression identifierExpression2 = this.mSymboltable.getIdentifierExpression(string);
            Expression expression = ExpressionFactory.newBinaryExpression((ILocation)variableLHS.getLocation(), (BinaryExpression.Operator)BinaryExpression.Operator.ARITHPLUS, (Expression)identifierExpression2, (Expression)identifierExpression);
            arrayList.add((Statement)Req2BoogieTranslator.genAssignmentStmt(variableLHS.getLocation(), variableLHS, expression));
        }
        return arrayList;
    }

    private List<Statement> genDelay(BoogieLocation boogieLocation) {
        String string = this.mSymboltable.getDeltaVarName();
        ArrayList<Statement> arrayList = new ArrayList<Statement>(this.genHavocStmts(this.mSymboltable.getPrimedVars()));
        arrayList.addAll(this.genHavocStmts(this.mSymboltable.getEventVars()));
        arrayList.addAll(this.genHavocStmts(Collections.singleton(string)));
        IdentifierExpression identifierExpression = this.mSymboltable.getIdentifierExpression(string);
        ILocation iLocation = identifierExpression.getLocation();
        RealLiteral realLiteral = ExpressionFactory.createRealLiteral((ILocation)iLocation, (String)"0.0");
        Expression expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPGT, (Expression)identifierExpression, (Expression)realLiteral);
        arrayList.add((Statement)new AssumeStatement(iLocation, expression));
        arrayList.addAll(this.genClockPlusDelta(this.mSymboltable.getClockVars()));
        return arrayList;
    }

    private List<Statement> genHavocStmts(Collection<String> collection) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (String string : collection) {
            VariableLHS variableLHS = this.mSymboltable.getVariableLhs(string);
            arrayList.add((Statement)new HavocStatement(variableLHS.getLocation(), new VariableLHS[]{variableLHS}));
        }
        return arrayList;
    }

    private Expression genComparePhaseCounter(int n, String string, BoogieLocation boogieLocation) {
        IdentifierExpression identifierExpression = this.mSymboltable.getIdentifierExpression(string);
        IntegerLiteral integerLiteral = ExpressionFactory.createIntegerLiteral((ILocation)boogieLocation, (String)Integer.toString(n));
        return ExpressionFactory.newBinaryExpression((ILocation)boogieLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)integerLiteral);
    }

    private Statement[] genCheckPhaseInvariant(Phase phase, BoogieLocation boogieLocation, PeaLocationAnnotation peaLocationAnnotation) {
        AssumeStatement assumeStatement;
        AssumeStatement assumeStatement2;
        CDD cDD;
        CDD cDD2 = phase.getClockInvariant();
        if (cDD2 != CDD.TRUE) {
            cDD = new CDDTranslator().toBoogie(cDD2, boogieLocation);
            assumeStatement2 = new AssumeStatement((ILocation)boogieLocation, (Expression)this.mNormalFormTransformer.toNnf((Object)cDD));
        } else {
            assumeStatement2 = null;
        }
        cDD = phase.getStateInvariant();
        if (cDD != CDD.TRUE) {
            Expression expression = new CDDTranslator().toBoogie(cDD, boogieLocation);
            assumeStatement = new AssumeStatement((ILocation)boogieLocation, (Expression)this.mNormalFormTransformer.toNnf((Object)expression));
        } else {
            assumeStatement = null;
        }
        if (assumeStatement2 == null && assumeStatement == null) {
            return null;
        }
        if (assumeStatement2 != null) {
            peaLocationAnnotation.annotate((IElement)assumeStatement2);
        }
        if (assumeStatement != null) {
            peaLocationAnnotation.annotate((IElement)assumeStatement);
        }
        return Req2BoogieTranslator.concatStmt(new Statement[]{assumeStatement2, assumeStatement});
    }

    private static Statement[] concatStmt(Statement ... statementArray) {
        if (statementArray == null || statementArray.length == 0) {
            throw new IllegalArgumentException();
        }
        List<Statement> list = Arrays.stream(statementArray).filter(statement -> statement != null).collect(Collectors.toList());
        if (list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return list.toArray(new Statement[list.size()]);
    }

    private static Statement joinIfSmts(Statement[] statementArray, BoogieLocation boogieLocation) {
        if (statementArray == null || statementArray.length == 0) {
            throw new IllegalArgumentException();
        }
        IfStatement ifStatement = null;
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            IfStatement ifStatement2 = (IfStatement)statement;
            assert (ifStatement2.getElsePart().length == 0);
            ifStatement = ifStatement == null ? ifStatement2 : new IfStatement((ILocation)boogieLocation, ifStatement2.getCondition(), ifStatement2.getThenPart(), new Statement[]{ifStatement});
            ++n2;
        }
        return ifStatement;
    }

    private static Statement joinInnerIfSmts(Statement[] statementArray, BoogieLocation boogieLocation) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            IfStatement ifStatement = (IfStatement)statement;
            if (arrayList.isEmpty()) {
                var8_8 = new BooleanLiteral((ILocation)boogieLocation, false);
                var9_9 = new AssumeStatement((ILocation)boogieLocation, (Expression)var8_8);
                Statement[] statementArray3 = new Statement[]{var9_9};
                IfStatement ifStatement2 = new IfStatement((ILocation)boogieLocation, ifStatement.getCondition(), ifStatement.getThenPart(), statementArray3);
                arrayList.add(ifStatement2);
            } else {
                var8_8 = new BooleanLiteral[]{(Statement)arrayList.get(arrayList.size() - 1)};
                var9_9 = new IfStatement((ILocation)boogieLocation, ifStatement.getCondition(), ifStatement.getThenPart(), (Statement[])var8_8);
                arrayList.add(var9_9);
            }
            ++n2;
        }
        return (Statement)arrayList.get(arrayList.size() - 1);
    }

    private List<Statement> genInvariantGuards(PatternType<?> patternType, PhaseEventAutomata phaseEventAutomata, String string, BoogieLocation boogieLocation) {
        List list = phaseEventAutomata.getPhases();
        assert (list.size() > 0);
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        Statement[] statementArray = new Statement[]{};
        int n = 0;
        while (n < list.size()) {
            Expression expression = this.genComparePhaseCounter(n, string, boogieLocation);
            PeaLocationAnnotation peaLocationAnnotation = new PeaLocationAnnotation(Collections.singletonList(phaseEventAutomata), Collections.singletonList((Phase)list.get(n)));
            Statement[] statementArray2 = this.genCheckPhaseInvariant((Phase)list.get(n), boogieLocation, peaLocationAnnotation);
            if (statementArray2 == null) {
                this.mLogger.warn((Object)("phase without clock or state invariant for " + String.valueOf(patternType)));
            } else {
                arrayList.add((Statement)new IfStatement((ILocation)boogieLocation, expression, statementArray2, statementArray));
            }
            ++n;
        }
        if (arrayList.isEmpty() || arrayList.size() == 1) {
            return arrayList;
        }
        return Collections.singletonList(Req2BoogieTranslator.joinIfSmts(arrayList.toArray(new Statement[arrayList.size()]), boogieLocation));
    }

    private static Statement generateClockResetAssign(String string, BoogieLocation boogieLocation) {
        RealLiteral realLiteral = new RealLiteral((ILocation)boogieLocation, DOUBLE_ZERO);
        return Req2BoogieTranslator.genAssignmentStmt((ILocation)boogieLocation, string, (Expression)realLiteral);
    }

    private static Statement genPCAssign(String string, int n, BoogieLocation boogieLocation) {
        IntegerLiteral integerLiteral = new IntegerLiteral((ILocation)boogieLocation, Integer.toString(n));
        return Req2BoogieTranslator.genAssignmentStmt((ILocation)boogieLocation, string, (Expression)integerLiteral);
    }

    private Statement[] generateTransitionFromPeaTransition(PhaseEventAutomata phaseEventAutomata, String string2, Transition transition, BoogieLocation boogieLocation) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        this.createAssumeFromTransition(transition, boogieLocation).ifPresent(arrayList::add);
        Arrays.stream(transition.getResets()).map(string -> Req2BoogieTranslator.generateClockResetAssign(string, boogieLocation)).forEachOrdered(arrayList::add);
        int n = Req2BoogieTranslator.getPhaseIndex(transition, phaseEventAutomata.getPhases());
        assert (n != -1);
        arrayList.add(Req2BoogieTranslator.genPCAssign(string2, n, boogieLocation));
        return arrayList.toArray(new Statement[arrayList.size()]);
    }

    private static int getPhaseIndex(Transition transition, List<Phase> list) {
        String string = transition.getDest().getName();
        int n = 0;
        while (n < list.size()) {
            if (list.get(n).getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private Optional<Statement> createAssumeFromTransition(Transition transition, BoogieLocation boogieLocation) {
        CDD cDD = transition.getGuard();
        if (cDD == CDD.TRUE) {
            return Optional.empty();
        }
        Expression expression = new CDDTranslator().toBoogie(cDD, boogieLocation);
        return Optional.of(new AssumeStatement((ILocation)boogieLocation, (Expression)this.mNormalFormTransformer.toNnf((Object)expression)));
    }

    private Statement generateTransitionsFromPhase(PhaseEventAutomata phaseEventAutomata, String string, Phase phase, BoogieLocation boogieLocation) {
        Statement[] statementArray = new Statement[phase.getTransitions().size()];
        Statement[] statementArray2 = new Statement[]{};
        WildcardExpression wildcardExpression = new WildcardExpression((ILocation)boogieLocation);
        List list = phase.getTransitions();
        int n = 0;
        while (n < list.size()) {
            statementArray[n] = new IfStatement((ILocation)boogieLocation, (Expression)wildcardExpression, this.generateTransitionFromPeaTransition(phaseEventAutomata, string, (Transition)list.get(n), boogieLocation), statementArray2);
            ++n;
        }
        return Req2BoogieTranslator.joinInnerIfSmts(statementArray, boogieLocation);
    }

    private Statement generateTransition(PhaseEventAutomata phaseEventAutomata, String string, BoogieLocation boogieLocation) {
        List list = phaseEventAutomata.getPhases();
        Statement[] statementArray = new Statement[list.size()];
        Statement[] statementArray2 = new Statement[]{};
        int n = 0;
        while (n < list.size()) {
            Expression expression = this.genComparePhaseCounter(n, string, boogieLocation);
            Statement[] statementArray3 = new Statement[]{this.generateTransitionsFromPhase(phaseEventAutomata, string, (Phase)list.get(n), boogieLocation)};
            statementArray[n] = new IfStatement((ILocation)boogieLocation, expression, statementArray3, statementArray2);
            ++n;
        }
        return Req2BoogieTranslator.joinIfSmts(statementArray, boogieLocation);
    }

    private List<Statement> genStateVarsAssign() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        if (this.mBuildHistoryVars) {
            arrayList.addAll(this.mSymboltable.getStateVars().stream().map(this::genStateVarAssignHistory).collect(Collectors.toList()));
        }
        arrayList.addAll(this.mSymboltable.getStateVars().stream().map(this::genStateVarAssignPrimed).collect(Collectors.toList()));
        return arrayList;
    }

    private AssignmentStatement genStateVarAssignPrimed(String string) {
        VariableLHS variableLHS = this.mSymboltable.getVariableLhs(string);
        IdentifierExpression identifierExpression = this.mSymboltable.getIdentifierExpression(this.mSymboltable.getPrimedVarId(string));
        return Req2BoogieTranslator.genAssignmentStmt(identifierExpression.getLocation(), variableLHS, (Expression)identifierExpression);
    }

    private AssignmentStatement genStateVarAssignHistory(String string) {
        VariableLHS variableLHS = this.mSymboltable.getVariableLhs(this.mSymboltable.getHistoryVarId(string));
        IdentifierExpression identifierExpression = this.mSymboltable.getIdentifierExpression(string);
        return Req2BoogieTranslator.genAssignmentStmt(identifierExpression.getLocation(), variableLHS, (Expression)identifierExpression);
    }

    private Statement[] genWhileLoopBody(BoogieLocation boogieLocation) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>(this.genDelay(boogieLocation));
        for (PatternType.ReqPeas reqPeas : this.mReqPeas) {
            for (Object object : reqPeas.getCounterTrace2Pea()) {
                arrayList.addAll(this.genInvariantGuards(reqPeas.getPattern(), (PhaseEventAutomata)object.getValue(), this.mSymboltable.getPcName((PhaseEventAutomata)object.getValue()), boogieLocation));
            }
        }
        arrayList.addAll(this.mReqCheckAnnotator.getStateChecks());
        if (this.mBuildHistoryVars) {
            arrayList.addAll(this.mSymboltable.getPcVars().stream().map(this::genStateVarAssignHistory).collect(Collectors.toList()));
        }
        for (PatternType.ReqPeas reqPeas : this.mReqPeas) {
            for (Object object : reqPeas.getCounterTrace2Pea()) {
                PhaseEventAutomata phaseEventAutomata = (PhaseEventAutomata)object.getValue();
                arrayList.add(this.generateTransition(phaseEventAutomata, this.mSymboltable.getPcName(phaseEventAutomata), boogieLocation));
            }
        }
        arrayList.addAll(this.mReqCheckAnnotator.getPostTransitionChecks());
        arrayList.addAll(this.genStateVarsAssign());
        return arrayList.toArray(new Statement[arrayList.size()]);
    }

    private Statement genWhileLoop(BoogieLocation boogieLocation) {
        return new WhileStatement((ILocation)boogieLocation, (Expression)new WildcardExpression((ILocation)boogieLocation), new LoopInvariantSpecification[0], this.genWhileLoopBody(boogieLocation));
    }

    private Expression genPcExpr(PhaseEventAutomata phaseEventAutomata, BoogieLocation boogieLocation) {
        Object object2;
        List list = phaseEventAutomata.getPhases();
        List list2 = phaseEventAutomata.getInit();
        block0: for (Object object2 : list) {
            for (Phase phase : list2) {
                if (!object2.getName().equals(phase.getName())) continue;
                object2.setInit(true);
                continue block0;
            }
        }
        object2 = this.mSymboltable.getPcName(phaseEventAutomata);
        Expression expression = null;
        int n = 0;
        while (n < list.size()) {
            if (((Phase)list.get(n)).isInit()) {
                CDD cDD;
                IdentifierExpression identifierExpression = this.mSymboltable.getIdentifierExpression((String)object2);
                Expression expression2 = ExpressionFactory.newBinaryExpression((ILocation)identifierExpression.getLocation(), (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)ExpressionFactory.createIntegerLiteral((ILocation)identifierExpression.getLocation(), (String)Integer.toString(n)));
                if (((Phase)list.get(n)).getInitialTransition() != null && (cDD = ((Phase)list.get(n)).getInitialTransition().getGuard()) != CDD.TRUE) {
                    Expression expression3 = new CDDTranslator().toBoogie(cDD, boogieLocation);
                    expression3.setType((IBoogieType)BoogieType.TYPE_BOOL);
                    expression2 = ExpressionFactory.newBinaryExpression((ILocation)identifierExpression.getLocation(), (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression2, (Expression)expression3);
                }
                expression = expression == null ? expression2 : ExpressionFactory.newBinaryExpression((ILocation)identifierExpression.getLocation(), (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression, (Expression)expression2);
            }
            ++n;
        }
        return (Expression)this.mNormalFormTransformer.toNnf(expression);
    }

    private List<Statement> genInitialPhasesStmts(BoogieLocation boogieLocation) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (PatternType.ReqPeas reqPeas : this.mReqPeas) {
            for (Map.Entry entry : reqPeas.getCounterTrace2Pea()) {
                PhaseEventAutomata phaseEventAutomata = (PhaseEventAutomata)entry.getValue();
                VariableLHS variableLHS = this.mSymboltable.getVariableLhs(this.mSymboltable.getPcName(phaseEventAutomata));
                arrayList.add((Statement)new HavocStatement(variableLHS.getLocation(), new VariableLHS[]{variableLHS}));
                arrayList.add((Statement)new AssumeStatement(variableLHS.getLocation(), this.genPcExpr(phaseEventAutomata, boogieLocation)));
            }
        }
        return arrayList;
    }

    private List<Statement> genClockInitStmts() {
        if (this.mSymboltable.getClockVars().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (String string : this.mSymboltable.getClockVars()) {
            IdentifierExpression identifierExpression = this.mSymboltable.getIdentifierExpression(string);
            RealLiteral realLiteral = ExpressionFactory.createRealLiteral((ILocation)identifierExpression.getLocation(), (String)"0.0");
            arrayList.add((Statement)new HavocStatement(identifierExpression.getLocation(), new VariableLHS[]{this.mSymboltable.getVariableLhs(string)}));
            arrayList.add((Statement)new AssumeStatement(identifierExpression.getLocation(), ExpressionFactory.newBinaryExpression((ILocation)identifierExpression.getLocation(), (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)realLiteral)));
        }
        return arrayList;
    }

    private Statement[] generateProcedureBody(BoogieLocation boogieLocation, List<DeclarationPattern> list) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>(this.genInitialPhasesStmts(boogieLocation));
        arrayList.addAll(this.genClockInitStmts());
        if (this.mBuildHistoryVars) {
            arrayList.addAll(this.mSymboltable.getStateVars().stream().map(this::genStateVarAssignHistory).collect(Collectors.toList()));
            arrayList.addAll(this.mSymboltable.getPcVars().stream().map(this::genStateVarAssignHistory).collect(Collectors.toList()));
        }
        arrayList.addAll(this.mReqCheckAnnotator.getPreChecks());
        arrayList.add(this.genWhileLoop(boogieLocation));
        return arrayList.toArray(new Statement[arrayList.size()]);
    }

    private static AssignmentStatement genAssignmentStmt(ILocation iLocation, String string, Expression expression) {
        return Req2BoogieTranslator.genAssignmentStmt(iLocation, new VariableLHS(iLocation, string), expression);
    }

    private static AssignmentStatement genAssignmentStmt(ILocation iLocation, VariableLHS variableLHS, Expression expression) {
        assert (variableLHS.getLocation() == iLocation);
        return new AssignmentStatement(iLocation, new LeftHandSide[]{variableLHS}, new Expression[]{expression});
    }

    public IReqSymbolTable getReqSymbolTable() {
        return this.mSymboltable;
    }

    public List<PatternType.ReqPeas> getReqPeas() {
        return Collections.unmodifiableList(this.mReqPeas);
    }

    private Declaration generateProcedure(List<DeclarationPattern> list) {
        BoogieLocation boogieLocation = this.mUnitLocation;
        VariableDeclaration[] variableDeclarationArray = new VariableDeclaration[]{};
        Body body = new Body((ILocation)boogieLocation, variableDeclarationArray, this.generateProcedureBody(boogieLocation, list));
        ArrayList<String> arrayList = new ArrayList<String>(this.mSymboltable.getClockVars());
        arrayList.addAll(this.mSymboltable.getPcVars());
        arrayList.add(this.mSymboltable.getDeltaVarName());
        arrayList.addAll(this.mSymboltable.getStateVars());
        arrayList.addAll(this.mSymboltable.getPrimedVars());
        if (this.mBuildHistoryVars) {
            arrayList.addAll(this.mSymboltable.getHistoryVars());
        }
        arrayList.addAll(this.mSymboltable.getEventVars());
        VariableLHS[] variableLHSArray = new VariableLHS[arrayList.size()];
        int n = 0;
        while (n < variableLHSArray.length) {
            variableLHSArray[n] = new VariableLHS((ILocation)boogieLocation, (String)arrayList.get(n));
            ++n;
        }
        ModifiesSpecification modifiesSpecification = new ModifiesSpecification((ILocation)boogieLocation, false, variableLHSArray);
        ModifiesSpecification[] modifiesSpecificationArray = new ModifiesSpecification[]{modifiesSpecification};
        Attribute[] attributeArray = new Attribute[]{};
        String[] stringArray = new String[]{};
        VarList[] varListArray = new VarList[]{};
        VarList[] varListArray2 = new VarList[]{};
        return new Procedure((ILocation)boogieLocation, attributeArray, PROCEDURE_NAME, stringArray, varListArray, varListArray2, (Specification[])modifiesSpecificationArray, body);
    }
}

