/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.IDfsVisitor;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.WrapperVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CoveringOptimizationVisitor<L, S>
extends WrapperVisitor<L, S, IDfsVisitor<L, S>> {
    private final IGeneralizedCoveringRelation<S> mCoveringRelation;
    private final CoveringMode mMode;
    private final Map<Object, Set<S>> mCoveringMap = new HashMap<Object, Set<S>>();

    public CoveringOptimizationVisitor(IDfsVisitor<L, S> iDfsVisitor, ICoveringRelation<S> iCoveringRelation, CoveringMode coveringMode) {
        super(iDfsVisitor);
        this.mCoveringRelation = iCoveringRelation;
        this.mMode = coveringMode;
    }

    @Override
    public boolean discoverTransition(S s, L l, S s2) {
        Set<S> set = this.getCoveringStates(s2);
        return switch (this.mMode) {
            case CoveringMode.REDIRECT -> {
                if (set == null) {
                    yield super.discoverTransition(s, l, s2);
                }
                for (S var5_6 : set) {
                    super.discoverTransition(s, l, var5_6);
                }
                yield true;
            }
            case CoveringMode.PRUNE -> {
                if (set == null && !super.discoverTransition(s, l, s2)) {
                    yield false;
                }
                yield true;
            }
            default -> throw new MatchException(null, null);
        };
    }

    private Set<S> getCoveringStates(S s) {
        Object object = this.mCoveringRelation.getKey(s);
        Set<S> set = this.mCoveringMap.get(object);
        if (set == null || set.contains(s)) {
            return null;
        }
        return this.mCoveringRelation.coveringStates(set, s);
    }

    @Override
    public boolean discoverState(S s) {
        Object object2 = this.mCoveringRelation.getKey(s);
        this.mCoveringMap.computeIfAbsent(object2, object -> new HashSet()).add(s);
        return super.discoverState(s);
    }

    public static enum CoveringMode {
        PRUNE,
        REDIRECT;

    }

    @FunctionalInterface
    public static interface ICoveringRelation<S>
    extends IGeneralizedCoveringRelation<S> {
        public boolean covers(S var1, S var2);

        @Override
        default public Set<S> coveringStates(Set<S> set, S s) {
            Optional<Object> optional = set.stream().filter(object2 -> this.covers(object2, s)).findAny();
            if (optional.isEmpty()) {
                return null;
            }
            return Set.of(optional.get());
        }
    }

    @FunctionalInterface
    public static interface IGeneralizedCoveringRelation<S> {
        public Set<S> coveringStates(Set<S> var1, S var2);

        default public Object getKey(S s) {
            return null;
        }
    }
}

