/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST;

import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.IdentifierListAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.PetriNetTransitionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransitionListAST
extends AtsASTNode {
    private static final long serialVersionUID = 4468320445354864058L;
    private final Map<Pair<String, String>, Set<String>> mTransitions;
    private final Map<String, Map<String, Map<String, Set<String>>>> mReturnTransitions;
    private final List<PetriNetTransitionAST> mnetTransitions;
    private final ArrayList<IdentifierListAST> mIdLists = new ArrayList();

    public TransitionListAST(ILocation iLocation) {
        super(iLocation);
        this.mTransitions = new HashMap<Pair<String, String>, Set<String>>();
        this.mReturnTransitions = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        this.mnetTransitions = new ArrayList<PetriNetTransitionAST>();
    }

    private void addTransition(String string, String string2, String string3) {
        Pair pair = new Pair((Object)string, (Object)string2);
        if (this.mTransitions.containsKey(pair)) {
            Set<String> set = this.mTransitions.get(pair);
            set.add(string3);
            this.mTransitions.put((Pair<String, String>)pair, set);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string3);
            this.mTransitions.put((Pair<String, String>)pair, hashSet);
        }
    }

    private void addTransition(String string, String string2, String string3, String string4) {
        Set<String> set;
        Map<String, Set<String>> map;
        Map<String, Map<String, Set<String>>> map2 = this.mReturnTransitions.get(string);
        if (map2 == null) {
            map2 = new HashMap<String, Map<String, Set<String>>>();
            this.mReturnTransitions.put(string, map2);
        }
        if ((map = map2.get(string2)) == null) {
            map = new HashMap<String, Set<String>>();
            map2.put(string2, map);
        }
        if ((set = map.get(string3)) == null) {
            set = new HashSet<String>();
            map.put(string3, set);
        }
        set.add(string4);
    }

    public void addTransition(IdentifierListAST identifierListAST) {
        this.mIdLists.add(identifierListAST);
        List<String> list = identifierListAST.getIdentifierList();
        if (list.size() == 3) {
            this.addTransition(list.get(0), list.get(1), list.get(2));
        } else if (list.size() == 4) {
            this.addTransition(list.get(0), list.get(1), list.get(2), list.get(3));
        }
    }

    @Deprecated
    public Map<Pair<String, String>, Set<String>> getTransitions() {
        return this.mTransitions;
    }

    @Deprecated
    public Map<String, Map<String, Map<String, Set<String>>>> getReturnTransitions() {
        return this.mReturnTransitions;
    }

    public void addNetTransition(PetriNetTransitionAST petriNetTransitionAST) {
        this.mnetTransitions.add(petriNetTransitionAST);
    }

    public List<PetriNetTransitionAST> getNetTransitions() {
        return this.mnetTransitions;
    }

    public HashRelation<String, String> convertToEpsilonTransitions() {
        HashRelation hashRelation = new HashRelation();
        for (IdentifierListAST identifierListAST : this.mIdLists) {
            if (identifierListAST.getIdentifierList().size() != 2) {
                throw new IllegalArgumentException("List of epsilon transitions contains element that is not a pair: " + String.valueOf((Object)identifierListAST));
            }
            hashRelation.addPair((Object)identifierListAST.getIdentifierList().get(0), (Object)identifierListAST.getIdentifierList().get(1));
        }
        return hashRelation;
    }
}

