/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class QuantUtil {
    private QuantUtil() {
    }

    public static boolean isEssentiallyUninterpreted(Term term) {
        if (term.getFreeVars().length == 0) {
            return true;
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            if (!functionSymbol.isInterpreted()) {
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term2 = termArray[n2];
                    if (!(term2 instanceof TermVariable) && !QuantUtil.isEssentiallyUninterpreted(term2)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            if (functionSymbol.getName() == "select") {
                Term[] termArray = applicationTerm.getParameters();
                if (termArray[0] instanceof TermVariable || !QuantUtil.isEssentiallyUninterpreted(termArray[0])) {
                    return false;
                }
                return termArray[1] instanceof TermVariable || QuantUtil.isEssentiallyUninterpreted(termArray[1]);
            }
            if (functionSymbol.getName() == "+" || functionSymbol.getName() == "-" || functionSymbol.getName() == "*") {
                Polynomial polynomial = new Polynomial(term);
                for (Map<Term, Integer> map : polynomial.getSummands().keySet()) {
                    for (Term term3 : map.keySet()) {
                        if (QuantUtil.isEssentiallyUninterpreted(term3)) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean containsArithmeticOnQuantOnlyAtTopLevel(QuantLiteral quantLiteral) {
        assert (!quantLiteral.isNegated());
        if (quantLiteral instanceof QuantBoundConstraint) {
            return QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(((QuantBoundConstraint)quantLiteral).getAffineTerm());
        }
        QuantEquality quantEquality = (QuantEquality)quantLiteral;
        Polynomial polynomial = new Polynomial(quantEquality.getLhs());
        if (QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(polynomial)) {
            Polynomial polynomial2 = new Polynomial(quantEquality.getRhs());
            return QuantUtil.containsArithmeticOnQuantOnlyAtTopLevel(polynomial2);
        }
        return false;
    }

    public static boolean containsAppTermsForEachVar(QuantLiteral quantLiteral) {
        Object object2;
        assert (!quantLiteral.isNegated());
        HashSet<Object> hashSet = new HashSet<Object>();
        if (quantLiteral instanceof QuantEquality) {
            object2 = (QuantEquality)quantLiteral;
            Term object4 = ((QuantEquality)object2).getLhs();
            Object object = ((QuantEquality)object2).getRhs();
            Polynomial polynomial = new Polynomial(object4);
            Polynomial polynomial2 = new Polynomial((Term)object);
            for (Map<Term, Integer> map : polynomial.getSummands().keySet()) {
                hashSet.addAll(map.keySet());
            }
            for (Map<Term, Integer> map : polynomial2.getSummands().keySet()) {
                hashSet.addAll(map.keySet());
            }
        } else {
            object2 = (QuantBoundConstraint)quantLiteral;
            for (Map map : ((QuantBoundConstraint)object2).getAffineTerm().getSummands().keySet()) {
                hashSet.addAll(map.keySet());
            }
        }
        object2 = new HashSet();
        HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>();
        for (Object object : hashSet) {
            if (object instanceof TermVariable) {
                object2.add(object);
                continue;
            }
            if (object.getFreeVars().length == 0) continue;
            hashSet2.addAll(Arrays.asList(object.getFreeVars()));
        }
        object2.removeAll(hashSet2);
        return object2.isEmpty();
    }

    public static boolean isVarEq(QuantLiteral quantLiteral) {
        assert (!quantLiteral.isNegated());
        if (quantLiteral instanceof QuantEquality) {
            QuantEquality quantEquality = (QuantEquality)quantLiteral;
            return quantEquality.getLhs() instanceof TermVariable && quantEquality.getRhs() instanceof TermVariable;
        }
        return false;
    }

    public static Term[] getArithmeticalTermLtTerm(QuantLiteral quantLiteral, TermCompiler termCompiler) {
        assert (quantLiteral.isArithmetical());
        Term term = null;
        Term term2 = null;
        if (quantLiteral instanceof QuantEquality) {
            QuantEquality quantEquality = (QuantEquality)quantLiteral;
            assert (quantEquality.getLhs() instanceof TermVariable && quantEquality.getRhs().getFreeVars().length == 0);
            term = quantEquality.getLhs();
            term2 = quantEquality.getRhs();
        } else {
            assert (quantLiteral.isNegated());
            QuantBoundConstraint quantBoundConstraint = (QuantBoundConstraint)quantLiteral.getAtom();
            TermVariable termVariable = null;
            TermVariable termVariable2 = null;
            Polynomial polynomial = new Polynomial();
            Polynomial polynomial2 = quantBoundConstraint.getAffineTerm();
            for (Map.Entry<Map<Term, Integer>, Rational> entry : polynomial2.getSummands().entrySet()) {
                Term term3 = null;
                if (entry.getKey().size() == 1 && entry.getKey().values().iterator().next() == 1) {
                    term3 = entry.getKey().keySet().iterator().next();
                }
                if (term3 instanceof TermVariable) {
                    if (entry.getValue().signum() < 0) {
                        assert (term == null);
                        termVariable = (TermVariable)term3;
                        continue;
                    }
                    assert (termVariable2 == null);
                    termVariable2 = (TermVariable)term3;
                    continue;
                }
                polynomial.add(entry.getValue(), entry.getKey());
            }
            assert (termVariable != null || termVariable2 != null);
            if (termVariable != null && termVariable2 != null) {
                assert (polynomial.isZero());
                term = termVariable;
                term2 = termVariable2;
            } else if (termVariable != null) {
                term = termVariable;
                term2 = polynomial.toTerm(termVariable.getSort());
            } else {
                polynomial.mul(Rational.MONE);
                term = polynomial.toTerm(termVariable2.getSort());
                term2 = termVariable2;
            }
        }
        return new Term[]{term, term2};
    }

    public static boolean isTermVariable(Map<Term, Integer> map) {
        return map.size() == 1 && map.values().iterator().next() == 1 && map.keySet().iterator().next() instanceof TermVariable;
    }

    public static boolean containsArithmeticOnQuantOnlyAtTopLevel(Polynomial polynomial) {
        for (Map<Term, Integer> map : polynomial.getSummands().keySet()) {
            if (QuantUtil.isTermVariable(map)) continue;
            for (Term term : map.keySet()) {
                if (QuantUtil.isSimpleEU(term)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSimpleEU(Term term) {
        if (term.getFreeVars().length != 0) {
            if (term instanceof TermVariable) {
                return false;
            }
            assert (term instanceof ApplicationTerm);
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            if (functionSymbol.isInterpreted() && !functionSymbol.getName().equals("select")) {
                return false;
            }
            Term[] termArray = applicationTerm.getParameters();
            if (functionSymbol.getName().equals("select")) {
                if (!QuantUtil.isSimpleEU(termArray[0])) {
                    return false;
                }
                if (!(termArray[1] instanceof TermVariable) && !QuantUtil.isSimpleEU(termArray[1])) {
                    return false;
                }
            } else {
                Term[] termArray2 = termArray;
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term2 = termArray2[n2];
                    if (!(term2 instanceof TermVariable) && !QuantUtil.isSimpleEU(term2)) {
                        return false;
                    }
                    ++n2;
                }
            }
        }
        return true;
    }

    public static boolean isAuxApplication(Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
            return functionSymbol.isIntern() && functionSymbol.getName().startsWith("@AUX");
        }
        return false;
    }

    public static boolean isLambda(Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
            return functionSymbol.isIntern() && functionSymbol.getName().startsWith("@0");
        }
        return false;
    }
}

