/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AllSpecificationsHoldResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.PositiveResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgPetrifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureErrorDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.StringDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.proofs.IProof;
import de.uni_freiburg.informatik.ultimate.lib.proofs.IProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.proofs.ProofAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.FloydHoareUtils;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.FloydHoareValidityCheck;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IcfgFloydHoareValidityCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.ICopyActionFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.PetriNetLargeBlockEncoding;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbstractCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.BasicCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopLocalResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopResultReporter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IWitnessTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PetriCegarLoopStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PetriCegarStatisticsType;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TraceAbstractionBenchmarks;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TraceAbstractionStarter<L extends IIcfgTransition<?>> {
    public static final String ULTIMATE_INIT = "ULTIMATE.init";
    public static final String ULTIMATE_START = "ULTIMATE.start";
    private static final long MILLISECONDS_PER_SECOND = 1000L;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final TAPreferences mPrefs;
    private final boolean mIsConcurrent;
    private final CegarLoopFactory<L> mCegarFactory;
    private IElement mRootOfNewModel;
    private IElement mArtifact;
    private final List<INestedWordAutomaton<String, String>> mRawFloydHoareAutomataFromFile;
    private final List<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>> mFloydHoareAutomataFromErrorLocations = new ArrayList<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>>();
    private final Map<DebugIdentifier, List<TraceAbstractionBenchmarks>> mStatistics = new LinkedHashMap<DebugIdentifier, List<TraceAbstractionBenchmarks>>();
    private Map<IcfgLocation, IcfgLocation> mLocationMap;
    private final Map<IcfgLocation, IResult> mResultsPerLocation;
    private final CegarLoopResultReporter<L> mResultReporter;
    private final IWitnessTransformer<L> mWitnessTransformer;

    public TraceAbstractionStarter(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<IcfgLocation> iIcfg, IWitnessTransformer<L> iWitnessTransformer, List<INestedWordAutomaton<String, String>> list, Supplier<PetriNetLargeBlockEncoding.IPLBECompositionFactory<L>> supplier, ICopyActionFactory<L> iCopyActionFactory, Class<L> clazz) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mPrefs = new TAPreferences(this.mServices);
        this.mResultsPerLocation = new LinkedHashMap<IcfgLocation, IResult>();
        this.mWitnessTransformer = iWitnessTransformer;
        this.mRawFloydHoareAutomataFromFile = list;
        this.mIsConcurrent = IcfgUtils.isConcurrent(iIcfg);
        this.mResultReporter = new CegarLoopResultReporter(this.mServices, this.mLogger, Activator.PLUGIN_ID, "TraceAbstraction", this::recordLocationResult);
        this.mCegarFactory = new CegarLoopFactory<L>(iUltimateServiceProvider, clazz, this.mPrefs, supplier, iCopyActionFactory);
        try {
            this.runCegarLoops(iIcfg);
        }
        finally {
            this.mCegarFactory.shutdown();
        }
    }

    private void runCegarLoops(IIcfg<IcfgLocation> iIcfg) {
        this.logSettings();
        Set set = IcfgUtils.getErrorLocations(iIcfg);
        int n = set.size();
        this.mLogger.info((Object)String.format("Applying trace abstraction to ICFG %s that has %d procedures, %d locations, %d edges, %d initial locations, %d loop locations, and %d error locations.", iIcfg.getIdentifier(), iIcfg.getProcedureEntryNodes().size(), IcfgUtils.getNumberOfLocations(iIcfg), IcfgUtils.getNumberOfEdges(iIcfg), iIcfg.getInitialNodes().size(), iIcfg.getLoopLocations().size(), n));
        if (n <= 0) {
            AllSpecificationsHoldResult allSpecificationsHoldResult = AllSpecificationsHoldResult.createAllSpecificationsHoldResult((String)"TraceAbstraction", (int)n);
            this.mResultReporter.reportResult((IResult)allSpecificationsHoldResult);
            return;
        }
        this.mArtifact = null;
        List<ProvenCegarLoopResult<L>> list = IcfgUtils.isConcurrent(iIcfg) ? this.analyseConcurrentProgram(iIcfg) : this.analyseSequentialProgram(iIcfg);
        this.mLogger.info((Object)"Computing trace abstraction results");
        this.reportLocationResults();
        this.reportBenchmarkResults();
        this.logNumberOfWitnessInvariants(set);
        this.mResultReporter.reportAllSafeResultIfNecessary(list, n);
        IProgressMonitorService iProgressMonitorService = this.mServices.getProgressMonitorService();
        IBacktranslationService iBacktranslationService = this.mServices.getBacktranslationService();
        for (ProvenCegarLoopResult<L> provenCegarLoopResult : list) {
            if (!iProgressMonitorService.continueProcessing()) break;
            IProof iProof = provenCegarLoopResult.getProof();
            if (iProof != null) {
                ProofAnnotation.addProof(iIcfg, (IProof)iProof);
            }
            if (iProof instanceof IFloydHoareAnnotation) {
                IFloydHoareAnnotation iFloydHoareAnnotation = (IFloydHoareAnnotation)iProof;
                assert (new IcfgFloydHoareValidityCheck(this.mServices, iIcfg, iFloydHoareAnnotation, true, FloydHoareValidityCheck.MissingAnnotationBehaviour.IGNORE, true).getResult()) : "incorrect Hoare annotation";
                FloydHoareUtils.createInvariantResults((String)"TraceAbstraction", iIcfg, (IFloydHoareAnnotation)iFloydHoareAnnotation, (IBacktranslationService)iBacktranslationService, this.mResultReporter::reportResult);
                if (!this.mPrefs.computeProcedureContracts()) continue;
                FloydHoareUtils.createProcedureContractResults((IUltimateServiceProvider)this.mServices, (String)"TraceAbstraction", iIcfg, (IFloydHoareAnnotation)iFloydHoareAnnotation, (IBacktranslationService)iBacktranslationService, this.mResultReporter::reportResult);
                continue;
            }
            if (provenCegarLoopResult.getProof() == null) continue;
            this.mLogger.warn((Object)("Unknown type of proof: " + String.valueOf(provenCegarLoopResult.getProof().getClass())));
        }
        this.mRootOfNewModel = this.mArtifact;
    }

    private void logSettings() {
        StringBuilder stringBuilder = new StringBuilder("Automizer settings:");
        stringBuilder.append(" Hoare:").append(this.mPrefs.getHoareSettings().getHoarePositions());
        stringBuilder.append(" ").append(this.mPrefs.differenceSenwa() ? "SeNWA" : "NWA");
        stringBuilder.append(" Interpolation:").append(this.mPrefs.interpolation());
        stringBuilder.append(" Determinization: ").append((Object)this.mPrefs.interpolantAutomatonEnhancement());
        this.mLogger.info((Object)stringBuilder.toString());
    }

    private List<ProvenCegarLoopResult<L>> analyseConcurrentProgram(IIcfg<IcfgLocation> iIcfg) {
        if (iIcfg.getInitialNodes().size() > 1) {
            throw new UnsupportedOperationException("Library mode is not supported for concurrent programs. There must be a unique entry procedure.");
        }
        int n = 1;
        while (true) {
            IIcfg<IcfgLocation> iIcfg2 = this.petrify(iIcfg, n);
            this.mResultsPerLocation.clear();
            List<ProvenCegarLoopResult<L>> list = this.analyseProgram(iIcfg2, TraceAbstractionStarter::hasSufficientThreadInstances);
            if (TraceAbstractionStarter.resultsHaveSufficientInstances(list)) {
                this.mLogger.info((Object)("Analysis of concurrent program completed with " + n + " thread instances"));
                return list;
            }
            assert (IcfgUtils.isConcurrent(iIcfg)) : "Insufficient thread instances for sequential program";
            this.mLogger.warn((Object)(n + " thread instances were not sufficient, I will increase this number and restart the analysis"));
            ++n;
        }
    }

    private static <L extends IIcfgTransition<?>> boolean resultsHaveSufficientInstances(List<? extends CegarLoopResult<L>> list) {
        boolean bl = true;
        for (CegarLoopResult<L> cegarLoopResult : list) {
            if (cegarLoopResult.resultStream().allMatch(result -> result != AbstractCegarLoop.Result.UNSAFE)) continue;
            if (TraceAbstractionStarter.hasSufficientThreadInstances(cegarLoopResult)) {
                return true;
            }
            bl = false;
        }
        return bl;
    }

    private List<ProvenCegarLoopResult<L>> analyseSequentialProgram(IIcfg<IcfgLocation> iIcfg) {
        return this.analyseProgram(iIcfg, cegarLoopResult -> true);
    }

    private List<ProvenCegarLoopResult<L>> analyseProgram(IIcfg<IcfgLocation> iIcfg, Predicate<CegarLoopResult<L>> predicate) {
        ArrayList<ProvenCegarLoopResult<L>> arrayList = new ArrayList<ProvenCegarLoopResult<L>>();
        List<Pair<DebugIdentifier, Set<IcfgLocation>>> list = this.partitionErrorLocations(iIcfg);
        boolean bl = list.size() > 1;
        IProgressMonitorService iProgressMonitorService = this.mServices.getProgressMonitorService();
        int n = 0;
        for (Pair<DebugIdentifier, Set<IcfgLocation>> pair : list) {
            DebugIdentifier debugIdentifier = (DebugIdentifier)pair.getKey();
            Set set = (Set)pair.getValue();
            IUltimateServiceProvider iUltimateServiceProvider = this.mPrefs.hasErrorLocTimeLimit() ? iProgressMonitorService.registerChildTimer(this.mServices, iProgressMonitorService.getTimer((long)this.mPrefs.getErrorLocTimeLimit() * 1000L * (long)set.size())) : this.mServices;
            if (bl) {
                iUltimateServiceProvider.getProgressMonitorService().setSubtask(debugIdentifier.toString());
            }
            TraceAbstractionBenchmarks traceAbstractionBenchmarks = this.createNewBenchmark(debugIdentifier, iIcfg);
            ProvenCegarLoopResult<L> provenCegarLoopResult = this.executeCegarLoop(iUltimateServiceProvider, debugIdentifier, iIcfg, traceAbstractionBenchmarks, set);
            arrayList.add(provenCegarLoopResult);
            ++n;
            if (bl) {
                this.mLogger.info((Object)String.format("Result for error location %s was %s (%s/%s)", debugIdentifier, provenCegarLoopResult.resultStream().map(Enum::toString).collect(Collectors.joining(",")), n, list.size()));
            }
            if (!predicate.test(provenCegarLoopResult)) break;
            if (this.mPrefs.getFloydHoareAutomataReuse() != TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse.NONE) {
                this.mFloydHoareAutomataFromErrorLocations.addAll(provenCegarLoopResult.getFloydHoareAutomata());
            }
            this.mResultReporter.reportCegarLoopResult(provenCegarLoopResult);
            this.mArtifact = provenCegarLoopResult.getArtifact();
            if (this.mPrefs.stopAfterFirstViolation() && provenCegarLoopResult.resultStream().anyMatch(result -> result == AbstractCegarLoop.Result.UNSAFE) || !this.mServices.getProgressMonitorService().continueProcessing()) break;
        }
        return arrayList;
    }

    private List<Pair<DebugIdentifier, Set<IcfgLocation>>> partitionErrorLocations(IIcfg<IcfgLocation> iIcfg) {
        CegarRestartBehaviour cegarRestartBehaviour = (CegarRestartBehaviour)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("CEGAR restart behaviour", CegarRestartBehaviour.class);
        if (cegarRestartBehaviour == CegarRestartBehaviour.ONE_CEGAR_PER_THREAD_INSTANCE && !this.mIsConcurrent) {
            this.mLogger.warn((Object)("Program is not concurrent. Changing CEGAR restart behaviour to " + String.valueOf((Object)CegarRestartBehaviour.ONLY_ONE_CEGAR)));
            cegarRestartBehaviour = CegarRestartBehaviour.ONLY_ONE_CEGAR;
        }
        if (cegarRestartBehaviour == CegarRestartBehaviour.ONE_CEGAR_PER_THREAD_INSTANCE) {
            assert (this.mIsConcurrent) : "One CEGAR per thread instance only works for concurrent programs";
            ArrayList<Pair<DebugIdentifier, Set<IcfgLocation>>> arrayList = new ArrayList<Pair<DebugIdentifier, Set<IcfgLocation>>>();
            for (String string : IcfgUtils.getAllThreadInstances(iIcfg)) {
                Set set = (Set)iIcfg.getProcedureErrorNodes().get(string);
                if (set.isEmpty()) continue;
                ThreadInstanceDebugIdentifier threadInstanceDebugIdentifier = new ThreadInstanceDebugIdentifier(string);
                arrayList.add((Pair<DebugIdentifier, Set<IcfgLocation>>)new Pair((Object)threadInstanceDebugIdentifier, (Object)set));
            }
            return arrayList;
        }
        Set set = IcfgUtils.getErrorLocations(iIcfg);
        if (cegarRestartBehaviour == CegarRestartBehaviour.ONE_CEGAR_PER_ERROR_LOCATION) {
            Stream stream = set.stream();
            if (this.mIsConcurrent) {
                stream = switch (this.mPrefs.getOrderOfErrorLocations()) {
                    case TraceAbstractionPreferenceInitializer.OrderOfErrorLocations.PROGRAM_FIRST -> stream.sorted((icfgLocation, icfgLocation2) -> Boolean.compare(TraceAbstractionStarter.isInsufficientThreadsLocation(icfgLocation), TraceAbstractionStarter.isInsufficientThreadsLocation(icfgLocation2)));
                    case TraceAbstractionPreferenceInitializer.OrderOfErrorLocations.INSUFFICIENT_FIRST -> stream.sorted((icfgLocation, icfgLocation2) -> Boolean.compare(TraceAbstractionStarter.isInsufficientThreadsLocation(icfgLocation2), TraceAbstractionStarter.isInsufficientThreadsLocation(icfgLocation)));
                    case TraceAbstractionPreferenceInitializer.OrderOfErrorLocations.TOGETHER -> stream;
                    default -> throw new MatchException(null, null);
                };
            }
            return stream.map(icfgLocation -> new Pair((Object)icfgLocation.getDebugIdentifier(), Set.of(icfgLocation))).collect(Collectors.toList());
        }
        assert (cegarRestartBehaviour == CegarRestartBehaviour.ONLY_ONE_CEGAR) : "unsupported CEGAR restart behaviour";
        if (this.mIsConcurrent && this.mPrefs.getOrderOfErrorLocations() != TraceAbstractionPreferenceInitializer.OrderOfErrorLocations.TOGETHER && !IcfgUtils.getForksInLoop(iIcfg).isEmpty()) {
            HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>(TraceAbstractionStarter.getInUseErrorNodeMap(iIcfg).values());
            Set set2 = DataStructureUtils.difference((Set)set, hashSet);
            Pair pair = new Pair((Object)AllErrorsAtOnceDebugIdentifier.INSTANCE, (Object)set2);
            Pair pair2 = new Pair((Object)InUseDebugIdentifier.INSTANCE, hashSet);
            if (this.mPrefs.getOrderOfErrorLocations() == TraceAbstractionPreferenceInitializer.OrderOfErrorLocations.INSUFFICIENT_FIRST) {
                return List.of(pair2, pair);
            }
            return List.of(pair, pair2);
        }
        return List.of(new Pair((Object)AllErrorsAtOnceDebugIdentifier.INSTANCE, (Object)set));
    }

    private ProvenCegarLoopResult<L> executeCegarLoop(IUltimateServiceProvider iUltimateServiceProvider, DebugIdentifier debugIdentifier, IIcfg<IcfgLocation> iIcfg, TraceAbstractionBenchmarks traceAbstractionBenchmarks, Set<IcfgLocation> set) {
        IProof iProof;
        Pair<BasicCegarLoop<L, ?>, IProofProducer<IIcfg<IcfgLocation>, ?>> pair = this.mCegarFactory.constructCegarLoop(iUltimateServiceProvider, debugIdentifier, iIcfg, set, this.mWitnessTransformer, this.mRawFloydHoareAutomataFromFile);
        CegarLoopResult cegarLoopResult = ((BasicCegarLoop)pair.getFirst()).runCegar();
        IProofProducer iProofProducer = (IProofProducer)pair.getSecond();
        if (iProofProducer != null && cegarLoopResult.hasProvenAnything()) {
            assert (iProofProducer.isReadyToComputeProof()) : "Not ready to compute proof";
            this.mLogger.debug((Object)"Computing proof for CEGAR loop...");
            iProof = iProofProducer.getOrComputeProof();
        } else {
            this.mLogger.debug((Object)"No proof to compute for CEGAR loop.");
            iProof = null;
        }
        StatisticsData statisticsData = new StatisticsData();
        statisticsData.aggregateBenchmarkData(cegarLoopResult.getCegarLoopStatisticsGenerator());
        if (cegarLoopResult.getCegarLoopStatisticsGenerator().getBenchmarkType() instanceof PetriCegarStatisticsType) {
            statisticsData.aggregateBenchmarkData((IStatisticsDataProvider)new PetriCegarLoopStatisticsGenerator(this.mCegarFactory.getStatistics()));
        } else {
            statisticsData.aggregateBenchmarkData((IStatisticsDataProvider)this.mCegarFactory.getStatistics());
        }
        traceAbstractionBenchmarks.aggregateBenchmarkData((IStatisticsDataProvider)statisticsData);
        return new ProvenCegarLoopResult(cegarLoopResult, iProof);
    }

    private static Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation> getInUseErrorNodeMap(IIcfg<?> iIcfg) {
        return iIcfg.getCfgSmtToolkit().getConcurrencyInformation().getInUseErrorNodeMap();
    }

    private void logNumberOfWitnessInvariants(Collection<IcfgLocation> collection) {
        int n = 0;
        for (IcfgLocation icfgLocation : collection) {
            if (!(icfgLocation instanceof BoogieIcfgLocation)) {
                this.mLogger.info((Object)"Did not count any witness invariants because Icfg is not BoogieIcfg");
                return;
            }
            BoogieASTNode boogieASTNode = ((BoogieIcfgLocation)icfgLocation).getBoogieASTNode();
            Check check = Check.getAnnotation((IElement)boogieASTNode);
            if (check == null || !check.getSpec().contains(Spec.WITNESS_INVARIANT)) continue;
            ++n;
        }
        if (n > 0) {
            this.mLogger.info((Object)("Automizer considered " + n + " witness invariants"));
            this.mLogger.info((Object)("WitnessConsidered=" + n));
        }
    }

    private static boolean isInsufficientThreadsIdentifier(DebugIdentifier debugIdentifier) {
        if (debugIdentifier instanceof ProcedureErrorDebugIdentifier) {
            return ((ProcedureErrorDebugIdentifier)debugIdentifier).getType() == ProcedureErrorDebugIdentifier.ProcedureErrorType.INUSE_VIOLATION;
        }
        return false;
    }

    private IIcfg<IcfgLocation> petrify(IIcfg<IcfgLocation> iIcfg, int n) {
        assert (IcfgUtils.isConcurrent(iIcfg)) : "Petrification unnecessary for sequential programs";
        this.mLogger.info((Object)("Constructing petrified ICFG for " + n + " thread instances."));
        IcfgPetrifier icfgPetrifier = new IcfgPetrifier(this.mServices, iIcfg, n, false);
        IIcfg iIcfg2 = icfgPetrifier.getPetrifiedIcfg();
        this.mLocationMap = ((BlockEncodingBacktranslator)icfgPetrifier.getBacktranslator()).getLocationMapping();
        this.mServices.getBacktranslationService().addTranslator(icfgPetrifier.getBacktranslator());
        return iIcfg2;
    }

    private TraceAbstractionBenchmarks createNewBenchmark(DebugIdentifier debugIdentifier2, IIcfg<IcfgLocation> iIcfg) {
        List list = this.mStatistics.computeIfAbsent(debugIdentifier2, debugIdentifier -> new ArrayList());
        TraceAbstractionBenchmarks traceAbstractionBenchmarks = new TraceAbstractionBenchmarks(iIcfg);
        list.add(traceAbstractionBenchmarks);
        return traceAbstractionBenchmarks;
    }

    private void reportBenchmarkResults() {
        for (Map.Entry<DebugIdentifier, List<TraceAbstractionBenchmarks>> entry : this.mStatistics.entrySet()) {
            DebugIdentifier debugIdentifier = entry.getKey();
            int n = 1;
            for (TraceAbstractionBenchmarks traceAbstractionBenchmarks : entry.getValue()) {
                String string = this.getBenchmarkDescription(debugIdentifier, n);
                this.mResultReporter.reportResult((IResult)new StatisticsResult("TraceAbstraction", string, (ICsvProviderProvider)traceAbstractionBenchmarks));
                ++n;
            }
        }
    }

    private void recordLocationResult(IcfgLocation icfgLocation, IResult iResult) {
        IcfgLocation icfgLocation2 = this.getOriginalLocation(icfgLocation);
        IResult iResult2 = this.mResultsPerLocation.get(icfgLocation2);
        if (iResult2 == null) {
            this.mResultsPerLocation.put(icfgLocation2, iResult);
        } else {
            this.mResultsPerLocation.put(icfgLocation2, ResultUtil.combineLocationResults((IResult)iResult2, (IResult)iResult));
        }
    }

    private IcfgLocation getOriginalLocation(IcfgLocation icfgLocation) {
        if (this.mLocationMap == null) {
            return icfgLocation;
        }
        return this.mLocationMap.getOrDefault(icfgLocation, icfgLocation);
    }

    private void reportLocationResults() {
        boolean bl = this.mResultsPerLocation.entrySet().stream().anyMatch(entry -> TraceAbstractionStarter.isInsufficientThreadsLocation((IcfgLocation)entry.getKey()) && !(entry.getValue() instanceof PositiveResult));
        for (Map.Entry<IcfgLocation, IResult> entry2 : this.mResultsPerLocation.entrySet()) {
            boolean bl2;
            if (bl) {
                bl2 = !(entry2.getValue() instanceof PositiveResult);
            } else {
                boolean bl3 = bl2 = !TraceAbstractionStarter.isInsufficientThreadsLocation(entry2.getKey());
            }
            if (!bl2) continue;
            this.mResultReporter.reportResult(entry2.getValue());
        }
    }

    private String getBenchmarkDescription(DebugIdentifier debugIdentifier, int n) {
        Object object = debugIdentifier instanceof AllErrorsAtOnceDebugIdentifier ? "Ultimate Automizer benchmark data" : (debugIdentifier instanceof ThreadInstanceDebugIdentifier ? "Ultimate Automizer benchmark data for errors in thread instance: " + String.valueOf(debugIdentifier) : (debugIdentifier instanceof InUseDebugIdentifier ? "Ultimate Automizer benchmark data for thread instance sufficiency" : (TraceAbstractionStarter.isInsufficientThreadsIdentifier(debugIdentifier) ? "Ultimate Automizer benchmark data for thread instance sufficiency: " + String.valueOf(debugIdentifier) : "Ultimate Automizer benchmark data for error location: " + String.valueOf(debugIdentifier))));
        if (this.mIsConcurrent) {
            return (String)object + " with " + n + " thread instances";
        }
        return object;
    }

    public IElement getRootOfNewModel() {
        return this.mRootOfNewModel;
    }

    private static <L extends IIcfgTransition<?>> boolean hasSufficientThreadInstances(CegarLoopResult<L> cegarLoopResult) {
        return cegarLoopResult.getResults().entrySet().stream().filter(entry -> ((CegarLoopLocalResult)entry.getValue()).getResult() == AbstractCegarLoop.Result.UNSAFE).noneMatch(entry -> TraceAbstractionStarter.isInsufficientThreadsLocation((IcfgLocation)entry.getKey()));
    }

    private static boolean isInsufficientThreadsLocation(IcfgLocation icfgLocation) {
        Check check = Check.getAnnotation((IElement)icfgLocation);
        return check != null && check.getSpec().contains(Spec.SUFFICIENT_THREAD_INSTANCES);
    }

    public static final class AllErrorsAtOnceDebugIdentifier
    extends DebugIdentifier {
        public static final AllErrorsAtOnceDebugIdentifier INSTANCE = new AllErrorsAtOnceDebugIdentifier();

        private AllErrorsAtOnceDebugIdentifier() {
        }

        public String toString() {
            return "AllErrorsAtOnce";
        }
    }

    public static enum CegarRestartBehaviour {
        ONLY_ONE_CEGAR,
        ONE_CEGAR_PER_THREAD_INSTANCE,
        ONE_CEGAR_PER_ERROR_LOCATION;

    }

    public static final class InUseDebugIdentifier
    extends DebugIdentifier {
        public static final InUseDebugIdentifier INSTANCE = new InUseDebugIdentifier();

        private InUseDebugIdentifier() {
        }

        public String toString() {
            return "InUseError";
        }
    }

    private static final class ProvenCegarLoopResult<L>
    extends CegarLoopResult<L> {
        private final IProof mProof;

        public ProvenCegarLoopResult(CegarLoopResult<L> cegarLoopResult, IProof iProof) {
            super(cegarLoopResult.getResults(), cegarLoopResult.getCegarLoopStatisticsGenerator(), cegarLoopResult.getArtifact(), cegarLoopResult.getFloydHoareAutomata());
            this.mProof = iProof;
        }

        public IProof getProof() {
            return this.mProof;
        }
    }

    private static final class ThreadInstanceDebugIdentifier
    extends StringDebugIdentifier {
        private ThreadInstanceDebugIdentifier(String string) {
            super(string);
        }
    }
}

