/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Trigger;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FunctionInliner
extends BoogieTransformer
implements IUnmanagedObserver {
    private Map<String, FunctionDeclaration> mInlinedFunctions;
    private Scope mCurrentScope;
    private final ILogger mLogger;

    public FunctionInliner(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public boolean process(IElement iElement) {
        if (!(iElement instanceof Unit)) {
            return true;
        }
        Unit unit = (Unit)iElement;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.mInlinedFunctions = new HashMap<String, FunctionDeclaration>();
        Declaration[] declarationArray = unit.getDeclarations();
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Declaration declaration = declarationArray[n2];
            if (declaration instanceof FunctionDeclaration) {
                FunctionDeclaration functionDeclaration = (FunctionDeclaration)declaration;
                if (functionDeclaration.getBody() == null) {
                    arrayList.add(functionDeclaration);
                } else if (!this.checkFunctionInlineAttr(functionDeclaration)) {
                    Axiom axiom = FunctionInliner.createAxiom(functionDeclaration);
                    this.mLogger.warn("Replacing function body of %s with quantified axiom %s", new Object[]{functionDeclaration.getIdentifier(), BoogiePrettyPrinter.print((Axiom)axiom)});
                    arrayList.add(new FunctionDeclaration(functionDeclaration.getLocation(), functionDeclaration.getAttributes(), functionDeclaration.getIdentifier(), functionDeclaration.getTypeParams(), functionDeclaration.getInParams(), functionDeclaration.getOutParam()));
                    arrayList.add(axiom);
                }
            } else {
                arrayList.add(declaration);
            }
            ++n2;
        }
        this.mCurrentScope = new Scope();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            arrayList.set(n3, this.processDeclaration((Declaration)arrayList.get(n3)));
            ++n3;
        }
        this.mCurrentScope = null;
        this.mInlinedFunctions = null;
        unit.setDeclarations(arrayList.toArray(new Declaration[arrayList.size()]));
        return false;
    }

    private static Axiom createAxiom(FunctionDeclaration functionDeclaration) {
        String string;
        Expression[] expressionArray;
        ArrayList<IdentifierExpression> arrayList = new ArrayList<IdentifierExpression>();
        int n = 0;
        BinaryExpression binaryExpression = functionDeclaration.getInParams();
        int n2 = ((VarList[])binaryExpression).length;
        int n3 = 0;
        while (n3 < n2) {
            expressionArray = binaryExpression[n3];
            if (expressionArray.getIdentifiers().length == 0) {
                arrayList.add(new IdentifierExpression(expressionArray.getLocation(), expressionArray.getType().getBoogieType(), "#" + n, new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null)));
                ++n;
            } else {
                String[] stringArray = expressionArray.getIdentifiers();
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    string = stringArray[n5];
                    arrayList.add(new IdentifierExpression(expressionArray.getLocation(), expressionArray.getType().getBoogieType(), string, new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null)));
                    ++n5;
                }
            }
            ++n3;
        }
        expressionArray = arrayList.toArray(new Expression[arrayList.size()]);
        FunctionApplication functionApplication = new FunctionApplication(functionDeclaration.getLocation(), functionDeclaration.getOutParam().getType().getBoogieType(), functionDeclaration.getIdentifier(), expressionArray);
        Trigger trigger = new Trigger(functionDeclaration.getLocation(), new Expression[]{functionApplication});
        binaryExpression = new BinaryExpression(functionDeclaration.getLocation(), (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.COMPEQ, (Expression)functionApplication, functionDeclaration.getBody());
        string = new QuantifierExpression(functionDeclaration.getLocation(), (IBoogieType)BoogieType.TYPE_BOOL, true, functionDeclaration.getTypeParams(), functionDeclaration.getInParams(), new Attribute[]{trigger}, (Expression)binaryExpression);
        return new Axiom(functionDeclaration.getLocation(), new Attribute[0], (Expression)string);
    }

    private boolean checkFunctionInlineAttr(FunctionDeclaration functionDeclaration) {
        Attribute[] attributeArray = functionDeclaration.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof NamedAttribute) {
                NamedAttribute namedAttribute = (NamedAttribute)attribute;
                Expression[] expressionArray = namedAttribute.getValues();
                if ("inline".equals(namedAttribute.getName())) {
                    if (expressionArray.length != 1 || !(expressionArray[0] instanceof BooleanLiteral)) {
                        throw new RuntimeException("inline attribute with wrong parameters: " + Arrays.stream(expressionArray).map(BoogiePrettyPrinter::print).collect(Collectors.joining(", ")) + " (should be only 1 and of type bool)");
                    }
                    if (!((BooleanLiteral)expressionArray[0]).getValue()) {
                        return false;
                    }
                }
            }
            ++n2;
        }
        this.mInlinedFunctions.put(functionDeclaration.getIdentifier(), functionDeclaration);
        return true;
    }

    protected Declaration processDeclaration(Declaration declaration) {
        if (declaration instanceof FunctionDeclaration || declaration instanceof Procedure) {
            this.mCurrentScope = new Scope(this.mCurrentScope);
            Declaration declaration2 = super.processDeclaration(declaration);
            this.mCurrentScope = this.mCurrentScope.getParent();
            return declaration2;
        }
        return super.processDeclaration(declaration);
    }

    protected Body processBody(Body body) {
        this.mCurrentScope = new Scope(this.mCurrentScope);
        Body body2 = super.processBody(body);
        this.mCurrentScope = this.mCurrentScope.getParent();
        return body2;
    }

    public VarList processVarList(VarList varList) {
        String[] stringArray = varList.getIdentifiers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.mCurrentScope.declareName(string);
            ++n2;
        }
        return super.processVarList(varList);
    }

    public Expression processExpression(Expression expression) {
        Expression expression2 = null;
        if (expression instanceof IdentifierExpression) {
            String string = ((IdentifierExpression)expression).getIdentifier();
            Expression expression3 = this.mCurrentScope.lookupRenaming(string);
            if (expression3 != null) {
                expression2 = expression3;
            }
        } else if (expression instanceof FunctionApplication) {
            FunctionApplication functionApplication = (FunctionApplication)expression;
            String string = functionApplication.getIdentifier();
            if (this.mInlinedFunctions.containsKey(string)) {
                VarList varList;
                this.mCurrentScope = new Scope(this.mCurrentScope);
                FunctionDeclaration functionDeclaration = this.mInlinedFunctions.get(string);
                Expression[] expressionArray = functionApplication.getArguments();
                int n = 0;
                VarList[] varListArray = functionDeclaration.getInParams();
                int n2 = varListArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    varList = varListArray[n3];
                    if (varList.getIdentifiers().length == 0) {
                        ++n;
                    } else {
                        String[] stringArray = varList.getIdentifiers();
                        int n4 = stringArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            String string2 = stringArray[n5];
                            this.mCurrentScope.addRenaming(string2, this.processExpression(expressionArray[n]));
                            ++n;
                            ++n5;
                        }
                    }
                    ++n3;
                }
                varList = this.processExpression(functionDeclaration.getBody());
                this.mCurrentScope = this.mCurrentScope.getParent();
                expression2 = varList;
            }
        } else if (expression instanceof QuantifierExpression) {
            String[] stringArray;
            VarList[] varListArray;
            QuantifierExpression quantifierExpression = (QuantifierExpression)expression;
            this.mCurrentScope = new Scope(this.mCurrentScope);
            VarList[] varListArray2 = varListArray = quantifierExpression.getParameters();
            int n = 0;
            while (n < varListArray.length) {
                String[] stringArray2 = stringArray = varListArray[n].getIdentifiers();
                int n6 = 0;
                while (n6 < stringArray.length) {
                    if (this.mCurrentScope.clashes(stringArray[n6])) {
                        String string;
                        if (stringArray2 == stringArray) {
                            stringArray2 = (String[])stringArray.clone();
                        }
                        int n7 = 0;
                        do {
                            string = stringArray[n6] + "$" + n7;
                            ++n7;
                        } while (this.mCurrentScope.clashes(string));
                        stringArray2[n6] = string;
                        this.mCurrentScope.addRenaming(stringArray[n6], (Expression)new IdentifierExpression(varListArray[n].getLocation(), varListArray[n].getType().getBoogieType(), string, new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null)));
                    }
                    if (stringArray2 != stringArray) {
                        if (varListArray2 == varListArray) {
                            varListArray2 = (VarList[])varListArray.clone();
                        }
                        varListArray2[n] = new VarList(varListArray[n].getLocation(), stringArray2, varListArray[n].getType());
                    }
                    ++n6;
                }
                ++n;
            }
            varListArray2 = this.processVarLists(varListArray2);
            Expression expression4 = this.processExpression(quantifierExpression.getSubformula());
            stringArray = this.processAttributes(quantifierExpression.getAttributes());
            this.mCurrentScope = this.mCurrentScope.getParent();
            if (varListArray == varListArray2 && expression4 == quantifierExpression.getSubformula() && stringArray == quantifierExpression.getAttributes()) {
                return expression;
            }
            expression2 = new QuantifierExpression(quantifierExpression.getLocation(), quantifierExpression.getType(), quantifierExpression.isUniversal(), quantifierExpression.getTypeParams(), varListArray2, (Attribute[])stringArray, expression4);
        }
        if (expression2 == null) {
            return super.processExpression(expression);
        }
        ModelUtils.copyAnnotations((IElement)expression, expression2);
        return expression2;
    }

    public void finish() {
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public boolean performedChanges() {
        return false;
    }

    private static final class Scope {
        private final Map<String, Expression> mRenamings;
        private final Set<String> mDeclaredName;
        private final Scope mParent;

        public Scope() {
            this.mParent = null;
            this.mRenamings = new HashMap<String, Expression>();
            this.mDeclaredName = new HashSet<String>();
        }

        public Scope(Scope scope) {
            this.mParent = scope;
            this.mRenamings = new HashMap<String, Expression>(scope.mRenamings);
            this.mDeclaredName = new HashSet<String>(scope.mDeclaredName);
        }

        public Scope getParent() {
            return this.mParent;
        }

        public void addRenaming(String string, Expression expression) {
            this.mRenamings.put(string, expression);
        }

        public Expression lookupRenaming(String string) {
            return this.mRenamings.get(string);
        }

        public boolean clashes(String string) {
            return this.mDeclaredName.contains(string);
        }

        public void declareName(String string) {
            this.mDeclaredName.add(string);
        }
    }
}

