/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.IBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolutionBuilder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermOperations;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.INonSolverScript;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ExplicitLhsPolynomialRelation
implements IBinaryRelation,
ITermProvider {
    private static final boolean THROW_EXCEPTION_IF_NOT_SOLVABLE = false;
    protected final RelationSymbol mRelationSymbol;
    protected final Rational mLhsCoefficient;
    protected final Monomial mLhsMonomial;
    protected final IPolynomialTerm mRhs;

    public ExplicitLhsPolynomialRelation(RelationSymbol relationSymbol, Rational rational, Monomial monomial, IPolynomialTerm iPolynomialTerm) {
        this.mRelationSymbol = relationSymbol;
        this.mLhsCoefficient = rational;
        this.mLhsMonomial = monomial;
        this.mRhs = iPolynomialTerm;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public Rational getLhsCoefficient() {
        return this.mLhsCoefficient;
    }

    public Monomial getLhsMonomial() {
        return this.mLhsMonomial;
    }

    public IPolynomialTerm getRhs() {
        return this.mRhs;
    }

    public ExplicitLhsPolynomialRelation changeRelationSymbol(RelationSymbol relationSymbol) {
        return new ExplicitLhsPolynomialRelation(relationSymbol, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs);
    }

    public static ExplicitLhsPolynomialRelation moveMonomialToLhs(Script script, Term term, PolynomialRelation polynomialRelation) {
        Rational rational;
        Monomial monomial = polynomialRelation.getPolynomialTerm().getExclusiveMonomialOfSubject(term);
        if (monomial == null) {
            return null;
        }
        if (monomial.getVariable2Exponent().get(term) != Rational.ONE) {
            return null;
        }
        if (polynomialRelation.getPolynomialTerm().isAffine()) {
            Term term2 = monomial.getSingleVariable();
            assert (term.equals(term2));
            rational = polynomialRelation.getPolynomialTerm().getAbstractVariable2Coefficient().get(term2);
        } else {
            rational = polynomialRelation.getPolynomialTerm().getAbstractVariable2Coefficient().get(monomial);
        }
        if (rational.equals((Object)Rational.ZERO)) {
            throw new AssertionError((Object)"no abstract variable must have coefficient zero");
        }
        return new ExplicitLhsPolynomialRelation(polynomialRelation.getRelationSymbol(), rational, monomial, polynomialRelation.getPolynomialTerm().removeAndNegate(monomial));
    }

    @Deprecated
    public ExplicitLhsPolynomialRelation mul(Rational rational, Script script, boolean bl) {
        IPolynomialTerm iPolynomialTerm;
        Object object;
        if (rational.equals((Object)Rational.ZERO)) {
            throw new AssertionError((Object)"mul by zero not supported");
        }
        Rational rational2 = this.mLhsCoefficient.mul(rational);
        RelationSymbol relationSymbol = this.determineResultRelationSymbol(this.mLhsMonomial.getSort(), this.mRelationSymbol, rational);
        if (bl && (relationSymbol.equals((Object)RelationSymbol.LESS) || relationSymbol.equals((Object)RelationSymbol.GREATER))) {
            if (relationSymbol.equals((Object)RelationSymbol.LESS)) {
                object = rational.abs().add(Rational.MONE).negate();
            } else {
                assert (relationSymbol.equals((Object)RelationSymbol.GREATER));
                object = rational.abs().add(Rational.MONE);
            }
            iPolynomialTerm = PolynomialTermOperations.sum(PolynomialTermOperations.mul(this.mRhs, rational), new AffineTerm(this.mLhsMonomial.getSort(), (Rational)object, Collections.emptyMap()));
        } else if (!bl && (relationSymbol.equals((Object)RelationSymbol.LEQ) || relationSymbol.equals((Object)RelationSymbol.GEQ))) {
            if (relationSymbol.equals((Object)RelationSymbol.GEQ)) {
                object = rational.abs().add(Rational.MONE).negate();
            } else {
                assert (relationSymbol.equals((Object)RelationSymbol.LEQ));
                object = rational.abs().add(Rational.MONE);
            }
            iPolynomialTerm = PolynomialTermOperations.sum(PolynomialTermOperations.mul(this.mRhs, rational), new AffineTerm(this.mLhsMonomial.getSort(), (Rational)object, Collections.emptyMap()));
        } else {
            iPolynomialTerm = PolynomialTermOperations.mul(this.mRhs, rational);
        }
        object = new ExplicitLhsPolynomialRelation(relationSymbol, rational2, this.mLhsMonomial, iPolynomialTerm);
        assert (script instanceof INonSolverScript || SmtUtils.checkEquivalence(this.toTerm(script), ((ExplicitLhsPolynomialRelation)object).toTerm(script), script) != Script.LBool.SAT) : "mul unsound";
        return object;
    }

    public ExplicitLhsPolynomialRelation divInvertible(Rational rational) {
        IPolynomialTerm iPolynomialTerm;
        IPolynomialTerm iPolynomialTerm2;
        if (rational.equals((Object)Rational.ZERO)) {
            throw new AssertionError((Object)"div by zero");
        }
        RelationSymbol relationSymbol = this.determineResultRelationSymbol(this.mLhsMonomial.getSort(), this.mRelationSymbol, rational);
        if (relationSymbol.isConvexInequality() && SmtSortUtils.isIntSort(this.mRhs.getSort())) {
            Rational rational2;
            iPolynomialTerm2 = this.mRhs.add(this.mRhs.getConstant().negate());
            assert (iPolynomialTerm2.getConstant().equals((Object)Rational.ZERO));
            IPolynomialTerm iPolynomialTerm3 = iPolynomialTerm2.divInvertible(rational);
            if (iPolynomialTerm3 == null) {
                return null;
            }
            Rational rational3 = rational.isNegative() ? this.mRhs.getConstant().negate() : this.mRhs.getConstant();
            if (relationSymbol.equals((Object)RelationSymbol.LEQ) || relationSymbol.equals((Object)RelationSymbol.GREATER)) {
                rational2 = rational3.div(rational.abs()).floor();
            } else if (relationSymbol.equals((Object)RelationSymbol.LESS) || relationSymbol.equals((Object)RelationSymbol.GEQ)) {
                rational2 = rational3.add(Rational.MONE).div(rational.abs()).floor().add(Rational.ONE);
            } else {
                throw new AssertionError((Object)("Unexpected relation symbol: " + String.valueOf((Object)relationSymbol)));
            }
            iPolynomialTerm = iPolynomialTerm3.add(rational2);
        } else {
            iPolynomialTerm = this.mRhs.divInvertible(rational);
        }
        if (iPolynomialTerm == null) {
            return null;
        }
        iPolynomialTerm2 = PolynomialTermUtils.divInvertible(this.mLhsMonomial.getSort(), this.mLhsCoefficient, rational);
        if (iPolynomialTerm2 == null) {
            return null;
        }
        return new ExplicitLhsPolynomialRelation(relationSymbol, (Rational)iPolynomialTerm2, this.mLhsMonomial, iPolynomialTerm);
    }

    private RelationSymbol determineResultRelationSymbol(Sort sort, RelationSymbol relationSymbol, Rational rational) {
        RelationSymbol relationSymbol2 = ExplicitLhsPolynomialRelation.swapOfRelationSymbolRequired(rational, sort) ? relationSymbol.swapParameters() : relationSymbol;
        return relationSymbol2;
    }

    public static boolean swapOfRelationSymbolRequired(Rational rational, Sort sort) {
        return rational.isNegative() || SmtSortUtils.isBitvecSort(sort) && SmtUtils.isBvMinusOneButNotOne(rational, sort);
    }

    public Pair<ExplicitLhsPolynomialRelation, Term> divideByIntegerCoefficient(Script script, Set<TermVariable> set) {
        if (this.mLhsCoefficient.equals((Object)Rational.ZERO)) {
            throw new AssertionError((Object)"div by zero");
        }
        if (!SmtSortUtils.isIntSort(this.mLhsMonomial.getSort())) {
            throw new AssertionError((Object)("no int: " + String.valueOf(this.mLhsMonomial.getSort())));
        }
        Term term = this.mLhsCoefficient.toTerm(this.mLhsMonomial.getSort());
        IPolynomialTerm iPolynomialTerm = SolveForSubjectUtils.constructRhsIntegerQuotient(script, this.mRelationSymbol, this.mRhs, !this.mLhsCoefficient.isNegative(), term, set);
        Term term2 = this.mRhs.toTerm(script);
        if (iPolynomialTerm == null) {
            assert (Arrays.stream(term2.getFreeVars()).anyMatch(set::contains)) : "no ban problem detected";
            return null;
        }
        Term term3 = switch (this.mRelationSymbol) {
            case RelationSymbol.DISTINCT -> ExplicitLhsPolynomialRelation.constructDivisibilityConstraint(script, true, term2, term);
            case RelationSymbol.EQ -> ExplicitLhsPolynomialRelation.constructDivisibilityConstraint(script, false, term2, term);
            case RelationSymbol.LEQ, RelationSymbol.GEQ, RelationSymbol.LESS, RelationSymbol.GREATER, RelationSymbol.BVULE, RelationSymbol.BVULT, RelationSymbol.BVUGE, RelationSymbol.BVUGT, RelationSymbol.BVSLE, RelationSymbol.BVSLT, RelationSymbol.BVSGE, RelationSymbol.BVSGT -> null;
            default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)this.mRelationSymbol)));
        };
        RelationSymbol relationSymbol = this.determineResultRelationSymbol(this.mLhsMonomial.getSort(), this.mRelationSymbol, this.mLhsCoefficient);
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation = new ExplicitLhsPolynomialRelation(relationSymbol, Rational.ONE, this.getLhsMonomial(), iPolynomialTerm);
        return new Pair((Object)explicitLhsPolynomialRelation, (Object)term3);
    }

    @Deprecated
    public SolvedBinaryRelation divideByIntegerCoefficientForInequalities(Script script, Set<TermVariable> set) {
        switch (this.mRelationSymbol) {
            case EQ: 
            case DISTINCT: {
                throw new AssertionError((Object)"no inequality");
            }
            case LEQ: 
            case GEQ: 
            case LESS: 
            case GREATER: 
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + String.valueOf((Object)this.mRelationSymbol)));
            }
        }
        Pair<ExplicitLhsPolynomialRelation, Term> pair = this.divideByIntegerCoefficient(script, set);
        if (pair == null) {
            return null;
        }
        assert (pair.getSecond() == null);
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation = (ExplicitLhsPolynomialRelation)pair.getFirst();
        return new SolvedBinaryRelation(this.mLhsMonomial.getSingleVariable(), explicitLhsPolynomialRelation.getRhs().toTerm(script), explicitLhsPolynomialRelation.getRelationSymbol(), MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT);
    }

    public MultiCaseSolvedBinaryRelation divByMonomial(Script script, Term term, MultiCaseSolvedBinaryRelation.Xnf xnf, Set<TermVariable> set, Term term2, MultiCaseSolvedBinaryRelation.IntricateOperation intricateOperation) {
        int supportingTerm;
        int hashSet2;
        if (!this.mLhsCoefficient.equals((Object)Rational.ONE)) {
            throw new AssertionError((Object)"could be supported, but should not be used in our applications");
        }
        Term term4 = this.mRhs.toTerm(script);
        if (this.mLhsMonomial.isLinear()) {
            throw new AssertionError((Object)"division not necessary");
        }
        if (Arrays.stream(term4.getFreeVars()).anyMatch(set::contains)) {
            return null;
        }
        EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> enumSet = intricateOperation == null ? EnumSet.of(MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT) : EnumSet.of(MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, intricateOperation);
        MultiCaseSolutionBuilder multiCaseSolutionBuilder = new MultiCaseSolutionBuilder(term, xnf);
        ArrayList<Case> arrayList = new ArrayList<Case>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        HashSet<SupportingTerm> hashSet = new HashSet<SupportingTerm>();
        ArrayList<Term> arrayList3 = new ArrayList<Term>();
        ArrayList<SupportingTerm> arrayList4 = new ArrayList<SupportingTerm>();
        ArrayList<SupportingTerm> arrayList5 = new ArrayList<SupportingTerm>();
        ArrayList<Term> arrayList6 = new ArrayList<Term>();
        for (Map.Entry<Term, Rational> term32 : this.mLhsMonomial.getVariable2Exponent().entrySet()) {
            assert (term32.getValue().isIntegral());
            if (term32.getKey() == term) continue;
            arrayList.add(ExplicitLhsPolynomialRelation.constructDivByVarEqualZeroCase(script, term32.getKey(), term4, this.mRelationSymbol, xnf, term2));
            hashSet2 = term32.getValue().numerator().intValueExact();
            supportingTerm = 0;
            while (supportingTerm < hashSet2) {
                arrayList6.add(term32.getKey());
                ++supportingTerm;
            }
            if (ExplicitLhsPolynomialRelation.isEqOrDistinct(this.mRelationSymbol) || hashSet2 % 2 == 0) {
                arrayList2.add(term32.getKey());
                hashSet.add(ExplicitLhsPolynomialRelation.constructInRelationToZeroSupportingTerm(script, term32.getKey(), SolveForSubjectUtils.negateForCnf(RelationSymbol.DISTINCT, xnf)));
                continue;
            }
            arrayList3.add(term32.getKey());
            arrayList4.add(ExplicitLhsPolynomialRelation.constructInRelationToZeroSupportingTerm(script, term32.getKey(), SolveForSubjectUtils.negateForCnf(RelationSymbol.LESS, xnf)));
            arrayList5.add(ExplicitLhsPolynomialRelation.constructInRelationToZeroSupportingTerm(script, term32.getKey(), SolveForSubjectUtils.negateForCnf(RelationSymbol.GREATER, xnf)));
        }
        Term term3 = SmtUtils.mul(script, ((Term)arrayList6.get(0)).getSort(), arrayList6.toArray(new Term[arrayList6.size()]));
        if (arrayList3.isEmpty()) {
            SolvedBinaryRelation solvedBinaryRelation = ExplicitLhsPolynomialRelation.constructSolvedBinaryRelation(script, term, this.mRhs, this.mRelationSymbol, true, term3, enumSet, set);
            HashSet<SupportingTerm> supportingTerm2 = new HashSet<SupportingTerm>(hashSet);
            if (SolveForSubjectUtils.isDerIntegerDivisionSupportingTermRequired(xnf, term.getSort(), this.mRelationSymbol)) {
                SupportingTerm supportingTerm3 = ExplicitLhsPolynomialRelation.constructDerIntegerDivisionSupportingTerm(script, term4, this.mRelationSymbol, term3);
                supportingTerm2.add(supportingTerm3);
                if (term2 != null) {
                    SupportingTerm solvedBinaryRelation2 = SolveForSubjectUtils.constructDerIntegerDivisionSupportingTerm(script, term2);
                    supportingTerm2.add(solvedBinaryRelation2);
                }
            }
            arrayList.add(new Case(solvedBinaryRelation, supportingTerm2, xnf));
        } else {
            if (arrayList3.size() > 30) {
                throw new UnsupportedOperationException("Exponential blowup too huge. Exponent is " + arrayList3.size());
            }
            int n3 = BigInteger.valueOf(2L).pow(arrayList3.size()).intValueExact();
            hashSet2 = 0;
            while (hashSet2 < n3) {
                SupportingTerm supportingTerm4;
                supportingTerm = BigInteger.valueOf(hashSet2).bitCount() % 2 == 0 ? 1 : 0;
                SolvedBinaryRelation solvedBinaryRelation = ExplicitLhsPolynomialRelation.constructSolvedBinaryRelation(script, term, this.mRhs, this.mRelationSymbol, supportingTerm != 0, term3, enumSet, set);
                HashSet<SupportingTerm> hashSet3 = new HashSet<SupportingTerm>(hashSet);
                int supportingTerm3 = 0;
                while (supportingTerm3 < arrayList3.size()) {
                    supportingTerm4 = BigInteger.valueOf(hashSet2).testBit(supportingTerm3) ? (SupportingTerm)arrayList4.get(supportingTerm3) : (SupportingTerm)arrayList5.get(supportingTerm3);
                    hashSet3.add(supportingTerm4);
                    ++supportingTerm3;
                }
                if (SolveForSubjectUtils.isDerIntegerDivisionSupportingTermRequired(xnf, term.getSort(), this.mRelationSymbol)) {
                    SupportingTerm supportingTerm5 = ExplicitLhsPolynomialRelation.constructDerIntegerDivisionSupportingTerm(script, term4, this.mRelationSymbol, term3);
                    hashSet3.add(supportingTerm5);
                    assert (term2 != null);
                    supportingTerm4 = SolveForSubjectUtils.constructDerIntegerDivisionSupportingTerm(script, term2);
                    hashSet3.add(supportingTerm4);
                }
                arrayList.add(new Case(solvedBinaryRelation, hashSet3, xnf));
                ++hashSet2;
            }
        }
        if (SolveForSubjectUtils.isAntiDerIntegerDivisionCaseRequired(xnf, term.getSort(), this.mRelationSymbol)) {
            Case case_ = ExplicitLhsPolynomialRelation.constructAntiDerIntegerDivisibilityCase(script, xnf, term4, this.mRelationSymbol, term3);
            arrayList.add(case_);
            if (term2 != null) {
                SupportingTerm supportingTerm6 = new SupportingTerm(term2, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_INTEGER_CONSTANT, Collections.emptySet());
                Case case_2 = new Case(null, Collections.singleton(supportingTerm6), xnf);
                arrayList.add(case_2);
            }
        }
        multiCaseSolutionBuilder.splitCases(arrayList);
        MultiCaseSolvedBinaryRelation multiCaseSolvedBinaryRelation = multiCaseSolutionBuilder.buildResult();
        return multiCaseSolvedBinaryRelation;
    }

    private static SupportingTerm constructDerIntegerDivisionSupportingTerm(Script script, Term term, RelationSymbol relationSymbol, Term term2) {
        boolean bl = relationSymbol.equals((Object)RelationSymbol.DISTINCT);
        Term term3 = ExplicitLhsPolynomialRelation.constructDivisibilityConstraint(script, bl, term, SmtUtils.mul(script, term.getSort(), term2));
        SupportingTerm supportingTerm = new SupportingTerm(term3, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
        return supportingTerm;
    }

    private static Case constructAntiDerIntegerDivisibilityCase(Script script, MultiCaseSolvedBinaryRelation.Xnf xnf, Term term, RelationSymbol relationSymbol, Term term2) {
        HashSet<SupportingTerm> hashSet = new HashSet<SupportingTerm>();
        boolean bl = relationSymbol.equals((Object)RelationSymbol.DISTINCT);
        Term term3 = ExplicitLhsPolynomialRelation.constructDivisibilityConstraint(script, bl, term, SmtUtils.mul(script, term.getSort(), term2));
        SupportingTerm supportingTerm = new SupportingTerm(term3, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
        hashSet.add(supportingTerm);
        SupportingTerm supportingTerm2 = ExplicitLhsPolynomialRelation.constructInRelationToZeroSupportingTerm(script, SmtUtils.mul(script, term.getSort(), term2), SolveForSubjectUtils.negateForCnf(RelationSymbol.DISTINCT, xnf));
        hashSet.add(supportingTerm2);
        Case case_ = new Case(null, hashSet, xnf);
        return case_;
    }

    private static SupportingTerm constructInRelationToZeroSupportingTerm(Script script, Term term, RelationSymbol relationSymbol) {
        Term term2 = SmtUtils.rational2Term(script, Rational.ZERO, term.getSort());
        Term term3 = relationSymbol.constructTerm(script, term, term2);
        return new SupportingTerm(term3, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
    }

    private static SolvedBinaryRelation constructSolvedBinaryRelation(Script script, Term term, IPolynomialTerm iPolynomialTerm, RelationSymbol relationSymbol, boolean bl, Term term2, EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> enumSet, Set<TermVariable> set) {
        Term term3;
        RelationSymbol relationSymbol2 = bl ? relationSymbol : relationSymbol.swapParameters();
        if (SmtSortUtils.isIntSort(iPolynomialTerm.getSort())) {
            term3 = SolveForSubjectUtils.constructRhsIntegerQuotient(script, relationSymbol, iPolynomialTerm, bl, term2, set).toTerm(script);
            if (term3 == null) {
                return null;
            }
        } else {
            term3 = SmtUtils.divReal(script, SolveForSubjectUtils.prepend(iPolynomialTerm.toTerm(script), term2));
        }
        SolvedBinaryRelation solvedBinaryRelation = new SolvedBinaryRelation(term, term3, relationSymbol2, enumSet.toArray(new MultiCaseSolvedBinaryRelation.IntricateOperation[enumSet.size()]));
        return solvedBinaryRelation;
    }

    public static Term constructDivisibilityConstraint(Script script, boolean bl, Term term, Term term2) {
        Term term3 = SmtUtils.mod(script, term, term2);
        Term term4 = SmtUtils.binaryEquality(script, term3, SmtUtils.constructIntegerValue(script, SmtSortUtils.getIntSort(script), BigInteger.ZERO));
        Term term5 = bl ? SmtUtils.not(script, term4) : term4;
        return term5;
    }

    private static Case constructDivByVarEqualZeroCase(Script script, Term term, Term term2, RelationSymbol relationSymbol, MultiCaseSolvedBinaryRelation.Xnf xnf, Term term3) {
        LinkedHashSet<SupportingTerm> linkedHashSet = new LinkedHashSet<SupportingTerm>();
        if (SolveForSubjectUtils.isDerIntegerDivisionSupportingTermRequired(xnf, term.getSort(), relationSymbol) && term3 != null) {
            linkedHashSet.add(SolveForSubjectUtils.constructDerIntegerDivisionSupportingTerm(script, term3));
        }
        Term term4 = SmtUtils.rational2Term(script, Rational.ZERO, term.getSort());
        Term term5 = SmtUtils.binaryEquality(script, term4, term);
        linkedHashSet.add(switch (xnf) {
            case MultiCaseSolvedBinaryRelation.Xnf.CNF -> new SupportingTerm(SmtUtils.not(script, term5), MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
            case MultiCaseSolvedBinaryRelation.Xnf.DNF -> new SupportingTerm(term5, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet());
            default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)xnf)));
        });
        linkedHashSet.add(new SupportingTerm(switch (relationSymbol) {
            case RelationSymbol.EQ -> SmtUtils.binaryEquality(script, term4, term2);
            case RelationSymbol.DISTINCT -> SmtUtils.distinct(script, term4, term2);
            case RelationSymbol.LEQ -> SmtUtils.leq(script, term4, term2);
            case RelationSymbol.LESS -> SmtUtils.less(script, term4, term2);
            case RelationSymbol.GEQ -> SmtUtils.geq(script, term4, term2);
            case RelationSymbol.GREATER -> SmtUtils.greater(script, term4, term2);
            case RelationSymbol.BVULE -> SmtUtils.bvule(script, term4, term2);
            case RelationSymbol.BVULT -> SmtUtils.bvult(script, term4, term2);
            case RelationSymbol.BVUGE -> SmtUtils.bvuge(script, term4, term2);
            case RelationSymbol.BVUGT -> SmtUtils.bvugt(script, term4, term2);
            case RelationSymbol.BVSLE -> SmtUtils.bvsle(script, term4, term2);
            case RelationSymbol.BVSLT -> SmtUtils.bvslt(script, term4, term2);
            case RelationSymbol.BVSGE -> SmtUtils.bvsge(script, term4, term2);
            case RelationSymbol.BVSGT -> SmtUtils.bvsgt(script, term4, term2);
            default -> throw new AssertionError((Object)("Unknown RelationSymbol: " + String.valueOf((Object)relationSymbol)));
        }, MultiCaseSolvedBinaryRelation.IntricateOperation.DIV_BY_NONCONSTANT, Collections.emptySet()));
        return new Case(null, linkedHashSet, xnf);
    }

    public ExplicitLhsPolynomialRelation changeStrictness(PolynomialRelation.TransformInequality transformInequality) {
        if (!SmtSortUtils.isIntSort(this.mRhs.getSort())) {
            throw new UnsupportedOperationException("Change of strictness only for ints.");
        }
        if (transformInequality == PolynomialRelation.TransformInequality.NO_TRANFORMATION) {
            return this;
        }
        switch (this.mRelationSymbol) {
            case EQ: 
            case DISTINCT: {
                throw new UnsupportedOperationException("Only applicable to integer inequalities");
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                throw new UnsupportedOperationException("Only applicable to integer inequalities");
            }
            case GEQ: {
                if (transformInequality == PolynomialRelation.TransformInequality.NONSTRICT2STRICT) {
                    return new ExplicitLhsPolynomialRelation(RelationSymbol.GREATER, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs.add(Rational.MONE));
                }
                throw new UnsupportedOperationException("Not strict");
            }
            case GREATER: {
                if (transformInequality == PolynomialRelation.TransformInequality.STRICT2NONSTRICT) {
                    return new ExplicitLhsPolynomialRelation(RelationSymbol.GEQ, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs.add(Rational.ONE));
                }
                throw new UnsupportedOperationException("Is strict");
            }
            case LEQ: {
                if (transformInequality == PolynomialRelation.TransformInequality.NONSTRICT2STRICT) {
                    return new ExplicitLhsPolynomialRelation(RelationSymbol.LESS, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs.add(Rational.ONE));
                }
                throw new UnsupportedOperationException("Not strict");
            }
            case LESS: {
                if (transformInequality == PolynomialRelation.TransformInequality.STRICT2NONSTRICT) {
                    return new ExplicitLhsPolynomialRelation(RelationSymbol.LEQ, this.mLhsCoefficient, this.mLhsMonomial, this.mRhs.add(Rational.MONE));
                }
                throw new UnsupportedOperationException("Is strict");
            }
        }
        throw new AssertionError((Object)("Unknown relation symbol " + String.valueOf((Object)this.mRelationSymbol)));
    }

    public ExplicitLhsPolynomialRelation makeTight() {
        ExplicitLhsPolynomialRelation explicitLhsPolynomialRelation;
        Object object;
        if (SmtSortUtils.isRealSort(this.mRhs.getSort())) {
            object = this.mLhsCoefficient;
        } else if (SmtSortUtils.isBitvecSort(this.mRhs.getSort())) {
            if (!this.mLhsCoefficient.equals((Object)Rational.ONE) && !SmtUtils.isBvMinusOneButNotOne(this.mLhsCoefficient, this.mRhs.getSort())) {
                throw new AssertionError((Object)"Expect that bitvector relations can only have coefficient 1 and -1.");
            }
            object = this.mLhsCoefficient;
        } else if (SmtSortUtils.isIntSort(this.mRhs.getSort())) {
            explicitLhsPolynomialRelation = this.mLhsCoefficient.gcd(this.mRhs.computeGcdOfCoefficients()).abs();
            assert (!explicitLhsPolynomialRelation.isNegative());
            if (!explicitLhsPolynomialRelation.equals(Rational.ONE)) {
                throw new AssertionError((Object)"The PolynomialRelation should have divided by the GCD!");
            }
            object = this.mLhsCoefficient.isNegative() ? explicitLhsPolynomialRelation.negate() : explicitLhsPolynomialRelation;
        } else {
            throw new UnsupportedOperationException("Unsupported sort: " + String.valueOf(this.mRhs.getSort()));
        }
        if (object.equals((Object)Rational.ONE)) {
            return this;
        }
        explicitLhsPolynomialRelation = this.divInvertible((Rational)object);
        if (explicitLhsPolynomialRelation == null) {
            throw new AssertionError((Object)("Invertible division must not fail for " + String.valueOf(object)));
        }
        return explicitLhsPolynomialRelation;
    }

    private static boolean isEqOrDistinct(RelationSymbol relationSymbol) {
        return relationSymbol.equals((Object)RelationSymbol.EQ) || relationSymbol.equals((Object)RelationSymbol.DISTINCT);
    }

    @Override
    public SolvedBinaryRelation solveForSubject(Script script, Term term) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Term toTerm(Script script) {
        Term term = SmtUtils.mul(script, this.mLhsCoefficient, this.mLhsMonomial.toTerm(script));
        return this.mRelationSymbol.constructTerm(script, term, this.mRhs.toTerm(script));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mLhsCoefficient);
        stringBuilder.append("*");
        stringBuilder.append(this.mLhsMonomial);
        stringBuilder.append(" ");
        stringBuilder.append((Object)this.mRelationSymbol);
        stringBuilder.append(" ");
        stringBuilder.append(this.mRhs);
        return stringBuilder.toString();
    }
}

