/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.CachedPersistentSetChoice;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.ConstantDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.DepthFirstTraversal;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IPersistentSetChoice;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.ISleepSetStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.MinimalSleepSetReduction;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.MultiPersistentSetChoice;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.PersistentSetReduction;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.CachedBudget;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.ISleepMapStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.SleepMapReduction;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.AutomatonConstructingVisitor;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.DeadEndOptimizingSearchVisitor;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.IDeadEndStore;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.IDfsVisitor;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.WrapperVisitor;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.BetterLockstepOrder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.LoopLockstepOrder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.PartialOrderMode;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.RandomDfsOrder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.SleepMapStateFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.SleepSetStateFactoryForRefinement;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.ThreadBasedPersistentSets;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceBuilder;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PartialOrderReductionFacade<L extends IIcfgTransition<?>> {
    public static final boolean ENABLE_COVERING_OPTIMIZATION = false;
    public static final boolean ENABLE_MULTI_PERSISTENT_SETS = true;
    private final IUltimateServiceProvider mServices;
    private final AutomataLibraryServices mAutomataServices;
    private final PartialOrderMode mMode;
    private final IDfsOrder<L, IPredicate> mDfsOrder;
    private final ISleepSetStateFactory<L, IPredicate, IPredicate> mSleepFactory;
    private final ISleepMapStateFactory<L, IPredicate, IPredicate> mSleepMapFactory;
    private StateSplitter<IPredicate> mStateSplitter;
    private final IDeadEndStore<?, IPredicate> mDeadEndStore;
    private final IIcfg<?> mIcfg;
    private final Collection<? extends IcfgLocation> mErrorLocs;
    private final List<IIndependenceRelation<IPredicate, L>> mIndependenceRelations;
    private IPersistentSetChoice<L, IPredicate> mPersistent;
    private final Function<SleepMapReduction<L, IPredicate, IPredicate>, SleepMapReduction.IBudgetFunction<L, IPredicate>> mGetBudget;
    private final Statistics mStatistics = new Statistics();

    public PartialOrderReductionFacade(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, IIcfg<?> iIcfg, Collection<? extends IcfgLocation> collection, PartialOrderMode partialOrderMode, OrderType orderType, long l, List<IIndependenceRelation<IPredicate, L>> list, Function<SleepMapReduction<L, IPredicate, IPredicate>, SleepMapReduction.IBudgetFunction<L, IPredicate>> function, Function<StateSplitter<IPredicate>, IDeadEndStore<?, IPredicate>> function2) {
        this.mServices = iUltimateServiceProvider;
        this.mAutomataServices = new AutomataLibraryServices(iUltimateServiceProvider);
        this.mMode = partialOrderMode;
        if (list.isEmpty() && this.mMode != PartialOrderMode.NONE) {
            throw new IllegalArgumentException("Need at least one independence relation");
        }
        if (list.size() > 1 && this.mMode != PartialOrderMode.SLEEP_NEW_STATES && this.mMode != PartialOrderMode.PERSISTENT_SLEEP_NEW_STATES_FIXEDORDER) {
            throw new IllegalArgumentException("This mode does not support multiple independence relations");
        }
        this.mIndependenceRelations = new ArrayList<IIndependenceRelation<IPredicate, L>>(list);
        this.mGetBudget = function;
        this.mSleepFactory = this.createSleepFactory(predicateFactory);
        this.mSleepMapFactory = this.createSleepMapFactory(predicateFactory);
        this.mDfsOrder = this.getDfsOrder(orderType, l, iIcfg, collection);
        this.mDeadEndStore = function2 == null ? null : function2.apply(this.mStateSplitter);
        this.mIcfg = iIcfg;
        this.mErrorLocs = collection;
        this.mPersistent = this.createPersistentSets(this.mIcfg, this.mErrorLocs);
    }

    public void replaceIndependence(int n, IIndependenceRelation<IPredicate, L> iIndependenceRelation) {
        assert (n >= 0 && n < this.mIndependenceRelations.size()) : "Unsupported index";
        IIndependenceRelation<IPredicate, L> iIndependenceRelation2 = this.mIndependenceRelations.get(n);
        if (Objects.equals(iIndependenceRelation, iIndependenceRelation2)) {
            return;
        }
        this.mStatistics.reportIndependenceStatistics(iIndependenceRelation2);
        if (this.mPersistent != null) {
            this.mStatistics.reportPersistentSetStatistics(this.mPersistent);
        }
        this.mIndependenceRelations.set(n, iIndependenceRelation);
        this.mPersistent = this.createPersistentSets(this.mIcfg, this.mErrorLocs);
    }

    public IIndependenceRelation<IPredicate, L> getIndependence(int n) {
        return this.mIndependenceRelations.get(n);
    }

    private ISleepSetStateFactory<L, IPredicate, IPredicate> createSleepFactory(PredicateFactory predicateFactory) {
        if (!this.mMode.hasSleepSets()) {
            return null;
        }
        if (this.mIndependenceRelations.size() > 1) {
            return null;
        }
        SleepSetStateFactoryForRefinement sleepSetStateFactoryForRefinement = new SleepSetStateFactoryForRefinement(predicateFactory);
        this.mStateSplitter = StateSplitter.extend(this.mStateSplitter, sleepSetStateFactoryForRefinement::getOriginalState, sleepSetStateFactoryForRefinement::getSleepSet);
        return sleepSetStateFactoryForRefinement;
    }

    private ISleepMapStateFactory<L, IPredicate, IPredicate> createSleepMapFactory(PredicateFactory predicateFactory) {
        if (this.mIndependenceRelations.size() <= 1) {
            return null;
        }
        SleepMapStateFactory sleepMapStateFactory = new SleepMapStateFactory(predicateFactory);
        this.mStateSplitter = StateSplitter.extend(this.mStateSplitter, sleepMapStateFactory::getOriginalState, iPredicate -> new Pair(sleepMapStateFactory.getSleepMap((IPredicate)iPredicate), (Object)sleepMapStateFactory.getBudget((IPredicate)iPredicate)));
        return sleepMapStateFactory;
    }

    public ISleepSetStateFactory<L, IPredicate, IPredicate> getSleepFactory() {
        return this.mSleepFactory;
    }

    public ISleepMapStateFactory<L, IPredicate, IPredicate> getSleepMapFactory() {
        return this.mSleepMapFactory;
    }

    private IDfsOrder<L, IPredicate> getDfsOrder(OrderType orderType, long l, IIcfg<?> iIcfg, Collection<? extends IcfgLocation> collection) {
        return switch (orderType) {
            case OrderType.BY_SERIAL_NUMBER -> {
                Set var6_5 = collection.stream().map(IcfgLocation::getProcedure).collect(Collectors.toSet());
                yield new ConstantDfsOrder(Comparator.comparing(iIcfgTransition -> !var6_5.contains(iIcfgTransition.getPrecedingProcedure())).thenComparing(Comparator.comparing(iIcfgTransition -> iIcfgTransition.getPrecedingProcedure())).thenComparing(Comparator.comparingInt(Object::hashCode)));
            }
            case OrderType.PSEUDO_LOCKSTEP -> new BetterLockstepOrder(this::normalizePredicate);
            case OrderType.RANDOM -> new RandomDfsOrder(l, false);
            case OrderType.POSITIONAL_RANDOM -> new RandomDfsOrder(l, true, this::normalizePredicate);
            case OrderType.LOOP_LOCKSTEP -> {
                LoopLockstepOrder var8_6 = new LoopLockstepOrder(iIcfg, this.mStateSplitter == null ? null : this.mStateSplitter::getOriginal);
                this.mStateSplitter = StateSplitter.extend(this.mStateSplitter, iPredicate -> ((LoopLockstepOrder.PredicateWithLastThread)((Object)iPredicate)).getUnderlying(), iPredicate -> ((LoopLockstepOrder.PredicateWithLastThread)((Object)iPredicate)).getLastThread());
                yield var8_6;
            }
            default -> throw new MatchException(null, null);
        };
    }

    private final IPersistentSetChoice<L, IPredicate> createPersistentSets(IIcfg<?> iIcfg, Collection<? extends IcfgLocation> collection) {
        if (!this.mMode.hasPersistentSets()) {
            return null;
        }
        if (this.mIndependenceRelations.size() > 1) {
            List list = this.mIndependenceRelations.stream().map(iIndependenceRelation -> this.createPersistentSets(iIcfg, collection, (IIndependenceRelation<IPredicate, L>)iIndependenceRelation)).collect(Collectors.toList());
            return new MultiPersistentSetChoice(list, this.mSleepMapFactory);
        }
        IIndependenceRelation iIndependenceRelation2 = ((IndependenceBuilder)IndependenceBuilder.fromIndependence(this.mIndependenceRelations.get(0)).ensureUnconditional()).build();
        return this.createPersistentSets(iIcfg, collection, iIndependenceRelation2);
    }

    private IPersistentSetChoice<L, IPredicate> createPersistentSets(IIcfg<?> iIcfg, Collection<? extends IcfgLocation> collection, IIndependenceRelation<IPredicate, L> iIndependenceRelation) {
        IDfsOrder<L, IPredicate> iDfsOrder = this.mMode.hasFixedOrder() ? this.mDfsOrder : null;
        return new CachedPersistentSetChoice(new ThreadBasedPersistentSets(this.mServices, iIcfg, iIndependenceRelation, iDfsOrder, collection), this::normalizePredicate);
    }

    private Object normalizePredicate(IPredicate iPredicate) {
        if (this.mMode.hasFixedOrder() && this.mDfsOrder instanceof LoopLockstepOrder) {
            return new Pair((Object)((IMLPredicate)iPredicate).getProgramPoints(), (Object)this.mDfsOrder.getOrder((Object)iPredicate));
        }
        return ((IMLPredicate)iPredicate).getProgramPoints();
    }

    public IPersistentSetChoice<L, IPredicate> getPersistentSets() {
        return this.mPersistent;
    }

    public IDfsOrder<L, IPredicate> getDfsOrder() {
        return this.mDfsOrder;
    }

    public void apply(INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IDfsVisitor<L, IPredicate> iDfsVisitor) throws AutomataOperationCanceledException {
        if (this.mSleepMapFactory instanceof SleepMapStateFactory) {
            ((SleepMapStateFactory)this.mSleepMapFactory).reset();
        }
        ITraversal<L, IPredicate> iTraversal = this.buildReducedTraversal(this.mMode, new BasicTraversal(this.mAutomataServices));
        IDfsOrder<L, IPredicate> iDfsOrder = this.mDfsOrder;
        if (iDfsOrder instanceof LoopLockstepOrder) {
            LoopLockstepOrder loopLockstepOrder = (LoopLockstepOrder)iDfsOrder;
            iTraversal = new StatefulOrderTraversal(loopLockstepOrder, iTraversal);
        }
        iTraversal.traverse(iNwaOutgoingLetterAndTransitionProvider, this.mDfsOrder, iDfsVisitor);
    }

    private ITraversal<L, IPredicate> buildReducedTraversal(PartialOrderMode partialOrderMode, ITraversal<L, IPredicate> persistentSetTraversal) {
        return switch (partialOrderMode) {
            case PartialOrderMode.NONE -> persistentSetTraversal;
            case PartialOrderMode.SLEEP_NEW_STATES -> this.buildSleepTraversal(persistentSetTraversal);
            case PartialOrderMode.PERSISTENT_SETS -> new PersistentSetTraversal<L, IPredicate>(this.mPersistent, persistentSetTraversal);
            case PartialOrderMode.PERSISTENT_SLEEP_NEW_STATES, PartialOrderMode.PERSISTENT_SLEEP_NEW_STATES_FIXEDORDER -> this.buildSleepTraversal(new PersistentSetTraversal<L, IPredicate>(this.mPersistent, persistentSetTraversal));
            default -> throw new MatchException(null, null);
        };
    }

    private ITraversal<L, IPredicate> buildSleepTraversal(ITraversal<L, IPredicate> iTraversal) {
        if (this.mIndependenceRelations.size() > 1) {
            return new SleepMapTraversal(this.mIndependenceRelations, this.mSleepMapFactory, this.mGetBudget, iTraversal);
        }
        assert (!this.mIndependenceRelations.isEmpty()) : "Sleep sets require an independence relation";
        IIndependenceRelation<IPredicate, L> iIndependenceRelation = this.mIndependenceRelations.get(0);
        return new SleepSetTraversal<L, IPredicate>(iIndependenceRelation, this.mSleepFactory, iTraversal);
    }

    public NestedWordAutomaton<L, IPredicate> constructReduction(INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory) throws AutomataOperationCanceledException {
        AutomatonConstructingVisitor automatonConstructingVisitor = this.mStateSplitter != null ? new AutomatonConstructingVisitor(iPredicate -> iNwaOutgoingLetterAndTransitionProvider.isInitial((Object)this.mStateSplitter.getOriginal((IPredicate)iPredicate)), iPredicate -> iNwaOutgoingLetterAndTransitionProvider.isFinal((Object)this.mStateSplitter.getOriginal((IPredicate)iPredicate)), iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet(), this.mAutomataServices, iEmptyStackStateFactory) : new AutomatonConstructingVisitor(iNwaOutgoingLetterAndTransitionProvider, this.mAutomataServices, iEmptyStackStateFactory);
        this.apply(iNwaOutgoingLetterAndTransitionProvider, (IDfsVisitor<L, IPredicate>)automatonConstructingVisitor);
        return automatonConstructingVisitor.getReductionAutomaton();
    }

    public NestedWordAutomaton<L, IPredicate> constructReduction(INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, Predicate<IPredicate> predicate) throws AutomataOperationCanceledException {
        IDfsVisitor<L, IPredicate> iDfsVisitor = this.createBuildVisitor(iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet(), predicate);
        this.apply(iNwaOutgoingLetterAndTransitionProvider, iDfsVisitor);
        AutomatonConstructingVisitor automatonConstructingVisitor = iDfsVisitor instanceof WrapperVisitor ? (AutomatonConstructingVisitor)((WrapperVisitor)iDfsVisitor).getBaseVisitor() : (AutomatonConstructingVisitor)iDfsVisitor;
        return automatonConstructingVisitor.getReductionAutomaton();
    }

    private IDfsVisitor<L, IPredicate> createBuildVisitor(VpAlphabet<L> vpAlphabet, Predicate<IPredicate> predicate) {
        WrapperVisitor wrapperVisitor = new WrapperVisitor(iPredicate -> false, predicate, vpAlphabet, new AutomataLibraryServices(this.mServices), this.mSleepFactory);
        if (this.getDfsOrder() instanceof BetterLockstepOrder) {
            wrapperVisitor = ((BetterLockstepOrder)this.getDfsOrder()).wrapVisitor(wrapperVisitor);
        }
        return new DeadEndOptimizingSearchVisitor(wrapperVisitor, this.mDeadEndStore, true);
    }

    public IStatisticsDataProvider getStatistics() {
        for (IIndependenceRelation<IPredicate, L> iIndependenceRelation : this.mIndependenceRelations) {
            this.mStatistics.reportIndependenceStatistics(iIndependenceRelation);
        }
        if (this.mPersistent != null) {
            this.mStatistics.reportPersistentSetStatistics(this.mPersistent);
        }
        return this.mStatistics;
    }

    public StateSplitter<IPredicate> getStateSplitter() {
        return this.mStateSplitter;
    }

    private record BasicTraversal<L, S>(AutomataLibraryServices automataServices) implements ITraversal<L, S>
    {
        @Override
        public void traverse(INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, IDfsOrder<L, S> iDfsOrder, IDfsVisitor<L, S> iDfsVisitor) throws AutomataOperationCanceledException {
            DepthFirstTraversal.traverse((AutomataLibraryServices)this.automataServices, iNwaOutgoingLetterAndTransitionProvider, iDfsOrder, iDfsVisitor);
        }
    }

    private static interface ITraversal<L, S> {
        public void traverse(INwaOutgoingLetterAndTransitionProvider<L, S> var1, IDfsOrder<L, S> var2, IDfsVisitor<L, S> var3) throws AutomataOperationCanceledException;
    }

    public static enum OrderType {
        BY_SERIAL_NUMBER,
        PSEUDO_LOCKSTEP,
        RANDOM,
        POSITIONAL_RANDOM,
        LOOP_LOCKSTEP;

    }

    private record PersistentSetTraversal<L, S>(IPersistentSetChoice<L, S> persistent, ITraversal<L, S> underlying) implements ITraversal<L, S>
    {
        @Override
        public void traverse(INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, IDfsOrder<L, S> iDfsOrder, IDfsVisitor<L, S> iDfsVisitor) throws AutomataOperationCanceledException {
            IDfsOrder iDfsOrder2 = PersistentSetReduction.ensureCompatibility(this.persistent, iDfsOrder);
            PersistentSetReduction persistentSetReduction = new PersistentSetReduction(iNwaOutgoingLetterAndTransitionProvider, this.persistent);
            this.underlying.traverse((INwaOutgoingLetterAndTransitionProvider<L, S>)persistentSetReduction, (IDfsOrder<L, S>)iDfsOrder2, iDfsVisitor);
        }
    }

    private record SleepMapTraversal<L, S>(List<IIndependenceRelation<S, L>> independenceRelations, ISleepMapStateFactory<L, S, S> sleepMapFactory, Function<SleepMapReduction<L, S, S>, SleepMapReduction.IBudgetFunction<L, S>> getBudget, ITraversal<L, S> underlying) implements ITraversal<L, S>
    {
        public SleepMapTraversal {
            assert (list.size() > 1) : "Sleep maps require multiple independence relations";
        }

        @Override
        public void traverse(INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, IDfsOrder<L, S> iDfsOrder, IDfsVisitor<L, S> iDfsVisitor) throws AutomataOperationCanceledException {
            SleepMapReduction sleepMapReduction = new SleepMapReduction(iNwaOutgoingLetterAndTransitionProvider, this.independenceRelations, iDfsOrder, this.sleepMapFactory, this.getBudget.andThen(CachedBudget::new));
            this.underlying.traverse((INwaOutgoingLetterAndTransitionProvider<L, S>)sleepMapReduction, iDfsOrder, iDfsVisitor);
        }
    }

    private record SleepSetTraversal<L, S>(IIndependenceRelation<S, L> independence, ISleepSetStateFactory<L, S, S> sleepFactory, ITraversal<L, S> underlying) implements ITraversal<L, S>
    {
        @Override
        public void traverse(INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, IDfsOrder<L, S> iDfsOrder, IDfsVisitor<L, S> iDfsVisitor) throws AutomataOperationCanceledException {
            MinimalSleepSetReduction minimalSleepSetReduction = new MinimalSleepSetReduction(iNwaOutgoingLetterAndTransitionProvider, this.sleepFactory, this.independence, iDfsOrder);
            this.underlying.traverse((INwaOutgoingLetterAndTransitionProvider<L, S>)minimalSleepSetReduction, iDfsOrder, iDfsVisitor);
        }
    }

    public static class StateSplitter<S> {
        private final Function<S, S> mGetOriginal;
        private final Function<S, Object> mGetExtraInfo;

        public StateSplitter(Function<S, S> function, Function<S, Object> function2) {
            this.mGetOriginal = Objects.requireNonNull(function);
            this.mGetExtraInfo = Objects.requireNonNull(function2);
        }

        public S getOriginal(S s) {
            return this.mGetOriginal.apply(s);
        }

        public Object getExtraInfo(S s) {
            return this.mGetExtraInfo.apply(s);
        }

        static <T> StateSplitter<T> extend(StateSplitter<T> stateSplitter, Function<T, T> function, Function<T, Object> function2) {
            assert (function != null);
            assert (function2 != null);
            if (stateSplitter == null) {
                return new StateSplitter<T>(function, function2);
            }
            return new StateSplitter(stateSplitter.mGetOriginal.andThen(function), StateSplitter.addExtraInfo(stateSplitter.mGetOriginal, stateSplitter.mGetExtraInfo, function2));
        }

        private static <T> Function<T, Object> addExtraInfo(Function<T, T> function, Function<T, Object> function2, Function<T, Object> function3) {
            return object -> new Pair(function2.apply(object), function3.apply(function.apply(object)));
        }
    }

    private record StatefulOrderTraversal<L extends IIcfgTransition<?>>(LoopLockstepOrder<L> lockstep, ITraversal<L, IPredicate> underlying) implements ITraversal<L, IPredicate>
    {
        @Override
        public void traverse(INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IDfsOrder<L, IPredicate> iDfsOrder, IDfsVisitor<L, IPredicate> iDfsVisitor) throws AutomataOperationCanceledException {
            this.underlying.traverse(this.lockstep.wrapAutomaton(iNwaOutgoingLetterAndTransitionProvider), iDfsOrder, iDfsVisitor);
        }
    }

    private static final class Statistics
    extends AbstractStatisticsDataProvider {
        private int mIndependenceStatisticsCounter;
        private int mPersistentSetStatisticsCounter;

        private Statistics() {
        }

        private void reportIndependenceStatistics(IIndependenceRelation<?, ?> iIndependenceRelation) {
            StatisticsData statisticsData = new StatisticsData();
            statisticsData.aggregateBenchmarkData(iIndependenceRelation.getStatistics());
            ++this.mIndependenceStatisticsCounter;
            this.include("Independence relation #" + this.mIndependenceStatisticsCounter + " benchmarks", () -> statisticsData);
        }

        private void reportPersistentSetStatistics(IPersistentSetChoice<?, ?> iPersistentSetChoice) {
            StatisticsData statisticsData = new StatisticsData();
            statisticsData.aggregateBenchmarkData(iPersistentSetChoice.getStatistics());
            ++this.mPersistentSetStatisticsCounter;
            this.include("Persistent sets #" + this.mPersistentSetStatisticsCounter + " benchmarks", () -> statisticsData);
        }
    }
}

