/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.AbstractResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class NonTerminationArgumentResult<P extends IElement, E>
extends AbstractResultAtElement<P> {
    private final Class<E> mExprClazz;
    private final IBacktranslationService mTranslatorSequence;

    public NonTerminationArgumentResult(P p, String string, IBacktranslationService iBacktranslationService, Class<E> clazz) {
        super(p, string);
        this.mExprClazz = clazz;
        this.mTranslatorSequence = iBacktranslationService;
    }

    public String getShortDescription() {
        return "Nontermination argument in form of an infinite program execution.";
    }

    protected String printState(Map<E, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        boolean bl = true;
        for (Map.Entry<E, String> entry : map.entrySet()) {
            String string = this.mTranslatorSequence.translateExpressionToString(entry.getKey(), this.mExprClazz);
            if (string == null || string.contains("UnsupportedOperation")) continue;
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected String printState2(Map<E, E> map) {
        IProgramExecution.ProgramState programState = new IProgramExecution.ProgramState(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Set.of(entry.getValue()))), this.mExprClazz);
        return "{" + this.mTranslatorSequence.translateProgramStateToString(programState) + "}";
    }
}

