/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;

public class AffineSubtermNormalizer
extends TermTransformer {
    private final Script mScript;

    public AffineSubtermNormalizer(Script script) {
        this.mScript = script;
    }

    private static boolean isBinaryNumericRelation(Term term) {
        BinaryNumericRelation binaryNumericRelation = BinaryNumericRelation.convert(term);
        return binaryNumericRelation == null;
    }

    protected void convert(Term term) {
        if (!SmtSortUtils.isBoolSort(term.getSort())) {
            super.setResult(term);
            return;
        }
        if (AffineSubtermNormalizer.isBinaryNumericRelation(term)) {
            PolynomialRelation polynomialRelation = PolynomialRelation.of(this.mScript, term);
            if (polynomialRelation == null) {
                this.setResult(term);
                return;
            }
            Term term2 = polynomialRelation.toTerm(this.mScript);
            this.setResult(term2);
            return;
        }
        super.convert(term);
    }
}

