/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.armc;

import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.PEATestAutomaton;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RelationDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.PEA2TCSConverter;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.TCSWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ARMCWriter
extends TCSWriter {
    protected String primedVarList;
    protected String varList;
    protected boolean rename;
    protected Map<String, String> renameMap;
    protected int transCounter = 0;
    protected FileWriter writer;
    private Writer primedWriter;
    private Writer unPrimedWriter;
    private boolean firstPrimedConstraint;
    private boolean firstUnPrimedConstraint;

    public ARMCWriter(String string) {
        super(string);
    }

    public ARMCWriter(String string, boolean bl) {
        this(string);
        this.rename = bl;
    }

    protected void init() {
        this.renameMap = new HashMap<String, String>();
    }

    @Override
    public void write() {
        try {
            this.writer = new FileWriter(this.mFileName);
            this.init();
            this.writePreamble();
            this.writeInitialTransitions();
            this.writeTransitions();
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void writePreamble() throws IOException {
        Object object;
        this.writer.write("% Preamble:\n\n:- multifile r/5,implicit_updates/0,var2names/2,preds/2,cube_size/1,start/1,error/1,refinement/1.\nrefinement(inter).\ncube_size(1).\nstart(pc(init)).\nerror(pc(error)).\n\n\n");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Object object2 = this.mConverter.getVariables().keySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            stringBuilder.append("_" + (String)object);
            stringBuilder2.append("_" + (String)object + "P");
            if (!object2.hasNext()) continue;
            stringBuilder.append(", ");
            stringBuilder2.append(", ");
        }
        this.varList = stringBuilder.toString();
        this.primedVarList = stringBuilder2.toString();
        this.writer.write("preds(p(_, data(");
        this.writer.write(this.varList);
        this.writer.write(")), []).\n\n");
        this.writer.write("var2names(p(_, data(" + this.varList + ")),\n   [");
        object2 = this.mConverter.getVariables().keySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            this.writer.write("(_" + (String)object + ", '" + (String)object + "')");
            if (!object2.hasNext()) continue;
            this.writer.write(",\n    ");
        }
        this.writer.write("]).\n\n\n\n");
        object2 = this.mConverter.getPEA().getPhases();
        object = new HashSet<Phase>(Arrays.asList(((PEATestAutomaton)this.mConverter.getPEA()).getFinalPhases()));
        if (this.rename) {
            int n = object2.size();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Phase phase = (Phase)iterator.next();
                if (!object.contains(phase)) {
                    this.renameMap.put(phase.getName(), "state" + n);
                } else {
                    this.renameMap.put(phase.getName(), "error");
                }
                --n;
            }
        } else {
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Phase phase = (Phase)iterator.next();
                if (!object.contains(phase)) {
                    this.renameMap.put(phase.getName(), "p" + phase.getName());
                    continue;
                }
                this.renameMap.put(phase.getName(), "error");
            }
        }
    }

    protected void writeInitialTransitions() throws IOException {
        PEA2TCSConverter.TransitionConstraint transitionConstraint = this.mConverter.getNextInitConstraint();
        while (transitionConstraint != null) {
            this.writeTransitionPrefix("init", this.renameMap.get(transitionConstraint.getInitLoc()));
            this.writeConstraintSorted(transitionConstraint.getConstraint().prime(Collections.emptySet()));
            this.writeTransitionSuffix();
            transitionConstraint = this.mConverter.getNextInitConstraint();
        }
    }

    protected void writeTransitions() throws IOException {
        PEA2TCSConverter.TransitionConstraint transitionConstraint = this.mConverter.getNextTransitionConstraint();
        while (transitionConstraint != null) {
            if (transitionConstraint.getConstraint() == CDD.FALSE) {
                transitionConstraint = this.mConverter.getNextTransitionConstraint();
                continue;
            }
            this.writeTransitionPrefix(this.renameMap.get(transitionConstraint.getSource()), this.renameMap.get(transitionConstraint.getDest()));
            this.writeConstraintSorted(transitionConstraint.getConstraint());
            this.writeTransitionSuffix();
            transitionConstraint = this.mConverter.getNextTransitionConstraint();
        }
    }

    protected void writeConstraintSorted(CDD cDD) throws IOException {
        this.primedWriter = new StringWriter();
        this.unPrimedWriter = new StringWriter();
        this.firstPrimedConstraint = true;
        this.firstUnPrimedConstraint = true;
        this.writeConjunction(cDD, null);
        this.primedWriter.close();
        this.unPrimedWriter.close();
        this.writer.write("[");
        this.writer.write(this.unPrimedWriter.toString());
        this.writer.write("],[");
        this.writer.write(this.primedWriter.toString());
        this.writer.write("]");
    }

    protected void writeDecisionSorted(Decision decision, int n) throws IOException {
        if (decision instanceof BooleanDecision && ((BooleanDecision)decision).getVar().contains("'") || decision instanceof RangeDecision && ((RangeDecision)decision).getVar().contains("'")) {
            if (this.firstPrimedConstraint) {
                this.firstPrimedConstraint = false;
            } else {
                this.primedWriter.write(", ");
            }
            this.writeDecision(decision, n, this.primedWriter);
        } else {
            if (this.firstUnPrimedConstraint) {
                this.firstUnPrimedConstraint = false;
            } else {
                this.unPrimedWriter.write(", ");
            }
            this.writeDecision(decision, n, this.unPrimedWriter);
        }
    }

    protected void writeTransitionPrefix(String string, String string2) throws IOException {
        this.writer.write("r(p(pc(" + string + "),data(" + this.varList + ")),");
        this.writer.write("p(pc(" + string2 + "),data(" + this.primedVarList + ")), ");
    }

    protected void writeTransitionSuffix() throws IOException {
        this.writer.write("," + this.transCounter++ + ").\n");
    }

    @Override
    protected void writeAndDelimiter(Writer writer) throws IOException {
        assert (writer == null);
    }

    protected void writeDecision(Decision decision, int n, Writer writer) throws IOException {
        if (writer == null) {
            this.writeDecisionSorted(decision, n);
            return;
        }
        if (decision instanceof RangeDecision) {
            String string = ((RangeDecision)decision).getVar().replace("'", "P");
            writer.append("_" + string);
            int[] nArray = ((RangeDecision)decision).getLimits();
            if (n == 0) {
                if ((nArray[0] & 1) == 0) {
                    writer.append(" < ");
                } else {
                    writer.append(" =< ");
                }
                writer.append(Integer.toString(nArray[0] / 2));
                return;
            }
            if (n == nArray.length) {
                if ((nArray[nArray.length - 1] & 1) == 1) {
                    writer.append(" > ");
                } else {
                    writer.append(" >= ");
                }
                writer.append(Integer.toString(nArray[nArray.length - 1] / 2));
                return;
            }
            if (nArray[n - 1] / 2 == nArray[n] / 2) {
                writer.append(" > ");
                writer.append(Integer.toString(nArray[n] / 2));
                return;
            }
            if ((nArray[n - 1] & 1) == 1) {
                writer.append(" > ");
            } else {
                writer.append(" >= ");
            }
            writer.append(Integer.toString(nArray[n - 1] / 2));
            writer.append(", ").append("_" + string);
            if ((nArray[n] & 1) == 0) {
                writer.append(" < ");
            } else {
                writer.append(" =< ");
            }
            writer.append(Integer.toString(nArray[n] / 2));
            return;
        }
        if (n == 0) {
            if (decision instanceof RelationDecision) {
                String string = ((BooleanDecision)decision).getVar().replace(RelationDecision.Operator.LEQ.toString(), "=<");
                string = string.replace(RelationDecision.Operator.PRIME.toString(), "P");
                string = string.replaceAll("([a-zA-Z])(\\w*)", "_$1$2");
                writer.append(string);
            } else if (decision instanceof BooleanDecision) {
                String string = ((BooleanDecision)decision).getVar().replace("'", "P");
                string = string.replaceAll("([a-zA-Z])(\\w*)", "_$1$2");
                writer.append(string);
            } else if (decision instanceof EventDecision) {
                String string = ((EventDecision)decision).getEvent();
                writer.append(string + " > " + string + "'");
            }
        } else if (decision instanceof RelationDecision) {
            String string = ((RelationDecision)decision).toString(n);
            string = string.replaceAll("([a-zA-Z])(\\w*)", "_$1$2");
            if ((string = string.replace(RelationDecision.Operator.PRIME.toString(), "P")).contains(RelationDecision.Operator.NEQ.toString())) {
                throw new RuntimeException("ARMC export: negated expressions not supported: " + string);
            }
            writer.append(string);
        } else if (decision instanceof BooleanDecision) {
            String string = ((BooleanDecision)decision).toString(n);
            string = string.replaceAll("([a-zA-Z])(\\w*)", "_$1$2");
            string = string.replace("'", "P");
            writer.append(string);
        } else if (decision instanceof EventDecision) {
            String string = ((EventDecision)decision).getEvent();
            writer.append(string + " = " + string + "'");
        }
    }

    public static class ARMCString {
        public static final String ARMC_PRIME = "P";
        public static final String ARMC_US = "_";
        public static final String ERROR_LOC = "error";
        public static final String INIT_LOC = "init";
        public static final String LOC_PREFIX = "p";
        public static final String STATE_NAME = "state";
        public static final String PRIME = "'";
        public static final String LESS = "<";
        public static final String GREATER = ">";
        public static final String LEQ = "=<";
        public static final String GEQ = ">=";
        public static final String EQUALS = "=";
        public static final String NEQ = "!=";
        public static final String PLUS = "+";
        public static final String MINUS = "-";
        public static final String MULT = "*";
        public static final String DIV = "/";
    }
}

