/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Trigger;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.LocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class MappedTerm2Expression
implements Serializable {
    private static final long serialVersionUID = -3407883192314998843L;
    private final Script mScript;
    private final ScopedHashMap<TermVariable, VarList> mQuantifiedVariables;
    private int mFreshIdentiferCounter;
    private final TypeSortTranslator mTypeSortTranslator;
    private final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    private final Set<IdentifierExpression> mFreeVariables;

    public MappedTerm2Expression(TypeSortTranslator typeSortTranslator, Boogie2SmtSymbolTable boogie2SmtSymbolTable, ManagedScript managedScript) {
        this.mTypeSortTranslator = typeSortTranslator;
        this.mBoogie2SmtSymbolTable = boogie2SmtSymbolTable;
        this.mScript = managedScript.getScript();
        this.mFreeVariables = new HashSet<IdentifierExpression>();
        this.mFreshIdentiferCounter = 0;
        this.mQuantifiedVariables = new ScopedHashMap();
    }

    private String getFreshIdenfier() {
        ++this.mFreshIdentiferCounter;
        return "freshIdentifier" + this.mFreshIdentiferCounter;
    }

    public Expression translate(Term term, Set<TermVariable> set, Map<TermVariable, String> map) {
        Expression expression;
        if (term instanceof AnnotatedTerm) {
            expression = MappedTerm2Expression.translate((AnnotatedTerm)term, set, map);
        } else {
            if (term instanceof ApplicationTerm) {
                return this.translate((ApplicationTerm)term, set, map);
            }
            if (term instanceof ConstantTerm) {
                expression = this.translate((ConstantTerm)term, set, map);
            } else if (term instanceof LetTerm) {
                expression = MappedTerm2Expression.translate((LetTerm)term, set, map);
            } else if (term instanceof QuantifiedFormula) {
                expression = this.translate((QuantifiedFormula)term, set, map);
            } else if (term instanceof TermVariable) {
                expression = this.translate((TermVariable)term, set, map);
            } else {
                throw new UnsupportedOperationException("unknown kind of Term");
            }
        }
        assert (expression != null);
        return expression;
    }

    private static Expression translate(AnnotatedTerm annotatedTerm, Set<TermVariable> set, Map<TermVariable, String> map) {
        throw new UnsupportedOperationException("annotations not supported yet" + String.valueOf(annotatedTerm));
    }

    private Expression translate(ApplicationTerm applicationTerm, Set<TermVariable> set, Map<TermVariable, String> map) {
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        if (functionSymbol.isIntern() && "select".equals(functionSymbol.getName())) {
            return this.translateSelect(applicationTerm, set, map);
        }
        if (functionSymbol.isIntern() && "store".equals(functionSymbol.getName())) {
            return this.translateStore(applicationTerm, set, map);
        }
        if (BitvectorUtils.isBitvectorConstant((FunctionSymbol)functionSymbol)) {
            return this.translateBitvectorConstant(applicationTerm);
        }
        Term[] termArray = applicationTerm.getParameters();
        Expression[] expressionArray = new Expression[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            expressionArray[n] = this.translate(termArray[n], set, map);
            ++n;
        }
        IBoogieType iBoogieType = this.mTypeSortTranslator.getType(functionSymbol.getReturnSort());
        Expression expression = this.translateWithSymbolTable(functionSymbol, iBoogieType, termArray, set, map);
        if (expression != null) {
            return expression;
        }
        if (functionSymbol.getParameterSorts().length == 0) {
            if (SmtUtils.isTrueLiteral((Term)applicationTerm)) {
                IBoogieType iBoogieType2 = this.mTypeSortTranslator.getType(SmtSortUtils.getBoolSort((Script)this.mScript));
                return new BooleanLiteral(null, iBoogieType2, true);
            }
            if (SmtUtils.isFalseLiteral((Term)applicationTerm)) {
                IBoogieType iBoogieType3 = this.mTypeSortTranslator.getType(SmtSortUtils.getBoolSort((Script)this.mScript));
                return new BooleanLiteral(null, iBoogieType3, false);
            }
            ProgramFunction programFunction = this.mBoogie2SmtSymbolTable.getProgramFun(applicationTerm.getFunction());
            if (programFunction instanceof ProgramConst) {
                return new IdentifierExpression(null, this.mTypeSortTranslator.getType(applicationTerm.getSort()), ((ProgramConst)programFunction).getIdentifier(), new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null));
            }
            throw new IllegalArgumentException();
        }
        if ("ite".equals(functionSymbol.getName())) {
            return new IfThenElseExpression(null, iBoogieType, expressionArray[0], expressionArray[1], expressionArray[2]);
        }
        if (functionSymbol.isIntern()) {
            if (functionSymbol.getParameterSorts().length > 0 && (SmtSortUtils.isBitvecSort((Sort)functionSymbol.getParameterSorts()[0]) || SmtSortUtils.isFloatingpointSort((Sort)functionSymbol.getReturnSort())) && !"=".equals(functionSymbol.getName()) && !"distinct".equals(functionSymbol.getName())) {
                if ("extract".equals(functionSymbol.getName())) {
                    return this.translateBitvectorAccess(iBoogieType, applicationTerm, set, map);
                }
                throw new UnsupportedOperationException("translation of " + String.valueOf(functionSymbol) + " not yet implemented, please contact Matthias");
            }
            if (functionSymbol.getParameterSorts().length == 1) {
                if ("not".equals(functionSymbol.getName())) {
                    Expression expression2 = this.translate(applicationTerm.getParameters()[0], set, map);
                    return new UnaryExpression(null, iBoogieType, UnaryExpression.Operator.LOGICNEG, expression2);
                }
                if ("-".equals(functionSymbol.getName())) {
                    Expression expression3 = this.translate(applicationTerm.getParameters()[0], set, map);
                    return new UnaryExpression(null, iBoogieType, UnaryExpression.Operator.ARITHNEGATIVE, expression3);
                }
                throw new IllegalArgumentException("unknown symbol " + String.valueOf(functionSymbol));
            }
            if ("xor".equals(functionSymbol.getName())) {
                return MappedTerm2Expression.xor(expressionArray);
            }
            if ("mod".equals(functionSymbol.getName())) {
                return MappedTerm2Expression.mod(expressionArray);
            }
            BinaryExpression.Operator operator = MappedTerm2Expression.getBinaryOperator(functionSymbol);
            if (functionSymbol.isLeftAssoc()) {
                return MappedTerm2Expression.leftAssoc(operator, iBoogieType, expressionArray);
            }
            if (functionSymbol.isRightAssoc()) {
                return MappedTerm2Expression.rightAssoc(operator, iBoogieType, expressionArray);
            }
            if (functionSymbol.isChainable()) {
                return MappedTerm2Expression.chainable(operator, iBoogieType, expressionArray);
            }
            if (functionSymbol.isPairwise()) {
                return MappedTerm2Expression.pairwise(operator, iBoogieType, expressionArray);
            }
            throw new UnsupportedOperationException("don't know symbol which is neither leftAssoc, rightAssoc, chainable, or pairwise.");
        }
        throw new UnsupportedOperationException("translation of " + String.valueOf(functionSymbol) + " not yet implemented, please contact Matthias");
    }

    private Expression translateBitvectorAccess(IBoogieType iBoogieType, ApplicationTerm applicationTerm, Set<TermVariable> set, Map<TermVariable, String> map) {
        assert ("extract".equals(applicationTerm.getFunction().getName())) : "no extract";
        assert (applicationTerm.getParameters().length == 1);
        assert (applicationTerm.getFunction().getIndices().length == 2);
        Expression expression = this.translate(applicationTerm.getParameters()[0], set, map);
        int n = Integer.valueOf(applicationTerm.getFunction().getIndices()[1]);
        int n2 = Integer.valueOf(applicationTerm.getFunction().getIndices()[0]);
        return new BitVectorAccessExpression(null, iBoogieType, expression, n2, n);
    }

    private Expression translateWithSymbolTable(FunctionSymbol functionSymbol, IBoogieType iBoogieType, Term[] termArray, Set<TermVariable> set, Map<TermVariable, String> map) {
        String string = this.mBoogie2SmtSymbolTable.translateToBoogieFunction(functionSymbol.getName(), iBoogieType);
        if (string == null) {
            return null;
        }
        Expression[] expressionArray = new Expression[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            expressionArray[n] = this.translate(termArray[n], set, map);
            ++n;
        }
        return new FunctionApplication(null, iBoogieType, string, expressionArray);
    }

    private Expression translateBitvectorConstant(ApplicationTerm applicationTerm) {
        assert (applicationTerm.getSort().getIndices().length == 1);
        String string = applicationTerm.getFunction().getName();
        assert (string.startsWith("bv"));
        String string2 = string.substring(2);
        IBoogieType iBoogieType = this.mTypeSortTranslator.getType(applicationTerm.getSort());
        String string3 = applicationTerm.getSort().getIndices()[0];
        return new BitvecLiteral(null, iBoogieType, string2, Integer.valueOf(string3).intValue());
    }

    private static Expression mod(Expression[] expressionArray) {
        if (expressionArray.length != 2) {
            throw new AssertionError((Object)"mod has two parameters");
        }
        return new BinaryExpression(null, (IBoogieType)BoogieType.TYPE_INT, BinaryExpression.Operator.ARITHMOD, expressionArray[0], expressionArray[1]);
    }

    private ArrayStoreExpression translateStore(ApplicationTerm applicationTerm, Set<TermVariable> set, Map<TermVariable, String> map) {
        Expression expression = this.translate(applicationTerm.getParameters()[0], set, map);
        Expression expression2 = this.translate(applicationTerm.getParameters()[1], set, map);
        Expression[] expressionArray = new Expression[]{expression2};
        Expression expression3 = this.translate(applicationTerm.getParameters()[2], set, map);
        IBoogieType iBoogieType = this.mTypeSortTranslator.getType(applicationTerm.getSort());
        return new ArrayStoreExpression(null, iBoogieType, expression, expressionArray, expression3);
    }

    private ArrayAccessExpression translateSelect(ApplicationTerm applicationTerm, Set<TermVariable> set, Map<TermVariable, String> map) {
        Expression expression = this.translate(applicationTerm.getParameters()[0], set, map);
        Expression expression2 = this.translate(applicationTerm.getParameters()[1], set, map);
        Expression[] expressionArray = new Expression[]{expression2};
        IBoogieType iBoogieType = this.mTypeSortTranslator.getType(applicationTerm.getSort());
        return new ArrayAccessExpression(null, iBoogieType, expression, expressionArray);
    }

    private ArrayAccessExpression translateArray(ApplicationTerm applicationTerm, Set<TermVariable> set, Map<TermVariable, String> map) {
        Expression expression;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ApplicationTerm applicationTerm2 = applicationTerm;
        while ("select".equals(applicationTerm2.getFunction().getName()) && applicationTerm2.getParameters()[0] instanceof ApplicationTerm) {
            assert (applicationTerm2.getParameters().length == 2);
            expression = this.translate(applicationTerm2.getParameters()[1], set, map);
            arrayList.add(expression);
            applicationTerm2 = (ApplicationTerm)applicationTerm2.getParameters()[0];
        }
        assert (applicationTerm2.getParameters().length == 2);
        expression = this.translate(applicationTerm2.getParameters()[1], set, map);
        arrayList.add(expression);
        Expression expression2 = this.translate(applicationTerm2.getParameters()[0], set, map);
        Expression[] expressionArray = new Expression[arrayList.size()];
        int n = 0;
        while (n < expressionArray.length) {
            expressionArray[n] = (Expression)arrayList.get(expressionArray.length - 1 - n);
            ++n;
        }
        IBoogieType iBoogieType = this.mTypeSortTranslator.getType(applicationTerm2.getSort());
        return new ArrayAccessExpression(null, iBoogieType, expression2, expressionArray);
    }

    private Expression translate(ConstantTerm constantTerm, Set<TermVariable> set, Map<TermVariable, String> map) {
        Object object = constantTerm.getValue();
        IBoogieType iBoogieType = this.mTypeSortTranslator.getType(constantTerm.getSort());
        if (SmtSortUtils.isBitvecSort((Sort)constantTerm.getSort())) {
            BigInteger bigInteger;
            String[] stringArray = constantTerm.getSort().getIndices();
            if (stringArray.length != 1) {
                throw new AssertionError((Object)"BitVec has exactly one index");
            }
            if (object.toString().startsWith("#x")) {
                bigInteger = new BigInteger(object.toString().substring(2), 16);
            } else if (object.toString().startsWith("#b")) {
                bigInteger = new BigInteger(object.toString().substring(2), 2);
            } else {
                throw new UnsupportedOperationException("only hexadecimal values and boolean values supported yet");
            }
            int n = Integer.valueOf(stringArray[0]);
            return new BitvecLiteral(null, iBoogieType, String.valueOf(bigInteger), n);
        }
        if (object instanceof String) {
            return new StringLiteral(null, iBoogieType, object.toString());
        }
        if (object instanceof BigInteger) {
            return new IntegerLiteral(null, iBoogieType, object.toString());
        }
        if (object instanceof BigDecimal) {
            return new RealLiteral(null, iBoogieType, object.toString());
        }
        if (object instanceof Rational) {
            if (SmtSortUtils.isIntSort((Sort)constantTerm.getSort())) {
                return new IntegerLiteral(null, iBoogieType, object.toString());
            }
            if (SmtSortUtils.isRealSort((Sort)constantTerm.getSort())) {
                return new RealLiteral(null, iBoogieType, object.toString());
            }
            throw new UnsupportedOperationException("unknown Sort");
        }
        throw new UnsupportedOperationException("unknown kind of Term");
    }

    private static Expression translate(LetTerm letTerm, Set<TermVariable> set, Map<TermVariable, String> map) {
        throw new IllegalArgumentException("unlet Term first");
    }

    private Expression translate(QuantifiedFormula quantifiedFormula, Set<TermVariable> set, Map<TermVariable, String> map) {
        Object object;
        PrimitiveType primitiveType;
        Expression expression;
        IBoogieType iBoogieType;
        TermVariable termVariable;
        this.mQuantifiedVariables.beginScope();
        VarList[] varListArray = new VarList[quantifiedFormula.getVariables().length];
        int n = 0;
        TermVariable[] termVariableArray = quantifiedFormula.getVariables();
        int n2 = termVariableArray.length;
        int n3 = 0;
        while (n3 < n2) {
            termVariable = termVariableArray[n3];
            iBoogieType = this.mTypeSortTranslator.getType(termVariable.getSort());
            expression = new Expression[]{termVariable.getName()};
            primitiveType = new PrimitiveType(null, iBoogieType, iBoogieType.toString());
            varListArray[n] = object = new VarList(null, (String[])expression, (ASTType)primitiveType);
            this.mQuantifiedVariables.put((Object)termVariable, object);
            ++n;
            ++n3;
        }
        termVariable = this.mTypeSortTranslator.getType(quantifiedFormula.getSort());
        assert (quantifiedFormula.getQuantifier() == 1 || quantifiedFormula.getQuantifier() == 0);
        n3 = quantifiedFormula.getQuantifier() == 1 ? 1 : 0;
        String[] stringArray = new String[]{};
        iBoogieType = quantifiedFormula.getSubformula();
        if (iBoogieType instanceof AnnotatedTerm) {
            assert (":pattern".equals(((AnnotatedTerm)iBoogieType).getAnnotations()[0].getKey()));
            expression = ((AnnotatedTerm)iBoogieType).getAnnotations();
            assert (((Expression)expression).length == 1) : "expecting only one annotation at a time";
            primitiveType = expression[0];
            object = primitiveType.getValue();
            assert (object instanceof Term[]) : "expecting Term[]" + String.valueOf(object);
            iBoogieType = ((AnnotatedTerm)iBoogieType).getSubterm();
            Term[] termArray = (Term[])object;
            if (termArray.length == 0) {
                termVariableArray = new Attribute[]{};
            } else {
                Expression[] expressionArray = new Expression[termArray.length];
                int n4 = 0;
                while (n4 < termArray.length) {
                    expressionArray[n4] = this.translate(termArray[n4], set, map);
                    ++n4;
                }
                Trigger trigger = new Trigger(null, expressionArray);
                termVariableArray = new Attribute[]{trigger};
            }
        } else {
            termVariableArray = new Attribute[]{};
        }
        expression = this.translate((Term)iBoogieType, set, map);
        primitiveType = new QuantifierExpression(null, (IBoogieType)termVariable, n3 != 0, stringArray, varListArray, (Attribute[])termVariableArray, expression);
        this.mQuantifiedVariables.endScope();
        return primitiveType;
    }

    private Expression translate(TermVariable termVariable, Set<TermVariable> set, Map<TermVariable, String> map) {
        IdentifierExpression identifierExpression;
        IBoogieType iBoogieType = this.mTypeSortTranslator.getType(termVariable.getSort());
        if (map.containsKey(termVariable)) {
            identifierExpression = new IdentifierExpression(null, iBoogieType, map.get(termVariable), new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION, null));
        } else if (set.contains(termVariable)) {
            identifierExpression = new IdentifierExpression(null, iBoogieType, termVariable.getName(), new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION, null));
        } else if (this.mQuantifiedVariables.containsKey((Object)termVariable)) {
            VarList varList = (VarList)this.mQuantifiedVariables.get((Object)termVariable);
            assert (varList.getIdentifiers().length == 1);
            String string = varList.getIdentifiers()[0];
            identifierExpression = new IdentifierExpression(null, iBoogieType, this.translateIdentifier(string), new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null));
        } else if (this.mBoogie2SmtSymbolTable.getProgramVar(termVariable) == null) {
            identifierExpression = new IdentifierExpression(null, iBoogieType, this.getFreshIdenfier(), new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null));
            this.mFreeVariables.add(identifierExpression);
        } else {
            IProgramVar iProgramVar = this.mBoogie2SmtSymbolTable.getProgramVar(termVariable);
            BoogieASTNode boogieASTNode = this.mBoogie2SmtSymbolTable.getAstNode(iProgramVar);
            assert (boogieASTNode != null) : "There is no AstNode for the IProgramVar " + String.valueOf(iProgramVar);
            ILocation iLocation = boogieASTNode.getLocation();
            DeclarationInformation declarationInformation = this.mBoogie2SmtSymbolTable.getDeclarationInformation(iProgramVar);
            if (iProgramVar instanceof LocalProgramVar) {
                identifierExpression = new IdentifierExpression(iLocation, iBoogieType, this.translateIdentifier(((LocalProgramVar)iProgramVar).getIdentifier()), declarationInformation);
            } else if (iProgramVar instanceof ProgramNonOldVar) {
                identifierExpression = new IdentifierExpression(iLocation, iBoogieType, this.translateIdentifier(((ProgramNonOldVar)iProgramVar).getIdentifier()), declarationInformation);
            } else if (iProgramVar instanceof ProgramOldVar) {
                assert (iProgramVar.isGlobal());
                IdentifierExpression identifierExpression2 = new IdentifierExpression(iLocation, iBoogieType, this.translateIdentifier(((ProgramOldVar)iProgramVar).getIdentifierOfNonOldVar()), declarationInformation);
                identifierExpression = new UnaryExpression(iLocation, iBoogieType, UnaryExpression.Operator.OLD, (Expression)identifierExpression2);
            } else if (iProgramVar instanceof ProgramConst) {
                identifierExpression = new IdentifierExpression(iLocation, iBoogieType, this.translateIdentifier(((ProgramConst)((Object)iProgramVar)).getIdentifier()), declarationInformation);
            } else {
                throw new AssertionError((Object)("unsupported kind of variable " + iProgramVar.getClass().getSimpleName()));
            }
        }
        return identifierExpression;
    }

    private String translateIdentifier(String string) {
        return string.replace(" ", "_").replace("(", "_").replace(")", "_").replace("+", "PLUS").replace("-", "MINUS").replace("*", "MUL");
    }

    private static BinaryExpression.Operator getBinaryOperator(FunctionSymbol functionSymbol) {
        if ("and".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.LOGICAND;
        }
        if ("or".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.LOGICOR;
        }
        if ("=>".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.LOGICIMPLIES;
        }
        if ("=".equals(functionSymbol.getName()) && "bool".equals(functionSymbol.getParameterSort(0).getName())) {
            return BinaryExpression.Operator.LOGICIFF;
        }
        if ("=".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.COMPEQ;
        }
        if ("distinct".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.COMPNEQ;
        }
        if ("<=".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.COMPLEQ;
        }
        if (">=".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.COMPGEQ;
        }
        if ("<".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.COMPLT;
        }
        if (">".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.COMPGT;
        }
        if ("+".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.ARITHPLUS;
        }
        if ("-".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.ARITHMINUS;
        }
        if ("*".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.ARITHMUL;
        }
        if ("/".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.ARITHDIV;
        }
        if ("div".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.ARITHDIV;
        }
        if ("mod".equals(functionSymbol.getName())) {
            return BinaryExpression.Operator.ARITHMOD;
        }
        if ("ite".equals(functionSymbol.getName())) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if ("abs".equals(functionSymbol.getName())) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        throw new IllegalArgumentException("unknown symbol " + String.valueOf(functionSymbol));
    }

    private static Expression leftAssoc(BinaryExpression.Operator operator, IBoogieType iBoogieType, Expression[] expressionArray) {
        Expression expression = expressionArray[0];
        int n = 0;
        while (n < expressionArray.length - 1) {
            expression = new BinaryExpression(null, iBoogieType, operator, expression, expressionArray[n + 1]);
            ++n;
        }
        return expression;
    }

    private static Expression rightAssoc(BinaryExpression.Operator operator, IBoogieType iBoogieType, Expression[] expressionArray) {
        Expression expression = expressionArray[expressionArray.length - 1];
        int n = expressionArray.length - 1;
        while (n > 0) {
            expression = new BinaryExpression(null, iBoogieType, operator, expressionArray[n - 1], expression);
            --n;
        }
        return expression;
    }

    private static Expression chainable(BinaryExpression.Operator operator, IBoogieType iBoogieType, Expression[] expressionArray) {
        assert (iBoogieType == BoogieType.TYPE_BOOL);
        BinaryExpression binaryExpression = new BinaryExpression(null, iBoogieType, operator, expressionArray[0], expressionArray[1]);
        int n = 1;
        while (n < expressionArray.length - 1) {
            BinaryExpression binaryExpression2 = new BinaryExpression(null, iBoogieType, operator, expressionArray[n], expressionArray[n + 1]);
            binaryExpression = new BinaryExpression(null, (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.LOGICAND, (Expression)binaryExpression, (Expression)binaryExpression2);
            ++n;
        }
        return binaryExpression;
    }

    private static Expression pairwise(BinaryExpression.Operator operator, IBoogieType iBoogieType, Expression[] expressionArray) {
        assert (iBoogieType == BoogieType.TYPE_BOOL);
        BinaryExpression binaryExpression = new BinaryExpression(null, iBoogieType, operator, expressionArray[0], expressionArray[1]);
        int n = 0;
        while (n < expressionArray.length - 1) {
            int n2 = n + 1;
            while (n2 < expressionArray.length - 1) {
                if (n != 0 || n2 != 1) {
                    BinaryExpression binaryExpression2 = new BinaryExpression(null, iBoogieType, operator, expressionArray[n2], expressionArray[n2 + 1]);
                    binaryExpression = new BinaryExpression(null, (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.LOGICAND, (Expression)binaryExpression, (Expression)binaryExpression2);
                }
                ++n2;
            }
            ++n;
        }
        return binaryExpression;
    }

    private static Expression xor(Expression[] expressionArray) {
        BoogiePrimitiveType boogiePrimitiveType = BoogieType.TYPE_BOOL;
        BinaryExpression.Operator operator = BinaryExpression.Operator.LOGICIFF;
        UnaryExpression.Operator operator2 = UnaryExpression.Operator.LOGICNEG;
        Expression expression = expressionArray[0];
        int n = 0;
        while (n < expressionArray.length - 1) {
            expression = new BinaryExpression(null, (IBoogieType)boogiePrimitiveType, operator, expressionArray[n + 1], expression);
            expression = new UnaryExpression(null, (IBoogieType)boogiePrimitiveType, operator2, expression);
            ++n;
        }
        return expression;
    }
}

