/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MinimizeDfaHopcroftWiki<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private ArrayList<STATE> mInt2state;
    private HashMap<STATE, Integer> mState2int;
    private ArrayList<LETTER> mInt2letter;
    private HashMap<LETTER, Integer> mLetter2int;
    private final Partition mPartition;
    private int[] mLabels;
    private int[] mLabelTails;
    private int[] mLabelHeads;
    private int mNumberOfTransitions;
    private ArrayList<int[]> mMapStatesToTransitionTails;
    private int[] mState2representative;

    public MinimizeDfaHopcroftWiki(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        this.initializeData();
        this.mPartition = this.createInitialPartition();
        this.minimizeDfaHopcroft();
        this.constructResult();
        this.printExitMessage();
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    private Partition createInitialPartition() {
        Partition partition = new Partition();
        partition.init();
        return partition;
    }

    private void initializeData() {
        int n = this.mOperand.size();
        int n2 = this.mOperand.getVpAlphabet().getInternalAlphabet().size();
        this.initializeMappings(n, n2);
        this.initializeLables();
    }

    private void initializeMappings(int n, int n2) {
        this.mInt2state = new ArrayList(n);
        this.mState2int = new HashMap(MinimizeDfaHopcroftWiki.computeHashCap(n));
        this.mInt2letter = new ArrayList(n2);
        this.mLetter2int = new HashMap(MinimizeDfaHopcroftWiki.computeHashCap(n2));
        int n3 = -1;
        for (Object object : this.mOperand.getStates()) {
            this.mInt2state.add(object);
            this.mState2int.put(object, ++n3);
        }
        n3 = -1;
        for (Object object : this.mOperand.getVpAlphabet().getInternalAlphabet()) {
            this.mInt2letter.add(object);
            this.mLetter2int.put(object, ++n3);
        }
    }

    private void initializeLables() {
        int n = (int)Math.min(2.147483647E9, (double)this.mOperand.size() * (double)this.mOperand.size() * (double)this.mOperand.getVpAlphabet().getInternalAlphabet().size());
        this.mLabels = new int[n];
        this.mLabelTails = new int[n];
        this.mLabelHeads = new int[n];
        this.mMapStatesToTransitionTails = new ArrayList();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.mInt2state.size()) {
            STATE STATE = this.mInt2state.get(n3);
            int n4 = 0;
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
                this.mLabels[n2] = this.mLetter2int.get(outgoingInternalTransition.getLetter());
                this.mLabelTails[n2] = this.mState2int.get(STATE);
                this.mLabelHeads[n2] = this.mState2int.get(outgoingInternalTransition.getSucc());
                ++n2;
                ++n4;
            }
            int[] object2 = new int[]{n3++, n2 - n4, n4};
            this.mMapStatesToTransitionTails.add(object2);
        }
        this.mNumberOfTransitions = n2;
        this.mLabels = Arrays.copyOf(this.mLabels, this.mNumberOfTransitions);
        this.mLabelTails = Arrays.copyOf(this.mLabelTails, this.mNumberOfTransitions);
        this.mLabelHeads = Arrays.copyOf(this.mLabelHeads, this.mNumberOfTransitions);
    }

    private void minimizeDfaHopcroft() {
        Worklist worklist = this.mPartition.getWorklist();
        while (!worklist.isEmpty()) {
            int[] nArray = worklist.popFromWorklist();
            for (Object LETTER : this.mOperand.getVpAlphabet().getInternalAlphabet()) {
                int[] nArray2;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int n = this.mLetter2int.get(LETTER);
                int n2 = 0;
                while (n2 < this.mNumberOfTransitions) {
                    if (this.mLabels[n2] == n) {
                        nArray2 = nArray;
                        int n3 = nArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int n5 = nArray2[n4];
                            if (n5 == this.mLabelHeads[n2]) {
                                arrayList.add(this.mLabelTails[n2]);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.mPartition.getPartitions().size()) {
                    int[] nArray3 = this.mPartition.getPartitions().get(n2);
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                    int[] nArray4 = nArray3;
                    int n6 = nArray3.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        int n8 = nArray4[n7];
                        if (arrayList.contains(n8)) {
                            arrayList2.add(n8);
                        } else {
                            arrayList3.add(n8);
                        }
                        ++n7;
                    }
                    nArray2 = MinimizeDfaHopcroftWiki.toIntArray(arrayList2);
                    int[] nArray5 = MinimizeDfaHopcroftWiki.toIntArray(arrayList3);
                    if (!arrayList2.isEmpty() && !arrayList3.isEmpty()) {
                        this.mPartition.replaceSetBy2Sets(n2, nArray2, nArray5);
                        n6 = this.findSet(nArray3, worklist);
                        if (n6 >= 0) {
                            worklist.replaceSetBy2Sets(n6, nArray2, nArray5);
                        } else if (nArray2.length <= nArray5.length) {
                            worklist.addToWorklist(nArray2);
                        } else {
                            worklist.addToWorklist(nArray5);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private int findSet(int[] nArray, Worklist worklist) {
        int n = 0;
        while (n < worklist.getSize()) {
            if (MinimizeDfaHopcroftWiki.arrayEquals(nArray, worklist.get(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static boolean arrayEquals(int[] nArray, int[] nArray2) {
        if (nArray2.length != nArray.length) {
            return false;
        }
        int[] nArray3 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray3[n2];
            boolean bl = false;
            int[] nArray4 = nArray2;
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = nArray4[n5];
                if (n3 == n6) {
                    bl = true;
                    break;
                }
                ++n5;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static int[] toIntArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        int n = 0;
        for (Integer n2 : list) {
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    private void constructResult() {
        HashMap<Integer, Collection<STATE>> hashMap = this.computeMapState2Equiv();
        HashMap hashMap2 = new HashMap(MinimizeDfaHopcroftWiki.computeHashCap(hashMap.size()));
        assert (this.mOperand.getInitialStates().iterator().hasNext()) : "There is no initial state in the automaton.";
        int n = this.mState2representative[this.mState2int.get(this.mOperand.getInitialStates().iterator().next())];
        this.startResultConstruction();
        for (Map.Entry<Integer, Collection<STATE>> object : hashMap.entrySet()) {
            boolean bl;
            int n2 = object.getKey();
            Collection<STATE> collection = object.getValue();
            boolean bl2 = bl = n2 == n;
            assert (collection.iterator().hasNext()) : "There is no equivalent state in the collection.";
            boolean bl3 = this.mOperand.isFinal(collection.iterator().next());
            Object STATE = this.addState(bl, bl3, collection);
            hashMap2.put(n2, STATE);
        }
        for (Integer n3 : hashMap.keySet()) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(this.mInt2state.get(n3))) {
                this.addInternalTransition(hashMap2.get(n3), outgoingInternalTransition.getLetter(), hashMap2.get(this.mState2representative[this.mState2int.get(outgoingInternalTransition.getSucc())]));
            }
        }
        this.finishResultConstruction(null, false);
    }

    private HashMap<Integer, ? extends Collection<STATE>> computeMapState2Equiv() {
        this.mState2representative = new int[this.mOperand.size()];
        HashMap hashMap = new HashMap(MinimizeDfaHopcroftWiki.computeHashCap(this.mOperand.size()));
        for (int[] nArray : this.mPartition.getPartitions()) {
            if (nArray.length <= 0) continue;
            int n = nArray[0];
            LinkedList<STATE> linkedList = new LinkedList<STATE>();
            int[] nArray2 = nArray;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                linkedList.add(this.mInt2state.get(n4));
                this.mState2representative[n4] = n;
                ++n3;
            }
            hashMap.put(n, linkedList);
        }
        return hashMap;
    }

    private boolean hasIncomingTransitionWithLetter(int n, int n2) {
        STATE STATE = this.mInt2state.get(n);
        LETTER LETTER = this.mInt2letter.get(n2);
        return this.mOperand.internalPredecessors(STATE, LETTER).iterator().hasNext();
    }

    private boolean hasOutgoingTransitionWithLetter(int n, int n2) {
        STATE STATE = this.mInt2state.get(n);
        LETTER LETTER = this.mInt2letter.get(n2);
        return this.mOperand.internalSuccessors(STATE, LETTER).iterator().hasNext();
    }

    private int getPredecessor(int n, int n2) {
        STATE STATE = this.mInt2state.get(n);
        LETTER LETTER = this.mInt2letter.get(n2);
        STATE STATE2 = this.mOperand.internalPredecessors(STATE, LETTER).iterator().next().getPred();
        return this.mState2int.get(STATE2);
    }

    private int getSuccessor(int n, int n2) {
        STATE STATE = this.mInt2state.get(n);
        LETTER LETTER = this.mInt2letter.get(n2);
        STATE STATE2 = this.mOperand.internalSuccessors(STATE, LETTER).iterator().next().getSucc();
        return this.mState2int.get(STATE2);
    }

    public class Partition {
        private ArrayList<int[]> mSetsOfPartition;
        private int mSize = 0;
        private int[] mFinalStates;
        private int[] mNonfinalStates;
        private Worklist mWorkList;

        public void init() {
            Collection collection = MinimizeDfaHopcroftWiki.this.mOperand.getFinalStates();
            Set set = MinimizeDfaHopcroftWiki.this.mOperand.getStates();
            int n = collection.size();
            int n2 = set.size();
            this.mFinalStates = new int[n];
            this.mNonfinalStates = new int[n2 - n];
            this.mSetsOfPartition = new ArrayList(n2);
            int n3 = -1;
            int n4 = -1;
            for (Object e : set) {
                if (collection.contains(e)) {
                    this.mFinalStates[++n3] = MinimizeDfaHopcroftWiki.this.mState2int.get(e);
                } else {
                    this.mNonfinalStates[++n4] = MinimizeDfaHopcroftWiki.this.mState2int.get(e);
                }
                ++this.mSize;
            }
            this.mSetsOfPartition.add(this.mFinalStates);
            this.mSetsOfPartition.add(this.mNonfinalStates);
            this.mWorkList = new Worklist(set.size());
            this.mWorkList.addToWorklist(this.mFinalStates);
        }

        public int size() {
            return this.mSize;
        }

        public void replaceSetBy2Sets(int n, int[] nArray, int[] nArray2) {
            this.mSetsOfPartition.remove(n);
            this.mSetsOfPartition.add(nArray);
            this.mSetsOfPartition.add(nArray2);
            ++this.mSize;
        }

        public ArrayList<int[]> getPartitions() {
            return this.mSetsOfPartition;
        }

        public Worklist getWorklist() {
            return this.mWorkList;
        }
    }

    private static class Worklist {
        private final ArrayList<int[]> mSetsOfStates;
        private int mSize;

        public Worklist(int n) {
            this.mSetsOfStates = new ArrayList(n);
            this.mSize = this.mSetsOfStates.size();
        }

        public int[] popFromWorklist() {
            assert (!this.mSetsOfStates.isEmpty());
            int[] nArray = this.mSetsOfStates.remove(this.mSize - 1);
            --this.mSize;
            return nArray;
        }

        public void addToWorklist(int[] nArray) {
            this.mSetsOfStates.add(nArray);
            ++this.mSize;
        }

        public boolean replaceSetBy2Sets(int n, int[] nArray, int[] nArray2) {
            this.mSetsOfStates.remove(n);
            boolean bl = this.mSetsOfStates.add(nArray);
            boolean bl2 = this.mSetsOfStates.add(nArray2);
            ++this.mSize;
            return bl && bl2;
        }

        public boolean isEmpty() {
            return this.mSetsOfStates.isEmpty();
        }

        public int getSize() {
            return this.mSize;
        }

        public int[] get(int n) {
            return this.mSetsOfStates.get(n);
        }
    }
}

