/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.NonDeclaringTermTransferrer;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import java.util.Arrays;
import java.util.Objects;

public class DeclarableSortSymbol
implements ISmtDeclarable {
    private final String mName;
    private final int mArity;
    private final Sort[] mParams;
    private final Sort mDefinition;

    private DeclarableSortSymbol(String string, Sort[] sortArray, Sort sort2, int n) {
        this.mName = Objects.requireNonNull(string);
        this.mParams = sortArray;
        this.mDefinition = sort2;
        this.mArity = n;
        assert (this.mParams == null || this.mParams.length == n);
        assert (sortArray == null || Arrays.stream(sortArray).allMatch(sort -> sort != null));
    }

    public static DeclarableSortSymbol createFromScriptDefineSort(String string, Sort[] sortArray, Sort sort) {
        return new DeclarableSortSymbol(string, sortArray, sort, sortArray == null ? 0 : sortArray.length);
    }

    public static ISmtDeclarable createFromScriptDeclareSort(String string, int n) {
        return new DeclarableSortSymbol(string, null, null, n);
    }

    @Override
    public void defineOrDeclare(Script script) {
        NonDeclaringTermTransferrer nonDeclaringTermTransferrer = new NonDeclaringTermTransferrer(script);
        if (this.mDefinition == null && this.mParams == null) {
            script.declareSort(this.mName, this.mArity);
            return;
        }
        Sort[] sortArray = this.mParams == null ? null : nonDeclaringTermTransferrer.transferSorts(this.mParams);
        Sort sort = this.mDefinition == null ? null : nonDeclaringTermTransferrer.transferSort(this.mDefinition);
        script.defineSort(this.mName, sortArray, sort);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public String toString() {
        return "(" + PrintTerm.quoteIdentifier((String)this.mName) + " " + this.mArity + ")";
    }
}

