/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusContainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import java.util.function.BiFunction;

public class Heuristics {
    public static MusContainer chooseRandomMus(ArrayList<MusContainer> arrayList, Random random) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.get(random.nextInt(arrayList.size()));
    }

    public static MusContainer chooseSmallestMus(ArrayList<MusContainer> arrayList, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(arrayList, Heuristics::compareWhichMusIsSmaller, terminationRequest), random);
    }

    public static MusContainer chooseBiggestMus(ArrayList<MusContainer> arrayList, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(arrayList, Heuristics::compareWhichMusIsBigger, terminationRequest), random);
    }

    public static MusContainer chooseMusWithLowestLexicographicalOrder(ArrayList<MusContainer> arrayList, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(arrayList, Heuristics::compareWhichMusHasLowerLexicographicalOrder, terminationRequest), random);
    }

    public static MusContainer chooseMusWithHighestLexicographicalOrder(ArrayList<MusContainer> arrayList, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(arrayList, Heuristics::compareWhichMusHasHigherLexicographicalOrder, terminationRequest), random);
    }

    public static MusContainer chooseShallowestMus(ArrayList<MusContainer> arrayList, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(arrayList, Heuristics::compareWhichMusIsShallowerMus, terminationRequest), random);
    }

    public static MusContainer chooseDeepestMus(ArrayList<MusContainer> arrayList, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(arrayList, Heuristics::compareWhichMusIsDeeperMus, terminationRequest), random);
    }

    public static MusContainer chooseNarrowestMus(ArrayList<MusContainer> arrayList, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(arrayList, Heuristics::compareWhichMusIsNarrowerMus, terminationRequest), random);
    }

    public static MusContainer chooseWidestMus(ArrayList<MusContainer> arrayList, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return Heuristics.chooseRandomMus(Heuristics.findBestMusesAccordingToGivenCriterion(arrayList, Heuristics::compareWhichMusIsWiderMus, terminationRequest), random);
    }

    public static MusContainer chooseSmallestAmongWideMuses(ArrayList<MusContainer> arrayList, double d, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList<MusContainer> arrayList2 = new ArrayList<MusContainer>();
        MusContainer musContainer = Heuristics.chooseWidestMus(arrayList, random, terminationRequest);
        int n = Heuristics.width(musContainer);
        if (terminationRequest.isTerminationRequested()) {
            return musContainer;
        }
        int n2 = 0;
        while (n2 < arrayList.size() && !terminationRequest.isTerminationRequested()) {
            MusContainer musContainer2 = arrayList.get(n2);
            int n3 = Heuristics.width(musContainer2);
            if ((double)n3 >= (1.0 - d) * (double)n) {
                arrayList2.add(musContainer2);
            }
            ++n2;
        }
        return Heuristics.chooseSmallestMus(arrayList2, random, terminationRequest);
    }

    public static MusContainer chooseWidestAmongSmallMuses(ArrayList<MusContainer> arrayList, double d, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList<MusContainer> arrayList2 = new ArrayList<MusContainer>();
        MusContainer musContainer = Heuristics.chooseSmallestMus(arrayList, random, terminationRequest);
        int n = Heuristics.size(musContainer);
        if (terminationRequest.isTerminationRequested()) {
            return musContainer;
        }
        int n2 = 0;
        while (n2 < arrayList.size() && !terminationRequest.isTerminationRequested()) {
            MusContainer musContainer2 = arrayList.get(n2);
            int n3 = Heuristics.size(musContainer2);
            if ((double)n3 <= (1.0 + d) * (double)n) {
                arrayList2.add(musContainer2);
            }
            ++n2;
        }
        return Heuristics.chooseWidestMus(arrayList2, random, terminationRequest);
    }

    public static ArrayList<MusContainer> chooseAllMuses(ArrayList<MusContainer> arrayList) {
        return arrayList;
    }

    public static ArrayList<MusContainer> chooseMostDifferentMusesWithRespectToOtherHeuristics(ArrayList<MusContainer> arrayList, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty()) {
            return new ArrayList<MusContainer>();
        }
        ArrayList<MusContainer> arrayList2 = new ArrayList<MusContainer>();
        arrayList2.add(Heuristics.chooseSmallestMus(arrayList, random, terminationRequest));
        arrayList2.add(Heuristics.chooseBiggestMus(arrayList, random, terminationRequest));
        arrayList2.add(Heuristics.chooseMusWithLowestLexicographicalOrder(arrayList, random, terminationRequest));
        arrayList2.add(Heuristics.chooseMusWithHighestLexicographicalOrder(arrayList, random, terminationRequest));
        arrayList2.add(Heuristics.chooseShallowestMus(arrayList, random, terminationRequest));
        arrayList2.add(Heuristics.chooseDeepestMus(arrayList, random, terminationRequest));
        arrayList2.add(Heuristics.chooseNarrowestMus(arrayList, random, terminationRequest));
        arrayList2.add(Heuristics.chooseWidestMus(arrayList, random, terminationRequest));
        arrayList2.add(Heuristics.chooseSmallestAmongWideMuses(arrayList, 0.9, random, terminationRequest));
        arrayList2.add(Heuristics.chooseWidestAmongSmallMuses(arrayList, 0.9, random, terminationRequest));
        return arrayList2;
    }

    public static ArrayList<MusContainer> chooseDifferentMusesWithRespectToStatements(ArrayList<MusContainer> arrayList, int n, Random random, TerminationRequest terminationRequest) {
        if (arrayList.isEmpty() || n == 0) {
            return new ArrayList<MusContainer>();
        }
        ArrayList<MusContainer> arrayList2 = new ArrayList<MusContainer>();
        ArrayList<MusContainer> arrayList3 = new ArrayList<MusContainer>();
        arrayList2.add(arrayList.get(random.nextInt(arrayList.size())));
        int n2 = 1;
        while (n2 < n && !terminationRequest.isTerminationRequested()) {
            int n3 = Integer.MIN_VALUE;
            for (MusContainer musContainer : arrayList) {
                int n4 = Heuristics.findMinimumNumberOfDifferentStatements(musContainer, arrayList2);
                if (n4 > n3) {
                    n3 = n4;
                    arrayList3.clear();
                    arrayList3.add(musContainer);
                    continue;
                }
                if (n4 != n3) continue;
                arrayList3.add(musContainer);
            }
            if (n3 == 0) break;
            arrayList2.add(Heuristics.chooseRandomMus(arrayList3, random));
            ++n2;
        }
        return arrayList2;
    }

    private static int findMinimumNumberOfDifferentStatements(MusContainer musContainer, ArrayList<MusContainer> arrayList) {
        int n = Integer.MAX_VALUE;
        for (MusContainer musContainer2 : arrayList) {
            int n2 = Heuristics.numberOfDifferentStatements(musContainer, musContainer2);
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public static int numberOfDifferentStatements(MusContainer musContainer, MusContainer musContainer2) {
        BitSet bitSet = musContainer.getMus();
        BitSet bitSet2 = musContainer2.getMus();
        int n = 0;
        int n2 = 0;
        while (n2 < bitSet.length()) {
            if (bitSet.get(n2) && !bitSet2.get(n2) || bitSet2.get(n2) && !bitSet.get(n2)) {
                ++n;
            }
            ++n2;
        }
        if (bitSet2.length() > bitSet.length()) {
            n2 = bitSet2.nextSetBit(bitSet.length());
            while (n2 >= 0) {
                ++n;
                n2 = bitSet2.nextSetBit(n2 + 1);
            }
        }
        return n;
    }

    private static ResultOfComparison compareWhichMusIsSmaller(MusContainer musContainer, MusContainer musContainer2) {
        int n;
        int n2 = Heuristics.size(musContainer);
        if (n2 < (n = Heuristics.size(musContainer2))) {
            return ResultOfComparison.MUS1;
        }
        if (n2 > n) {
            return ResultOfComparison.MUS2;
        }
        return ResultOfComparison.EQUAL;
    }

    private static ResultOfComparison compareWhichMusIsBigger(MusContainer musContainer, MusContainer musContainer2) {
        return Heuristics.compareWhichMusIsSmaller(musContainer2, musContainer);
    }

    private static ResultOfComparison compareWhichMusHasLowerLexicographicalOrder(MusContainer musContainer, MusContainer musContainer2) {
        BitSet bitSet = musContainer.getMus();
        BitSet bitSet2 = musContainer2.getMus();
        int n = 0;
        while (n < bitSet.length()) {
            if (bitSet.get(n)) {
                if (!bitSet2.get(n)) {
                    return ResultOfComparison.MUS1;
                }
            } else if (bitSet2.get(n)) {
                return ResultOfComparison.MUS2;
            }
            ++n;
        }
        if (bitSet2.length() > bitSet.length()) {
            return ResultOfComparison.MUS1;
        }
        throw new SMTLIBException("Both muses must be the same. This should not be.");
    }

    private static ResultOfComparison compareWhichMusHasHigherLexicographicalOrder(MusContainer musContainer, MusContainer musContainer2) {
        if (Heuristics.compareWhichMusHasLowerLexicographicalOrder(musContainer, musContainer2) == ResultOfComparison.MUS1) {
            return ResultOfComparison.MUS2;
        }
        return ResultOfComparison.MUS1;
    }

    private static ResultOfComparison compareWhichMusIsShallowerMus(MusContainer musContainer, MusContainer musContainer2) {
        int n;
        int n2 = Heuristics.depth(musContainer);
        if (n2 < (n = Heuristics.depth(musContainer2))) {
            return ResultOfComparison.MUS1;
        }
        if (n2 > n) {
            return ResultOfComparison.MUS2;
        }
        return ResultOfComparison.EQUAL;
    }

    private static ResultOfComparison compareWhichMusIsDeeperMus(MusContainer musContainer, MusContainer musContainer2) {
        return Heuristics.compareWhichMusIsShallowerMus(musContainer2, musContainer);
    }

    private static ResultOfComparison compareWhichMusIsNarrowerMus(MusContainer musContainer, MusContainer musContainer2) {
        int n;
        int n2 = Heuristics.width(musContainer);
        if (n2 < (n = Heuristics.width(musContainer2))) {
            return ResultOfComparison.MUS1;
        }
        if (n2 > n) {
            return ResultOfComparison.MUS2;
        }
        return ResultOfComparison.EQUAL;
    }

    private static ResultOfComparison compareWhichMusIsWiderMus(MusContainer musContainer, MusContainer musContainer2) {
        return Heuristics.compareWhichMusIsNarrowerMus(musContainer2, musContainer);
    }

    private static ArrayList<MusContainer> findBestMusesAccordingToGivenCriterion(ArrayList<MusContainer> arrayList, BiFunction<MusContainer, MusContainer, ResultOfComparison> biFunction, TerminationRequest terminationRequest) {
        ArrayList<MusContainer> arrayList2 = new ArrayList<MusContainer>();
        MusContainer musContainer = arrayList.get(0);
        arrayList2.add(musContainer);
        int n = 1;
        while (n < arrayList.size() && !terminationRequest.isTerminationRequested()) {
            MusContainer musContainer2 = arrayList.get(n);
            ResultOfComparison resultOfComparison = biFunction.apply(musContainer, musContainer2);
            if (resultOfComparison == ResultOfComparison.MUS2) {
                arrayList2.clear();
                arrayList2.add(musContainer2);
                musContainer = musContainer2;
            } else if (resultOfComparison == ResultOfComparison.EQUAL) {
                arrayList2.add(musContainer2);
            }
            ++n;
        }
        return arrayList2;
    }

    public static int size(MusContainer musContainer) {
        return musContainer.getMus().cardinality();
    }

    public static int depth(MusContainer musContainer) {
        return musContainer.getMus().nextSetBit(0);
    }

    public static int width(MusContainer musContainer) {
        return musContainer.getMus().length() - musContainer.getMus().nextSetBit(0);
    }

    private static enum ResultOfComparison {
        MUS1{}
        ,
        MUS2{}
        ,
        EQUAL{};

    }
}

