/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.CheckMessageProvider;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ISimpleAST;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IMessageProvider;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class BoogieASTNode
extends BasePayloadContainer
implements ISimpleAST<BoogieASTNode, VisualizationNode> {
    private static final long serialVersionUID = 5856434889026482850L;
    protected static final Map<Class<?>, Predicate<BoogieASTNode>> VALIDATORS = new HashMap();
    private static final String IDENTIFIER_REGEX = "[a-zA-z\\.$#_'`~^\\\\\\?]+[a-zA-z.$#_'~^\\\\\\?\\!\\d]*";

    static {
        Predicate<BoogieASTNode> predicate = boogieASTNode -> {
            IdentifierExpression identifierExpression = (IdentifierExpression)((Object)boogieASTNode);
            return Pattern.matches(IDENTIFIER_REGEX, identifierExpression.identifier);
        };
        Predicate<BoogieASTNode> predicate2 = boogieASTNode -> {
            Procedure procedure = (Procedure)((Object)boogieASTNode);
            return Pattern.matches(IDENTIFIER_REGEX, procedure.identifier);
        };
        Predicate<BoogieASTNode> predicate3 = boogieASTNode -> {
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)((Object)boogieASTNode);
            return Pattern.matches(IDENTIFIER_REGEX, functionDeclaration.identifier);
        };
        Predicate<BoogieASTNode> predicate4 = boogieASTNode -> {
            HasNullElementVisitor hasNullElementVisitor = new HasNullElementVisitor();
            boogieASTNode.accept(hasNullElementVisitor);
            return !hasNullElementVisitor.getResult();
        };
        VALIDATORS.put(IdentifierExpression.class, predicate);
        VALIDATORS.put(Procedure.class, predicate2);
        VALIDATORS.put(FunctionDeclaration.class, predicate3);
        VALIDATORS.put(Body.class, predicate4);
        VALIDATORS.put(WhileStatement.class, predicate4);
        VALIDATORS.put(VarList.class, boogieASTNode -> ((VarList)((Object)boogieASTNode)).getType() != null);
    }

    public BoogieASTNode(ILocation iLocation) {
        if (iLocation == null) {
            return;
        }
        iLocation.annotate((IElement)this);
    }

    public ILocation getLocation() {
        return ILocation.getAnnotation((IElement)this);
    }

    protected BoogieASTNode createSpecialChild(String string, Object[] objectArray) {
        BoogieASTWrapper boogieASTWrapper = new BoogieASTWrapper(null, string);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            boogieASTWrapper.getOutgoingNodes().add(this.createSpecialChild(object));
            ++n2;
        }
        return boogieASTWrapper;
    }

    protected BoogieASTNode createSpecialChild(Object object) {
        return new BoogieASTWrapper(null, object);
    }

    public VisualizationNode getVisualizationGraph() {
        return new VisualizationNode((ISimpleAST)this);
    }

    public List<IWalkable> getSuccessors() {
        ArrayList<IWalkable> arrayList = new ArrayList<IWalkable>();
        arrayList.addAll(this.getOutgoingNodes());
        return arrayList;
    }

    public List<BoogieASTNode> getOutgoingNodes() {
        return new ArrayList<BoogieASTNode>();
    }

    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        throw new UnsupportedOperationException("The base class does not accept visitors");
    }

    public static Check createDefaultCheck(BoogieASTNode boogieASTNode) {
        if (boogieASTNode instanceof AssertStatement) {
            Attribute[] attributeArray = ((AssertStatement)boogieASTNode).getAttributes();
            if (attributeArray != null && attributeArray.length > 0) {
                String string = BoogiePrettyPrinter.print(attributeArray);
                CheckMessageProvider checkMessageProvider = new CheckMessageProvider();
                checkMessageProvider.registerSpecificationAssertNamedAttributes(string);
                return new Check(Spec.ASSERT, (IMessageProvider)checkMessageProvider);
            }
            return new Check(Spec.ASSERT);
        }
        if (boogieASTNode instanceof LoopInvariantSpecification) {
            return new Check(Spec.INVARIANT);
        }
        if (boogieASTNode instanceof CallStatement) {
            return new Check(Spec.PRE_CONDITION);
        }
        if (boogieASTNode instanceof EnsuresSpecification) {
            return new Check(Spec.POST_CONDITION);
        }
        if (boogieASTNode == null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    private class BoogieASTWrapper
    extends BoogieASTNode {
        private static final long serialVersionUID = 1L;
        private final Object mBacking;

        public BoogieASTWrapper(ILocation iLocation, Object object) {
            super(iLocation);
            this.mBacking = object;
        }

        public String toString() {
            if (this.mBacking != null) {
                return this.mBacking.toString();
            }
            return super.toString();
        }
    }

    private static final class HasNullElementVisitor
    extends GeneratedBoogieAstVisitor {
        private boolean mResult = false;

        private HasNullElementVisitor() {
        }

        @Override
        public boolean visit(Body body) {
            this.mResult = HasNullElementVisitor.hasNullElement(body.getBlock()) || HasNullElementVisitor.hasNullElement(body.getLocalVars());
            return false;
        }

        @Override
        public boolean visit(WhileStatement whileStatement) {
            this.mResult = HasNullElementVisitor.hasNullElement(whileStatement.getBody()) || HasNullElementVisitor.hasNullElement(whileStatement.getInvariants());
            return false;
        }

        public boolean getResult() {
            return this.mResult;
        }

        private static <T> boolean hasNullElement(T[] TArray) {
            if (TArray == null || TArray.length == 0) {
                return false;
            }
            return Arrays.stream(TArray).anyMatch(object -> object == null);
        }
    }
}

