/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieUtils;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.Activator;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.BackTransValue;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.BoogieCopyTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.IdExprWrapper;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.IdManager;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.InlinedCallAnnotation;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.InlinerStatistic;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.LabelMapKey;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.VarListIterator;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.VarMapKey;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.VarMapValue;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphEdgeLabel;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphNode;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.exceptions.CancelToolchainException;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.exceptions.InliningUnsupportedException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class InlineVersionTransformer
extends BoogieCopyTransformer {
    private static final String ATTR_PREFIX_END_INLINE = "end_inline_";
    public static final String ATTR_PREFIX_BEGIN_INLINE = "begin_inline_";
    private final ILogger mLogger;
    private final IProgressMonitorService mProgressMonitorService;
    private final GlobalScopeManager mGlobalScopeManager;
    private final InlinerStatistic mInlinerStatistic;
    private String mEntryProcId = null;
    private final Deque<Deque<CallStatement>> mCallStackStack = new ArrayDeque<ArrayDeque<Deque<CallStatement>>>(Collections.singleton(new ArrayDeque()));
    private final Map<BoogieASTNode, BackTransValue> mBackTransMap = new HashMap<BoogieASTNode, BackTransValue>();
    private final Deque<CallGraphNode> mProcedureStack = new ArrayDeque<CallGraphNode>();
    private final Deque<Integer> mEdgeIndexStack = new ArrayDeque<Integer>();
    private final Map<String, Integer> mCallCounter = new HashMap<String, Integer>();
    private final Deque<UnaryExpression> mInlinedOldExprStack = new ArrayDeque<UnaryExpression>();
    private final Deque<Set<IdExprWrapper>> mInlinedOldVarStack = new ArrayDeque<Set<IdExprWrapper>>();
    private final List<VariableDeclaration> mInlinedVars = new ArrayList<VariableDeclaration>();
    private final Map<VarMapKey, VarMapValue> mVarMap;
    private final IdManager mVarIdManager = new IdManager();
    private final Map<LabelMapKey, String> mLabelMap = new HashMap<LabelMapKey, String>();
    private final IdManager mLabelIdManager = new IdManager();

    public InlineVersionTransformer(IUltimateServiceProvider iUltimateServiceProvider, GlobalScopeManager globalScopeManager, InlinerStatistic inlinerStatistic) {
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mProgressMonitorService = iUltimateServiceProvider.getProgressMonitorService();
        this.mGlobalScopeManager = globalScopeManager;
        this.mInlinerStatistic = inlinerStatistic;
        this.mVarMap = globalScopeManager.initVarMap();
        globalScopeManager.initVarIdManager(this.mVarIdManager);
    }

    public Procedure inlineCallsInside(CallGraphNode callGraphNode) throws CancelToolchainException {
        VarList[] varListArray;
        VarList[] varListArray2;
        Attribute[] attributeArray;
        VariableDeclaration[] variableDeclarationArray;
        if (this.mEntryProcId != null) {
            throw new IllegalStateException("Instance was already used to inline an procedure: " + this.mEntryProcId);
        }
        if (!callGraphNode.isImplemented()) {
            return null;
        }
        this.mEntryProcId = callGraphNode.getId();
        this.mProcedureStack.push(callGraphNode);
        this.mEdgeIndexStack.push(0);
        this.mapVariablesOfCurrentProcedure();
        Procedure procedure = callGraphNode.getProcedureWithBody();
        String string = procedure.getIdentifier();
        Body body = procedure.getBody();
        Statement[] statementArray = body.getBlock();
        this.mapLabels(statementArray);
        Statement[] statementArray2 = this.flattenStatementsArray(statementArray);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, string);
        VariableDeclaration[] variableDeclarationArray2 = body.getLocalVars();
        int n = variableDeclarationArray2.length;
        int n2 = 0;
        while (n2 < n) {
            variableDeclarationArray = variableDeclarationArray2[n2];
            attributeArray = this.processAttributes(variableDeclarationArray.getAttributes());
            varListArray2 = this.applyMappingToVarList(variableDeclarationArray.getVariables(), declarationInformation);
            varListArray = new VariableDeclaration(variableDeclarationArray.getLocation(), attributeArray, varListArray2);
            ModelUtils.copyAnnotations((IElement)variableDeclarationArray, (IElement)varListArray);
            arrayList.add(varListArray);
            ++n2;
        }
        arrayList.addAll(this.mInlinedVars);
        variableDeclarationArray = arrayList.toArray(new VariableDeclaration[arrayList.size()]);
        Body body2 = new Body(body.getLocation(), variableDeclarationArray, statementArray2);
        ModelUtils.copyAnnotations((IElement)body, (IElement)body2);
        Specification[] specificationArray = procedure.getSpecification();
        boolean bl = specificationArray != null;
        attributeArray = null;
        if (bl) {
            attributeArray = new Specification[specificationArray.length];
            int n3 = 0;
            while (n3 < specificationArray.length) {
                attributeArray[n3] = this.processSpecification(specificationArray[n3]);
                this.addBacktranslation((BoogieASTNode)attributeArray[n3], (BoogieASTNode)specificationArray[n3]);
                ++n3;
            }
        }
        varListArray2 = this.applyMappingToVarList(procedure.getInParams(), new DeclarationInformation(bl ? DeclarationInformation.StorageClass.PROC_FUNC_INPARAM : DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string));
        varListArray = this.applyMappingToVarList(procedure.getOutParams(), new DeclarationInformation(bl ? DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM : DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, string));
        Attribute[] attributeArray2 = this.processAttributes(procedure.getAttributes());
        Procedure procedure2 = new Procedure(procedure.getLocation(), attributeArray2, string, procedure.getTypeParams(), varListArray2, varListArray, (Specification[])attributeArray, body2);
        ModelUtils.copyAnnotations((IElement)procedure, (IElement)procedure2);
        this.mEdgeIndexStack.pop();
        this.mProcedureStack.pop();
        return procedure2;
    }

    private void checkInstanceUsed() {
        if (this.mEntryProcId == null) {
            throw new IllegalStateException("Instance must have been used for inlining before.");
        }
    }

    public Map<BoogieASTNode, BackTransValue> getBacktranslationMap() {
        this.checkInstanceUsed();
        return Collections.unmodifiableMap(this.mBackTransMap);
    }

    public Map<VarMapKey, VarMapValue> getVariableMap() {
        this.checkInstanceUsed();
        return Collections.unmodifiableMap(this.mVarMap);
    }

    public String getEntryProcId() {
        this.checkInstanceUsed();
        return this.mEntryProcId;
    }

    private void addBacktranslation(BoogieASTNode boogieASTNode, BoogieASTNode boogieASTNode2) {
        this.mBackTransMap.put(boogieASTNode, new BackTransValue(this.mEntryProcId, this.mCallStackStack.peek(), boogieASTNode2));
    }

    private String currentProcId() {
        return this.mProcedureStack.peek().getId();
    }

    private boolean stackContainsDuplicates() {
        HashSet<String> hashSet = new HashSet<String>();
        for (CallGraphNode callGraphNode : this.mProcedureStack) {
            if (hashSet.add(callGraphNode.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean inEntryProcedure() {
        return this.mProcedureStack.size() == 1;
    }

    private boolean inInlinedOldExpr() {
        return !this.mInlinedOldExprStack.isEmpty();
    }

    private int getCallCounter(String string) {
        Integer n = this.mCallCounter.get(string);
        return n == null ? 0 : n;
    }

    private int incrementCallCounter(String string) {
        int n = this.getCallCounter(string);
        this.mCallCounter.put(string, n + 1);
        return n;
    }

    private int getAndUpdateEdgeIndex() {
        int n = this.mEdgeIndexStack.pop();
        this.mEdgeIndexStack.push(n + 1);
        return n;
    }

    private void mapVariablesOfCurrentProcedure() throws CancelToolchainException {
        CallGraphNode callGraphNode = this.mProcedureStack.peek();
        Procedure procedure = callGraphNode.getProcedureWithSpecification();
        Procedure procedure2 = callGraphNode.getProcedureWithBody();
        if (callGraphNode.isPolymorphic()) {
            ILocation iLocation = callGraphNode.getProcedureWithSpecification().getLocation();
            throw new InliningUnsupportedException("Polymorphic procedure " + callGraphNode.getId(), iLocation);
        }
        if (callGraphNode.isImplemented()) {
            if (callGraphNode.isCombined()) {
                this.mapProcedureParameters(procedure2);
            } else {
                this.mapProcedureParametersToSameValue(procedure.getInParams(), procedure2.getInParams(), true);
                this.mapProcedureParametersToSameValue(procedure.getOutParams(), procedure2.getOutParams(), false);
            }
            Body body = procedure2.getBody();
            VariableDeclaration[] variableDeclarationArray = body.getLocalVars();
            int n = variableDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableDeclaration variableDeclaration = variableDeclarationArray[n2];
                this.mapLocalVariables(variableDeclaration);
                ++n2;
            }
        } else {
            this.mapProcedureParameters(procedure);
        }
    }

    private void mapProcedureParameters(Procedure procedure) {
        boolean bl = procedure.getSpecification() != null;
        ArrayList<VarList> arrayList = new ArrayList<VarList>(procedure.getInParams().length + procedure.getOutParams().length);
        DeclarationInformation.StorageClass storageClass = bl ? DeclarationInformation.StorageClass.PROC_FUNC_INPARAM : DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM;
        DeclarationInformation.StorageClass storageClass2 = bl ? DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM : DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM;
        arrayList.addAll(this.mapVariables(procedure.getInParams(), storageClass));
        arrayList.addAll(this.mapVariables(procedure.getOutParams(), storageClass2));
        if (!this.inEntryProcedure() && !arrayList.isEmpty()) {
            Attribute[] attributeArray = new Attribute[]{};
            VarList[] varListArray = new VarList[arrayList.size()];
            arrayList.toArray(varListArray);
            VariableDeclaration variableDeclaration = new VariableDeclaration(procedure.getLocation(), attributeArray, varListArray);
            this.mInlinedVars.add(variableDeclaration);
        }
    }

    private void mapProcedureParametersToSameValue(VarList[] varListArray, VarList[] varListArray2, boolean bl) {
        boolean bl2 = this.inEntryProcedure();
        String string = this.currentProcId();
        DeclarationInformation.StorageClass storageClass = bl ? DeclarationInformation.StorageClass.PROC_FUNC_INPARAM : DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM;
        DeclarationInformation.StorageClass storageClass2 = bl ? DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM : DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM;
        DeclarationInformation declarationInformation = new DeclarationInformation(storageClass, string);
        DeclarationInformation declarationInformation2 = new DeclarationInformation(storageClass2, string);
        DeclarationInformation declarationInformation3 = new DeclarationInformation(bl2 ? storageClass : DeclarationInformation.StorageClass.LOCAL, this.mEntryProcId);
        DeclarationInformation declarationInformation4 = new DeclarationInformation(bl2 ? storageClass2 : DeclarationInformation.StorageClass.LOCAL, this.mEntryProcId);
        ArrayList<VariableDeclaration> arrayList = new ArrayList<VariableDeclaration>();
        VarListIterator varListIterator = new VarListIterator(varListArray, varListArray2);
        while (varListIterator.hasNext()) {
            varListIterator.next();
            String string2 = varListIterator.currentId(1);
            String string3 = bl2 ? this.mVarIdManager.makeAndAddUniqueId(string2) : this.mVarIdManager.makeAndAddUniqueId(string, string2);
            VarMapKey varMapKey = new VarMapKey(varListIterator.currentId(0), declarationInformation);
            VarMapKey varMapKey2 = new VarMapKey(varListIterator.currentId(1), declarationInformation2);
            this.mVarMap.put(varMapKey, new VarMapValue(string3, declarationInformation3));
            this.mVarMap.put(varMapKey2, new VarMapValue(string3, declarationInformation4));
            if (bl2) continue;
            VarList varList = varListIterator.currentVarList(1);
            VarList varList2 = varListIterator.currentVarList(0);
            ILocation iLocation = varList.getLocation();
            String[] stringArray = new String[]{string3};
            assert (varList.getType().getBoogieType().equals(varList2.getType().getBoogieType()));
            ASTType aSTType = varList.getType();
            Expression expression = varList.getWhereClause();
            if (expression != null) {
                expression = this.processExpression(expression);
            }
            Attribute[] attributeArray = new Attribute[]{};
            VarList varList3 = new VarList(iLocation, stringArray, aSTType, expression);
            ModelUtils.copyAnnotations((IElement)varList, (IElement)varList3);
            ModelUtils.copyAnnotations((IElement)varList2, (IElement)varList3);
            arrayList.add(new VariableDeclaration(iLocation, attributeArray, new VarList[]{varList3}));
        }
        this.mInlinedVars.addAll(arrayList);
    }

    private void mapLocalVariables(VariableDeclaration variableDeclaration) {
        List<VarList> list = this.mapVariables(variableDeclaration.getVariables(), DeclarationInformation.StorageClass.LOCAL);
        if (!this.inEntryProcedure()) {
            Attribute[] attributeArray = this.processAttributes(variableDeclaration.getAttributes());
            VarList[] varListArray = new VarList[list.size()];
            list.toArray(varListArray);
            VariableDeclaration variableDeclaration2 = new VariableDeclaration(variableDeclaration.getLocation(), attributeArray, varListArray);
            ModelUtils.copyAnnotations((IElement)variableDeclaration, (IElement)variableDeclaration2);
            this.mInlinedVars.add(variableDeclaration2);
        }
    }

    private void mapVariableInInlinedOldExpr(IdentifierExpression identifierExpression) {
        String string = identifierExpression.getIdentifier();
        String string2 = this.currentProcId();
        DeclarationInformation declarationInformation = identifierExpression.getDeclarationInformation();
        VarMapKey varMapKey = new VarMapKey(string, declarationInformation, string2);
        if (!this.mVarMap.containsKey(varMapKey)) {
            VarMapValue varMapValue = null;
            if (declarationInformation.getStorageClass() == DeclarationInformation.StorageClass.GLOBAL) {
                DeclarationInformation declarationInformation2 = new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, this.mEntryProcId);
                String string3 = this.mVarIdManager.makeAndAddUniqueId(string2 + "_old", string);
                varMapValue = new VarMapValue(string3, declarationInformation2);
                Declaration declaration = this.mGlobalScopeManager.getVarDeclaration(string);
                VarList varList = this.mGlobalScopeManager.getVarListFromDeclaration(string);
                Attribute[] attributeArray = this.processAttributes(declaration.getAttributes());
                ASTType aSTType = varList.getType();
                VarList[] varListArray = new VarList[]{new VarList(varList.getLocation(), new String[]{string3}, aSTType)};
                this.mInlinedVars.add(new VariableDeclaration(declaration.getLocation(), attributeArray, varListArray));
            } else {
                VarMapKey varMapKey2 = new VarMapKey(string, declarationInformation);
                varMapValue = this.mVarMap.get(varMapKey2);
            }
            this.mVarMap.put(varMapKey, varMapValue);
        }
    }

    private void updateInlinedOldVarStack(IdentifierExpression identifierExpression) {
        if (identifierExpression.getDeclarationInformation().getStorageClass() == DeclarationInformation.StorageClass.GLOBAL) {
            Set<IdExprWrapper> set = this.mInlinedOldVarStack.peek();
            set.add(new IdExprWrapper(identifierExpression));
        }
    }

    private List<VarList> mapVariables(VarList[] varListArray, DeclarationInformation.StorageClass storageClass) {
        String string;
        Object object;
        DeclarationInformation declarationInformation;
        boolean bl = this.inEntryProcedure();
        String string2 = this.currentProcId();
        boolean bl2 = storageClass == DeclarationInformation.StorageClass.QUANTIFIED;
        String string3 = bl2 ? null : string2;
        DeclarationInformation declarationInformation2 = new DeclarationInformation(storageClass, string3);
        if (bl) {
            declarationInformation = declarationInformation2;
        } else {
            object = bl2 ? DeclarationInformation.StorageClass.QUANTIFIED : DeclarationInformation.StorageClass.LOCAL;
            string = bl2 ? null : this.mEntryProcId;
            declarationInformation = new DeclarationInformation((DeclarationInformation.StorageClass)object, string);
        }
        object = new ArrayList();
        VarList[] varListArray2 = varListArray;
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray;
            string = varListArray2[n2];
            ArrayList<String> arrayList = new ArrayList<String>();
            VarList varList = string.getIdentifiers();
            int n3 = ((String[])varList).length;
            int n4 = 0;
            while (n4 < n3) {
                Object object2;
                String string4;
                stringArray = varList[n4];
                if (bl) {
                    string4 = this.mVarIdManager.makeAndAddUniqueId((String)stringArray);
                } else {
                    object2 = bl2 ? "quantified" : string2;
                    string4 = this.mVarIdManager.makeAndAddUniqueId((String)object2, (String)stringArray);
                    arrayList.add(string4);
                }
                object2 = new VarMapKey((String)stringArray, declarationInformation2);
                VarMapValue varMapValue = new VarMapValue(string4, declarationInformation);
                if (!this.mVarMap.containsKey(object2)) {
                    this.mVarMap.put((VarMapKey)object2, varMapValue);
                } else if (!bl2) {
                    throw new AssertionError((Object)("A variable wasn't mapped properly: " + String.valueOf(object2)));
                }
                ++n4;
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            Expression expression = string.getWhereClause();
            Expression expression2 = expression != null ? this.processExpression(expression) : null;
            varList = new VarList(string.getLocation(), stringArray, string.getType(), expression2);
            ModelUtils.copyAnnotations((IElement)string, (IElement)varList);
            object.add(varList);
            ++n2;
        }
        return object;
    }

    private Statement[] flattenStatementsArray(Statement[] statementArray) throws CancelToolchainException {
        List<Statement> list = this.flattenStatements(statementArray);
        return list.toArray(new Statement[list.size()]);
    }

    private List<Statement> flattenStatements(Statement[] statementArray) throws CancelToolchainException {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            arrayList.addAll(this.flattenStatement(statement));
            ++n2;
        }
        return arrayList;
    }

    private Deque<CallStatement> createUpdatedCallStack(CallStatement callStatement) {
        ArrayDeque<CallStatement> arrayDeque = new ArrayDeque<CallStatement>((Collection)this.mCallStackStack.peek());
        arrayDeque.push(callStatement);
        return arrayDeque;
    }

    private List<Statement> flattenStatement(Statement statement) throws CancelToolchainException {
        this.checkTimeout();
        Statement statement2 = null;
        if (statement instanceof CallStatement) {
            CallStatement callStatement = (CallStatement)statement;
            int n = this.getAndUpdateEdgeIndex();
            CallGraphNode callGraphNode = this.mProcedureStack.peek();
            CallGraphNode callGraphNode2 = (CallGraphNode)((Object)callGraphNode.getOutgoingNodes().get(n));
            CallGraphEdgeLabel callGraphEdgeLabel = (CallGraphEdgeLabel)callGraphNode.getOutgoingEdgeLabels().get(n);
            assert (callStatement.getMethodName().equals(callGraphNode2.getId()) && callStatement.getMethodName().equals(callGraphEdgeLabel.getCalleeProcedureId()));
            if (callGraphEdgeLabel.getInlineFlag()) {
                VariableLHS[] variableLHSArray = this.processVariableLHSs(callStatement.getLhs());
                this.mCallStackStack.push(this.createUpdatedCallStack(callStatement));
                this.mProcedureStack.push(callGraphNode2);
                this.mEdgeIndexStack.push(0);
                if (this.incrementCallCounter(callGraphNode2.getId()) <= 0) {
                    this.mapVariablesOfCurrentProcedure();
                }
                List<Statement> list = this.inlineCall(callStatement, variableLHSArray, callGraphNode2);
                this.mEdgeIndexStack.pop();
                this.mProcedureStack.pop();
                this.mCallStackStack.pop();
                this.mInlinerStatistic.incrementCallsInlined();
                return list;
            }
        } else if (statement instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)statement;
            Expression expression = this.processExpression(ifStatement.getCondition());
            Statement[] statementArray = this.flattenStatementsArray(ifStatement.getThenPart());
            Statement[] statementArray2 = this.flattenStatementsArray(ifStatement.getElsePart());
            statement2 = new IfStatement(ifStatement.getLocation(), expression, statementArray, statementArray2);
        } else if (statement instanceof WhileStatement) {
            WhileStatement whileStatement = (WhileStatement)statement;
            Expression expression = this.processExpression(whileStatement.getCondition());
            LoopInvariantSpecification[] loopInvariantSpecificationArray = this.processLoopSpecifications(whileStatement.getInvariants());
            Statement[] statementArray = this.flattenStatementsArray(whileStatement.getBody());
            statement2 = new WhileStatement(whileStatement.getLocation(), expression, loopInvariantSpecificationArray, statementArray);
        } else if (statement instanceof AtomicStatement) {
            AtomicStatement atomicStatement = (AtomicStatement)statement;
            Statement[] statementArray = this.flattenStatementsArray(atomicStatement.getBody());
            statement2 = new AtomicStatement(atomicStatement.getLocation(), statementArray);
        } else if (statement instanceof ForkStatement) {
            this.getAndUpdateEdgeIndex();
        }
        if (statement2 == null) {
            statement2 = this.processStatement(statement);
        } else {
            ModelUtils.copyAnnotations((IElement)statement, statement2);
            this.addBacktranslation((BoogieASTNode)statement2, (BoogieASTNode)statement);
        }
        this.mInlinerStatistic.incrementStatementsFlattened();
        return Collections.singletonList(statement2);
    }

    private static String getClassString(Map<String, IAnnotations> map) {
        if (map == null) {
            return "NULL";
        }
        return map.entrySet().stream().map(entry -> (String)entry.getKey() + " -> " + String.valueOf(entry.getValue() == null ? "NULL" : ((IAnnotations)entry.getValue()).getClass())).collect(Collectors.joining(", "));
    }

    private List<Statement> inlineCall(CallStatement callStatement, VariableLHS[] variableLHSArray, CallGraphNode callGraphNode) throws CancelToolchainException {
        IdentifierExpression identifierExpression;
        String string;
        IBoogieType iBoogieType;
        Statement statement;
        Procedure procedure;
        List<VariableLHS> list;
        Label label;
        Object object;
        Object object2;
        Object object4;
        ILocation iLocation;
        this.mInlinedOldVarStack.push(new HashSet());
        String string2 = callGraphNode.getId();
        assert (string2.equals(callStatement.getMethodName()));
        if (this.stackContainsDuplicates()) {
            throw new InliningUnsupportedException("Recursive call: " + String.valueOf(callStatement), callStatement.getLocation());
        }
        if (callStatement.isForall()) {
            throw new InliningUnsupportedException("Call forall: " + String.valueOf(callStatement), callStatement.getLocation());
        }
        Procedure procedure2 = callGraphNode.getProcedureWithSpecification();
        Specification[] specificationArray = procedure2.getSpecification();
        ArrayList<Expression[]> arrayList = new ArrayList<Expression[]>();
        ArrayList<VariableLHS[]> arrayList2 = new ArrayList<VariableLHS[]>();
        ArrayList<Expression[]> arrayList3 = new ArrayList<Expression[]>();
        ArrayList<Expression[]> arrayList4 = new ArrayList<Expression[]>();
        ArrayList<ModifiesSpecification> arrayList5 = new ArrayList<ModifiesSpecification>();
        Specification[] specificationArray2 = specificationArray;
        int n = specificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            iLocation = specificationArray2[n2];
            object4 = this.processSpecification((Specification)iLocation);
            ILocation object32 = object4.getLocation();
            boolean bl = object4.isFree();
            if (object4 instanceof RequiresSpecification) {
                object2 = ((RequiresSpecification)object4).getFormula();
                if (bl) {
                    throw new InliningUnsupportedException("Free ensures: " + String.valueOf(callStatement), callStatement.getLocation());
                }
                object = new AssertStatement(object32, (Expression)object2);
                ModelUtils.copyAnnotations((IElement)object4, (IElement)object);
                this.addBacktranslation((BoogieASTNode)object, (BoogieASTNode)iLocation);
                arrayList.add((Expression[])object);
                label = new AssumeStatement(object32, (Expression)object2);
                ModelUtils.copyAnnotations((IElement)object4, (IElement)label);
                this.addBacktranslation((BoogieASTNode)label, null);
                arrayList2.add((VariableLHS[])label);
            } else if (object4 instanceof EnsuresSpecification) {
                object2 = ((EnsuresSpecification)object4).getFormula();
                if (!bl && callGraphNode.isImplemented()) {
                    object = new AssertStatement(object32, (Expression)object2);
                    ModelUtils.copyAnnotations((IElement)object4, (IElement)object);
                    this.addBacktranslation((BoogieASTNode)object, null);
                    arrayList3.add((Expression[])object);
                }
                object = new AssumeStatement(object32, (Expression)object2);
                ModelUtils.copyAnnotations((IElement)object4, (IElement)object);
                this.addBacktranslation((BoogieASTNode)object, (BoogieASTNode)iLocation);
                arrayList4.add((Expression[])object);
            } else if (object4 instanceof ModifiesSpecification) {
                arrayList5.add((ModifiesSpecification)object4);
            }
            ++n2;
        }
        iLocation = callStatement.getLocation();
        ArrayList<Object> arrayList6 = new ArrayList<Object>();
        specificationArray2 = procedure2.getOutParams();
        if (specificationArray2.length > 0 && !(list = InlineVersionTransformer.varListsToVarLHSs((VarList[])specificationArray2, (DeclarationInformation)(object4 = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, string2)))).isEmpty()) {
            VariableLHS[] variableLHSArray2 = list.toArray(new VariableLHS[list.size()]);
            object2 = this.processStatement((Statement)new HavocStatement(iLocation, variableLHSArray2));
            this.addBacktranslation((BoogieASTNode)object2, null);
            arrayList6.add(object2);
        }
        object4 = new ArrayList();
        if (callGraphNode.isImplemented()) {
            procedure = callGraphNode.getProcedureWithBody();
            Body body = procedure.getBody();
            Statement[] statementArray = body.getBlock();
            this.mapLabels(statementArray);
            this.mapReturnLabel();
            object2 = new ArrayList();
            object = new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, string2);
            statement = body.getLocalVars();
            int n3 = ((VariableDeclaration[])statement).length;
            int n4 = 0;
            while (n4 < n3) {
                label = statement[n4];
                object2.addAll(InlineVersionTransformer.varListsToVarLHSs(label.getVariables(), (DeclarationInformation)object));
                ++n4;
            }
            if (!object2.isEmpty()) {
                label = object2.toArray(new VariableLHS[object2.size()]);
                Statement statement2 = this.processStatement((Statement)new HavocStatement(iLocation, (VariableLHS[])label));
                this.addBacktranslation((BoogieASTNode)statement2, null);
                arrayList6.add(statement2);
                object4.add(statement2);
            }
            arrayList6.addAll(this.flattenStatements(statementArray));
            label = BoogieUtils.constuctAuxiliaryLabel((ILocation)procedure.getLocation(), (String)this.getCurrentReturnLabelId());
            this.addBacktranslation((BoogieASTNode)label, null);
            arrayList6.add(label);
        } else {
            procedure = callGraphNode.getProcedureWithSpecification();
            for (ModifiesSpecification modifiesSpecification : arrayList5) {
                object2 = (ModifiesSpecification)this.processSpecification((Specification)modifiesSpecification);
                object = object2.getIdentifiers();
                if (((DeclarationInformation)object).length <= 0) continue;
                label = new HavocStatement(object2.getLocation(), (VariableLHS[])object);
                ModelUtils.copyAnnotations((IElement)object2, (IElement)label);
                this.addBacktranslation((BoogieASTNode)label, (BoogieASTNode)modifiesSpecification);
                arrayList6.add(label);
            }
        }
        ILocation iLocation2 = procedure.getLocation();
        boolean bl = procedure.getSpecification() != null;
        object2 = new ArrayList();
        if (procedure.getInParams().length > 0) {
            object = callStatement.getArguments();
            label = new VariableLHS[((Expression[])object).length];
            VarListIterator varListIterator = new VarListIterator(new VarList[][]{procedure.getInParams()});
            DeclarationInformation declarationInformation = new DeclarationInformation(bl ? DeclarationInformation.StorageClass.PROC_FUNC_INPARAM : DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, callGraphNode.getId());
            int n5 = 0;
            while (n5 < ((Expression[])object).length) {
                varListIterator.next();
                iBoogieType = varListIterator.currentVarList(0).getType().getBoogieType();
                string = varListIterator.currentId(0);
                label[n5] = new VariableLHS(procedure.getLocation(), iBoogieType, string, declarationInformation);
                ++n5;
            }
            statement = this.processStatement((Statement)new AssignmentStatement(iLocation, (LeftHandSide[])label, (Expression[])object));
            this.addBacktranslation((BoogieASTNode)statement, null);
            object2.add(statement);
            iBoogieType = this.processStatement((Statement)new HavocStatement(iLocation, (VariableLHS[])label));
            this.addBacktranslation((BoogieASTNode)iBoogieType, null);
            object4.add(iBoogieType);
        }
        object = new ArrayList();
        if (procedure.getOutParams().length > 0) {
            label = new Expression[variableLHSArray.length];
            VarListIterator varListIterator = new VarListIterator(new VarList[][]{procedure.getOutParams()});
            DeclarationInformation declarationInformation = new DeclarationInformation(bl ? DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM : DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, callGraphNode.getId());
            int n6 = 0;
            while (n6 < variableLHSArray.length) {
                varListIterator.next();
                iBoogieType = varListIterator.currentVarList(0).getType().getBoogieType();
                string = varListIterator.currentId(0);
                label[n6] = this.processExpression((Expression)new IdentifierExpression(iLocation2, iBoogieType, string, declarationInformation));
                ++n6;
            }
            statement = new AssignmentStatement(iLocation, (LeftHandSide[])variableLHSArray, (Expression[])label);
            this.addBacktranslation((BoogieASTNode)statement, null);
            object.add(statement);
        }
        label = this.mInlinedOldVarStack.pop();
        Iterator iterator = label.iterator();
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null);
        statement = new VariableLHS[label.size()];
        iBoogieType = new Expression[label.size()];
        int n7 = 0;
        while (iterator.hasNext()) {
            identifierExpression = ((IdExprWrapper)iterator.next()).getIdExpr();
            String string3 = identifierExpression.getIdentifier();
            IBoogieType iBoogieType2 = identifierExpression.getType();
            VarMapValue varMapValue = this.mVarMap.get(new VarMapKey(string3, declarationInformation, procedure.getIdentifier()));
            statement[n7] = new VariableLHS(iLocation, iBoogieType2, varMapValue.getVarId(), varMapValue.getDeclInfo());
            iBoogieType[n7] = new IdentifierExpression(iLocation, iBoogieType2, string3, declarationInformation);
            ++n7;
        }
        ArrayList<Statement> arrayList7 = new ArrayList<Statement>();
        if (((VariableDeclaration[])statement).length > 0) {
            identifierExpression = new AssignmentStatement(iLocation, (LeftHandSide[])statement, (Expression[])iBoogieType);
            this.addBacktranslation((BoogieASTNode)identifierExpression, null);
            arrayList7.add((Statement)identifierExpression);
        }
        arrayList7.add((Statement)this.getAssumeCallMarker(ATTR_PREFIX_BEGIN_INLINE + string2, iLocation, callStatement, false));
        arrayList7.addAll((Collection<Statement>)object2);
        arrayList7.addAll(arrayList);
        arrayList7.addAll(arrayList2);
        arrayList7.addAll(arrayList6);
        arrayList7.addAll(arrayList3);
        arrayList7.addAll(arrayList4);
        arrayList7.addAll((Collection<Statement>)object);
        arrayList7.addAll((Collection<Statement>)object4);
        arrayList7.add((Statement)this.getAssumeCallMarker(ATTR_PREFIX_END_INLINE + string2, iLocation, callStatement, true));
        return arrayList7;
    }

    private AssumeStatement getAssumeCallMarker(String string, ILocation iLocation, CallStatement callStatement, boolean bl) {
        AssumeStatement assumeStatement = new AssumeStatement(iLocation, new NamedAttribute[]{new NamedAttribute(iLocation, string, new Expression[0])}, (Expression)new BooleanLiteral(iLocation, true));
        if (!bl) {
            ModelUtils.copyAnnotationsFiltered((IElement)callStatement, (IElement)assumeStatement, iAnnotations -> iAnnotations instanceof Overapprox);
        }
        this.addBacktranslation((BoogieASTNode)assumeStatement, null);
        new InlinedCallAnnotation(callStatement, bl).annotate((IElement)assumeStatement);
        return assumeStatement;
    }

    private static List<VariableLHS> varListsToVarLHSs(VarList[] varListArray, DeclarationInformation declarationInformation) {
        ArrayList<VariableLHS> arrayList = new ArrayList<VariableLHS>(3 * varListArray.length);
        VarList[] varListArray2 = varListArray;
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray2[n2];
            IBoogieType iBoogieType = varList.getType().getBoogieType();
            ILocation iLocation = varList.getLocation();
            String[] stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                arrayList.add(new VariableLHS(iLocation, iBoogieType, string, declarationInformation));
                ++n4;
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    protected Statement processStatement(Statement statement) {
        Label label = null;
        if (statement instanceof Label) {
            Label label2 = (Label)statement;
            label = new Label(label2.getLocation(), this.getNewLabelId(label2.getName()), label2.getAttributes());
        } else if (statement instanceof GotoStatement) {
            GotoStatement gotoStatement = (GotoStatement)statement;
            String[] stringArray = gotoStatement.getLabels();
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = this.getNewLabelId(stringArray[n]);
                ++n;
            }
            label = new GotoStatement(gotoStatement.getLocation(), stringArray2);
        } else if (statement instanceof BreakStatement) {
            BreakStatement breakStatement = (BreakStatement)statement;
            String string = breakStatement.getLabel();
            if (string != null) {
                label = new BreakStatement(breakStatement.getLocation(), this.getNewLabelId(string));
            }
        } else if (statement instanceof ReturnStatement && !this.inEntryProcedure()) {
            label = new GotoStatement(statement.getLocation(), new String[]{this.getCurrentReturnLabelId()});
        }
        if (label == null) {
            label = super.processStatement(statement);
        } else {
            ModelUtils.copyAnnotations((IElement)statement, label);
        }
        this.addBacktranslation((BoogieASTNode)label, (BoogieASTNode)statement);
        return label;
    }

    protected LeftHandSide processLeftHandSide(LeftHandSide leftHandSide) {
        LeftHandSide leftHandSide2 = leftHandSide;
        Objects.requireNonNull(leftHandSide2);
        LeftHandSide leftHandSide3 = leftHandSide2;
        StructLHS structLHS = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableLHS.class, StructLHS.class, ArrayLHS.class}, (Object)leftHandSide3, 0)) {
            case 0 -> {
                VariableLHS var4_3 = (VariableLHS)leftHandSide3;
                DeclarationInformation var5_4 = var4_3.getDeclarationInformation();
                VarMapValue var6_5 = this.mVarMap.get(new VarMapKey(var4_3.getIdentifier(), var5_4, this.isGobalInOldExprOfProc(var5_4)));
                DeclarationInformation var7_6 = var6_5.getDeclInfo();
                yield new VariableLHS(var4_3.getLocation(), var4_3.getType(), var6_5.getVarId(), var7_6);
            }
            case 1 -> {
                StructLHS var8_7 = (StructLHS)leftHandSide3;
                LeftHandSide var9_8 = this.processLeftHandSide(var8_7.getStruct());
                yield new StructLHS(var8_7.getLocation(), var9_8, var8_7.getField());
            }
            case 2 -> {
                ArrayLHS var10_9 = (ArrayLHS)leftHandSide3;
                LeftHandSide var11_10 = this.processLeftHandSide(var10_9.getArray());
                Expression[] var12_11 = this.processExpressions(var10_9.getIndices());
                yield new ArrayLHS(leftHandSide.getLocation(), var10_9.getType(), var11_10, var12_11);
            }
            default -> throw new MatchException(null, null);
        };
        ModelUtils.copyAnnotations((IElement)leftHandSide, (IElement)structLHS);
        return structLHS;
    }

    private String getNewLabelId(String string) {
        String string2 = this.currentProcId();
        String string3 = this.mLabelMap.get(new LabelMapKey(string, string2, this.getCallCounter(string2)));
        assert (string3 != null) : "Missing mapping for Label: " + string;
        return string3;
    }

    private void mapReturnLabel() {
        String string = this.currentProcId();
        String string2 = this.mLabelIdManager.makeAndAddUniqueId(string, "returnLabel");
        this.mLabelMap.put(this.createCurrentReturnLabelKey(), string2);
    }

    private String getCurrentReturnLabelId() {
        return this.mLabelMap.get(this.createCurrentReturnLabelKey());
    }

    private LabelMapKey createCurrentReturnLabelKey() {
        String string = this.currentProcId();
        return new LabelMapKey(null, string, this.getCallCounter(string));
    }

    private void mapLabels(Statement[] statementArray) {
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            this.mapLabels(statement);
            ++n2;
        }
    }

    private void mapLabels(Statement statement) {
        if (statement instanceof WhileStatement) {
            this.mapLabels(((WhileStatement)statement).getBody());
        } else if (statement instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)statement;
            this.mapLabels(ifStatement.getThenPart());
            this.mapLabels(ifStatement.getElsePart());
        } else if (statement instanceof Label) {
            String string = this.currentProcId();
            String string2 = ((Label)statement).getName();
            String string3 = this.inEntryProcedure() ? this.mLabelIdManager.addId(string2) : this.mLabelIdManager.makeAndAddUniqueId(string, string2);
            LabelMapKey labelMapKey = new LabelMapKey(string2, string, this.getCallCounter(string));
            this.mLabelMap.put(labelMapKey, string3);
        }
    }

    @Override
    protected Expression processExpression(Expression expression) {
        Expression expression2 = null;
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            String string = identifierExpression.getIdentifier();
            DeclarationInformation declarationInformation = identifierExpression.getDeclarationInformation();
            String string2 = this.isGobalInOldExprOfProc(declarationInformation);
            if (string2 != null) {
                this.mapVariableInInlinedOldExpr(identifierExpression);
                this.updateInlinedOldVarStack(identifierExpression);
            }
            VarMapValue varMapValue = this.mVarMap.get(new VarMapKey(string, declarationInformation, string2));
            String string3 = varMapValue.getVarId();
            DeclarationInformation declarationInformation2 = varMapValue.getDeclInfo();
            expression2 = new IdentifierExpression(identifierExpression.getLocation(), identifierExpression.getType(), string3, declarationInformation2);
        } else if (expression instanceof QuantifierExpression) {
            QuantifierExpression quantifierExpression = (QuantifierExpression)expression;
            ILocation iLocation = quantifierExpression.getLocation();
            IBoogieType iBoogieType = quantifierExpression.getType();
            VarList[] varListArray = quantifierExpression.getParameters();
            Attribute[] attributeArray = quantifierExpression.getAttributes();
            Expression expression3 = quantifierExpression.getSubformula();
            this.mapVariables(quantifierExpression.getParameters(), DeclarationInformation.StorageClass.QUANTIFIED);
            VarList[] varListArray2 = this.applyMappingToVarList(varListArray, new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null));
            Attribute[] attributeArray2 = this.processAttributes(attributeArray);
            Expression expression4 = this.processExpression(expression3);
            expression2 = new QuantifierExpression(iLocation, iBoogieType, quantifierExpression.isUniversal(), quantifierExpression.getTypeParams(), varListArray2, attributeArray2, expression4);
        } else if (expression instanceof UnaryExpression && ((UnaryExpression)expression).getOperator() == UnaryExpression.Operator.OLD && !this.inEntryProcedure()) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            this.mInlinedOldExprStack.push(unaryExpression);
            expression2 = this.processExpression(unaryExpression.getExpr());
            this.mInlinedOldExprStack.pop();
        }
        if (expression2 == null) {
            expression2 = super.processExpression(expression);
        } else {
            ModelUtils.copyAnnotations((IElement)expression, expression2);
        }
        this.addBacktranslation((BoogieASTNode)expression2, (BoogieASTNode)expression);
        return expression2;
    }

    protected VarList[] applyMappingToVarList(VarList[] varListArray, DeclarationInformation declarationInformation) {
        VarList[] varListArray2 = new VarList[varListArray.length];
        boolean bl = false;
        int n = 0;
        while (n < varListArray.length) {
            VarList varList = varListArray[n];
            VarList varList2 = this.applyMappingToVarList(varList, declarationInformation);
            if (varList2 != varList) {
                bl = true;
            }
            varListArray2[n] = varList2;
            ++n;
        }
        return bl ? varListArray2 : varListArray;
    }

    private VarList applyMappingToVarList(VarList varList, DeclarationInformation declarationInformation) {
        Expression expression = varList.getWhereClause();
        Expression expression2 = expression != null ? this.processExpression(expression) : null;
        String[] stringArray = varList.getIdentifiers();
        String[] stringArray2 = this.applyMappingToVarIds(stringArray, declarationInformation);
        if (expression2 != expression || stringArray != stringArray2) {
            VarList varList2 = new VarList(varList.getLocation(), stringArray2, varList.getType(), expression2);
            ModelUtils.copyAnnotations((IElement)varList, (IElement)varList2);
            return varList2;
        }
        return varList;
    }

    private String[] applyMappingToVarIds(String[] stringArray, DeclarationInformation declarationInformation) {
        String[] stringArray2 = new String[stringArray.length];
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = this.mVarMap.get(new VarMapKey(string, declarationInformation, this.isGobalInOldExprOfProc(declarationInformation))).getVarId();
            if (!string2.equals(string)) {
                bl = true;
            }
            stringArray2[n] = string2;
            ++n;
        }
        return bl ? stringArray2 : stringArray;
    }

    @Deprecated
    protected VarList processVarList(VarList varList) {
        throw new UnsupportedOperationException("Use \"applyMappingToVarList(...)\" instead.");
    }

    private String isGobalInOldExprOfProc(DeclarationInformation declarationInformation) {
        if (declarationInformation.getStorageClass() == DeclarationInformation.StorageClass.GLOBAL && this.inInlinedOldExpr()) {
            return this.currentProcId();
        }
        return null;
    }

    private void checkTimeout() {
        if (!this.mProgressMonitorService.continueProcessing()) {
            String string = "inlining (statistic: " + String.valueOf(this.mInlinerStatistic) + ")";
            throw new ToolchainCanceledException(((Object)((Object)this)).getClass(), string);
        }
    }

    public static class GlobalScopeManager {
        private final Map<VarMapKey, VarMapValue> mVarMap = new HashMap<VarMapKey, VarMapValue>();
        private final Map<String, Declaration> mVarDecls = new HashMap<String, Declaration>();
        private final Map<String, VarList> mVarLists = new HashMap<String, VarList>();

        public GlobalScopeManager(Collection<Declaration> collection) {
            for (Declaration declaration : collection) {
                int n;
                Object object;
                VarList varList;
                ConstDeclaration constDeclaration;
                if (declaration instanceof ConstDeclaration) {
                    constDeclaration = (ConstDeclaration)declaration;
                    varList = constDeclaration.getVarList();
                    this.addVarsOrConsts(varList);
                    object = varList.getIdentifiers();
                    int n2 = ((String[])object).length;
                    n = 0;
                    while (n < n2) {
                        String string = object[n];
                        this.mVarDecls.put(string, (Declaration)constDeclaration);
                        this.mVarLists.put(string, varList);
                        ++n;
                    }
                    continue;
                }
                if (!(declaration instanceof VariableDeclaration)) continue;
                constDeclaration = (VariableDeclaration)declaration;
                VarList[] varListArray = constDeclaration.getVariables();
                n = varListArray.length;
                int n3 = 0;
                while (n3 < n) {
                    varList = varListArray[n3];
                    this.addVarsOrConsts(varList);
                    String[] stringArray = varList.getIdentifiers();
                    int n4 = stringArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        object = stringArray[n5];
                        this.mVarDecls.put((String)object, (Declaration)constDeclaration);
                        this.mVarLists.put((String)object, varList);
                        ++n5;
                    }
                    ++n3;
                }
            }
        }

        private void addVarsOrConsts(VarList varList) {
            ArrayList<String> arrayList = new ArrayList<String>();
            DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null);
            String[] stringArray = varList.getIdentifiers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                VarMapKey varMapKey = new VarMapKey(string, declarationInformation);
                VarMapValue varMapValue = new VarMapValue(string, declarationInformation);
                this.mVarMap.put(varMapKey, varMapValue);
                arrayList.add(string);
                ++n2;
            }
        }

        public Map<VarMapKey, VarMapValue> initVarMap() {
            return new HashMap<VarMapKey, VarMapValue>(this.mVarMap);
        }

        public void initVarIdManager(IdManager idManager) {
            for (VarMapKey varMapKey : this.mVarMap.keySet()) {
                idManager.addId(varMapKey.getVarId());
            }
        }

        public Declaration getVarDeclaration(String string) {
            return this.mVarDecls.get(string);
        }

        public VarList getVarListFromDeclaration(String string) {
            return this.mVarLists.get(string);
        }
    }
}

