/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.CongRewriteFunctionFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.MinimalProofChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProofSimplifier
extends TermTransformer {
    Script mSkript;
    ProofRules mProofRules;
    LogProxy mLogger;
    private final MinimalProofChecker mChecker;
    private HashMap<FunctionSymbol, LambdaTerm> mAuxDefs;
    private static final String ANNOT_PROVES_CLAUSE = ":proves";
    private static final String ANNOT_PROVED_EQ = ":provedEq";

    public ProofSimplifier(Script script) {
        this.mSkript = script;
        this.mProofRules = new ProofRules(script.getTheory());
        this.mLogger = new DefaultLogger();
        this.mChecker = new MinimalProofChecker(this.mSkript, new DefaultLogger());
    }

    private Term annotateProvedClause(Term term, Annotation annotation, ProofLiteral[] proofLiteralArray) {
        Object[] objectArray = new Object[proofLiteralArray.length * 2];
        int n = 0;
        while (n < proofLiteralArray.length) {
            objectArray[2 * n] = proofLiteralArray[n].getPolarity() ? "+" : "-";
            objectArray[2 * n + 1] = proofLiteralArray[n].getAtom();
            ++n;
        }
        return this.mSkript.annotate(term, new Annotation[]{new Annotation(ANNOT_PROVES_CLAUSE, (Object)objectArray), annotation});
    }

    private Term annotateProved(Term term, Term term2) {
        return this.mSkript.annotate(term2, new Annotation[]{new Annotation(ANNOT_PROVED_EQ, (Object)term)});
    }

    private Term provedTerm(AnnotatedTerm annotatedTerm) {
        assert (annotatedTerm.getAnnotations()[0].getKey() == ANNOT_PROVED_EQ);
        return (Term)annotatedTerm.getAnnotations()[0].getValue();
    }

    private Term stripAnnotation(Term term) {
        if (term instanceof AnnotatedTerm && ((AnnotatedTerm)term).getAnnotations()[0].getKey() == ANNOT_PROVED_EQ) {
            return ((AnnotatedTerm)term).getSubterm();
        }
        return term;
    }

    private Term subproof(AnnotatedTerm annotatedTerm) {
        assert (annotatedTerm.getAnnotations()[0].getKey() == ANNOT_PROVED_EQ);
        return annotatedTerm.getSubterm();
    }

    private boolean checkProof(Term term, ProofLiteral[] proofLiteralArray) {
        ProofLiteral[] proofLiteralArray2 = this.mChecker.getProvedClause(this.mAuxDefs, term);
        HashSet<ProofLiteral> hashSet = new HashSet<ProofLiteral>();
        hashSet.addAll(Arrays.asList(proofLiteralArray));
        assert (hashSet.size() == proofLiteralArray2.length);
        ProofLiteral[] proofLiteralArray3 = proofLiteralArray2;
        int n = proofLiteralArray2.length;
        int n2 = 0;
        while (n2 < n) {
            ProofLiteral proofLiteral = proofLiteralArray3[n2];
            assert (hashSet.contains(proofLiteral));
            ++n2;
        }
        return true;
    }

    private Term removeNot(Term term, Term term2, boolean bl) {
        while (this.isApplication("not", term2)) {
            term = this.mProofRules.resolutionRule(term2, bl ? term : this.mProofRules.notIntro(term2), bl ? this.mProofRules.notElim(term2) : term);
            term2 = ((ApplicationTerm)term2).getParameters()[0];
            boolean bl2 = bl = !bl;
        }
        return term;
    }

    private Term convertTermITE(ProofLiteral[] proofLiteralArray) {
        ProofLiteral proofLiteral;
        int n;
        Term term;
        int n2 = proofLiteralArray.length - 1;
        assert (proofLiteralArray[n2].getPolarity() && this.isApplication("=", proofLiteralArray[n2].getAtom()));
        ApplicationTerm applicationTerm = (ApplicationTerm)proofLiteralArray[n2].getAtom();
        Term term2 = applicationTerm.getParameters()[0];
        Term term3 = applicationTerm.getParameters()[1];
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        HashMap<Term, ProofLiteral> hashMap = new HashMap<Term, ProofLiteral>();
        int n3 = 0;
        while (n3 < proofLiteralArray.length - 1) {
            hashMap.put(proofLiteralArray[n3].getAtom(), proofLiteralArray[n3]);
            ++n3;
        }
        while (term2 != term3) {
            assert (this.isApplication("ite", term2));
            arrayList.add(term2);
            Term[] termArray = ((ApplicationTerm)term2).getParameters();
            term = termArray[0];
            n = 1;
            while (this.isApplication("not", term)) {
                term = ((ApplicationTerm)term).getParameters()[0];
                int n4 = n = n != 0 ? 0 : 1;
            }
            proofLiteral = (ProofLiteral)hashMap.get(term);
            if (n == proofLiteral.getPolarity()) {
                arrayList2.add(this.removeNot(this.mProofRules.ite2(term2), termArray[0], true));
                term2 = termArray[2];
                continue;
            }
            arrayList2.add(this.removeNot(this.mProofRules.ite1(term2), termArray[0], false));
            term2 = termArray[1];
        }
        assert (term2 == term3);
        if (arrayList2.size() > 1) {
            Theory theory = term3.getTheory();
            arrayList.add(term3);
            term = this.mProofRules.trans(arrayList.toArray(new Term[arrayList.size()]));
            n = 0;
            while (n < arrayList2.size()) {
                proofLiteral = theory.term("=", new Term[]{(Term)arrayList.get(n), (Term)arrayList.get(n + 1)});
                term = this.mProofRules.resolutionRule((Term)proofLiteral, (Term)arrayList2.get(n), term);
                ++n;
            }
            return term;
        }
        assert (arrayList2.size() == 1);
        return (Term)arrayList2.get(0);
    }

    private boolean checkIteinIteBound(Polynomial polynomial, ApplicationTerm applicationTerm, Rational rational) {
        assert (this.isApplication("ite", (Term)applicationTerm));
        Term[] termArray = applicationTerm.getParameters();
        boolean bl = false;
        HashSet<Term> hashSet = new HashSet<Term>();
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>();
        arrayDeque.add(termArray[2]);
        arrayDeque.add(termArray[1]);
        while (!arrayDeque.isEmpty()) {
            Term term = (Term)arrayDeque.removeLast();
            if (!hashSet.add(term)) continue;
            if (this.isApplication("ite", term)) {
                termArray = ((ApplicationTerm)term).getParameters();
                arrayDeque.addLast(termArray[1]);
                arrayDeque.addLast(termArray[2]);
                continue;
            }
            Polynomial polynomial2 = new Polynomial(term);
            polynomial2.add(Rational.MONE, (Term)applicationTerm);
            polynomial2.mul(rational);
            polynomial2.add(Rational.ONE, polynomial);
            if (!polynomial2.isConstant() || polynomial2.getConstant().signum() > 0) {
                return false;
            }
            if (polynomial2.getConstant().signum() != 0) continue;
            bl = true;
        }
        return bl;
    }

    private ApplicationTerm findAndCheckIteinIteBound(Polynomial polynomial) {
        for (Map.Entry<Map<Term, Integer>, Rational> entry : polynomial.getSummands().entrySet()) {
            ApplicationTerm applicationTerm;
            Term term;
            if (entry.getKey().size() != 1 || entry.getKey().values().iterator().next() != 1 || !this.isApplication("ite", term = entry.getKey().keySet().iterator().next()) || entry.getValue().abs() != Rational.ONE || !this.checkIteinIteBound(polynomial, applicationTerm = (ApplicationTerm)term, entry.getValue())) continue;
            return applicationTerm;
        }
        throw new AssertionError();
    }

    private Term proveIteEqualsLeafs(ApplicationTerm applicationTerm, Set<Term> set) {
        assert (this.isApplication("ite", (Term)applicationTerm));
        Theory theory = applicationTerm.getTheory();
        Term[] termArray = applicationTerm.getParameters();
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>();
        ArrayDeque<ApplicationTerm> arrayDeque2 = new ArrayDeque<ApplicationTerm>();
        HashSet<Term> hashSet = new HashSet<Term>();
        Term term = this.res(termArray[0], this.mProofRules.ite2((Term)applicationTerm), this.mProofRules.ite1((Term)applicationTerm));
        arrayDeque.add(termArray[2]);
        arrayDeque.add(termArray[1]);
        while (!arrayDeque.isEmpty()) {
            Term term2 = (Term)arrayDeque.removeLast();
            if (hashSet.contains(term2)) continue;
            if (this.isApplication("ite", term2)) {
                ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
                termArray = applicationTerm2.getParameters();
                if (!hashSet.contains(termArray[1]) || !hashSet.contains(termArray[2])) {
                    arrayDeque.addLast(term2);
                    arrayDeque.addLast(termArray[1]);
                    arrayDeque.addLast(termArray[2]);
                    continue;
                }
                arrayDeque2.addFirst(applicationTerm2);
                hashSet.add(term2);
                continue;
            }
            set.add(term2);
            hashSet.add(term2);
        }
        for (ApplicationTerm applicationTerm3 : arrayDeque2) {
            termArray = applicationTerm3.getParameters();
            Term term2 = this.res(termArray[0], this.mProofRules.ite2((Term)applicationTerm3), this.mProofRules.ite1((Term)applicationTerm3));
            int n = 1;
            while (n < 3) {
                Term term3 = theory.term("=", new Term[]{applicationTerm3, termArray[n]});
                term2 = this.res(term3, term2, this.mProofRules.trans(new Term[]{applicationTerm, applicationTerm3, termArray[n]}));
                ++n;
            }
            Term term4 = theory.term("=", new Term[]{applicationTerm, applicationTerm3});
            term = this.res(term4, term, term2);
        }
        return term;
    }

    private Term convertTermITEBound(ProofLiteral[] proofLiteralArray) {
        assert (proofLiteralArray.length == 1 && proofLiteralArray[0].getPolarity() && this.isApplication("<=", proofLiteralArray[0].getAtom()));
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        Term[] termArray = ((ApplicationTerm)proofLiteralArray[0].getAtom()).getParameters();
        assert (termArray.length == 2 && this.isZero(termArray[1]));
        Polynomial polynomial = new Polynomial(termArray[0]);
        ApplicationTerm applicationTerm = this.findAndCheckIteinIteBound(polynomial);
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        LinkedHashSet<Term> linkedHashSet2 = new LinkedHashSet<Term>();
        Term term = this.proveIteEqualsLeafs(applicationTerm, linkedHashSet);
        Sort sort = applicationTerm.getSort();
        FunctionSymbol functionSymbol = theory.getFunctionWithResult("<", null, null, new Sort[]{sort, sort});
        int n = -1;
        Term[] termArray2 = null;
        boolean bl = false;
        if (this.isApplication("+", termArray[0])) {
            termArray2 = ((ApplicationTerm)termArray[0]).getParameters();
            int n2 = 0;
            while (n2 < termArray2.length) {
                Object object;
                if (termArray2[n2] == applicationTerm) {
                    n = n2;
                    break;
                }
                if (this.isApplication("*", termArray2[n2]) && ((Term[])(object = ((ApplicationTerm)termArray2[n2]).getParameters())).length == 2 && object[1] == applicationTerm) {
                    n = n2;
                    bl = true;
                    break;
                }
                ++n2;
            }
            assert (n >= 0);
        } else if (termArray[0] != applicationTerm) {
            bl = true;
        }
        for (Term term2 : linkedHashSet) {
            Term term3;
            Term term4;
            Term[] termArray3;
            Term[] termArray4;
            Term term5 = theory.term("=", new Term[]{applicationTerm, term2});
            Polynomial polynomial2 = new Polynomial(term2);
            Term term6 = term2;
            if (bl) {
                termArray4 = (Term[])(n >= 0 ? termArray2[n] : termArray[0]);
                termArray3 = termArray4.getParameters();
                term4 = (Term)termArray3.clone();
                term4[1] = term2;
                term = this.res(term5, term, this.mProofRules.cong(termArray4.getFunction(), termArray3, (Term[])term4));
                term3 = theory.term(termArray4.getFunction(), (Term[])term4);
                linkedHashSet2.add(termArray3[0]);
                polynomial2.mul(new Polynomial(term4[0]));
                term6 = polynomial2.toTerm(term2.getSort());
                if (term3 != term6) {
                    term = this.res(theory.term("=", new Term[]{termArray4, term3}), term, this.res(theory.term("=", new Term[]{term3, term6}), this.mProofRules.polyMul(term3, term6), this.mProofRules.trans(termArray4, term3, term6)));
                }
                term5 = theory.term("=", new Term[]{termArray4, term6});
            }
            if (n >= 0) {
                termArray4 = ((ApplicationTerm)termArray[0]).getFunction();
                termArray3 = (Term[])termArray2.clone();
                termArray3[n] = term6;
                term4 = theory.term((FunctionSymbol)termArray4, termArray3);
                term = this.res(term5, term, this.mProofRules.cong((FunctionSymbol)termArray4, termArray2, termArray3));
                polynomial2 = new Polynomial();
                int n3 = 0;
                while (n3 < termArray3.length) {
                    polynomial2.add(Rational.ONE, termArray3[n3]);
                    if (n3 != n) {
                        linkedHashSet2.add(termArray3[n3]);
                    }
                    ++n3;
                }
                term6 = polynomial2.toTerm(term2.getSort());
                if (term4 != term6) {
                    term = this.res(theory.term("=", new Term[]{termArray[0], term4}), term, this.res(theory.term("=", new Term[]{term4, term6}), this.mProofRules.polyAdd(term4, term6), this.mProofRules.trans(termArray[0], term4, term6)));
                }
                term5 = theory.term("=", new Term[]{termArray[0], term6});
            }
            termArray4 = new Term[]{termArray[1], termArray[0]};
            termArray3 = new Term[]{termArray[1], term6};
            term = this.res(term5, term, this.mProofRules.cong(functionSymbol, termArray4, termArray3));
            linkedHashSet2.add(termArray[1]);
            term4 = theory.term(functionSymbol, termArray4);
            term3 = theory.term(functionSymbol, termArray3);
            Term term7 = theory.term("=", new Term[]{term4, term3});
            term = this.res(term7, term, this.mProofRules.iffElim2(term7));
            term = this.res(term3, term, this.mProofRules.farkas(new Term[]{term3}, new BigInteger[]{BigInteger.ONE}));
        }
        term = this.res(theory.term(functionSymbol, new Term[]{termArray[1], termArray[0]}), this.mProofRules.total(termArray[0], termArray[1]), term);
        for (Term term8 : linkedHashSet2) {
            term = this.res(theory.term("=", new Term[]{term8, term8}), this.mProofRules.refl(term8), term);
        }
        return term;
    }

    private Term convertTautQuantSkolemize(ProofLiteral[] proofLiteralArray, Term[] termArray, boolean bl) {
        assert (proofLiteralArray.length == 2);
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)proofLiteralArray[0].getAtom();
        assert (bl == proofLiteralArray[0].getPolarity());
        assert (quantifiedFormula.getQuantifier() == (bl ? 1 : 0));
        Theory theory = quantifiedFormula.getTheory();
        TermVariable[] termVariableArray = quantifiedFormula.getVariables();
        Sort[] sortArray = new Sort[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            sortArray[n] = termVariableArray[n].getSort();
            ++n;
        }
        theory.push();
        FunctionSymbol functionSymbol = theory.declareInternalFunction("@quantbody", sortArray, quantifiedFormula.getFreeVars(), quantifiedFormula.getSubformula(), 64);
        Term[] termArray2 = this.mProofRules.getSkolemVars(termVariableArray, quantifiedFormula.getSubformula(), bl);
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        Term term = formulaUnLet.unlet(this.mSkript.let(termVariableArray, termArray2, quantifiedFormula.getSubformula()));
        Term term2 = theory.term(functionSymbol, termArray2);
        Term term3 = theory.term(functionSymbol, termArray);
        Term term4 = formulaUnLet.unlet(this.mSkript.let(termVariableArray, termArray, quantifiedFormula.getSubformula()));
        Term term5 = this.res(theory.term("=", new Term[]{term3, term4}), this.mProofRules.expand(term3), this.res(theory.term("=", new Term[]{term4, term3}), this.mProofRules.symm(term4, term3), this.res(theory.term("=", new Term[]{term3, term2}), this.mProofRules.cong(functionSymbol, termArray, termArray2), this.res(theory.term("=", new Term[]{term2, term}), this.mProofRules.expand(term2), this.mProofRules.trans(term4, term3, term2, term)))));
        int n2 = 0;
        while (n2 < termArray2.length) {
            term5 = this.res(theory.term("=", new Term[]{termArray[n2], termArray2[n2]}), this.mProofRules.expand(termArray[n2]), term5);
            ++n2;
        }
        Term term6 = theory.term("=", new Term[]{term4, term});
        Term term7 = bl ? this.res(term, this.mProofRules.iffElim2(term6), this.mProofRules.forallIntro(quantifiedFormula)) : this.res(term, this.mProofRules.existsElim(quantifiedFormula), this.mProofRules.iffElim1(term6));
        term7 = this.res(term6, term5, term7);
        term7 = this.mProofRules.defineFun(functionSymbol, theory.lambda(termVariableArray, quantifiedFormula.getSubformula()), term7);
        theory.pop();
        return this.removeNot(term7, term4, !bl);
    }

    private Term convertTautForallElim(ProofLiteral[] proofLiteralArray, Term[] termArray) {
        assert (proofLiteralArray.length == 2 && !proofLiteralArray[0].getPolarity());
        Term term = proofLiteralArray[0].getAtom();
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
        assert (quantifiedFormula.getQuantifier() == 1);
        TermVariable[] termVariableArray = quantifiedFormula.getVariables();
        assert (termVariableArray.length == termArray.length);
        Term term2 = this.mProofRules.forallElim(termArray, quantifiedFormula);
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        Term term3 = formulaUnLet.unlet(this.mSkript.let(termVariableArray, termArray, quantifiedFormula.getSubformula()));
        term2 = this.removeNot(term2, term3, true);
        return term2;
    }

    private Term convertTautExistsIntro(ProofLiteral[] proofLiteralArray, Term[] termArray) {
        assert (proofLiteralArray.length == 2 && proofLiteralArray[0].getPolarity());
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)proofLiteralArray[0].getAtom();
        assert (quantifiedFormula.getQuantifier() == 0);
        TermVariable[] termVariableArray = quantifiedFormula.getVariables();
        assert (termVariableArray.length == termArray.length);
        Term term = this.mProofRules.existsIntro(termArray, quantifiedFormula);
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        Term term2 = formulaUnLet.unlet(this.mSkript.let(termVariableArray, termArray, quantifiedFormula.getSubformula()));
        term = this.removeNot(term, term2, false);
        return term;
    }

    private Term convertTautIte1Helper(Term term, Term term2, boolean bl) {
        Term term3 = term.getTheory().term("=", new Term[]{term, term2});
        Term term4 = this.mProofRules.resolutionRule(term3, this.mProofRules.ite1(term), bl ? this.mProofRules.iffElim1(term3) : this.mProofRules.iffElim2(term3));
        return this.removeNot(term4, term2, !bl);
    }

    private Term convertTautIte2Helper(Term term, Term term2, boolean bl) {
        Term term3 = term.getTheory().term("=", new Term[]{term, term2});
        Term term4 = this.mProofRules.resolutionRule(term3, this.mProofRules.ite2(term), bl ? this.mProofRules.iffElim1(term3) : this.mProofRules.iffElim2(term3));
        return this.removeNot(term4, term2, !bl);
    }

    private Term convertTautExcludedMiddle(String string, ProofLiteral[] proofLiteralArray) {
        Term term;
        Term term2;
        assert (proofLiteralArray.length == 2);
        boolean bl = string == ":excludedMiddle1";
        Term term3 = proofLiteralArray[0].getAtom();
        assert (proofLiteralArray[0].getPolarity() && this.isApplication("=", term3));
        Term[] termArray = ((ApplicationTerm)term3).getParameters();
        boolean bl2 = this.isAuxApplication(termArray[0]);
        Term term4 = term2 = bl2 ? this.expandAux((ApplicationTerm)termArray[0]) : termArray[0];
        assert (termArray.length == 2 && this.isApplication(bl ? "true" : "false", termArray[1]));
        Term term5 = term = bl ? this.mProofRules.resolutionRule(termArray[1], this.mProofRules.trueIntro(), this.mProofRules.iffIntro2(term3)) : this.mProofRules.resolutionRule(termArray[1], this.mProofRules.iffIntro1(term3), this.mProofRules.falseElim());
        if (bl2) {
            Term term6 = this.mSkript.term("=", new Term[]{termArray[0], term2});
            Term term7 = this.mProofRules.expand(termArray[0]);
            term = bl ? this.res(termArray[0], this.res(term6, term7, this.mProofRules.iffElim1(term6)), term) : this.res(termArray[0], term, this.res(term6, term7, this.mProofRules.iffElim2(term6)));
        }
        term = this.removeNot(term, term2, !bl);
        return term;
    }

    private boolean isSkolem(Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
            return functionSymbol.isIntern() && functionSymbol.getName().startsWith("@skolem");
        }
        return false;
    }

    private boolean isAuxApplication(Term term) {
        if (term instanceof ApplicationTerm) {
            FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
            return functionSymbol.isIntern() && functionSymbol.getName().startsWith("@AUX");
        }
        return false;
    }

    private int findArgPosition(ProofLiteral proofLiteral, Term[] termArray, boolean bl) {
        int n = 0;
        while (n < termArray.length) {
            Term term = termArray[n];
            boolean bl2 = true;
            while (this.isApplication("not", term)) {
                term = ((ApplicationTerm)term).getParameters()[0];
                boolean bl3 = bl2 = !bl2;
            }
            if (bl && n == termArray.length - 1) {
                boolean bl4 = bl2 = !bl2;
            }
            if (term == proofLiteral.getAtom() && bl2 == proofLiteral.getPolarity()) {
                return n;
            }
            ++n;
        }
        throw new AssertionError();
    }

    private Term convertTautElimIntro(String string, ProofLiteral[] proofLiteralArray) {
        Term term;
        ApplicationTerm applicationTerm;
        boolean bl;
        boolean bl2 = string.contains("-");
        ApplicationTerm applicationTerm2 = (ApplicationTerm)proofLiteralArray[0].getAtom();
        boolean bl3 = bl = proofLiteralArray[0].getPolarity() && this.isApplication("=", (Term)applicationTerm2);
        if (bl) {
            assert (this.isApplication(bl2 ? "false" : "true", applicationTerm2.getParameters()[1]));
            applicationTerm = (ApplicationTerm)this.expandAuxDef(applicationTerm2);
        } else {
            assert (bl2 != proofLiteralArray[0].getPolarity());
            applicationTerm = applicationTerm2;
        }
        assert (string.startsWith(":" + applicationTerm.getFunction().getName()));
        Term[] termArray = applicationTerm.getParameters();
        switch (string) {
            case ":or+": {
                assert (proofLiteralArray.length == 2);
                int n = this.findArgPosition(proofLiteralArray[1].negate(), termArray, false);
                term = this.mProofRules.orIntro(n, (Term)applicationTerm);
                term = this.removeNot(term, termArray[n], false);
                break;
            }
            case ":or-": {
                term = this.mProofRules.orElim((Term)applicationTerm);
                int n = 0;
                while (n < termArray.length) {
                    term = this.removeNot(term, termArray[n], true);
                    ++n;
                }
                break;
            }
            case ":and+": {
                term = this.mProofRules.andIntro((Term)applicationTerm);
                int n = 0;
                while (n < termArray.length) {
                    term = this.removeNot(term, termArray[n], false);
                    ++n;
                }
                break;
            }
            case ":and-": {
                assert (proofLiteralArray.length == 2);
                int n = this.findArgPosition(proofLiteralArray[1], termArray, false);
                term = this.mProofRules.andElim(n, (Term)applicationTerm);
                term = this.removeNot(term, termArray[n], true);
                break;
            }
            case ":=>+": {
                assert (proofLiteralArray.length == 2);
                int n = termArray.length - 1;
                int n2 = this.findArgPosition(proofLiteralArray[1], termArray, true);
                term = this.mProofRules.impIntro(n2, (Term)applicationTerm);
                term = this.removeNot(term, termArray[n2], n2 != n);
                break;
            }
            case ":=>-": {
                term = this.mProofRules.impElim((Term)applicationTerm);
                int n = 0;
                while (n < termArray.length) {
                    term = this.removeNot(term, termArray[n], n == termArray.length - 1);
                    ++n;
                }
                break;
            }
            case ":xor+1": {
                term = this.mProofRules.xorIntro(termArray, new Term[]{termArray[0]}, new Term[]{termArray[1]});
                term = this.removeNot(term, termArray[0], true);
                term = this.removeNot(term, termArray[1], false);
                break;
            }
            case ":xor+2": {
                term = this.mProofRules.xorIntro(termArray, new Term[]{termArray[1]}, new Term[]{termArray[0]});
                term = this.removeNot(term, termArray[0], false);
                term = this.removeNot(term, termArray[1], true);
                break;
            }
            case ":xor-1": {
                term = this.mProofRules.xorIntro(new Term[]{termArray[0]}, new Term[]{termArray[1]}, termArray);
                term = this.removeNot(term, termArray[0], true);
                term = this.removeNot(term, termArray[1], true);
                break;
            }
            case ":xor-2": {
                term = this.mProofRules.xorElim(termArray, new Term[]{termArray[0]}, new Term[]{termArray[1]});
                term = this.removeNot(term, termArray[0], false);
                term = this.removeNot(term, termArray[1], false);
                break;
            }
            case ":ite+1": {
                term = this.removeNot(this.convertTautIte1Helper((Term)applicationTerm, termArray[1], true), termArray[0], false);
                break;
            }
            case ":ite+2": {
                term = this.removeNot(this.convertTautIte2Helper((Term)applicationTerm, termArray[2], true), termArray[0], true);
                break;
            }
            case ":ite+red": {
                term = this.mProofRules.resolutionRule(termArray[0], this.convertTautIte2Helper((Term)applicationTerm, termArray[2], true), this.convertTautIte1Helper((Term)applicationTerm, termArray[1], true));
                break;
            }
            case ":ite-1": {
                term = this.removeNot(this.convertTautIte1Helper((Term)applicationTerm, termArray[1], false), termArray[0], false);
                break;
            }
            case ":ite-2": {
                term = this.removeNot(this.convertTautIte2Helper((Term)applicationTerm, termArray[2], false), termArray[0], true);
                break;
            }
            case ":ite-red": {
                term = this.mProofRules.resolutionRule(termArray[0], this.convertTautIte2Helper((Term)applicationTerm, termArray[2], false), this.convertTautIte1Helper((Term)applicationTerm, termArray[1], false));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (bl) {
            String string2 = this.mSkript.term("=", new Term[]{applicationTerm2, applicationTerm});
            if (bl2) {
                term = this.mProofRules.resolutionRule((Term)applicationTerm, this.proveAuxElim(applicationTerm2, (Term)applicationTerm), term);
            } else {
                term = this.mProofRules.resolutionRule((Term)applicationTerm, term, this.mProofRules.iffElim1((Term)string2));
                term = this.mProofRules.resolutionRule((Term)string2, this.proveAuxExpand(applicationTerm2, (Term)applicationTerm), term);
            }
        }
        return term;
    }

    private Term convertTautStore(ProofLiteral[] proofLiteralArray) {
        assert (proofLiteralArray.length == 1 && proofLiteralArray[0].getPolarity());
        Term term = proofLiteralArray[0].getAtom();
        assert (this.isApplication("=", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        assert (this.isApplication("select", termArray[0]));
        ApplicationTerm applicationTerm = (ApplicationTerm)termArray[0];
        Term term2 = applicationTerm.getParameters()[0];
        assert (this.isApplication("store", term2));
        Term[] termArray2 = ((ApplicationTerm)term2).getParameters();
        assert (termArray2[1] == applicationTerm.getParameters()[1] && termArray2[2] == termArray[1]);
        return this.mProofRules.selectStore1(termArray2[0], termArray2[1], termArray2[2]);
    }

    private Term convertTautDiff(ProofLiteral[] proofLiteralArray) {
        assert (proofLiteralArray.length == 2 && proofLiteralArray[0].getPolarity());
        Term term = proofLiteralArray[0].getAtom();
        assert (this.isApplication("=", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        return this.mProofRules.extDiff(termArray[0], termArray[1]);
    }

    private Term convertTautModulo(ProofLiteral[] proofLiteralArray) {
        Term term;
        Term term2;
        Term term3;
        assert (proofLiteralArray.length == 2);
        assert (proofLiteralArray[0].getPolarity());
        assert (proofLiteralArray[1].getPolarity());
        Term term4 = proofLiteralArray[1].getAtom();
        Theory theory = term4.getTheory();
        assert (this.isApplication("=", term4));
        Term term5 = ((ApplicationTerm)term4).getParameters()[0];
        assert (this.isApplication("mod", term5));
        Term term6 = ((ApplicationTerm)term5).getParameters()[1];
        Term term7 = ((ApplicationTerm)term5).getParameters()[0];
        assert (this.isApplication("=", proofLiteralArray[0].getAtom()) && term6 == ((ApplicationTerm)proofLiteralArray[0].getAtom()).getParameters()[0] && this.isZero(((ApplicationTerm)proofLiteralArray[0].getAtom()).getParameters()[1]));
        Sort sort = term7.getSort();
        Term term8 = theory.term("div", new Term[]{term7, term6});
        Term term9 = theory.term("*", new Term[]{term6, term8});
        Polynomial polynomial = new Polynomial(term6);
        polynomial.mul(new Polynomial(term8));
        Term term10 = polynomial.toTerm(sort);
        polynomial.add(Rational.ONE, new Polynomial(term5));
        Term term11 = polynomial.toTerm(sort);
        Term term12 = theory.term("+", new Term[]{term9, term5});
        Term term13 = this.mProofRules.modDef(term7, term6);
        if (term11 != term12) {
            term3 = theory.term("=", new Term[]{term12, term11});
            if (term10 != term9) {
                term2 = theory.term("=", new Term[]{term9, term10});
                Term term14 = this.mProofRules.polyMul(term9, term10);
                Term term15 = theory.term("+", new Term[]{term10, term5});
                term = this.res(term2, term14, this.mProofRules.cong(term12, term15));
                term = this.res(theory.term("=", new Term[]{term5, term5}), this.mProofRules.refl(term5), term);
                if (term15 != term11) {
                    Term term16 = theory.term("=", new Term[]{term12, term15});
                    Term term17 = theory.term("=", new Term[]{term15, term11});
                    term = this.res(term16, term, this.res(term17, this.mProofRules.polyAdd(term15, term11), this.mProofRules.trans(term12, term15, term11)));
                }
            } else {
                term = this.mProofRules.polyAdd(term12, term11);
            }
            term2 = theory.term("=", new Term[]{term11, term12});
            term13 = this.res(theory.term("=", new Term[]{term12, term7}), term13, this.res(term2, this.res(term3, term, this.mProofRules.symm(term11, term12)), this.mProofRules.trans(term11, term12, term7)));
        }
        term = new Term[]{term11, term7};
        term3 = theory.term("=", (Term[])term);
        term2 = this.proveEqWithMultiplier((Term[])term, ((ApplicationTerm)term4).getParameters(), Rational.ONE);
        return this.res(term3, term13, term2);
    }

    private Term convertTautLowHigh(Term term, String string, ProofLiteral[] proofLiteralArray) {
        String string2;
        Term term2;
        Term term3;
        Term term4;
        Term term5;
        Term term6;
        Term term7;
        Term term8;
        Term term9;
        Term term10;
        Term term11;
        Term term12;
        Term term13;
        Polynomial polynomial;
        Term term14 = proofLiteralArray[proofLiteralArray.length - 1].getAtom();
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        boolean bl = string.startsWith(":toInt");
        boolean bl2 = string.endsWith("High");
        assert (proofLiteralArray[proofLiteralArray.length - 1].getPolarity() != bl2);
        Term[] termArray = ((ApplicationTerm)term14).getParameters();
        Polynomial polynomial2 = new Polynomial(termArray[0]);
        assert (this.isZero(termArray[1]));
        assert (termArray[0].getSort().getName() == (bl ? "Real" : "Int"));
        Term[] termArray2 = ((ApplicationTerm)term).getParameters();
        Polynomial polynomial3 = new Polynomial(term);
        if (bl) {
            polynomial = new Polynomial();
            polynomial.add(Rational.ONE);
        } else {
            polynomial = new Polynomial(termArray2[1]);
            polynomial3.mul(polynomial);
        }
        boolean bl3 = false;
        Polynomial polynomial4 = new Polynomial(termArray2[0]);
        polynomial4.mul(Rational.MONE);
        polynomial4.add(Rational.ONE, polynomial3);
        if (bl2) {
            if (polynomial.isConstant()) {
                bl3 = polynomial.getConstant().signum() < 0;
                polynomial4.add(bl3 ? Rational.MONE : Rational.ONE, polynomial);
            } else {
                polynomial4.add(Rational.MONE, polynomial);
                bl3 = polynomial2.equals(polynomial4);
                if (!bl3) {
                    polynomial4.add(Rational.TWO, polynomial);
                }
            }
        }
        assert (polynomial2.equals(polynomial4));
        switch (string) {
            case ":toIntLow": {
                term13 = theory.term("<=", new Term[]{theory.term("to_real", new Term[]{term}), termArray2[0]});
                term12 = this.mProofRules.toIntLow(termArray2[0]);
                break;
            }
            case ":toIntHigh": {
                term13 = theory.term("<", new Term[]{termArray2[0], theory.term("+", new Term[]{theory.term("to_real", new Term[]{term}), Rational.ONE.toTerm(termArray2[0].getSort())})});
                term12 = this.mProofRules.toIntHigh(termArray2[0]);
                break;
            }
            case ":divLow": {
                term11 = theory.term("*", new Term[]{termArray2[1], term});
                term13 = theory.term("<=", new Term[]{term11, termArray2[0]});
                term12 = this.mProofRules.divLow(termArray2[0], termArray2[1]);
                term10 = polynomial3.toTerm(term11.getSort());
                if (term11 != term10) {
                    term9 = this.mProofRules.polyMul(term11, term10);
                    term8 = theory.term("<=", new Term[]{term10, termArray2[0]});
                    term7 = theory.term("=", new Term[]{term13, term8});
                    term6 = this.res(theory.term("=", new Term[]{term11, term10}), term9, this.res(theory.term("=", new Term[]{termArray2[0], termArray2[0]}), this.mProofRules.refl(termArray2[0]), this.mProofRules.cong(term13, term8)));
                    term12 = this.res(term13, term12, this.res(term7, term6, this.mProofRules.iffElim2(term7)));
                    term13 = term8;
                }
                if (!polynomial.isConstant()) break;
                term9 = Rational.ZERO.toTerm(termArray2[1].getSort());
                term12 = this.res(theory.term("=", new Term[]{termArray2[1], term9}), term12, this.proveTrivialDisequality(termArray2[1], term9));
                break;
            }
            case ":divHigh": {
                term11 = theory.term("abs", new Term[]{termArray2[1]});
                term10 = theory.term("*", new Term[]{termArray2[1], term});
                term9 = theory.term("+", new Term[]{term10, term11});
                term13 = theory.term("<", new Term[]{termArray2[0], term9});
                term12 = this.mProofRules.divHigh(termArray2[0], termArray2[1]);
                term8 = polynomial3.toTerm(term10.getSort());
                polynomial3.add(Rational.ONE, term11);
                term7 = polynomial3.toTerm(term9.getSort());
                if (term9 != term7) {
                    term6 = theory.term("+", new Term[]{term8, term11});
                    term5 = this.mProofRules.polyMul(term10, term8);
                    term4 = this.res(theory.term("=", new Term[]{term10, term8}), term5, this.res(theory.term("=", new Term[]{term11, term11}), this.mProofRules.refl(term11), this.mProofRules.cong(term9, term6)));
                    if (term6 != term7) {
                        term3 = this.mProofRules.polyAdd(term6, term7);
                        term2 = this.mProofRules.trans(term9, term6, term7);
                        term4 = this.res(theory.term("=", new Term[]{term9, term6}), term4, this.res(theory.term("=", new Term[]{term6, term7}), term3, term2));
                    }
                    term3 = theory.term("<", new Term[]{termArray2[0], term7});
                    term2 = theory.term("=", new Term[]{term13, term3});
                    Term term15 = this.res(theory.term("=", new Term[]{term9, term7}), term4, this.res(theory.term("=", new Term[]{termArray2[0], termArray2[0]}), this.mProofRules.refl(termArray2[0]), this.mProofRules.cong(term13, term3)));
                    term12 = this.res(term13, term12, this.res(term2, term15, this.mProofRules.iffElim2(term2)));
                    term13 = term3;
                }
                if (!polynomial.isConstant()) break;
                term6 = Rational.ZERO.toTerm(termArray2[1].getSort());
                term12 = this.res(theory.term("=", new Term[]{termArray2[1], term6}), term12, this.proveTrivialDisequality(termArray2[1], term6));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Object object = string2 = bl2 ? term14 : theory.term("<", new Term[]{termArray[1], termArray[0]});
        if (string.equals(":divHigh")) {
            term11 = polynomial.getConstant();
            term10 = theory.term("abs", new Term[]{termArray2[1]});
            if (bl3) {
                polynomial.mul(Rational.MONE);
                term9 = polynomial.toTerm(term.getSort());
            } else {
                term9 = termArray2[1];
            }
            term8 = theory.term("=", new Term[]{term10, term9});
            term12 = this.res(term13, term12, this.mProofRules.farkas(new Term[]{string2, term13, term8}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE, BigInteger.ONE}));
            if (polynomial.isConstant()) {
                term12 = this.res(theory.term("=", new Term[]{term10, term9}), this.proveAbsConstant((Rational)term11, termArray2[1].getSort()), term12);
            } else {
                term12 = this.res(theory.term("=", new Term[]{term10, term9}), this.proveAbsEquality(termArray2[1], term9), term12);
                term7 = Rational.ZERO.toTerm(termArray2[1].getSort());
                term6 = theory.term("<", new Term[]{termArray2[1], term7});
                term5 = theory.term("=", new Term[]{termArray2[1], term7});
                if (bl3) {
                    term4 = proofLiteralArray[0].getAtom();
                    assert (proofLiteralArray.length == 2 && !proofLiteralArray[0].getPolarity());
                    term12 = this.res(term6, this.mProofRules.total(term7, termArray2[1]), term12);
                    term12 = this.res(term5, term12, this.mProofRules.symm(term7, termArray2[1]));
                    term3 = theory.term("<=", new Term[]{term7, termArray2[1]});
                    term2 = theory.term("=", new Term[]{term7, termArray2[1]});
                    term12 = this.res(term3, term12, this.mProofRules.farkas(new Term[]{term3, term4}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE}));
                    term12 = this.res(term2, term12, this.mProofRules.farkas(new Term[]{term2, term4}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE}));
                } else {
                    assert (proofLiteralArray.length == 2 && proofLiteralArray[0].getPolarity());
                    assert (proofLiteralArray[0].getAtom() == theory.term("<=", new Term[]{termArray2[1], term7}));
                    term4 = theory.term("<", new Term[]{term7, termArray2[1]});
                    term12 = this.res(term5, term12, this.mProofRules.farkas(new Term[]{term4, term5}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE}));
                    term12 = this.res(term6, term12, this.mProofRules.farkas(new Term[]{term4, term6}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE}));
                    term12 = this.res(term4, this.mProofRules.total(termArray2[1], term7), term12);
                }
            }
        } else {
            term12 = this.res(term13, term12, this.mProofRules.farkas(new Term[]{string2, term13}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE}));
        }
        if (!bl2) {
            term12 = this.res((Term)string2, this.mProofRules.total(termArray[0], termArray[1]), term12);
        }
        return term12;
    }

    private Term convertTautDtMatch(String string, ProofLiteral[] proofLiteralArray) {
        Term term;
        MatchTerm matchTerm;
        boolean bl;
        boolean bl2 = string.equals(":matchCase");
        boolean bl3 = proofLiteralArray[0].getAtom() instanceof MatchTerm;
        ApplicationTerm applicationTerm = null;
        if (bl3) {
            assert (proofLiteralArray.length >= 2);
            bl = !proofLiteralArray[0].getPolarity();
            matchTerm = (MatchTerm)proofLiteralArray[0].getAtom();
            if (bl2) {
                assert (!proofLiteralArray[1].getPolarity());
                term = proofLiteralArray[1].getAtom();
                assert (this.isApplication("is", term));
                applicationTerm = (ApplicationTerm)term;
            }
        } else {
            assert (proofLiteralArray.length >= 1);
            bl = false;
            if (bl2) {
                assert (!proofLiteralArray[0].getPolarity());
                term = proofLiteralArray[0].getAtom();
                assert (this.isApplication("is", term));
                applicationTerm = (ApplicationTerm)term;
            }
            assert (proofLiteralArray[proofLiteralArray.length - 1].getPolarity());
            assert (this.isApplication("=", proofLiteralArray[proofLiteralArray.length - 1].getAtom()));
            term = (ApplicationTerm)proofLiteralArray[proofLiteralArray.length - 1].getAtom();
            assert (term.getParameters().length == 2);
            matchTerm = (MatchTerm)term.getParameters()[0];
        }
        term = matchTerm.getConstructors();
        int n = 0;
        while (n < ((Term)term).length) {
            if (bl2 ? term[n].getName().equals(applicationTerm.getFunction().getIndices()[0]) : term[n] == null) break;
            ++n;
        }
        Theory theory = matchTerm.getTheory();
        Term term2 = matchTerm.getDataTerm();
        Term term3 = MinimalProofChecker.buildIteForMatch(matchTerm);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(matchTerm);
        int n2 = 0;
        while (n2 < n) {
            assert (this.isApplication("ite", term3));
            arrayList.add(term3);
            term3 = ((ApplicationTerm)term3).getParameters()[2];
            ++n2;
        }
        if (bl2 && n < ((Term)term).length - 1) {
            assert (this.isApplication("ite", term3));
            arrayList.add(term3);
            term3 = ((ApplicationTerm)term3).getParameters()[1];
        }
        arrayList.add(term3);
        Term term4 = this.mProofRules.trans(arrayList.toArray(new Term[arrayList.size()]));
        term4 = this.res(theory.term("=", new Term[]{matchTerm, (Term)arrayList.get(1)}), this.mProofRules.dtMatch((Term)matchTerm), term4);
        Term term5 = term[n];
        Term term6 = null;
        if (bl2) {
            Term[] termArray = new Term[term5.getSelectors().length];
            int n3 = 0;
            while (n3 < termArray.length) {
                termArray[n3] = theory.term(term5.getSelectors()[n3], new Term[]{term2});
                ++n3;
            }
            term6 = theory.term(term5.getName(), null, term5.needsReturnOverload() ? term2.getSort() : null, termArray);
        }
        int n4 = 0;
        while (n4 < n) {
            term4 = this.res(theory.term("=", new Term[]{(Term)arrayList.get(n4 + 1), (Term)arrayList.get(n4 + 2)}), this.mProofRules.ite2((Term)arrayList.get(n4 + 1)), term4);
            if (bl2) {
                String[] stringArray = new String[]{term[n4].getName()};
                Term term7 = theory.term("is", stringArray, null, new Term[]{term2});
                Term term8 = theory.term("is", stringArray, null, new Term[]{term6});
                Term term9 = theory.term("=", new Term[]{term8, term7});
                term4 = this.res(term7, term4, this.mProofRules.iffElim1(term9));
                term4 = this.res(term9, this.mProofRules.cong(term8, term7), term4);
                term4 = this.res(term8, term4, this.mProofRules.dtTestE(term[n4].getName(), term6));
            }
            ++n4;
        }
        if (bl2 && n > 0) {
            Term term10 = theory.term("is", new String[]{term5.getName()}, null, new Term[]{term2});
            term4 = this.res(theory.term("=", new Term[]{term6, term2}), this.mProofRules.dtCons(term10), term4);
        }
        if (bl2 && n < ((Term)term).length - 1) {
            term4 = this.res(theory.term("=", new Term[]{(Term)arrayList.get(n + 1), (Term)arrayList.get(n + 2)}), this.mProofRules.ite1((Term)arrayList.get(n + 1)), term4);
        }
        if (bl3) {
            Term term11 = theory.term("=", new Term[]{matchTerm, term3});
            term4 = this.res(term11, term4, bl ? this.mProofRules.iffElim2(term11) : this.mProofRules.iffElim1(term11));
            term4 = this.removeNot(term4, term3, bl);
        }
        return term4;
    }

    private Term convertTautology(ProofLiteral[] proofLiteralArray, Annotation annotation) {
        String string = annotation.getKey();
        Term term = null;
        switch (string) {
            case ":true+": {
                assert (proofLiteralArray.length == 1 && proofLiteralArray[0].getPolarity() && this.isApplication("true", proofLiteralArray[0].getAtom()));
                term = this.mProofRules.trueIntro();
                break;
            }
            case ":false-": {
                assert (proofLiteralArray.length == 1 && !proofLiteralArray[0].getPolarity() && this.isApplication("false", proofLiteralArray[0].getAtom()));
                term = this.mProofRules.falseElim();
                break;
            }
            case ":=>+": 
            case ":=>-": 
            case ":or+": 
            case ":or-": 
            case ":and+": 
            case ":and-": 
            case ":ite+red": 
            case ":ite-red": 
            case ":ite+1": 
            case ":ite+2": 
            case ":ite-1": 
            case ":ite-2": 
            case ":xor+1": 
            case ":xor+2": 
            case ":xor-1": 
            case ":xor-2": {
                term = this.convertTautElimIntro(string, proofLiteralArray);
                break;
            }
            case ":=+1": {
                assert (proofLiteralArray.length == 3);
                Term term2 = proofLiteralArray[0].getAtom();
                assert (proofLiteralArray[0].getPolarity() && this.isApplication("=", term2));
                Term[] termArray = ((ApplicationTerm)term2).getParameters();
                assert (termArray.length == 2);
                term = this.mProofRules.iffIntro1(term2);
                assert (proofLiteralArray[1].getPolarity() && termArray[0] == proofLiteralArray[1].getAtom());
                term = this.removeNot(term, termArray[0], true);
                assert (proofLiteralArray[2].getPolarity() && termArray[1] == proofLiteralArray[2].getAtom());
                term = this.removeNot(term, termArray[1], true);
                break;
            }
            case ":=+2": {
                assert (proofLiteralArray.length == 3);
                Term term3 = proofLiteralArray[0].getAtom();
                assert (proofLiteralArray[0].getPolarity() && this.isApplication("=", term3));
                Term[] termArray = ((ApplicationTerm)term3).getParameters();
                assert (termArray.length == 2);
                term = this.mProofRules.iffIntro2(term3);
                assert (!proofLiteralArray[1].getPolarity() && termArray[0] == proofLiteralArray[1].getAtom());
                term = this.removeNot(term, termArray[0], false);
                assert (!proofLiteralArray[2].getPolarity() && termArray[1] == proofLiteralArray[2].getAtom());
                term = this.removeNot(term, termArray[0], false);
                break;
            }
            case ":=-1": {
                assert (proofLiteralArray.length == 3);
                Term term4 = proofLiteralArray[0].getAtom();
                assert (!proofLiteralArray[0].getPolarity() && this.isApplication("=", term4));
                Term[] termArray = ((ApplicationTerm)term4).getParameters();
                assert (termArray.length == 2);
                term = this.mProofRules.iffElim1(term4);
                assert (proofLiteralArray[1].getPolarity() && termArray[0] == proofLiteralArray[1].getAtom());
                term = this.removeNot(term, termArray[0], true);
                assert (!proofLiteralArray[2].getPolarity() && termArray[1] == proofLiteralArray[2].getAtom());
                term = this.removeNot(term, termArray[1], false);
                break;
            }
            case ":=-2": {
                assert (proofLiteralArray.length == 3);
                Term term5 = proofLiteralArray[0].getAtom();
                assert (!proofLiteralArray[0].getPolarity() && this.isApplication("=", term5));
                Term[] termArray = ((ApplicationTerm)term5).getParameters();
                assert (termArray.length == 2);
                term = this.mProofRules.iffElim2(term5);
                assert (!proofLiteralArray[1].getPolarity() && termArray[0] == proofLiteralArray[1].getAtom());
                term = this.removeNot(term, termArray[0], false);
                assert (proofLiteralArray[2].getPolarity() && termArray[1] == proofLiteralArray[2].getAtom());
                term = this.removeNot(term, termArray[1], true);
                break;
            }
            case ":exists-": 
            case ":forall+": {
                term = this.convertTautQuantSkolemize(proofLiteralArray, (Term[])annotation.getValue(), string.equals(":forall+"));
                break;
            }
            case ":exists+": {
                term = this.convertTautExistsIntro(proofLiteralArray, (Term[])annotation.getValue());
                break;
            }
            case ":forall-": {
                term = this.convertTautForallElim(proofLiteralArray, (Term[])annotation.getValue());
                break;
            }
            case ":termITE": {
                term = this.convertTermITE(proofLiteralArray);
                break;
            }
            case ":termITEBound": {
                term = this.convertTermITEBound(proofLiteralArray);
                break;
            }
            case ":trueNotFalse": {
                Theory theory = proofLiteralArray[0].getAtom().getTheory();
                term = this.mProofRules.resolutionRule((Term)theory.mTrue, this.mProofRules.trueIntro(), this.mProofRules.resolutionRule((Term)theory.mFalse, this.mProofRules.iffElim2(theory.term("=", new Term[]{theory.mTrue, theory.mFalse})), this.mProofRules.falseElim()));
                break;
            }
            case ":excludedMiddle1": 
            case ":excludedMiddle2": {
                term = this.convertTautExcludedMiddle(string, proofLiteralArray);
                break;
            }
            case ":divLow": 
            case ":divHigh": 
            case ":toIntLow": 
            case ":toIntHigh": {
                term = this.convertTautLowHigh((Term)annotation.getValue(), string, proofLiteralArray);
                break;
            }
            case ":modulo": {
                term = this.convertTautModulo(proofLiteralArray);
                break;
            }
            case ":store": {
                term = this.convertTautStore(proofLiteralArray);
                break;
            }
            case ":diff": {
                term = this.convertTautDiff(proofLiteralArray);
                break;
            }
            case ":matchDefault": 
            case ":matchCase": {
                term = this.convertTautDtMatch(string, proofLiteralArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Tautology");
            }
        }
        assert (this.checkProof(term, proofLiteralArray));
        return term;
    }

    private Term convertTrans(Term[] termArray) {
        Term[] termArray2 = new Term[termArray.length + 1];
        Term term = null;
        int n = 0;
        while (n < termArray.length) {
            ApplicationTerm applicationTerm = (ApplicationTerm)this.provedTerm((AnnotatedTerm)termArray[n]);
            assert (this.isApplication("=", (Term)applicationTerm));
            assert (applicationTerm.getParameters().length == 2);
            assert (n == 0 || term == applicationTerm.getParameters()[0]);
            termArray2[n] = applicationTerm.getParameters()[0];
            term = applicationTerm.getParameters()[1];
            ++n;
        }
        termArray2[termArray.length] = term;
        Term term2 = this.mProofRules.trans(termArray2);
        int n2 = 0;
        while (n2 < termArray.length) {
            ApplicationTerm applicationTerm = (ApplicationTerm)this.provedTerm((AnnotatedTerm)termArray[n2]);
            Term term3 = this.subproof((AnnotatedTerm)termArray[n2]);
            term2 = this.mProofRules.resolutionRule((Term)applicationTerm, term3, term2);
            ++n2;
        }
        Term term4 = term2.getTheory().term("=", new Term[]{termArray2[0], termArray2[termArray.length]});
        return this.annotateProved(term4, term2);
    }

    private Term convertCong(FunctionSymbol functionSymbol, Term[] termArray) {
        ApplicationTerm applicationTerm;
        Sort sort = functionSymbol.isReturnOverload() ? functionSymbol.getReturnSort() : null;
        FunctionSymbol functionSymbol2 = CongRewriteFunctionFactory.getFunctionFromIndex(functionSymbol.getIndices(), functionSymbol.getParameterSorts(), sort);
        ApplicationTerm applicationTerm2 = (ApplicationTerm)this.provedTerm((AnnotatedTerm)termArray[0]);
        Theory theory = termArray[0].getTheory();
        assert (this.isApplication("=", (Term)applicationTerm2));
        Term[] termArray2 = new Term[termArray.length];
        Term[] termArray3 = new Term[termArray.length];
        Term[] termArray4 = new Term[termArray.length];
        Term[] termArray5 = new Term[termArray.length];
        int n = 0;
        while (n < termArray3.length) {
            applicationTerm = (ApplicationTerm)this.provedTerm((AnnotatedTerm)termArray[n]);
            termArray4[n] = applicationTerm;
            termArray5[n] = this.subproof((AnnotatedTerm)termArray[n]);
            termArray2[n] = applicationTerm.getParameters()[0];
            termArray3[n] = applicationTerm.getParameters()[1];
            ++n;
        }
        Term term = theory.term(functionSymbol2, termArray2);
        applicationTerm = theory.term(functionSymbol2, termArray3);
        Term term2 = theory.term("=", new Term[]{term, applicationTerm});
        Term term3 = this.mProofRules.cong(functionSymbol2, termArray2, termArray3);
        HashSet<Term> hashSet = new HashSet<Term>();
        int n2 = 0;
        while (n2 < termArray3.length) {
            if (!hashSet.contains(termArray4[n2])) {
                term3 = this.mProofRules.resolutionRule(termArray4[n2], termArray5[n2], term3);
                hashSet.add(termArray4[n2]);
            }
            ++n2;
        }
        return this.annotateProved(term2, term3);
    }

    private Term convertMatch(Term[] termArray) {
        Object object;
        Term term;
        Object object2;
        Term term2;
        Term term3;
        Object object3;
        ApplicationTerm applicationTerm;
        AnnotatedTerm annotatedTerm;
        AnnotatedTerm annotatedTerm2;
        AnnotatedTerm annotatedTerm3 = (AnnotatedTerm)termArray[0];
        Theory theory = annotatedTerm3.getTheory();
        ApplicationTerm applicationTerm2 = (ApplicationTerm)this.provedTerm(annotatedTerm3);
        assert (applicationTerm2.getFunction().getName().equals("="));
        Term term4 = applicationTerm2.getParameters()[0];
        Term term5 = applicationTerm2.getParameters()[1];
        DataType dataType = (DataType)term4.getSort().getSortSymbol();
        Term[] termArray2 = new Term[termArray.length - 1];
        Term[] termArray3 = new Term[termArray.length - 1];
        TermVariable[][] termVariableArrayArray = new TermVariable[termArray.length - 1][];
        DataType.Constructor[] constructorArray = new DataType.Constructor[termArray.length - 1];
        Term[] termArray4 = new Term[termArray.length - 1];
        int n = 1;
        while (n < termArray.length) {
            annotatedTerm2 = (AnnotatedTerm)termArray[n];
            annotatedTerm = (AnnotatedTerm)annotatedTerm2.getSubterm();
            applicationTerm = (ApplicationTerm)this.provedTerm(annotatedTerm);
            assert (annotatedTerm2.getAnnotations()[0].getKey() == ":vars");
            termVariableArrayArray[n - 1] = (TermVariable[])annotatedTerm2.getAnnotations()[0].getValue();
            assert (annotatedTerm2.getAnnotations()[1].getKey() == ":constructor");
            object3 = (String)annotatedTerm2.getAnnotations()[1].getValue();
            termArray2[n - 1] = applicationTerm.getParameters()[0];
            termArray3[n - 1] = applicationTerm.getParameters()[1];
            constructorArray[n - 1] = object3 == null ? null : dataType.findConstructor((String)object3);
            termArray4[n - 1] = this.subproof(annotatedTerm);
            ++n;
        }
        MatchTerm matchTerm = (MatchTerm)theory.match(term4, (TermVariable[][])termVariableArrayArray, termArray2, constructorArray);
        annotatedTerm2 = (MatchTerm)theory.match(term5, (TermVariable[][])termVariableArrayArray, termArray2, constructorArray);
        annotatedTerm = (MatchTerm)theory.match(term5, (TermVariable[][])termVariableArrayArray, termArray3, constructorArray);
        applicationTerm = null;
        if (term4 != term5) {
            theory.push();
            object3 = theory.createFreshTermVariable("match", term4.getSort());
            term3 = new Term[]{object3};
            term2 = theory.match(object3, (TermVariable[][])termVariableArrayArray, termArray2, constructorArray);
            FunctionSymbol functionSymbol = theory.declareInternalFunction("@matchbody", new Sort[]{term4.getSort()}, (TermVariable[])term3, term2, 64);
            object2 = theory.term(functionSymbol, new Term[]{term4});
            term = theory.term(functionSymbol, new Term[]{term5});
            Term term6 = this.res(theory.term("=", new Term[]{object2, matchTerm}), this.mProofRules.expand((Term)object2), this.mProofRules.symm((Term)matchTerm, (Term)object2));
            object = this.res(theory.term("=", new Term[]{term4, term5}), this.subproof(annotatedTerm3), this.mProofRules.cong((Term)object2, term));
            applicationTerm = this.res(theory.term("=", new Term[]{matchTerm, object2}), term6, this.res(theory.term("=", new Term[]{object2, term}), (Term)object, this.res(theory.term("=", new Term[]{term, annotatedTerm2}), this.mProofRules.expand(term), this.mProofRules.trans(new Term[]{matchTerm, object2, term, annotatedTerm2}))));
            applicationTerm = this.mProofRules.defineFun(functionSymbol, theory.lambda((TermVariable[])term3, term2), (Term)applicationTerm);
            theory.pop();
        }
        object3 = MinimalProofChecker.buildIteForMatch((MatchTerm)annotatedTerm2);
        term3 = MinimalProofChecker.buildIteForMatch((MatchTerm)annotatedTerm);
        term2 = null;
        boolean bl = false;
        object2 = object3;
        term = term3;
        int n2 = 0;
        while (n2 < constructorArray.length) {
            Term term7;
            Term term8;
            if (constructorArray[n2] == null || n2 == termArray.length - 1) {
                object = object2;
                term8 = term;
            } else {
                assert (((ApplicationTerm)object2).getFunction().getName().equals("ite"));
                assert (((ApplicationTerm)term).getFunction().getName().equals("ite"));
                object = ((ApplicationTerm)object2).getParameters()[1];
                term8 = ((ApplicationTerm)term).getParameters()[1];
                term2 = this.res(theory.term("=", new Term[]{object2, term}), this.mProofRules.cong((Term)object2, term), term2);
                term7 = ((ApplicationTerm)object2).getParameters()[0];
                Term term9 = ((ApplicationTerm)term).getParameters()[0];
                term2 = this.res(theory.term("=", new Term[]{term7, term9}), this.mProofRules.cong(term7, term9), term2);
                bl = true;
            }
            if (constructorArray[n2] == null) {
                term7 = new Term[]{term5};
            } else {
                term7 = new Term[constructorArray[n2].getSelectors().length];
                int n3 = 0;
                while (n3 < ((Term[])term7).length) {
                    term7[n3] = theory.term(constructorArray[n2].getSelectors()[n3], new Term[]{term5});
                    ++n3;
                }
            }
            term2 = this.res(theory.term("=", new Term[]{object, term8}), theory.let(termVariableArrayArray[n2], (Term[])term7, termArray4[n2]), term2);
            if (constructorArray[n2] == null) break;
            if (n2 < termArray.length - 1) {
                object2 = ((ApplicationTerm)object2).getParameters()[2];
                term = ((ApplicationTerm)term).getParameters()[2];
            }
            ++n2;
        }
        term2 = new FormulaUnLet().unlet(term2);
        if (bl) {
            term2 = this.res(theory.term("=", new Term[]{term5, term5}), this.mProofRules.refl(term5), term2);
        }
        Term term10 = theory.term("=", new Term[]{object3, term3});
        object = this.res(term10, term2, this.mProofRules.trans(new Term[]{annotatedTerm2, object3, term3, annotatedTerm}));
        object = this.res(theory.term("=", new Term[]{annotatedTerm2, object3}), this.mProofRules.dtMatch((Term)annotatedTerm2), (Term)object);
        object = this.res(theory.term("=", new Term[]{annotatedTerm, term3}), this.mProofRules.dtMatch((Term)annotatedTerm), this.res(theory.term("=", new Term[]{term3, annotatedTerm}), this.mProofRules.symm(term3, (Term)annotatedTerm), (Term)object));
        if (term4 != term5) {
            object = this.res(theory.term("=", new Term[]{matchTerm, annotatedTerm2}), (Term)applicationTerm, this.res(theory.term("=", new Term[]{annotatedTerm2, annotatedTerm}), (Term)object, this.mProofRules.trans(new Term[]{matchTerm, annotatedTerm2, annotatedTerm})));
        }
        return this.annotateProved(theory.term("=", new Term[]{matchTerm, annotatedTerm}), (Term)object);
    }

    private Term convertRewriteIntern(Term term, Term term2) {
        Term term3;
        Term[] termArray;
        Theory theory = term.getTheory();
        if (term2 == term) {
            return this.mProofRules.refl(term);
        }
        if (this.isApplication("not", term2) && this.isApplication("=", (Term)(termArray = ((ApplicationTerm)term2).getParameters()[0])) && this.isApplication("false", (term3 = (Term)termArray).getParameters()[1]) && term == term3.getParameters()[0]) {
            Term term4 = theory.term("not", new Term[]{term3});
            Term term5 = theory.term("=", new Term[]{term, term4});
            Term term6 = term3.getParameters()[1];
            Term term7 = this.proveIff(term5, this.mProofRules.resolutionRule(term3, this.mProofRules.notIntro(term4), this.mProofRules.iffElim2(term3)), this.mProofRules.resolutionRule(term3, this.mProofRules.iffIntro1(term3), this.mProofRules.notElim(term4)));
            term7 = this.mProofRules.resolutionRule(term6, term7, this.mProofRules.falseElim());
            return term7;
        }
        if (this.isApplication("=", term2) && (termArray = ((ApplicationTerm)term2).getParameters()).length == 2 && this.isApplication("true", termArray[1]) && (term == termArray[0] || this.isAuxApplication(termArray[0]))) {
            term3 = theory.term("=", new Term[]{termArray[0], term2});
            Term term8 = this.res(termArray[1], this.mProofRules.trueIntro(), this.proveIff(term3, this.mProofRules.iffIntro2(term2), this.mProofRules.iffElim1(term2)));
            if (term != termArray[0]) {
                Term term9 = this.mProofRules.trans(term, termArray[0], term2);
                term8 = this.mProofRules.resolutionRule(term3, term8, term9);
                term8 = this.res(theory.term("=", new Term[]{term, termArray[0]}), this.res(theory.term("=", new Term[]{termArray[0], term}), this.mProofRules.expand(termArray[0]), this.mProofRules.symm(term, termArray[0])), term8);
            }
            return term8;
        }
        if (this.isApplication("<=", term)) {
            termArray = ((ApplicationTerm)term).getParameters();
            assert (this.isZero(termArray[1]));
            return this.proveRewriteWithLeq(term, term2, true);
        }
        if (this.isApplication("=", term)) {
            termArray = ((ApplicationTerm)term).getParameters();
            assert (termArray.length == 2);
            if (this.isApplication("false", term2)) {
                term3 = this.proveTrivialDisequality(termArray[0], termArray[1]);
                return this.proveIffFalse(theory.term("=", new Term[]{term, term2}), term3);
            }
            if (this.isApplication("true", term2)) {
                assert (termArray[0] == termArray[1]);
                return this.proveIffTrue(theory.term("=", new Term[]{term, term2}), this.mProofRules.refl(termArray[0]));
            }
            assert (this.isApplication("=", term2));
            term3 = ((ApplicationTerm)term2).getParameters();
            assert (((Term)term3).length == 2);
            Term term10 = theory.term("=", new Term[]{term, term2});
            if (termArray[1] == term3[0] && termArray[0] == term3[1]) {
                return this.proveIff(term10, this.mProofRules.symm(term3[0], term3[1]), this.mProofRules.symm(termArray[0], termArray[1]));
            }
            assert (termArray[0].getSort().isNumericSort());
            return this.proveRewriteWithLinEq(term, term2);
        }
        throw new AssertionError();
    }

    private Term convertRewriteLeq(String string, Term term, Term term2, Term term3) {
        boolean bl;
        assert (this.isApplication("<=", term2));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        assert (termArray.length == 2 && this.isZero(termArray[1]));
        Rational rational = this.parseConstant(termArray[0]);
        boolean bl2 = bl = string == ":leqTrue";
        if (bl) {
            assert (rational.signum() <= 0 && this.isApplication("true", term3));
            Term term4 = term2.getTheory().term("<", new Term[]{termArray[1], termArray[0]});
            return this.proveIffTrue(term, this.mProofRules.resolutionRule(term4, this.mProofRules.total(termArray[0], termArray[1]), this.mProofRules.farkas(new Term[]{term4}, new BigInteger[]{BigInteger.ONE})));
        }
        assert (rational.signum() > 0 && this.isApplication("false", term3));
        return this.proveIffFalse(term, this.mProofRules.farkas(new Term[]{term2}, new BigInteger[]{BigInteger.ONE}));
    }

    private Term convertRewriteNot(Term term, Term term2, Term term3) {
        assert (this.isApplication("not", term2));
        Term term4 = ((ApplicationTerm)term2).getParameters()[0];
        if (this.isApplication("false", term4)) {
            assert (this.isApplication("true", term3));
            return this.proveIffTrue(term, this.mProofRules.resolutionRule(term4, this.mProofRules.notIntro(term2), this.mProofRules.falseElim()));
        }
        if (this.isApplication("true", term4)) {
            assert (this.isApplication("false", term3));
            return this.proveIffFalse(term, this.mProofRules.resolutionRule(term4, this.mProofRules.trueIntro(), this.mProofRules.notElim(term2)));
        }
        if (this.isApplication("not", term4)) {
            assert (term3 == ((ApplicationTerm)term4).getParameters()[0]);
            return this.proveIff(term, this.mProofRules.resolutionRule(term4, this.mProofRules.notIntro(term4), this.mProofRules.notElim(term2)), this.mProofRules.resolutionRule(term4, this.mProofRules.notIntro(term2), this.mProofRules.notElim(term4)));
        }
        throw new AssertionError();
    }

    private Term convertRewriteTrueNotFalse(Term term, Term term2) {
        Term term3;
        Theory theory = term.getTheory();
        assert (this.isApplication("=", term) && this.isApplication("false", term2));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < termArray.length) {
            term3 = termArray[n3];
            if (this.isApplication("true", term3)) {
                n = n3;
            }
            if (this.isApplication("false", term3)) {
                n2 = n3;
            }
            ++n3;
        }
        assert (n >= 0 && n2 >= 0);
        term3 = theory.term("=", new Term[]{termArray[n], termArray[n2]});
        Term term4 = this.mProofRules.resolutionRule(term3, this.mProofRules.equalsElim(n, n2, term), this.mProofRules.iffElim2(term3));
        term4 = this.mProofRules.resolutionRule(term, this.mProofRules.iffIntro1(theory.term("=", new Term[]{term, term2})), term4);
        term4 = this.mProofRules.resolutionRule(termArray[n2], this.mProofRules.resolutionRule(termArray[n], this.mProofRules.trueIntro(), term4), this.mProofRules.falseElim());
        return term4;
    }

    private Term convertRewriteEqTrueFalse(String string, Term term, Term term2) {
        Term term3;
        Term term4;
        Term term5;
        boolean bl = string.equals(":eqTrue");
        assert (this.isApplication("=", term));
        int n = -1;
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        LinkedHashMap<Term, Integer> linkedHashMap = new LinkedHashMap<Term, Integer>();
        int n2 = 0;
        while (n2 < termArray.length) {
            if (this.isApplication(bl ? "true" : "false", term5 = termArray[n2])) {
                n = n2;
            } else if (!linkedHashMap.containsKey(term5)) {
                linkedHashMap.put(term5, n2);
            }
            ++n2;
        }
        assert (n >= 0);
        Theory theory = term.getTheory();
        term5 = theory.term("=", new Term[]{term, term2});
        Term term6 = null;
        Term term7 = null;
        if (linkedHashMap.size() > 1 || !bl) {
            assert (this.isApplication("not", term2));
            term7 = ((ApplicationTerm)term2).getParameters()[0];
            term6 = this.mProofRules.notIntro(term2);
            if (linkedHashMap.size() > 1) {
                assert (this.isApplication("or", term7));
                term6 = this.res(term7, term6, this.mProofRules.orElim(term7));
            }
        }
        Term term8 = termArray.length > 2 ? this.mProofRules.equalsIntro(term) : null;
        int n3 = 0;
        while (n3 < termArray.length - 1) {
            term4 = theory.term("=", new Term[]{termArray[n3], termArray[n3 + 1]});
            term3 = bl ? this.mProofRules.iffIntro2(term4) : this.mProofRules.iffIntro1(term4);
            term8 = this.res(term4, term3, term8);
            ++n3;
        }
        n3 = 0;
        term3 = linkedHashMap.values().iterator();
        while (term3.hasNext()) {
            Term term9;
            int n4 = (Integer)term3.next();
            Term term10 = termArray[n4];
            Term term11 = theory.term("not", new Term[]{term10});
            Term term12 = term9 = bl ? term11 : term10;
            if (linkedHashMap.size() > 1) {
                if (bl) {
                    term6 = this.res(term11, term6, this.mProofRules.notElim(term11));
                    term8 = this.res(term10, this.mProofRules.notIntro(term11), term8);
                }
                term8 = this.res(term9, term8, this.mProofRules.orIntro(n3++, term7));
            }
            Term term13 = theory.term("=", new Term[]{term10, termArray[n]});
            Term term14 = term6 = bl ? this.res(term10, this.mProofRules.iffElim1(term13), term6) : this.res(term10, term6, this.mProofRules.iffElim2(term13));
            Term term15 = termArray.length > 2 ? this.mProofRules.equalsElim(n4, n, term) : (n == 1 ? null : this.mProofRules.symm(termArray[1], termArray[0]));
            term6 = this.res(term13, term15, term6);
        }
        if (linkedHashMap.size() > 1 || !bl) {
            term8 = this.res(term7, term8, this.mProofRules.notElim(term2));
        }
        term4 = this.proveIff(term5, term6, term8);
        return bl ? this.res(termArray[n], this.mProofRules.trueIntro(), term4) : this.res(termArray[n], term4, this.mProofRules.falseElim());
    }

    private Term convertRewriteToXor(String string, Term term, Term term2, Term term3) {
        Term term4;
        Term term5;
        assert (this.isApplication(string == ":eqToXor" ? "=" : "distinct", term2));
        Term term6 = term3;
        if (string == ":eqToXor") {
            term6 = this.negate(term6);
        }
        assert (this.isApplication("xor", term6));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        Term[] termArray2 = ((ApplicationTerm)term6).getParameters();
        assert (termArray2.length == 2 && termArray.length == 2);
        assert (termArray2[0] == termArray[0] && termArray2[1] == termArray[1]);
        Term term7 = term.getTheory().term("=", new Term[]{termArray[0], termArray[1]});
        Term term8 = this.mProofRules.resolutionRule(termArray[0], this.mProofRules.resolutionRule(termArray[1], this.mProofRules.xorIntro(new Term[]{termArray2[0]}, new Term[]{termArray2[1]}, termArray2), this.mProofRules.iffElim1(term7)), this.mProofRules.resolutionRule(termArray[1], this.mProofRules.iffElim2(term7), this.mProofRules.xorElim(new Term[]{termArray2[0]}, new Term[]{termArray2[1]}, termArray2)));
        Term term9 = this.mProofRules.resolutionRule(termArray[0], this.mProofRules.resolutionRule(termArray[1], this.mProofRules.iffIntro1(term7), this.mProofRules.xorIntro(termArray2, new Term[]{termArray2[0]}, new Term[]{termArray2[1]})), this.mProofRules.resolutionRule(termArray[1], this.mProofRules.xorIntro(termArray2, new Term[]{termArray2[1]}, new Term[]{termArray2[0]}), this.mProofRules.iffIntro2(term7)));
        if (string == ":eqToXor") {
            term5 = this.mProofRules.resolutionRule(term3, this.mProofRules.iffIntro1(term), this.mProofRules.notElim(term3));
            term4 = this.mProofRules.resolutionRule(term3, this.mProofRules.notIntro(term3), this.mProofRules.iffIntro2(term));
        } else {
            term5 = this.mProofRules.resolutionRule(term2, this.mProofRules.distinctIntro(term2), this.mProofRules.iffIntro2(term));
            term4 = this.mProofRules.resolutionRule(term2, this.mProofRules.iffIntro1(term), this.mProofRules.distinctElim(0, 1, term2));
        }
        return this.mProofRules.resolutionRule(term7, this.mProofRules.resolutionRule(term6, term9, term5), this.mProofRules.resolutionRule(term6, term4, term8));
    }

    private Term convertRewriteXorNot(Term term, Term term2, Term term3) {
        Term term4;
        Term term5;
        Theory theory = term.getTheory();
        boolean bl = false;
        Term term6 = term3;
        if (this.isApplication("not", term3)) {
            bl = !bl;
            term6 = ((ApplicationTerm)term3).getParameters()[0];
        }
        assert (this.isApplication("xor", term2) && this.isApplication("xor", term6));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        Term[] termArray2 = ((ApplicationTerm)term6).getParameters();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        assert (termArray.length == termArray2.length);
        Term[] termArray3 = null;
        Term term7 = null;
        Term term8 = null;
        boolean bl2 = false;
        int n = 0;
        while (n < termArray.length) {
            term5 = termArray[n];
            term4 = termArray2[n];
            if (this.isApplication("not", term5)) {
                boolean bl3;
                Term term9;
                Term[] termArray4;
                Term term10;
                Term term11 = term5;
                int n2 = 0;
                while (this.isApplication("not", term11)) {
                    term11 = ((ApplicationTerm)term11).getParameters()[0];
                    ++n2;
                }
                assert (term11 == term4);
                Term term12 = null;
                Term[] termArray5 = null;
                term11 = term4;
                int n3 = 0;
                while (n3 < n2) {
                    term10 = this.mSkript.term("not", new Term[]{term11});
                    termArray4 = this.res(term11, this.mProofRules.notIntro(term10), term12);
                    term12 = this.res(term11, (Term)termArray5, this.mProofRules.notElim(term10));
                    termArray5 = termArray4;
                    term11 = term10;
                    ++n3;
                }
                Term[] termArray6 = new Term[]{term5, term4};
                term10 = theory.term("xor", termArray6);
                arrayList.add(term5);
                arrayList.add(term4);
                termArray4 = arrayList.toArray(new Term[arrayList.size()]);
                Term term13 = theory.term("xor", termArray4);
                if (n2 % 2 == 0) {
                    var27_29 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term5, this.mProofRules.xorIntro(new Term[]{term5}, new Term[]{term4}, termArray6), term12), this.mProofRules.resolutionRule(term5, (Term)termArray5, this.mProofRules.xorElim(new Term[]{term5}, new Term[]{term4}, termArray6)));
                    if (term7 == null) {
                        term9 = var27_29;
                    } else {
                        term9 = bl2 ? this.mProofRules.xorIntro(termArray6, termArray4, termArray3) : this.mProofRules.xorIntro(termArray6, termArray3, termArray4);
                        term9 = this.mProofRules.resolutionRule(term10, term9, var27_29);
                    }
                    bl3 = bl2;
                } else {
                    var27_29 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term5, (Term)termArray5, this.mProofRules.xorIntro(termArray6, new Term[]{term4}, new Term[]{term5})), this.mProofRules.resolutionRule(term5, this.mProofRules.xorIntro(termArray6, new Term[]{term5}, new Term[]{term4}), term12));
                    if (term7 == null) {
                        term9 = var27_29;
                    } else {
                        term9 = bl2 ? this.mProofRules.xorElim(termArray4, termArray3, termArray6) : this.mProofRules.xorIntro(termArray4, termArray3, termArray6);
                        term9 = this.mProofRules.resolutionRule(term10, var27_29, term9);
                    }
                    bl3 = !bl2;
                }
                term8 = this.res(term7, bl2 ? term8 : term9, bl2 ? term9 : term8);
                termArray3 = termArray4;
                term7 = term13;
                bl2 = bl3;
            } else assert (term5 == term4);
            ++n;
        }
        assert (arrayList.size() > 0);
        assert (bl == bl2);
        Term term14 = this.mProofRules.xorIntro(termArray, bl ? termArray2 : termArray3, bl ? termArray3 : termArray2);
        Term term15 = term5 = bl ? this.mProofRules.xorElim(termArray2, termArray3, termArray) : this.mProofRules.xorIntro(termArray2, termArray3, termArray);
        if (bl) {
            term14 = this.mProofRules.resolutionRule(term6, term14, this.mProofRules.notElim(term3));
            term5 = this.mProofRules.resolutionRule(term6, this.mProofRules.notIntro(term3), term5);
        }
        term4 = this.mProofRules.resolutionRule(term2, this.mProofRules.resolutionRule(term3, this.mProofRules.iffIntro1(term), term14), this.mProofRules.resolutionRule(term3, term5, this.mProofRules.iffIntro2(term)));
        return this.mProofRules.resolutionRule(term7, bl2 ? term8 : term4, bl2 ? term4 : term8);
    }

    private Term convertRewriteXorConst(String string, Term term, Term term2, Term term3) {
        assert (this.isApplication("xor", term2));
        boolean bl = string == ":xorTrue";
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        int n = this.isApplication(bl ? "true" : "false", termArray[0]) ? 0 : 1;
        Term[] termArray2 = new Term[]{termArray[n]};
        Term[] termArray3 = new Term[]{termArray[1 - n]};
        if (bl) {
            assert (this.isApplication("true", termArray[n]) && term3 == this.mSkript.term("not", new Term[]{termArray[1 - n]}));
            Term term4 = this.proveIff(term, this.mProofRules.resolutionRule(termArray[1 - n], this.mProofRules.notIntro(term3), this.mProofRules.xorElim(termArray3, termArray, termArray2)), this.mProofRules.resolutionRule(termArray[1 - n], this.mProofRules.xorIntro(termArray3, termArray, termArray2), this.mProofRules.notElim(term3)));
            return this.mProofRules.resolutionRule(termArray[n], this.mProofRules.trueIntro(), term4);
        }
        assert (this.isApplication("false", termArray[n]) && term3 == termArray[1 - n]);
        Term term5 = this.proveIff(term, this.mProofRules.xorIntro(termArray3, termArray2, termArray), this.mProofRules.xorIntro(termArray, termArray2, termArray3));
        return this.mProofRules.resolutionRule(termArray[n], term5, this.mProofRules.falseElim());
    }

    private Term convertRewriteXorSame(Term term, Term term2, Term term3) {
        assert (this.isApplication("xor", term2));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        assert (termArray.length == 2 && termArray[0] == termArray[1] && this.isApplication("false", term3));
        return this.proveIffFalse(term, this.mProofRules.xorElim(termArray, termArray, termArray));
    }

    private Term convertRewriteEqSimp(String string, Term term, Term term2) {
        assert (this.isApplication("=", term));
        Theory theory = term.getTheory();
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        LinkedHashMap<Term, Integer> linkedHashMap = new LinkedHashMap<Term, Integer>();
        int n = 0;
        while (n < termArray.length) {
            linkedHashMap.put(termArray[n], n);
            ++n;
        }
        if (linkedHashMap.size() == 1) {
            assert (string.equals(":eqSame") && this.isApplication("true", term2));
            Term term3 = this.mProofRules.refl(termArray[0]);
            if (termArray.length > 2) {
                term3 = this.res(theory.term("=", new Term[]{termArray[0], termArray[0]}), term3, this.mProofRules.equalsIntro(term));
            }
            return this.proveIffTrue(theory.term("=", new Term[]{term, term2}), term3);
        }
        assert (string.equals(":eqSimp"));
        assert (this.isApplication("=", term2));
        Term[] termArray2 = ((ApplicationTerm)term2).getParameters();
        assert (termArray2.length == linkedHashMap.size());
        LinkedHashMap<Term, Integer> linkedHashMap2 = new LinkedHashMap<Term, Integer>();
        int n2 = 0;
        while (n2 < termArray2.length) {
            linkedHashMap2.put(termArray2[n2], n2);
            ++n2;
        }
        Term term4 = this.mProofRules.equalsIntro(term2);
        HashSet<Term> hashSet = new HashSet<Term>();
        int n3 = 0;
        while (n3 < termArray2.length - 1) {
            Term term5 = theory.term("=", new Term[]{termArray2[n3], termArray2[n3 + 1]});
            if (hashSet.add(term5)) {
                term4 = this.mProofRules.resolutionRule(term5, this.mProofRules.equalsElim((Integer)linkedHashMap.get(termArray2[n3]), (Integer)linkedHashMap.get(termArray2[n3 + 1]), term), term4);
            }
            ++n3;
        }
        hashSet.clear();
        Term term6 = this.mProofRules.equalsIntro(term);
        int n4 = 0;
        while (n4 < termArray.length - 1) {
            Term term7 = theory.term("=", new Term[]{termArray[n4], termArray[n4 + 1]});
            if (hashSet.add(term7)) {
                term6 = this.mProofRules.resolutionRule(term7, this.mProofRules.equalsElim((Integer)linkedHashMap2.get(termArray[n4]), (Integer)linkedHashMap2.get(termArray[n4 + 1]), term2), term6);
            }
            ++n4;
        }
        return this.proveIff(theory.term("=", new Term[]{term, term2}), term4, term6);
    }

    private Term convertRewriteEqBinary(Term term, Term term2, Term term3) {
        Theory theory = term2.getTheory();
        assert (this.isApplication("=", term2));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        assert (termArray.length >= 3);
        assert (this.isApplication("not", term3));
        Term term4 = ((ApplicationTerm)term3).getParameters()[0];
        assert (this.isApplication("or", term4));
        Term[] termArray2 = ((ApplicationTerm)term4).getParameters();
        assert (termArray.length == termArray2.length + 1);
        Term term5 = this.mProofRules.resolutionRule(term3, this.mProofRules.iffIntro1(term), this.mProofRules.notElim(term3));
        Term term6 = this.mProofRules.resolutionRule(term3, this.mProofRules.notIntro(term3), this.mProofRules.iffIntro2(term));
        term6 = this.mProofRules.resolutionRule(term4, term6, this.mProofRules.orElim(term4));
        term6 = this.mProofRules.resolutionRule(term2, this.mProofRules.equalsIntro(term2), term6);
        int n = 0;
        while (n < termArray2.length) {
            Term term7 = theory.term("=", new Term[]{termArray[n], termArray[n + 1]});
            assert (termArray2[n] == theory.term("not", new Term[]{term7}));
            term6 = this.mProofRules.resolutionRule(termArray2[n], term6, this.mProofRules.notElim(termArray2[n]));
            term6 = this.mProofRules.resolutionRule(term7, this.mProofRules.resolutionRule(termArray2[n], this.mProofRules.notIntro(termArray2[n]), this.mProofRules.resolutionRule(term4, this.mProofRules.orIntro(n, term4), this.mProofRules.resolutionRule(term2, term5, this.mProofRules.equalsElim(n, n + 1, term2)))), term6);
            ++n;
        }
        return term6;
    }

    private Term convertRewriteDistinct(String string, Term term, Term term2, Term term3) {
        Theory theory = term2.getTheory();
        assert (this.isApplication("distinct", term2));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        switch (string) {
            case ":distinctBool": {
                assert (termArray.length > 2 && termArray[0].getSort().getName() == "Bool" && this.isApplication("false", term3));
                Term term4 = theory.term("=", new Term[]{termArray[0], termArray[1]});
                Term term5 = theory.term("=", new Term[]{termArray[0], termArray[2]});
                Term term6 = theory.term("=", new Term[]{termArray[1], termArray[2]});
                Term term7 = this.mProofRules.distinctElim(0, 1, term2);
                Term term8 = this.mProofRules.distinctElim(0, 2, term2);
                Term term9 = this.mProofRules.distinctElim(1, 2, term2);
                Term term10 = this.mProofRules.resolutionRule(termArray[0], this.mProofRules.resolutionRule(termArray[1], this.mProofRules.iffIntro1(term4), this.mProofRules.resolutionRule(termArray[2], this.mProofRules.iffIntro1(term5), this.mProofRules.iffIntro2(term6))), this.mProofRules.resolutionRule(termArray[1], this.mProofRules.resolutionRule(termArray[2], this.mProofRules.iffIntro1(term6), this.mProofRules.iffIntro2(term5)), this.mProofRules.iffIntro2(term4)));
                term10 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term5, this.mProofRules.resolutionRule(term6, term10, term9), term8), term7);
                term10 = this.proveIffFalse(term, term10);
                return term10;
            }
            case ":distinctSame": {
                assert (this.isApplication("false", term3));
                HashMap<Term, Integer> hashMap = new HashMap<Term, Integer>();
                int n = 0;
                while (n < termArray.length) {
                    Integer n2 = hashMap.put(termArray[n], n);
                    if (n2 != null) {
                        Term term11 = theory.term("=", new Term[]{termArray[n], termArray[n]});
                        return this.proveIffFalse(term, this.res(term11, this.mProofRules.refl(termArray[n]), this.mProofRules.distinctElim(n2, n, term2)));
                    }
                    ++n;
                }
                throw new AssertionError();
            }
            case ":distinctBinary": {
                Term term12 = this.negate(term3);
                if (termArray.length == 2) {
                    assert (term12 == this.mSkript.term("=", new Term[]{termArray[0], termArray[1]}));
                    Term term13 = this.mProofRules.resolutionRule(term12, this.mProofRules.distinctIntro(term2), this.mProofRules.notElim(term3));
                    Term term14 = this.mProofRules.resolutionRule(term12, this.mProofRules.notIntro(term3), this.mProofRules.distinctElim(0, 1, term2));
                    return this.mProofRules.resolutionRule(term2, this.mProofRules.resolutionRule(term3, this.mProofRules.iffIntro1(term), term13), this.mProofRules.resolutionRule(term3, term14, this.mProofRules.iffIntro2(term)));
                }
                assert (this.isApplication("or", term12));
                Term[] termArray2 = ((ApplicationTerm)term12).getParameters();
                Term term15 = this.mProofRules.distinctIntro(term2);
                Term term16 = this.mProofRules.resolutionRule(term12, this.mProofRules.notIntro(term3), this.mProofRules.orElim(term12));
                int n = 0;
                int n3 = 0;
                while (n3 < termArray.length - 1) {
                    int n4 = n3 + 1;
                    while (n4 < termArray.length) {
                        assert (n < termArray2.length && termArray2[n] == this.mSkript.term("=", new Term[]{termArray[n3], termArray[n4]}));
                        term15 = this.mProofRules.resolutionRule(termArray2[n], term15, this.mProofRules.orIntro(n, term12));
                        term16 = this.mProofRules.resolutionRule(termArray2[n], term16, this.mProofRules.distinctElim(n3, n4, term2));
                        ++n;
                        ++n4;
                    }
                    ++n3;
                }
                term15 = this.mProofRules.resolutionRule(term12, term15, this.mProofRules.notElim(term3));
                assert (n == termArray2.length);
                return this.proveIff(term, term16, term15);
            }
        }
        throw new AssertionError();
    }

    private Term convertRewriteOrSimp(Term term, Term term2, Term term3) {
        assert (this.isApplication("or", term2));
        LinkedHashMap<Term, Integer> linkedHashMap = new LinkedHashMap<Term, Integer>();
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        Term term4 = null;
        int n = 0;
        while (n < termArray.length) {
            if (this.isApplication("false", termArray[n])) {
                term4 = termArray[n];
            } else {
                linkedHashMap.put(termArray[n], n);
            }
            ++n;
        }
        Term term5 = this.mProofRules.orElim(term2);
        if (term4 != null && term3 != term4) {
            term5 = this.mProofRules.resolutionRule(term4, term5, this.mProofRules.falseElim());
        }
        Term term6 = null;
        if (this.isApplication("false", term3)) {
            term6 = this.mProofRules.falseElim();
        } else if (linkedHashMap.size() > 1) {
            assert (this.isApplication("or", term3));
            Term[] termArray2 = ((ApplicationTerm)term3).getParameters();
            int n2 = 0;
            while (n2 < termArray2.length) {
                term5 = this.mProofRules.resolutionRule(termArray2[n2], term5, this.mProofRules.orIntro(n2, term3));
                ++n2;
            }
            term6 = this.mProofRules.orElim(term3);
        }
        Iterator iterator = linkedHashMap.values().iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            term6 = term6 == null ? this.mProofRules.orIntro(n3, term2) : this.mProofRules.resolutionRule(termArray[n3], term6, this.mProofRules.orIntro(n3, term2));
        }
        return this.proveIff(term, term5, term6);
    }

    private Term convertRewriteOrTaut(Term term, Term term2, Term term3) {
        assert (this.isApplication("or", term2) && this.isApplication("true", term3));
        Term term4 = this.mProofRules.iffIntro2(term);
        HashMap<Term, Integer> hashMap = new HashMap<Term, Integer>();
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        int n = 0;
        while (n < termArray.length) {
            if (this.isApplication("true", termArray[n])) {
                term4 = this.mProofRules.resolutionRule(term2, this.mProofRules.orIntro(n, term2), term4);
                break;
            }
            Integer n2 = (Integer)hashMap.get(this.negate(termArray[n]));
            if (n2 != null) {
                int n3;
                int n4;
                if (this.isApplication("not", termArray[n])) {
                    n4 = n;
                    n3 = n2;
                } else {
                    n4 = n2;
                    n3 = n;
                }
                Term term5 = this.mProofRules.resolutionRule(termArray[n3], this.mProofRules.resolutionRule(termArray[n4], this.mProofRules.notIntro(termArray[n4]), this.mProofRules.orIntro(n4, term2)), this.mProofRules.orIntro(n3, term2));
                term4 = this.mProofRules.resolutionRule(term2, term5, term4);
                break;
            }
            hashMap.put(termArray[n], n);
            ++n;
        }
        return this.mProofRules.resolutionRule(term3, this.mProofRules.trueIntro(), term4);
    }

    private Term convertRewriteCanonicalSum(Term term, Term term2) {
        Theory theory = term.getTheory();
        if (term instanceof ConstantTerm) {
            return this.proveTrivialEquality(term, term2);
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        Term[] termArray = applicationTerm.getParameters();
        switch (applicationTerm.getFunction().getName()) {
            case "+": {
                return this.mProofRules.polyAdd(term, term2);
            }
            case "*": {
                return this.mProofRules.polyMul(term, term2);
            }
            case "to_real": {
                Term term3 = ProofRules.computePolyToReal(termArray[0]);
                if (term2 == term3) {
                    return this.mProofRules.toRealDef(term);
                }
                return this.res(theory.term("=", new Term[]{term, term3}), this.mProofRules.toRealDef(term), this.res(theory.term("=", new Term[]{term3, term2}), this.mProofRules.polyAdd(term3, term2), this.mProofRules.trans(term, term3, term2)));
            }
            case "-": {
                Polynomial polynomial;
                Term term4 = ProofRules.computePolyMinus(term);
                if (term4 == term2) {
                    return this.mProofRules.minusDef(term);
                }
                if (termArray.length == 1) {
                    Term term5 = this.res(theory.term("=", new Term[]{term, term4}), this.mProofRules.minusDef(term), this.mProofRules.trans(term, term4, term2));
                    return this.res(theory.term("=", new Term[]{term4, term2}), this.mProofRules.polyMul(term4, term2), term5);
                }
                Term[] termArray2 = new Term[termArray.length];
                termArray2[0] = termArray[0];
                int n = 1;
                while (n < termArray.length) {
                    polynomial = new Polynomial();
                    polynomial.add(Rational.MONE, termArray[n]);
                    termArray2[n] = polynomial.toTerm(termArray[n].getSort());
                    ++n;
                }
                Term term6 = theory.term("+", termArray2);
                polynomial = term6 != term2 ? this.res(theory.term("=", new Term[]{term6, term2}), this.mProofRules.polyAdd(term6, term2), this.mProofRules.trans(term, term4, term6, term2)) : this.mProofRules.trans(term, term4, term6);
                polynomial = this.res(theory.term("=", new Term[]{term, term4}), this.mProofRules.minusDef(term), (Term)polynomial);
                polynomial = this.res(theory.term("=", new Term[]{term4, term6}), this.mProofRules.cong(term4, term6), (Term)polynomial);
                HashSet<Term> hashSet = new HashSet<Term>();
                Term[] termArray3 = ((ApplicationTerm)term4).getParameters();
                int n2 = 0;
                while (n2 < termArray3.length) {
                    Term term7 = theory.term("=", new Term[]{termArray3[n2], termArray2[n2]});
                    if (hashSet.add(term7)) {
                        Term term8 = termArray3[n2] == termArray2[n2] ? this.mProofRules.refl(termArray3[n2]) : this.mProofRules.polyMul(termArray3[n2], termArray2[n2]);
                        polynomial = this.res(term7, term8, (Term)polynomial);
                    }
                    ++n2;
                }
                return polynomial;
            }
            case "/": {
                Term term9;
                Term term10 = this.mProofRules.divideDef(term);
                Sort sort = term.getSort();
                Term term11 = Rational.ZERO.toTerm(sort);
                Term[] termArray4 = new Term[termArray.length];
                Rational rational = Rational.ONE;
                int n = 1;
                while (n < termArray.length) {
                    term9 = theory.term("=", new Term[]{termArray[n], term11});
                    term10 = this.res(term9, term10, this.proveTrivialDisequality(termArray[n], term11));
                    rational = rational.mul(this.parseConstant(termArray[n]));
                    termArray4[n - 1] = termArray[n];
                    ++n;
                }
                termArray4[termArray4.length - 1] = term;
                Term term12 = theory.term("*", termArray4);
                if (termArray4.length > 2) {
                    term9 = theory.term("*", new Term[]{rational.toTerm(sort), term});
                    term10 = this.res(theory.term("=", new Term[]{term9, term12}), this.res(theory.term("=", new Term[]{term12, term9}), this.mProofRules.polyMul(term12, term9), this.mProofRules.symm(term9, term12)), this.mProofRules.trans(term9, term12, termArray[0]));
                    term12 = term9;
                }
                return this.res(theory.term("=", new Term[]{term12, termArray[0]}), term10, this.proveEqWithMultiplier(new Term[]{term12, termArray[0]}, new Term[]{term, term2}, rational.inverse()));
            }
        }
        throw new AssertionError();
    }

    private Term convertRewriteToInt(Term term, Term term2) {
        assert (this.isApplication("to_int", term));
        Term term3 = ((ApplicationTerm)term).getParameters()[0];
        Rational rational = this.parseConstant(term3);
        Rational rational2 = this.parseConstant(term2);
        assert (rational != null && rational2 != null && rational2.equals((Object)rational.floor()));
        Theory theory = term.getTheory();
        Term term4 = theory.term("+", new Term[]{term, rational2.negate().toTerm(term2.getSort())});
        Term term5 = theory.term("<", new Term[]{term, term2});
        Term term6 = theory.term("<", new Term[]{term2, term});
        Term term7 = theory.term("<=", new Term[]{term4, Rational.MONE.toTerm(term2.getSort())});
        Term term8 = theory.term("<=", new Term[]{Rational.ZERO.toTerm(term2.getSort()), term4});
        Term term9 = theory.term("<=", new Term[]{term4, Rational.ZERO.toTerm(term2.getSort())});
        Term term10 = theory.term("<=", new Term[]{Rational.ONE.toTerm(term2.getSort()), term4});
        Term term11 = this.mProofRules.trichotomy(term, term2);
        Term term12 = Rational.ONE.toTerm(term3.getSort());
        Term term13 = theory.term("<=", new Term[]{theory.term("to_real", new Term[]{term}), term3});
        Term term14 = theory.term("<", new Term[]{term3, theory.term("+", new Term[]{theory.term("to_real", new Term[]{term}), term12})});
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.ONE, BigInteger.ONE};
        term11 = this.res(term6, term11, this.mProofRules.farkas(new Term[]{term6, term9}, bigIntegerArray));
        term11 = this.res(term9, this.mProofRules.totalInt(term4, BigInteger.ZERO), term11);
        term11 = this.res(term10, term11, this.mProofRules.farkas(new Term[]{term13, term10}, bigIntegerArray));
        term11 = this.res(term5, term11, this.mProofRules.farkas(new Term[]{term5, term8}, bigIntegerArray));
        term11 = this.res(term8, this.mProofRules.totalInt(term4, BigInteger.ONE.negate()), term11);
        term11 = this.res(term7, term11, this.mProofRules.farkas(new Term[]{term14, term7}, bigIntegerArray));
        term11 = this.res(term13, this.mProofRules.toIntLow(term3), term11);
        term11 = this.res(term14, this.mProofRules.toIntHigh(term3), term11);
        return term11;
    }

    private Term convertRewriteStoreOverStore(Term term, Term term2) {
        assert (this.isApplication("store", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        Term term3 = termArray[0];
        Term term4 = termArray[1];
        Term term5 = termArray[2];
        assert (this.isApplication("store", term3));
        Term[] termArray2 = ((ApplicationTerm)term3).getParameters();
        Term term6 = termArray2[0];
        Term term7 = termArray2[1];
        Term term8 = this.proveTrivialEquality(term4, term7);
        assert (term2 == this.mSkript.term("store", new Term[]{term6, term4, term5}));
        Theory theory = term.getTheory();
        Term term9 = theory.term("@diff", new Term[]{term, term2});
        Term term10 = theory.term("select", new Term[]{term, term9});
        Term term11 = theory.term("select", new Term[]{term3, term9});
        Term term12 = theory.term("select", new Term[]{term6, term9});
        Term term13 = theory.term("select", new Term[]{term2, term9});
        Term term14 = theory.term("select", new Term[]{term, term4});
        Term term15 = theory.term("select", new Term[]{term2, term4});
        Term term16 = this.mProofRules.trans(term10, term14, term5, term15, term13);
        term16 = this.res(theory.term("=", new Term[]{term10, term14}), this.mProofRules.cong(term10, term14), term16);
        term16 = this.res(theory.term("=", new Term[]{term, term}), this.mProofRules.refl(term), term16);
        term16 = this.res(theory.term("=", new Term[]{term9, term4}), this.mProofRules.symm(term9, term4), term16);
        term16 = this.res(theory.term("=", new Term[]{term14, term5}), this.mProofRules.selectStore1(term3, term4, term5), term16);
        term16 = this.res(theory.term("=", new Term[]{term5, term15}), this.mProofRules.symm(term5, term15), term16);
        term16 = this.res(theory.term("=", new Term[]{term15, term5}), this.mProofRules.selectStore1(term6, term4, term5), term16);
        term16 = this.res(theory.term("=", new Term[]{term15, term13}), this.mProofRules.cong(term15, term13), term16);
        term16 = this.res(theory.term("=", new Term[]{term2, term2}), this.mProofRules.refl(term2), term16);
        Term term17 = this.mProofRules.trans(term10, term11, term12, term13);
        term17 = this.res(theory.term("=", new Term[]{term10, term11}), this.mProofRules.selectStore2(term3, term4, term5, term9), term17);
        term17 = this.res(theory.term("=", new Term[]{term11, term12}), this.mProofRules.selectStore2(term6, term7, termArray2[2], term9), term17);
        if (term7 != term4) {
            term17 = this.res(theory.term("=", new Term[]{term7, term9}), term17, this.mProofRules.trans(term4, term7, term9));
            term17 = this.res(theory.term("=", new Term[]{term4, term7}), term8, term17);
        }
        term17 = this.res(theory.term("=", new Term[]{term12, term13}), this.mProofRules.symm(term12, term13), term17);
        term17 = this.res(theory.term("=", new Term[]{term13, term12}), this.mProofRules.selectStore2(term6, term4, term5, term9), term17);
        Term term18 = this.res(theory.term("=", new Term[]{term4, term9}), term17, term16);
        term18 = this.res(theory.term("=", new Term[]{term10, term13}), term18, this.mProofRules.extDiff(term, term2));
        return term18;
    }

    private Term convertRewriteSelectOverStore(Term term, Term term2) {
        Polynomial polynomial;
        boolean bl;
        Theory theory = term.getTheory();
        assert (this.isApplication("select", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        Term term3 = termArray[0];
        assert (this.isApplication("store", term3));
        Term[] termArray2 = ((ApplicationTerm)term3).getParameters();
        Term term4 = termArray2[0];
        Term term5 = termArray2[1];
        Term term6 = termArray2[2];
        Term term7 = termArray[1];
        if (term5 == term7) {
            bl = true;
        } else {
            polynomial = new Polynomial(term5);
            polynomial.add(Rational.MONE, term7);
            bl = polynomial.isZero();
        }
        if (bl) {
            assert (term2 == termArray2[2]);
            polynomial = theory.term("select", new Term[]{term3, term5});
            Term term8 = this.mProofRules.trans(new Term[]{term, polynomial, term6});
            term8 = this.res(theory.term("=", new Term[]{term, polynomial}), this.mProofRules.cong(term, (Term)polynomial), term8);
            term8 = this.res(theory.term("=", new Term[]{term3, term3}), this.mProofRules.refl(term3), term8);
            term8 = this.res(theory.term("=", new Term[]{term7, term5}), this.proveTrivialEquality(term7, term5), term8);
            term8 = this.res(theory.term("=", new Term[]{polynomial, term6}), this.mProofRules.selectStore1(term4, term5, term6), term8);
            return term8;
        }
        polynomial = this.proveTrivialDisequality(term5, term7);
        assert (polynomial != null);
        return this.res(theory.term("=", new Term[]{term5, term7}), this.mProofRules.selectStore2(term4, term5, term6, term7), (Term)polynomial);
    }

    private Term convertRewriteAuxIntro(Term term, Term term2, Term term3) {
        Term term4 = this.mSkript.term("=", new Term[]{term3, term2});
        return this.res(term4, this.mProofRules.expand(term3), this.mProofRules.symm(term2, term3));
    }

    private Term convertRewriteStore(Term term, Term term2, Term term3) {
        Theory theory = term2.getTheory();
        assert (this.isApplication("=", term2));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        int n = this.isApplication("store", termArray[0]) && ((ApplicationTerm)termArray[0]).getParameters()[0] == termArray[1] ? 0 : 1;
        Term term4 = termArray[n];
        Term[] termArray2 = ((ApplicationTerm)term4).getParameters();
        Term term5 = termArray2[0];
        Term term6 = termArray2[1];
        Term term7 = termArray2[2];
        assert (this.isApplication("store", term4) && term5 == termArray[1 - n]);
        Term term8 = theory.term("@diff", new Term[]{term4, term5});
        Term term9 = theory.term("select", new Term[]{term5, term8});
        Term term10 = theory.term("select", new Term[]{term4, term8});
        Term term11 = theory.term("select", new Term[]{term5, term6});
        Term term12 = theory.term("select", new Term[]{term4, term6});
        Term term13 = this.res(theory.term("=", new Term[]{term11, term12}), this.res(theory.term("=", new Term[]{term6, term6}), this.mProofRules.refl(term6), this.mProofRules.cong(term11, term12)), this.mProofRules.trans(term11, term12, term7));
        Term term14 = this.mProofRules.trans(term10, term12, term7, term11, term9);
        term14 = this.res(theory.term("=", new Term[]{term10, term12}), this.mProofRules.cong(term10, term12), term14);
        term14 = this.res(theory.term("=", new Term[]{term8, term6}), this.mProofRules.symm(term8, term6), term14);
        term14 = this.res(theory.term("=", new Term[]{term4, term4}), this.mProofRules.refl(term4), term14);
        term14 = this.res(theory.term("=", new Term[]{term7, term11}), this.mProofRules.symm(term7, term11), term14);
        term14 = this.res(theory.term("=", new Term[]{term11, term9}), this.mProofRules.cong(term11, term9), term14);
        term14 = this.res(theory.term("=", new Term[]{term5, term5}), this.mProofRules.refl(term5), term14);
        term14 = this.res(theory.term("=", new Term[]{term6, term8}), this.mProofRules.selectStore2(term5, term6, term7, term8), term14);
        term14 = this.res(theory.term("=", new Term[]{term10, term9}), term14, this.mProofRules.extDiff(term4, term5));
        if (n == 0) {
            term13 = this.res(theory.term("=", new Term[]{term5, term4}), this.mProofRules.symm(term5, term4), term13);
        } else {
            term14 = this.res(theory.term("=", new Term[]{term4, term5}), term14, this.mProofRules.symm(term5, term4));
        }
        Term term15 = this.proveIff(term, term13, term14);
        term15 = this.res(theory.term("=", new Term[]{term12, term7}), this.mProofRules.selectStore1(term5, term6, term7), term15);
        return term15;
    }

    private Term convertRewriteToLeq0(String string, Term term, Term term2) {
        String string2;
        Object object = string2 = (switch (string) {
            case ":leqToLeq0" -> {
                if (!$assertionsDisabled && !this.isApplication("<=", term)) {
                    throw new AssertionError();
                }
                yield false;
            }
            case ":ltToLeq0" -> {
                if (!$assertionsDisabled && !this.isApplication("<", term)) {
                    throw new AssertionError();
                }
                yield true;
            }
            case ":geqToLeq0" -> {
                if (!$assertionsDisabled && !this.isApplication(">=", term)) {
                    throw new AssertionError();
                }
                yield false;
            }
            case ":gtToLeq0" -> {
                if (!$assertionsDisabled && !this.isApplication(">", term)) {
                    throw new AssertionError();
                }
                yield true;
            }
            default -> throw new AssertionError();
        }) ? this.negate(term2) : term2;
        assert (this.isApplication("<=", (Term)string2));
        return this.proveRewriteWithLeq(term, term2, false);
    }

    private Term convertRewriteIte(String string, Term term, Term term2, Term term3) {
        assert (this.isApplication("ite", term2));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        Term term4 = termArray[0];
        Term term5 = termArray[1];
        Term term6 = termArray[2];
        switch (string) {
            case ":iteTrue": {
                return this.mProofRules.resolutionRule(term4, this.mProofRules.trueIntro(), this.mProofRules.ite1(term2));
            }
            case ":iteFalse": {
                return this.mProofRules.resolutionRule(term4, this.mProofRules.ite2(term2), this.mProofRules.falseElim());
            }
            case ":iteSame": {
                return this.mProofRules.resolutionRule(term4, this.mProofRules.ite2(term2), this.mProofRules.ite1(term2));
            }
            case ":iteBool1": {
                assert (this.isApplication("true", term5) && this.isApplication("false", term6) && term3 == term4);
                Term term7 = this.mSkript.term("=", new Term[]{term2, term6});
                Term term8 = this.mProofRules.resolutionRule(term7, this.mProofRules.ite2(term2), this.mProofRules.iffElim2(term7));
                term8 = this.mProofRules.resolutionRule(term6, term8, this.mProofRules.falseElim());
                Term term9 = this.mSkript.term("=", new Term[]{term2, term5});
                Term term10 = this.mProofRules.resolutionRule(term9, this.mProofRules.ite1(term2), this.mProofRules.iffElim1(term9));
                term10 = this.mProofRules.resolutionRule(term5, this.mProofRules.trueIntro(), term10);
                return this.proveIff(term, term8, term10);
            }
            case ":iteBool2": {
                assert (this.isApplication("false", term5) && this.isApplication("true", term6) && term3 == this.mSkript.term("not", new Term[]{term4}));
                Term term11 = this.mSkript.term("=", new Term[]{term2, term5});
                Term term12 = this.mProofRules.resolutionRule(term11, this.mProofRules.ite1(term2), this.mProofRules.iffElim2(term11));
                term12 = this.mProofRules.resolutionRule(term5, term12, this.mProofRules.falseElim());
                term12 = this.mProofRules.resolutionRule(term4, this.mProofRules.notIntro(term3), term12);
                Term term13 = this.mSkript.term("=", new Term[]{term2, term6});
                Term term14 = this.mProofRules.resolutionRule(term13, this.mProofRules.ite2(term2), this.mProofRules.iffElim1(term13));
                term14 = this.mProofRules.resolutionRule(term6, this.mProofRules.trueIntro(), term14);
                term14 = this.mProofRules.resolutionRule(term4, term14, this.mProofRules.notElim(term3));
                return this.proveIff(term, term12, term14);
            }
            case ":iteBool3": {
                assert (this.isApplication("true", term5) && term3 == this.mSkript.term("or", new Term[]{term4, term6}));
                Term term15 = this.mSkript.term("=", new Term[]{term2, term5});
                Term term16 = this.mSkript.term("=", new Term[]{term2, term6});
                Term term17 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term6, this.mProofRules.resolutionRule(term16, this.mProofRules.ite2(term2), this.mProofRules.iffElim2(term16)), this.mProofRules.orIntro(1, term3)), this.mProofRules.orIntro(0, term3));
                Term term18 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term6, this.mProofRules.orElim(term3), this.mProofRules.resolutionRule(term16, this.mProofRules.ite2(term2), this.mProofRules.iffElim1(term16))), this.mProofRules.resolutionRule(term15, this.mProofRules.ite1(term2), this.mProofRules.iffElim1(term15)));
                term18 = this.mProofRules.resolutionRule(term5, this.mProofRules.trueIntro(), term18);
                return this.proveIff(term, term17, term18);
            }
            case ":iteBool4": {
                assert (this.isApplication("false", term5) && term3 == this.mSkript.term("not", new Term[]{this.mSkript.term("or", new Term[]{term4, this.mSkript.term("not", new Term[]{term6})})}));
                Term term19 = ((ApplicationTerm)term3).getParameters()[0];
                Term term20 = ((ApplicationTerm)term19).getParameters()[1];
                Term term21 = this.mSkript.term("=", new Term[]{term2, term5});
                Term term22 = this.mSkript.term("=", new Term[]{term2, term6});
                Term term23 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term20, this.mProofRules.orElim(term19), this.mProofRules.resolutionRule(term6, this.mProofRules.resolutionRule(term22, this.mProofRules.ite2(term2), this.mProofRules.iffElim2(term22)), this.mProofRules.notElim(term20))), this.mProofRules.resolutionRule(term21, this.mProofRules.ite1(term2), this.mProofRules.iffElim2(term21)));
                term23 = this.mProofRules.resolutionRule(term5, term23, this.mProofRules.falseElim());
                term23 = this.mProofRules.resolutionRule(term19, this.mProofRules.notIntro(term3), term23);
                Term term24 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term6, this.mProofRules.resolutionRule(term20, this.mProofRules.notIntro(term20), this.mProofRules.orIntro(1, term19)), this.mProofRules.resolutionRule(term22, this.mProofRules.ite2(term2), this.mProofRules.iffElim1(term22))), this.mProofRules.orIntro(0, term19));
                term24 = this.mProofRules.resolutionRule(term19, term24, this.mProofRules.notElim(term3));
                return this.proveIff(term, term23, term24);
            }
            case ":iteBool5": {
                Term term25 = this.mSkript.term("not", new Term[]{term4});
                assert (this.isApplication("true", term6) && term3 == this.mSkript.term("or", new Term[]{term25, term5}));
                Term term26 = this.mSkript.term("=", new Term[]{term2, term5});
                Term term27 = this.mSkript.term("=", new Term[]{term2, term6});
                Term term28 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term25, this.mProofRules.notIntro(term25), this.mProofRules.orIntro(0, term3)), this.mProofRules.resolutionRule(term5, this.mProofRules.resolutionRule(term26, this.mProofRules.ite1(term2), this.mProofRules.iffElim2(term26)), this.mProofRules.orIntro(1, term3)));
                Term term29 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term27, this.mProofRules.ite2(term2), this.mProofRules.iffElim1(term27)), this.mProofRules.resolutionRule(term5, this.mProofRules.resolutionRule(term25, this.mProofRules.orElim(term3), this.mProofRules.notElim(term25)), this.mProofRules.resolutionRule(term26, this.mProofRules.ite1(term2), this.mProofRules.iffElim1(term26))));
                term29 = this.mProofRules.resolutionRule(term6, this.mProofRules.trueIntro(), term29);
                return this.proveIff(term, term28, term29);
            }
            case ":iteBool6": {
                assert (this.isApplication("false", term6) && term3 == this.mSkript.term("not", new Term[]{this.mSkript.term("or", new Term[]{this.mSkript.term("not", new Term[]{term4}), this.mSkript.term("not", new Term[]{term5})})}));
                Term term30 = ((ApplicationTerm)term3).getParameters()[0];
                Term term31 = ((ApplicationTerm)term30).getParameters()[1];
                Term term32 = ((ApplicationTerm)term30).getParameters()[0];
                Term term33 = this.mSkript.term("=", new Term[]{term2, term5});
                Term term34 = this.mSkript.term("=", new Term[]{term2, term6});
                Term term35 = this.mProofRules.resolutionRule(term4, this.mProofRules.resolutionRule(term34, this.mProofRules.ite2(term2), this.mProofRules.iffElim2(term34)), this.mProofRules.resolutionRule(term32, this.mProofRules.resolutionRule(term31, this.mProofRules.orElim(term30), this.mProofRules.resolutionRule(term5, this.mProofRules.resolutionRule(term33, this.mProofRules.ite1(term2), this.mProofRules.iffElim2(term33)), this.mProofRules.notElim(term31))), this.mProofRules.notElim(term32)));
                term35 = this.mProofRules.resolutionRule(term6, term35, this.mProofRules.falseElim());
                term35 = this.mProofRules.resolutionRule(term30, this.mProofRules.notIntro(term3), term35);
                Term term36 = this.mProofRules.resolutionRule(term32, this.mProofRules.resolutionRule(term4, this.mProofRules.notIntro(term32), this.mProofRules.resolutionRule(term5, this.mProofRules.resolutionRule(term31, this.mProofRules.notIntro(term31), this.mProofRules.orIntro(1, term30)), this.mProofRules.resolutionRule(term33, this.mProofRules.ite1(term2), this.mProofRules.iffElim1(term33)))), this.mProofRules.orIntro(0, term30));
                term36 = this.mProofRules.resolutionRule(term30, term36, this.mProofRules.notElim(term3));
                return this.proveIff(term, term35, term36);
            }
        }
        throw new AssertionError();
    }

    private Term convertRewriteConstDiff(Term term, Term term2, Term term3) {
        assert (this.isApplication("=", term2) && this.isApplication("false", term3));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        assert (termArray[0].getSort().isNumericSort());
        int n = -1;
        Rational rational = null;
        int n2 = 0;
        while (n2 < termArray.length) {
            Rational rational2 = this.parseConstant(termArray[n2]);
            if (rational2 != null) {
                if (n < 0) {
                    n = n2;
                    rational = rational2;
                } else if (!rational.equals((Object)rational2)) {
                    Term term4 = this.proveTrivialDisequality(termArray[n], termArray[n2]);
                    if (termArray.length > 2) {
                        term4 = this.mProofRules.resolutionRule(term2.getTheory().term("=", new Term[]{termArray[n], termArray[n2]}), this.mProofRules.equalsElim(n, n2, term2), term4);
                    }
                    term4 = this.proveIffFalse(term, term4);
                    return term4;
                }
            }
            ++n2;
        }
        throw new AssertionError();
    }

    private Term proveDivWithFarkas(Term term, Term term2) {
        Term term3;
        Term term4;
        Theory theory = term.getTheory();
        Sort sort = term.getSort();
        assert (this.isApplication("div", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        assert (termArray.length == 2);
        Rational rational = this.parseConstant(termArray[1]);
        assert (rational != null && rational.isIntegral());
        Polynomial polynomial = new Polynomial();
        polynomial.add(Rational.MONE, term2);
        polynomial.add(rational.inverse(), termArray[0]);
        assert (polynomial.isConstant());
        Rational rational2 = polynomial.getConstant();
        assert (rational2.abs().compareTo(Rational.ONE) < 0);
        assert (rational2.signum() * rational.signum() != -1);
        Term term5 = Rational.ZERO.toTerm(sort);
        Term term6 = theory.term("abs", new Term[]{termArray[1]});
        Term term7 = rational.abs().toTerm(sort);
        Term term8 = theory.term("<=", new Term[]{theory.term("*", new Term[]{termArray[1], term}), termArray[0]});
        Term term9 = theory.term("<", new Term[]{termArray[0], theory.term("+", new Term[]{theory.term("*", new Term[]{termArray[1], term}), term6})});
        Polynomial polynomial2 = new Polynomial(term);
        polynomial2.add(Rational.MONE, term2);
        Term term10 = polynomial2.toTerm(sort);
        Term term11 = this.mProofRules.trichotomy(term, term2);
        Term term12 = theory.term("<", new Term[]{term, term2});
        Term term13 = theory.term("<", new Term[]{term2, term});
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.ONE, BigInteger.ONE};
        if (rational.signum() < 0 || rational2.signum() != 0) {
            term4 = theory.term("<=", new Term[]{term10, term5});
            term3 = theory.term("<=", new Term[]{Rational.ONE.toTerm(sort), term10});
            term11 = this.res(term13, term11, this.mProofRules.farkas(new Term[]{term13, term4}, bigIntegerArray));
            term11 = this.res(term4, this.mProofRules.totalInt(term10, BigInteger.ZERO), term11);
            term13 = term3;
        }
        if (rational.signum() > 0 || rational2.signum() != 0) {
            term4 = theory.term("<=", new Term[]{term5, term10});
            term3 = theory.term("<=", new Term[]{term10, Rational.MONE.toTerm(sort)});
            term11 = this.res(term12, term11, this.mProofRules.farkas(new Term[]{term12, term4}, bigIntegerArray));
            term11 = this.res(term4, this.mProofRules.totalInt(term10, BigInteger.ONE.negate()), term11);
            term12 = term3;
        }
        term4 = rational.signum() > 0 ? term13 : term12;
        term3 = rational.signum() > 0 ? term12 : term13;
        BigInteger[] bigIntegerArray2 = new BigInteger[]{BigInteger.ONE, rational.abs().numerator()};
        BigInteger[] bigIntegerArray3 = new BigInteger[]{BigInteger.ONE, rational.abs().numerator(), BigInteger.ONE};
        Term term14 = theory.term("=", new Term[]{term6, term7});
        term11 = this.res(term4, term11, this.mProofRules.farkas(new Term[]{term8, term4}, bigIntegerArray2));
        term11 = this.res(term3, term11, this.mProofRules.farkas(new Term[]{term9, term3, term14}, bigIntegerArray3));
        term11 = this.res(term14, this.proveAbsConstant(rational, sort), term11);
        term11 = this.res(term9, this.mProofRules.divHigh(termArray[0], termArray[1]), term11);
        term11 = this.res(term8, this.mProofRules.divLow(termArray[0], termArray[1]), term11);
        return term11;
    }

    private Term convertRewriteDiv(String string, Term term, Term term2) {
        assert (this.isApplication("div", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        assert (termArray.length == 2);
        Rational rational = this.parseConstant(termArray[1]);
        assert (rational != null && rational.isIntegral());
        Theory theory = term.getTheory();
        Term term3 = Rational.ZERO.toTerm(term.getSort());
        return this.res(theory.term("=", new Term[]{termArray[1], term3}), this.proveDivWithFarkas(term, term2), this.proveTrivialDisequality(termArray[1], term3));
    }

    private Term convertRewriteModulo(String string, Term term, Term term2) {
        Object object;
        assert (this.isApplication("mod", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        assert (termArray.length == 2);
        Term term3 = term.getTheory().term("div", termArray);
        Rational rational = this.parseConstant(termArray[1]);
        assert (rational != null && rational != Rational.ZERO);
        Theory theory = term.getTheory();
        Sort sort = term.getSort();
        Term term4 = this.mProofRules.modDef(termArray[0], termArray[1]);
        Term term5 = Rational.ZERO.toTerm(sort);
        Term term6 = theory.term("+", new Term[]{theory.term("*", new Term[]{termArray[1], term3}), term});
        Term term7 = theory.term("=", new Term[]{term6, termArray[0]});
        Polynomial polynomial = new Polynomial(termArray[0]);
        polynomial.add(rational.negate(), term3);
        Term term8 = switch (string) {
            case ":modulo1" -> {
                if (!($assertionsDisabled || rational.equals((Object)Rational.ONE) && this.isZero(term2))) {
                    throw new AssertionError();
                }
                yield termArray[0];
            }
            case ":modulo-1" -> {
                if (!($assertionsDisabled || rational.equals((Object)Rational.MONE) && this.isZero(term2))) {
                    throw new AssertionError();
                }
                object = new Polynomial(termArray[0]);
                ((Polynomial)object).mul(Rational.MONE);
                yield ((Polynomial)object).toTerm(sort);
            }
            case ":moduloConst" -> {
                object = this.parseConstant(termArray[0]);
                Rational var17_17 = object.div(rational.abs()).floor();
                if (rational.signum() < 0) {
                    var17_17 = var17_17.negate();
                }
                yield var17_17.toTerm(sort);
            }
            case ":modulo" -> {
                if (!$assertionsDisabled && !new Polynomial(term2).equals(polynomial)) {
                    throw new AssertionError();
                }
                yield term3;
            }
            default -> throw new AssertionError();
        };
        String string2 = term8 == term3 ? term2 : polynomial.toTerm(sort);
        term4 = this.res(term7, term4, this.proveEqWithMultiplier(new Term[]{term6, termArray[0]}, new Term[]{term, string2}, Rational.ONE));
        if (term8 != term3) {
            object = this.res(theory.term("=", new Term[]{term3, term8}), this.proveDivWithFarkas(term3, term8), this.proveEqWithMultiplier(new Term[]{term3, term8}, new Term[]{string2, term2}, rational.negate()));
            term4 = this.res(theory.term("=", new Term[]{term, string2}), term4, this.res(theory.term("=", new Term[]{string2, term2}), (Term)object, this.mProofRules.trans(new Term[]{term, string2, term2})));
        }
        term4 = this.res(theory.term("=", new Term[]{termArray[1], term5}), term4, this.proveTrivialDisequality(termArray[1], term5));
        return term4;
    }

    private Term convertRewriteDivisible(String string, Term term, Term term2) {
        Term term3;
        assert (this.isApplication("divisible", term));
        BigInteger bigInteger = new BigInteger(((ApplicationTerm)term).getFunction().getIndices()[0]);
        Term term4 = ((ApplicationTerm)term).getParameters()[0];
        Term term5 = this.mProofRules.divisible(bigInteger, term4);
        if (this.isApplication("=", term2)) {
            return term5;
        }
        Theory theory = term.getTheory();
        Rational rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
        Term term6 = rational.toTerm(term4.getSort());
        Term term7 = theory.term("div", new Term[]{term4, term6});
        Term term8 = theory.term("*", new Term[]{term6, term7});
        Term term9 = theory.term("=", new Term[]{term4, term8});
        Term term10 = theory.term("=", new Term[]{term9, term2});
        if (this.isApplication("false", term2)) {
            assert (this.isApplication("false", term2));
            term3 = this.res(term2, this.res(term9, this.mProofRules.iffIntro1(term10), this.proveTrivialDisequality(term4, term8)), this.mProofRules.falseElim());
        } else {
            assert (this.isApplication("true", term2));
            Term term11 = term2;
            Polynomial polynomial = new Polynomial(term4);
            polynomial.mul(rational.inverse());
            assert (polynomial.getGcd().isIntegral() && polynomial.getConstant().isIntegral());
            Term term12 = polynomial.toTerm(term4.getSort());
            Term term13 = Rational.ZERO.toTerm(term4.getSort());
            Term term14 = this.res(theory.term("=", new Term[]{term7, term12}), this.proveDivWithFarkas(term7, term12), this.proveEqWithMultiplier(new Term[]{term7, term12}, new Term[]{term4, term8}, rational.negate()));
            term14 = this.res(theory.term("=", new Term[]{term6, term13}), term14, this.proveTrivialDisequality(term6, term13));
            term3 = this.res(term11, this.mProofRules.trueIntro(), this.res(term9, term14, this.mProofRules.iffIntro2(term10)));
        }
        return this.res(term10, term3, this.res(theory.term("=", new Term[]{term, term9}), term5, this.mProofRules.trans(term, term9, term2)));
    }

    private Term convertRewrite(Term term, Term term2, Annotation annotation) {
        Term term3 = term.getTheory().term("=", new Term[]{term, term2});
        String string = annotation.getKey();
        assert (this.isApplication("=", term3));
        Term term4 = switch (string) {
            case ":expand", ":expandDef" -> this.mProofRules.expand(term);
            case ":intern" -> this.convertRewriteIntern(term, term2);
            case ":notSimp" -> this.convertRewriteNot(term3, term, term2);
            case ":trueNotFalse" -> this.convertRewriteTrueNotFalse(term, term2);
            case ":eqTrue", ":eqFalse" -> this.convertRewriteEqTrueFalse(string, term, term2);
            case ":eqSame", ":eqSimp" -> this.convertRewriteEqSimp(string, term, term2);
            case ":eqBinary" -> this.convertRewriteEqBinary(term3, term, term2);
            case ":distinctToXor", ":eqToXor" -> this.convertRewriteToXor(string, term3, term, term2);
            case ":xorFalse", ":xorTrue" -> this.convertRewriteXorConst(string, term3, term, term2);
            case ":xorNot" -> this.convertRewriteXorNot(term3, term, term2);
            case ":xorSame" -> this.convertRewriteXorSame(term3, term, term2);
            case ":orSimp" -> this.convertRewriteOrSimp(term3, term, term2);
            case ":orTaut" -> this.convertRewriteOrTaut(term3, term, term2);
            case ":distinctBinary", ":distinctBool", ":distinctSame" -> this.convertRewriteDistinct(string, term3, term, term2);
            case ":leqTrue", ":leqFalse" -> this.convertRewriteLeq(string, term3, term, term2);
            case ":leqToLeq0", ":geqToLeq0", ":gtToLeq0", ":ltToLeq0" -> this.convertRewriteToLeq0(string, term, term2);
            case ":iteBool1", ":iteBool2", ":iteBool3", ":iteBool4", ":iteBool5", ":iteBool6", ":iteFalse", ":iteSame", ":iteTrue" -> this.convertRewriteIte(string, term3, term, term2);
            case ":constDiff" -> this.convertRewriteConstDiff(term3, term, term2);
            case ":strip" -> this.mProofRules.delAnnot(term);
            case ":canonicalSum" -> this.convertRewriteCanonicalSum(term, term2);
            case ":toInt" -> this.convertRewriteToInt(term, term2);
            case ":divConst", ":div1", ":div-1" -> this.convertRewriteDiv(string, term, term2);
            case ":moduloConst", ":modulo", ":modulo1", ":modulo-1" -> this.convertRewriteModulo(string, term, term2);
            case ":divisible" -> this.convertRewriteDivisible(string, term, term2);
            case ":storeOverStore" -> this.convertRewriteStoreOverStore(term, term2);
            case ":selectOverStore" -> this.convertRewriteSelectOverStore(term, term2);
            case ":storeRewrite" -> this.convertRewriteStore(term3, term, term2);
            case ":auxIntro" -> this.convertRewriteAuxIntro(term3, term, term2);
            default -> this.mProofRules.oracle(this.termToProofLiterals(term3), new Annotation[]{annotation});
        };
        assert (this.checkProof(term4, this.termToProofLiterals(term3)));
        return this.annotateProved(term3, term4);
    }

    private Term convertLALemma(ProofLiteral[] proofLiteralArray, Term[] termArray) {
        assert (proofLiteralArray.length == termArray.length);
        Theory theory = this.mSkript.getTheory();
        BigInteger[] bigIntegerArray = new BigInteger[termArray.length];
        Term[] termArray2 = new Term[proofLiteralArray.length];
        Term[] termArray3 = new Term[proofLiteralArray.length];
        Term[] termArray4 = new Term[proofLiteralArray.length];
        int n = 0;
        while (n < proofLiteralArray.length) {
            Term term;
            Term term2;
            Rational rational = this.parseConstant(termArray[n]);
            assert (rational.isIntegral() && rational != Rational.ZERO);
            bigIntegerArray[n] = rational.numerator().abs();
            boolean bl = !proofLiteralArray[n].getPolarity();
            Term term3 = proofLiteralArray[n].getAtom();
            Term[] termArray5 = ((ApplicationTerm)term3).getParameters();
            if (this.isApplication("=", term3)) {
                assert (bl);
                if (rational.signum() > 0) {
                    term2 = theory.term("=", new Term[]{termArray5[0], termArray5[1]});
                    term = null;
                } else {
                    term2 = theory.term("=", new Term[]{termArray5[1], termArray5[0]});
                    term = this.mProofRules.symm(termArray5[1], termArray5[0]);
                }
            } else if (bl) {
                assert (rational.signum() > 0);
                term2 = term3;
                term = null;
            } else {
                assert (rational.signum() < 0);
                if (this.isApplication("<=", term3)) {
                    Sort sort = termArray5[0].getSort();
                    if (sort.getName().equals("Int")) {
                        assert (this.isZero(termArray5[1]));
                        term2 = theory.term("<=", new Term[]{Rational.ONE.toTerm(sort), termArray5[0]});
                        term = this.mProofRules.totalInt(termArray5[0], BigInteger.ZERO);
                    } else {
                        term2 = theory.term("<", new Term[]{termArray5[1], termArray5[0]});
                        term = this.mProofRules.total(termArray5[0], termArray5[1]);
                    }
                } else {
                    term2 = theory.term("<=", new Term[]{termArray5[1], termArray5[0]});
                    term = this.mProofRules.total(termArray5[1], termArray5[0]);
                }
            }
            termArray3[n] = term2;
            termArray4[n] = term;
            termArray2[n] = term3;
            ++n;
        }
        Term term = this.mProofRules.farkas(termArray3, bigIntegerArray);
        int n2 = 0;
        while (n2 < termArray2.length) {
            term = this.res(termArray3[n2], termArray4[n2], term);
            ++n2;
        }
        return term;
    }

    private Term convertTrichotomy(ProofLiteral[] proofLiteralArray) {
        Term term;
        Object object;
        assert (proofLiteralArray.length == 3);
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        Term term2 = null;
        Term term3 = null;
        Term term4 = null;
        ProofLiteral[] proofLiteralArray2 = proofLiteralArray;
        int n = proofLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = proofLiteralArray2[n2];
            boolean bl = ((ProofLiteral)object).getPolarity();
            term = ((ProofLiteral)object).getAtom();
            assert (this.isZero(((ApplicationTerm)term).getParameters()[1]));
            if (this.isApplication("=", term)) {
                assert (bl && term2 == null);
                term2 = term;
            } else if (this.isApplication("<=", term) || this.isApplication("<", term)) {
                if (bl) {
                    assert (term3 == null);
                    term3 = term;
                } else {
                    assert (term4 == null);
                    term4 = term;
                }
            } else {
                throw new AssertionError();
            }
            ++n2;
        }
        object = ((ApplicationTerm)term2).getParameters();
        Term term5 = this.mProofRules.trichotomy((Term)object[0], (Term)object[1]);
        Term term6 = theory.term("<", new Term[]{object[1], object[0]});
        term5 = this.mProofRules.resolutionRule(term6, term5, this.mProofRules.farkas(new Term[]{term6, term4}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE}));
        if (this.isApplication("<=", term3)) {
            proofLiteralArray2 = ((ApplicationTerm)term3).getParameters();
            assert (this.isZero((Term)proofLiteralArray2[1]));
            Term term7 = Rational.ONE.toTerm(proofLiteralArray2[0].getSort());
            term = theory.term("<", new Term[]{object[0], object[1]});
            Term term8 = theory.term("<=", new Term[]{term7, proofLiteralArray2[0]});
            term5 = this.mProofRules.resolutionRule(term, term5, this.mProofRules.resolutionRule(term8, this.mProofRules.totalInt((Term)proofLiteralArray2[0], BigInteger.ZERO), this.mProofRules.farkas(new Term[]{term8, term}, new BigInteger[]{BigInteger.ONE, BigInteger.ONE})));
        }
        return term5;
    }

    private Term convertEQTrivialLemma(ProofLiteral[] proofLiteralArray) {
        assert (proofLiteralArray.length == 1);
        assert (!proofLiteralArray[0].getPolarity());
        assert (this.isApplication("=", proofLiteralArray[0].getAtom()));
        ApplicationTerm applicationTerm = (ApplicationTerm)proofLiteralArray[0].getAtom();
        return this.proveTrivialDisequality(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]);
    }

    private Term convertEQLemma(ProofLiteral[] proofLiteralArray) {
        if (proofLiteralArray.length == 1) {
            return this.convertEQTrivialLemma(proofLiteralArray);
        }
        assert (proofLiteralArray.length == 2);
        int n = proofLiteralArray[0].getPolarity() ? 0 : 1;
        int n2 = 1 - n;
        assert (proofLiteralArray[1].getPolarity() == (n == 1));
        assert (this.isApplication("=", proofLiteralArray[0].getAtom()) && this.isApplication("=", proofLiteralArray[1].getAtom()));
        Term[] termArray = ((ApplicationTerm)proofLiteralArray[n2].getAtom()).getParameters();
        Term[] termArray2 = ((ApplicationTerm)proofLiteralArray[n].getAtom()).getParameters();
        Polynomial polynomial = new Polynomial(termArray[0]);
        polynomial.add(Rational.MONE, termArray[1]);
        Polynomial polynomial2 = new Polynomial(termArray2[0]);
        polynomial2.add(Rational.MONE, termArray2[1]);
        assert (!polynomial.isZero());
        Map<Term, Integer> map = polynomial.getSummands().keySet().iterator().next();
        Rational rational = polynomial2.getSummands().get(map).div(polynomial.getSummands().get(map));
        Term term = this.proveEqWithMultiplier(termArray, termArray2, rational);
        return term;
    }

    private void collectEqualities(ProofLiteral[] proofLiteralArray, HashMap<SymmetricPair<Term>, Term> hashMap, HashMap<SymmetricPair<Term>, Term> hashMap2) {
        ProofLiteral[] proofLiteralArray2 = proofLiteralArray;
        int n = proofLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProofLiteral proofLiteral = proofLiteralArray2[n2];
            Term term = proofLiteral.getAtom();
            assert (this.isApplication("=", term));
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            assert (termArray.length == 2);
            if (proofLiteral.getPolarity()) {
                hashMap2.put(new SymmetricPair<Term>(termArray[0], termArray[1]), term);
            } else {
                hashMap.put(new SymmetricPair<Term>(termArray[0], termArray[1]), term);
            }
            ++n2;
        }
    }

    private Term convertCCLemma(ProofLiteral[] proofLiteralArray, String string, Term[] termArray) {
        Term term;
        Object object;
        ApplicationTerm applicationTerm;
        assert (termArray.length >= 2) : "Main path too short in CC lemma";
        Theory theory = termArray[0].getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        assert (hashMap2.size() <= 1);
        HashSet<Term> hashSet = new HashSet<Term>();
        if (termArray.length == 2) {
            assert (string == ":cong") : "Transitivity lemma must have at least three steps";
            assert (termArray[0] instanceof ApplicationTerm && termArray[1] instanceof ApplicationTerm);
            applicationTerm = (ApplicationTerm)termArray[0];
            object = (ApplicationTerm)termArray[1];
            term = this.mProofRules.cong((Term)applicationTerm, (Term)object);
            assert (applicationTerm.getFunction() == object.getFunction() && applicationTerm.getParameters().length == object.getParameters().length);
            Term[] termArray2 = applicationTerm.getParameters();
            Term[] termArray3 = object.getParameters();
            assert (termArray2.length == termArray3.length);
            int n = 0;
            while (n < termArray2.length) {
                hashSet.add(theory.term("=", new Term[]{termArray2[n], termArray3[n]}));
                ++n;
            }
        } else {
            assert (string == ":trans") : "Congruence lemma must have a main path of length 2";
            term = this.mProofRules.trans(termArray);
            int n = 0;
            while (n < termArray.length - 1) {
                hashSet.add(theory.term("=", new Term[]{termArray[n], termArray[n + 1]}));
                ++n;
            }
        }
        applicationTerm = theory.term("=", new Term[]{termArray[0], termArray[termArray.length - 1]});
        object = Collections.singleton(applicationTerm);
        term = this.resolveNeededEqualities(term, hashMap, hashMap2, hashSet, (Set<Term>)object);
        return term;
    }

    private Term proveSelectConst(Term term, Term term2, Term term3, Set<SymmetricPair<Term>> set, Set<Term> set2) {
        Term[] termArray;
        Theory theory = term.getTheory();
        if (this.isApplication("select", term) && (termArray = ((ApplicationTerm)term).getParameters())[0] == term2) {
            if (termArray[1] == term3) {
                return this.mProofRules.refl(term);
            }
            if (set.contains(new SymmetricPair<Term>(term3, termArray[1]))) {
                set2.add(theory.term("=", new Term[]{term2, term2}));
                set2.add(theory.term("=", new Term[]{term3, termArray[1]}));
                return this.mProofRules.cong(theory.term("select", new Term[]{term2, term3}), term);
            }
        }
        if (this.isApplication("const", term2) && ((ApplicationTerm)term2).getParameters()[0] == term) {
            return this.mProofRules.constArray(term, term3);
        }
        return null;
    }

    private Term proveSelectPathTrans(Term term, Term term2, Term term3, Term term4, Term term5, Term term6, Term term7, Set<Term> set) {
        Theory theory = term.getTheory();
        Term term8 = theory.term("select", new Term[]{term, term5});
        Term term9 = theory.term("select", new Term[]{term4, term5});
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        linkedHashSet.add(term8);
        linkedHashSet.add(term2);
        linkedHashSet.add(term3);
        linkedHashSet.add(term9);
        Term term10 = null;
        if (linkedHashSet.size() > 2) {
            term10 = this.mProofRules.trans(linkedHashSet.toArray(new Term[linkedHashSet.size()]));
        }
        if (term8 != term2) {
            term10 = this.res(theory.term("=", new Term[]{term8, term2}), term6, term10);
        }
        if (term2 != term3) {
            set.add(theory.term("=", new Term[]{term2, term3}));
        }
        if (term9 != term3) {
            term10 = this.res(theory.term("=", new Term[]{term3, term9}), this.mProofRules.symm(term3, term9), term10);
            term10 = this.res(theory.term("=", new Term[]{term9, term3}), term7, term10);
        }
        return term10;
    }

    private Term proveSelectPath(Term term, Term term2, Term term3, Set<SymmetricPair<Term>> set, Set<Term> set2) {
        Term term4;
        Term term5 = set.iterator();
        while (term5.hasNext()) {
            term4 = term5.next();
            Term term6 = term4.getFirst();
            Term term7 = term4.getSecond();
            Term term8 = this.proveSelectConst(term6, term, term3, set, set2);
            Term term9 = this.proveSelectConst(term7, term2, term3, set, set2);
            if (term8 != null && term9 != null) {
                return this.proveSelectPathTrans(term, term6, term7, term2, term3, term8, term9, set2);
            }
            term8 = this.proveSelectConst(term7, term, term3, set, set2);
            term9 = this.proveSelectConst(term6, term2, term3, set, set2);
            if (term8 == null || term9 == null) continue;
            return this.proveSelectPathTrans(term, term7, term6, term2, term3, term8, term9, set2);
        }
        if (this.isApplication("const", term) && (term5 = this.proveSelectConst(term4 = ((ApplicationTerm)term).getParameters()[0], term2, term3, set, set2)) != null) {
            return this.proveSelectPathTrans(term, term4, term4, term2, term3, this.mProofRules.constArray(term4, term3), term5, set2);
        }
        if (this.isApplication("const", term2) && (term5 = this.proveSelectConst(term4 = ((ApplicationTerm)term2).getParameters()[0], term, term3, set, set2)) != null) {
            return this.proveSelectPathTrans(term, term4, term4, term2, term3, term5, this.mProofRules.constArray(term4, term3), set2);
        }
        return null;
    }

    private Term proveStoreStep(Term term, Term term2, Term term3, Set<SymmetricPair<Term>> set, Set<Term> set2) {
        Term term4;
        Term[] termArray;
        if (this.isApplication("store", term) && (termArray = ((ApplicationTerm)term).getParameters())[0] == term2 && set.contains(new SymmetricPair<Term>(term3, term4 = ((ApplicationTerm)term).getParameters()[1]))) {
            Term term5 = ((ApplicationTerm)term).getParameters()[2];
            Theory theory = term.getTheory();
            set2.add(theory.term("=", new Term[]{term4, term3}));
            return this.mProofRules.selectStore2(term2, term4, term5, term3);
        }
        return null;
    }

    private Term proveSelectOverPathStep(Term term, Term term2, Term term3, Term term4, Term term5, Set<SymmetricPair<Term>> set, Set<SymmetricPair<Term>> set2, Set<Term> set3, Set<Term> set4) {
        Theory theory = term.getTheory();
        if (set.contains(new SymmetricPair<Term>(term, term2))) {
            set3.add(theory.term("=", new Term[]{term, term2}));
            set3.add(theory.term("=", new Term[]{term3, term3}));
            return this.mProofRules.cong(term4, term5);
        }
        Term term6 = this.proveStoreStep(term, term2, term3, set2, set4);
        if (term6 != null) {
            return term6;
        }
        term6 = this.proveStoreStep(term2, term, term3, set2, set4);
        if (term6 != null) {
            return this.res(theory.term("=", new Term[]{term5, term4}), term6, this.mProofRules.symm(term4, term5));
        }
        return this.proveSelectPath(term, term2, term3, set, set3);
    }

    private Term proveSelectOverPath(Term term, Term[] termArray, Set<SymmetricPair<Term>> set, Set<SymmetricPair<Term>> set2, Set<Term> set3, Set<Term> set4) {
        assert (termArray.length >= 1);
        Theory theory = termArray[0].getTheory();
        Term[] termArray2 = new Term[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            termArray2[n] = theory.term("select", new Term[]{termArray[n], term});
            ++n;
        }
        if (termArray2.length == 1) {
            return this.mProofRules.refl(termArray2[0]);
        }
        Term term2 = termArray2.length > 2 ? this.mProofRules.trans(termArray2) : null;
        int n2 = 0;
        while (n2 < termArray.length - 1) {
            Term term3 = this.proveSelectOverPathStep(termArray[n2], termArray[n2 + 1], term, termArray2[n2], termArray2[n2 + 1], set, set2, set3, set4);
            term2 = this.res(theory.term("=", new Term[]{termArray2[n2], termArray2[n2 + 1]}), term3, term2);
            ++n2;
        }
        return term2;
    }

    private Term convertArraySelectConstWeakEqLemma(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        int n;
        assert (objectArray.length >= 3);
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        Term term = (Term)objectArray[0];
        assert (this.isApplication("=", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        assert (termArray.length == 2);
        assert (objectArray.length == 3);
        assert (objectArray[1] == ":weakpath");
        Object[] objectArray2 = (Object[])objectArray[2];
        assert (objectArray2.length == 2);
        Term term2 = (Term)objectArray2[0];
        Term[] termArray2 = (Term[])objectArray2[1];
        Term term3 = this.proveSelectOverPath(term2, termArray2, hashMap.keySet(), hashMap2.keySet(), hashSet, hashSet2);
        Term term4 = theory.term("select", new Term[]{termArray2[0], term2});
        Term term5 = theory.term("select", new Term[]{termArray2[termArray2.length - 1], term2});
        assert (this.isApplication("const", termArray2[termArray2.length - 1]));
        Term term6 = ((ApplicationTerm)termArray2[termArray2.length - 1]).getParameters()[0];
        int n2 = n = termArray[1] == term6 ? 0 : 1;
        assert (termArray[n] == this.mSkript.term("select", new Term[]{termArray2[0], term2}));
        assert (termArray[1 - n] == term6);
        term3 = this.res(theory.term("=", new Term[]{term4, term5}), term3, this.mProofRules.trans(term4, term5, term6));
        term3 = this.res(theory.term("=", new Term[]{term5, term6}), this.mProofRules.constArray(term6, term2), term3);
        hashSet2.add(theory.term("=", new Term[]{term4, term6}));
        return this.resolveNeededEqualities(term3, hashMap, hashMap2, hashSet, hashSet2);
    }

    private Term convertArraySelectWeakEqLemma(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        Term term;
        assert (objectArray.length >= 3);
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        Term term2 = (Term)objectArray[0];
        assert (this.isApplication("=", term2));
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        assert (termArray.length == 2);
        assert (objectArray.length == 3);
        assert (objectArray[1] == ":weakpath");
        Object[] objectArray2 = (Object[])objectArray[2];
        assert (objectArray2.length == 2);
        Term term3 = (Term)objectArray2[0];
        Term[] termArray2 = (Term[])objectArray2[1];
        Term term4 = this.proveSelectOverPath(term3, termArray2, hashMap.keySet(), hashMap2.keySet(), hashSet, hashSet2);
        assert (this.isApplication("select", termArray[0]) && this.isApplication("select", termArray[1]));
        int n = ((ApplicationTerm)termArray[0]).getParameters()[0] == termArray2[0] ? 0 : 1;
        Term term5 = termArray[n];
        Term term6 = termArray[1 - n];
        Term term7 = theory.term("select", new Term[]{termArray2[0], term3});
        Term term8 = theory.term("select", new Term[]{termArray2[termArray2.length - 1], term3});
        if (term5 != term7) {
            assert (termArray2[0] == ((ApplicationTerm)term5).getParameters()[0]);
            term = ((ApplicationTerm)term5).getParameters()[1];
            term4 = this.res(theory.term("=", new Term[]{term7, term8}), term4, this.mProofRules.trans(term5, term7, term8));
            term4 = this.res(theory.term("=", new Term[]{term5, term7}), this.mProofRules.cong(term5, term7), term4);
            hashSet.add(theory.term("=", new Term[]{term, term3}));
            hashSet.add(theory.term("=", new Term[]{termArray2[0], termArray2[0]}));
        }
        if (term6 != term8) {
            assert (termArray2[termArray2.length - 1] == ((ApplicationTerm)term6).getParameters()[0]);
            term = ((ApplicationTerm)term6).getParameters()[1];
            term4 = this.res(theory.term("=", new Term[]{term5, term8}), term4, this.mProofRules.trans(term5, term8, term6));
            term4 = this.res(theory.term("=", new Term[]{term8, term6}), this.mProofRules.cong(term8, term6), term4);
            hashSet.add(theory.term("=", new Term[]{term3, term}));
            hashSet.add(theory.term("=", new Term[]{termArray2[termArray2.length - 1], termArray2[termArray2.length - 1]}));
        }
        hashSet2.add(theory.term("=", new Term[]{term5, term6}));
        return this.resolveNeededEqualities(term4, hashMap, hashMap2, hashSet, hashSet2);
    }

    private Term convertArrayWeakEqExtLemma(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        Term term;
        Term term2;
        assert (objectArray.length >= 3);
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        Term term3 = (Term)objectArray[0];
        assert (this.isApplication("=", term3));
        Term[] termArray = ((ApplicationTerm)term3).getParameters();
        assert (termArray.length == 2);
        assert (objectArray.length % 2 == 1);
        assert (objectArray[1] == ":subpath");
        Term[] termArray2 = (Term[])objectArray[2];
        Term term4 = termArray2[0];
        Term term5 = termArray2[termArray2.length - 1];
        Term term6 = theory.term("@diff", new Term[]{term4, term5});
        Term[] termArray3 = new Term[termArray2.length];
        int n = 0;
        while (n < termArray2.length) {
            termArray3[n] = theory.term("select", new Term[]{termArray2[n], term6});
            ++n;
        }
        Term term7 = termArray3[0];
        Term term8 = termArray3[termArray2.length - 1];
        HashSet<SymmetricPair<Term>> hashSet3 = new HashSet<SymmetricPair<Term>>();
        HashSet<Term> hashSet4 = new HashSet<Term>();
        int n2 = 3;
        while (n2 < objectArray.length) {
            assert (objectArray[n2] == ":weakpath");
            Object[] objectArray2 = (Object[])objectArray[n2 + 1];
            term2 = (Term)objectArray2[0];
            hashSet3.add(new SymmetricPair<Term>(term2, term6));
            n2 += 2;
        }
        Term term9 = termArray2.length > 2 ? this.mProofRules.trans(termArray3) : null;
        int n3 = 0;
        while (n3 < termArray2.length - 1) {
            term = new SymmetricPair(termArray2[n3], termArray2[n3 + 1]);
            if (hashMap.containsKey(term)) {
                hashSet.add(theory.term("=", new Term[]{termArray2[n3], termArray2[n3 + 1]}));
                hashSet.add(theory.term("=", new Term[]{term6, term6}));
                term2 = this.mProofRules.cong(termArray3[n3], termArray3[n3 + 1]);
            } else {
                term2 = this.proveStoreStep(termArray2[n3], termArray2[n3 + 1], term6, hashSet3, hashSet4);
                if (term2 == null) {
                    term2 = this.proveStoreStep(termArray2[n3 + 1], termArray2[n3], term6, hashSet3, hashSet4);
                    term2 = this.res(theory.term("=", new Term[]{termArray3[n3 + 1], termArray3[n3]}), term2, this.mProofRules.symm(termArray3[n3], termArray3[n3 + 1]));
                }
            }
            term9 = this.res(theory.term("=", new Term[]{termArray3[n3], termArray3[n3 + 1]}), term2, term9);
            ++n3;
        }
        n3 = 3;
        while (n3 < objectArray.length) {
            assert (objectArray[n3] == ":weakpath");
            term2 = (Term)objectArray[n3 + 1];
            term = (Term)term2[0];
            Term[] termArray4 = (Term[])term2[1];
            assert (term4 == termArray4[0] && term5 == termArray4[termArray4.length - 1]);
            Term term10 = theory.term("=", new Term[]{term, term6});
            boolean bl = hashSet4.remove(term10);
            assert (bl);
            Term term11 = theory.term("select", new Term[]{term4, term});
            Term term12 = theory.term("select", new Term[]{term5, term});
            Term term13 = this.proveSelectOverPath(term, termArray4, hashMap.keySet(), hashMap2.keySet(), hashSet, hashSet2);
            term13 = this.res(theory.term("=", new Term[]{term11, term12}), term13, this.mProofRules.trans(term7, term11, term12, term8));
            term13 = this.res(theory.term("=", new Term[]{term7, term11}), this.mProofRules.cong(term7, term11), term13);
            term13 = this.res(theory.term("=", new Term[]{term12, term8}), this.mProofRules.cong(term12, term8), term13);
            hashSet.add(theory.term("=", new Term[]{term4, term4}));
            hashSet.add(theory.term("=", new Term[]{term5, term5}));
            term13 = this.res(theory.term("=", new Term[]{term6, term}), this.mProofRules.symm(term6, term), term13);
            term9 = this.res(term10, term9, term13);
            n3 += 2;
        }
        assert (hashSet4.isEmpty());
        Term term14 = this.mProofRules.extDiff(term4, term5);
        term14 = this.res(theory.term("=", new Term[]{term7, term8}), term9, term14);
        hashSet2.add(theory.term("=", new Term[]{term4, term5}));
        return this.resolveNeededEqualities(term14, hashMap, hashMap2, hashSet, hashSet2);
    }

    private Term convertDTProject(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        assert (objectArray.length == 3);
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        assert (this.isApplication("=", (Term)applicationTerm));
        assert (objectArray[1].equals(":cons"));
        ApplicationTerm applicationTerm2 = (ApplicationTerm)objectArray[2];
        FunctionSymbol functionSymbol = applicationTerm2.getFunction();
        assert (functionSymbol.isConstructor());
        Term[] termArray = applicationTerm.getParameters();
        assert (termArray.length == 2);
        assert (termArray[0] instanceof ApplicationTerm);
        ApplicationTerm applicationTerm3 = (ApplicationTerm)termArray[0];
        FunctionSymbol functionSymbol2 = applicationTerm3.getFunction();
        assert (functionSymbol2.isSelector());
        Term term = applicationTerm3.getParameters()[0];
        Term term2 = theory.term(functionSymbol2, new Term[]{applicationTerm2});
        DataType.Constructor constructor = ((DataType)applicationTerm2.getSort().getSortSymbol()).getConstructor(functionSymbol.getName());
        int n = constructor.getSelectorIndex(functionSymbol2.getName());
        Term term3 = applicationTerm2.getParameters()[n];
        Term term4 = this.mProofRules.dtProject(term2);
        hashSet2.add(theory.term("=", new Term[]{applicationTerm3, term3}));
        if (applicationTerm3 != term2) {
            hashSet.add(theory.term("=", new Term[]{term, applicationTerm2}));
            term4 = this.res(theory.term("=", new Term[]{term2, term3}), term4, this.mProofRules.trans(new Term[]{applicationTerm3, term2, term3}));
            term4 = this.res(theory.term("=", new Term[]{applicationTerm3, term2}), this.mProofRules.cong((Term)applicationTerm3, term2), term4);
        }
        return this.resolveNeededEqualities(term4, hashMap, hashMap2, hashSet, hashSet2);
    }

    private Term convertDTTester(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        Term term;
        assert (objectArray.length == 3);
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        Term term2 = (Term)objectArray[0];
        assert (this.isApplication("=", term2));
        assert (objectArray[1].equals(":cons"));
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[2];
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        assert (functionSymbol.isConstructor());
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        assert (termArray.length == 2);
        assert (termArray[0] instanceof ApplicationTerm);
        ApplicationTerm applicationTerm2 = (ApplicationTerm)termArray[0];
        FunctionSymbol functionSymbol2 = applicationTerm2.getFunction();
        assert (functionSymbol2.getName().equals("is"));
        Term term3 = applicationTerm2.getParameters()[0];
        Term term4 = theory.term(functionSymbol2, new Term[]{applicationTerm});
        Term term5 = termArray[1];
        String string = functionSymbol2.getIndices()[0];
        boolean bl = functionSymbol.getName().equals(string);
        assert (term5 == (bl ? theory.mTrue : theory.mFalse));
        Term term6 = theory.term("=", new Term[]{term4, term5});
        if (bl) {
            term = this.mProofRules.dtTestI((Term)applicationTerm);
            term = this.res(term4, term, this.res(term5, this.mProofRules.trueIntro(), this.mProofRules.iffIntro2(term6)));
        } else {
            term = this.mProofRules.dtTestE(string, (Term)applicationTerm);
            term = this.res(term4, this.res(term5, this.mProofRules.iffIntro1(term6), this.mProofRules.falseElim()), term);
        }
        hashSet2.add(theory.term("=", new Term[]{applicationTerm2, term5}));
        if (applicationTerm2 != term4) {
            hashSet.add(theory.term("=", new Term[]{term3, applicationTerm}));
            term = this.res(theory.term("=", new Term[]{term4, term5}), term, this.mProofRules.trans(new Term[]{applicationTerm2, term4, term5}));
            term = this.res(theory.term("=", new Term[]{applicationTerm2, term4}), this.mProofRules.cong((Term)applicationTerm2, term4), term);
        }
        return this.resolveNeededEqualities(term, hashMap, hashMap2, hashSet, hashSet2);
    }

    private Term convertDTConstructor(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        assert (objectArray.length == 1);
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        assert (this.isApplication("=", (Term)applicationTerm));
        Term[] termArray = applicationTerm.getParameters();
        assert (termArray.length == 2);
        ApplicationTerm applicationTerm2 = (ApplicationTerm)termArray[1];
        Term term = termArray[0];
        DataType dataType = (DataType)term.getSort().getSortSymbol();
        DataType.Constructor constructor = dataType.getConstructor(applicationTerm2.getFunction().getName());
        Term term2 = theory.term("is", new String[]{constructor.getName()}, null, new Term[]{term});
        Term term3 = theory.term("=", new Term[]{term2, theory.mTrue});
        hashSet.add(term3);
        hashSet2.add(theory.term("=", new Term[]{applicationTerm2, term}));
        Term term4 = this.res(term2, this.res((Term)theory.mTrue, this.mProofRules.trueIntro(), this.mProofRules.iffElim1(term3)), this.mProofRules.dtCons(term2));
        return this.resolveNeededEqualities(term4, hashMap, hashMap2, hashSet, hashSet2);
    }

    private Term convertDTCases(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        assert (objectArray.length > 0);
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        assert (this.isApplication("is", (Term)applicationTerm));
        Term term = applicationTerm.getParameters()[0];
        Term term2 = this.mProofRules.dtExhaust(term);
        int n = 0;
        while (n < objectArray.length) {
            Term term3 = (Term)objectArray[n];
            assert (this.isApplication("is", term3));
            FunctionSymbol functionSymbol = ((ApplicationTerm)term3).getFunction();
            Term term4 = ((ApplicationTerm)objectArray[n]).getParameters()[0];
            Term term5 = theory.term("=", new Term[]{term3, theory.mFalse});
            Term term6 = this.res((Term)theory.mFalse, this.mProofRules.iffElim2(term5), this.mProofRules.falseElim());
            hashSet.add(term5);
            Term term7 = theory.term(functionSymbol, new Term[]{term});
            if (term3 != term7) {
                Term term8 = theory.term("=", new Term[]{term, term4});
                Term term9 = theory.term("=", new Term[]{term7, term3});
                hashSet.add(term8);
                term6 = this.res(term9, this.mProofRules.cong(term7, term3), this.res(term3, this.mProofRules.iffElim2(term9), term6));
            }
            term2 = this.res(term7, term2, term6);
            ++n;
        }
        return this.resolveNeededEqualities(term2, hashMap, hashMap2, hashSet, hashSet2);
    }

    private Term convertDTUnique(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        assert (objectArray.length == 2);
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        assert (this.isApplication("is", (Term)applicationTerm));
        Term term = applicationTerm.getParameters()[0];
        ApplicationTerm applicationTerm2 = (ApplicationTerm)objectArray[1];
        assert (this.isApplication("is", (Term)applicationTerm2));
        Term term2 = applicationTerm2.getParameters()[0];
        assert (term.getSort() == term2.getSort());
        DataType dataType = (DataType)term.getSort().getSortSymbol();
        DataType.Constructor constructor = dataType.getConstructor(applicationTerm.getFunction().getIndices()[0]);
        String[] stringArray = constructor.getSelectors();
        Term[] termArray = new Term[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            termArray[n] = theory.term(stringArray[n], new Term[]{term});
            ++n;
        }
        Term term3 = theory.term(constructor.getName(), null, constructor.needsReturnOverload() ? term.getSort() : null, termArray);
        Term term4 = theory.term("=", new Term[]{term3, term});
        Term term5 = theory.term(applicationTerm2.getFunction(), new Term[]{term3});
        Term term6 = this.res(term4, this.mProofRules.dtCons((Term)applicationTerm), this.mProofRules.trans(term3, term, term2));
        hashSet.add(theory.term("=", new Term[]{term, term2}));
        term6 = this.res(theory.term("=", new Term[]{term3, term2}), term6, this.mProofRules.cong(term5, (Term)applicationTerm2));
        Term term7 = theory.term("=", new Term[]{term5, applicationTerm2});
        term6 = this.res(term7, term6, this.mProofRules.iffElim1(term7));
        term6 = this.res(term5, term6, this.mProofRules.dtTestE(applicationTerm2.getFunction().getIndices()[0], term3));
        Term term8 = theory.term("=", new Term[]{applicationTerm, theory.mTrue});
        hashSet.add(term8);
        term6 = this.res((Term)applicationTerm, this.mProofRules.iffElim1(term8), term6);
        Term term9 = theory.term("=", new Term[]{applicationTerm2, theory.mTrue});
        hashSet.add(term9);
        term6 = this.res((Term)applicationTerm2, this.mProofRules.iffElim1(term9), term6);
        term6 = this.res((Term)theory.mTrue, this.mProofRules.trueIntro(), term6);
        return this.resolveNeededEqualities(term6, hashMap, hashMap2, hashSet, hashSet2);
    }

    private Term convertDTInjective(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        assert (objectArray.length == 4);
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        assert (objectArray[1].equals(":cons"));
        ApplicationTerm applicationTerm2 = (ApplicationTerm)objectArray[2];
        ApplicationTerm applicationTerm3 = (ApplicationTerm)objectArray[3];
        assert (applicationTerm2.getFunction() == applicationTerm3.getFunction());
        assert (applicationTerm2.getFunction().isConstructor());
        Term[] termArray = applicationTerm2.getParameters();
        Term[] termArray2 = applicationTerm3.getParameters();
        Term term = applicationTerm.getParameters()[0];
        Term term2 = applicationTerm.getParameters()[1];
        int n = 0;
        while (termArray[n] != term || termArray2[n] != term2) {
            ++n;
        }
        DataType dataType = (DataType)applicationTerm2.getSort().getSortSymbol();
        DataType.Constructor constructor = dataType.findConstructor(applicationTerm2.getFunction().getName());
        String string = constructor.getSelectors()[n];
        Term term3 = theory.term(string, new Term[]{applicationTerm2});
        Term term4 = theory.term(string, new Term[]{applicationTerm3});
        Term term5 = this.mProofRules.trans(term, term3, term4, term2);
        hashSet2.add((Term)applicationTerm);
        term5 = this.res(theory.term("=", new Term[]{term, term3}), this.res(theory.term("=", new Term[]{term3, term}), this.mProofRules.dtProject(term3), this.mProofRules.symm(term, term3)), term5);
        term5 = this.res(theory.term("=", new Term[]{term4, term2}), this.mProofRules.dtProject(term4), term5);
        term5 = this.res(theory.term("=", new Term[]{term3, term4}), this.mProofRules.cong(term3, term4), term5);
        hashSet.add(theory.term("=", new Term[]{applicationTerm2, applicationTerm3}));
        return this.resolveNeededEqualities(term5, hashMap, hashMap2, hashSet, hashSet2);
    }

    private Term convertDTDisjoint(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        assert (objectArray.length == 3);
        assert (objectArray[0].equals(":cons"));
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[1];
        ApplicationTerm applicationTerm2 = (ApplicationTerm)objectArray[2];
        assert (applicationTerm.getFunction() != applicationTerm2.getFunction());
        assert (applicationTerm.getFunction().isConstructor());
        assert (applicationTerm2.getFunction().isConstructor());
        Term term = theory.term("is", new String[]{applicationTerm.getFunction().getName()}, null, new Term[]{applicationTerm});
        Term term2 = theory.term("is", new String[]{applicationTerm.getFunction().getName()}, null, new Term[]{applicationTerm2});
        Term term3 = theory.term("=", new Term[]{term, term2});
        Term term4 = this.mProofRules.cong(term, term2);
        hashSet.add(theory.term("=", new Term[]{applicationTerm, applicationTerm2}));
        term4 = this.res(term3, term4, this.mProofRules.iffElim2(term3));
        term4 = this.res(term, this.mProofRules.dtTestI((Term)applicationTerm), term4);
        term4 = this.res(term2, term4, this.mProofRules.dtTestE(applicationTerm.getFunction().getName(), (Term)applicationTerm2));
        return this.resolveNeededEqualities(term4, hashMap, hashMap2, hashSet, hashSet2);
    }

    private int checkAndFindConsArg(Term term, Term term2) {
        if (!(term instanceof ApplicationTerm)) {
            return -1;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        if (!applicationTerm.getFunction().isConstructor()) {
            return -1;
        }
        Term[] termArray = applicationTerm.getParameters();
        int n = 0;
        while (n < termArray.length) {
            if (termArray[n] == term2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private Term convertDTCycle(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        Theory theory = proofLiteralArray[0].getAtom().getTheory();
        HashMap<SymmetricPair<Term>, Term> hashMap = new HashMap<SymmetricPair<Term>, Term>();
        HashMap<SymmetricPair<Term>, Term> hashMap2 = new HashMap<SymmetricPair<Term>, Term>();
        this.collectEqualities(proofLiteralArray, hashMap, hashMap2);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        assert (objectArray.length == 2);
        assert (objectArray[0].equals(":cycle"));
        Term[] termArray = (Term[])objectArray[1];
        assert (termArray.length >= 3);
        assert (termArray.length % 2 == 1);
        assert (termArray[0] == termArray[termArray.length - 1]);
        Term term = termArray[0];
        Term term2 = this.mProofRules.refl(term);
        int[] nArray = new int[(termArray.length - 1) / 2];
        int n = termArray.length - 3;
        while (n >= 0) {
            Term term3;
            Term term4;
            block21: {
                term4 = termArray[n + 1];
                Term term5 = termArray[n + 2];
                int n2 = this.checkAndFindConsArg(term4, term5);
                if (n2 >= 0) {
                    if (term == term5) {
                        term = term4;
                        term2 = this.mProofRules.refl(term);
                    } else {
                        term3 = (Term)((ApplicationTerm)term4).getParameters().clone();
                        term3[n2] = term;
                        int n3 = 0;
                        while (n3 < ((Term[])term3).length) {
                            if (n3 != n2) {
                                hashSet.add(theory.term("=", new Term[]{term3[n3], term3[n3]}));
                            }
                            ++n3;
                        }
                        var17_17 = theory.term(((ApplicationTerm)term4).getFunction(), (Term[])term3);
                        term2 = this.res(theory.term("=", new Term[]{term, term5}), term2, this.mProofRules.cong((Term)var17_17, term4));
                        term = var17_17;
                    }
                    nArray[n / 2] = n2;
                } else {
                    DataType.Constructor[] constructorArray;
                    term3 = term5;
                    assert (term3.getFunction().isSelector());
                    assert (term4 == term3.getParameters()[0]);
                    var17_17 = (DataType)term4.getSort().getSortSymbol();
                    DataType.Constructor[] constructorArray2 = constructorArray = var17_17.getConstructors();
                    int n4 = constructorArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        DataType.Constructor constructor = constructorArray2[n5];
                        String[] stringArray = constructor.getSelectors();
                        n2 = 0;
                        while (n2 < stringArray.length) {
                            if (stringArray[n2].equals(term3.getFunction().getName())) {
                                Term[] termArray2 = new Term[stringArray.length];
                                Term[] termArray3 = new Term[stringArray.length];
                                int n6 = 0;
                                while (n6 < termArray2.length) {
                                    termArray2[n6] = theory.term(stringArray[n6], new Term[]{term4});
                                    if (n6 != n2) {
                                        termArray3[n6] = termArray2[n6];
                                        hashSet.add(theory.term("=", new Term[]{termArray2[n6], termArray2[n6]}));
                                    } else {
                                        termArray3[n6] = term;
                                    }
                                    ++n6;
                                }
                                Term term6 = theory.term(constructor.getName(), null, constructor.needsReturnOverload() ? term4.getSort() : null, termArray2);
                                Term term7 = theory.term(constructor.getName(), null, constructor.needsReturnOverload() ? term4.getSort() : null, termArray3);
                                Term term8 = theory.term("is", new String[]{constructor.getName()}, null, new Term[]{term4});
                                term2 = this.res(theory.term("=", new Term[]{term, term5}), term2, this.mProofRules.cong(term7, term6));
                                term2 = this.res(theory.term("=", new Term[]{term7, term6}), term2, this.mProofRules.trans(term7, term6, term4));
                                Term term9 = theory.term("=", new Term[]{term8, theory.mTrue});
                                term2 = this.res(theory.term("=", new Term[]{term6, term4}), this.mProofRules.dtCons(term8), term2);
                                term2 = this.res(term8, this.res((Term)theory.mTrue, this.mProofRules.trueIntro(), this.mProofRules.iffElim1(term9)), term2);
                                hashSet.add(term9);
                                term = term7;
                                nArray[n / 2] = n2;
                                break block21;
                            }
                            ++n2;
                        }
                        ++n5;
                    }
                    throw new AssertionError();
                }
            }
            term3 = termArray[n];
            if (term3 != term4) {
                term2 = this.res(theory.term("=", new Term[]{term, term4}), term2, this.mProofRules.trans(term, term4, term3));
                hashSet.add(theory.term("=", new Term[]{term4, term3}));
            }
            n -= 2;
        }
        term2 = this.res(theory.term("=", new Term[]{term, termArray[0]}), term2, this.mProofRules.dtAcyclic(term, nArray));
        return this.resolveNeededEqualities(term2, hashMap, hashMap2, hashSet, hashSet2);
    }

    private void convertInstLemma(ProofLiteral[] proofLiteralArray, Object[] objectArray) {
        assert (!proofLiteralArray[0].getPolarity());
        Term term = proofLiteralArray[0].getAtom();
        assert (term instanceof QuantifiedFormula && ((QuantifiedFormula)term).getQuantifier() == 1);
        assert (objectArray.length == 5 && objectArray[0] == ":subs" && (objectArray[2] == ":conflict" || objectArray[2] == ":e-matching" || objectArray[2] == ":enumeration") && objectArray[3] == ":subproof");
        Term[] termArray = (Term[])objectArray[1];
        AnnotatedTerm annotatedTerm = (AnnotatedTerm)this.getConverted();
        Term term2 = this.provedTerm(annotatedTerm);
        Term term3 = this.stripAnnotation((Term)annotatedTerm);
        assert (this.isApplication("=", term2));
        Term[] termArray2 = ((ApplicationTerm)term2).getParameters();
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
        AnnotatedTerm annotatedTerm2 = this.substituteInQuantInst(termArray, quantifiedFormula);
        assert (this.provedTerm(annotatedTerm2) == termArray2[0]);
        Term term4 = this.stripAnnotation((Term)annotatedTerm2);
        term4 = this.mProofRules.resolutionRule(termArray2[0], term4, this.mProofRules.iffElim2(term2));
        term4 = this.mProofRules.resolutionRule(term2, term3, term4);
        Term[] termArray3 = new Term[]{termArray2[1]};
        if (this.isApplication("false", termArray2[1])) {
            termArray3 = new Term[]{};
            term4 = this.mProofRules.resolutionRule(termArray2[1], term4, this.mProofRules.falseElim());
        } else if (this.isApplication("or", termArray2[1])) {
            termArray3 = ((ApplicationTerm)termArray2[1]).getParameters();
            term4 = this.mProofRules.resolutionRule(termArray2[1], term4, this.mProofRules.orElim(termArray2[1]));
        }
        int n = 0;
        while (n < termArray3.length) {
            term4 = this.removeNot(term4, termArray3[n], true);
            ++n;
        }
        this.setResult(term4);
    }

    private Term convertQuant(Term[] termArray) {
        Theory theory = this.mSkript.getTheory();
        AnnotatedTerm annotatedTerm = (AnnotatedTerm)termArray[0];
        Annotation annotation = annotatedTerm.getAnnotations()[0];
        assert (annotatedTerm.getAnnotations().length == 1 && (annotation.getKey() == ":forall" || annotation.getKey() == ":exists") && annotation.getValue() instanceof TermVariable[]);
        boolean bl = annotation.getKey() == ":forall";
        TermVariable[] termVariableArray = (TermVariable[])annotation.getValue();
        Term term = annotatedTerm.getSubterm();
        Term term2 = this.subproof((AnnotatedTerm)term);
        ApplicationTerm applicationTerm = (ApplicationTerm)this.provedTerm((AnnotatedTerm)term);
        assert (this.isApplication("=", (Term)applicationTerm));
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        Term[] termArray2 = this.mProofRules.getSkolemVars(termVariableArray, (Term)applicationTerm, true);
        Term term3 = formulaUnLet.unlet(theory.let(termVariableArray, termArray2, (Term)applicationTerm));
        Term term4 = formulaUnLet.unlet(theory.let(termVariableArray, termArray2, term2));
        QuantifiedFormula quantifiedFormula = (QuantifiedFormula)theory.forall(termVariableArray, (Term)applicationTerm);
        Term term5 = this.res(term3, term4, this.mProofRules.forallIntro(quantifiedFormula));
        Term term6 = applicationTerm.getParameters()[0];
        Term term7 = applicationTerm.getParameters()[1];
        Term[] termArray3 = this.mProofRules.getSkolemVars(termVariableArray, bl ? term6 : term7, bl);
        Term term8 = formulaUnLet.unlet(theory.let(termVariableArray, termArray3, term7));
        Term term9 = formulaUnLet.unlet(theory.let(termVariableArray, termArray3, term6));
        Term term10 = theory.term("=", new Term[]{term9, term8});
        Term term11 = this.mProofRules.forallElim(termArray3, quantifiedFormula);
        Term[] termArray4 = this.mProofRules.getSkolemVars(termVariableArray, bl ? term7 : term6, bl);
        Term term12 = formulaUnLet.unlet(theory.let(termVariableArray, termArray4, term6));
        Term term13 = formulaUnLet.unlet(theory.let(termVariableArray, termArray4, term7));
        Term term14 = theory.term("=", new Term[]{term12, term13});
        Term term15 = this.mProofRules.forallElim(termArray4, quantifiedFormula);
        QuantifiedFormula quantifiedFormula2 = (QuantifiedFormula)(bl ? theory.forall(termVariableArray, term6) : theory.exists(termVariableArray, term6));
        QuantifiedFormula quantifiedFormula3 = (QuantifiedFormula)(bl ? theory.forall(termVariableArray, term7) : theory.exists(termVariableArray, term7));
        Term term16 = theory.term("=", new Term[]{quantifiedFormula2, quantifiedFormula3});
        Term term17 = this.mProofRules.resolutionRule(term8, bl ? this.mProofRules.forallElim(termArray3, quantifiedFormula3) : this.mProofRules.existsElim(quantifiedFormula3), this.mProofRules.resolutionRule(term9, this.mProofRules.resolutionRule(term10, term11, this.mProofRules.iffElim1(term10)), bl ? this.mProofRules.forallIntro(quantifiedFormula2) : this.mProofRules.existsIntro(termArray3, quantifiedFormula2)));
        Term term18 = this.mProofRules.resolutionRule(term12, bl ? this.mProofRules.forallElim(termArray4, quantifiedFormula2) : this.mProofRules.existsElim(quantifiedFormula2), this.mProofRules.resolutionRule(term13, this.mProofRules.resolutionRule(term14, term15, this.mProofRules.iffElim2(term14)), bl ? this.mProofRules.forallIntro(quantifiedFormula3) : this.mProofRules.existsIntro(termArray4, quantifiedFormula3)));
        term2 = this.proveIff(term16, term18, term17);
        term2 = this.res((Term)quantifiedFormula, term5, term2);
        assert (this.checkProof(term2, this.termToProofLiterals(term16)));
        return this.annotateProved(term16, term2);
    }

    public Term convertLemma(ProofLiteral[] proofLiteralArray, Annotation annotation) {
        String string = annotation.getKey();
        Object object = annotation.getValue();
        Term term = switch (string) {
            case ":cong", ":trans" -> this.convertCCLemma(proofLiteralArray, string, (Term[])object);
            case ":read-over-weakeq" -> this.convertArraySelectWeakEqLemma(proofLiteralArray, (Object[])object);
            case ":weakeq-ext" -> this.convertArrayWeakEqExtLemma(proofLiteralArray, (Object[])object);
            case ":read-const-weakeq" -> this.convertArraySelectConstWeakEqLemma(proofLiteralArray, (Object[])object);
            case ":dt-project" -> this.convertDTProject(proofLiteralArray, (Object[])object);
            case ":dt-tester" -> this.convertDTTester(proofLiteralArray, (Object[])object);
            case ":dt-constructor" -> this.convertDTConstructor(proofLiteralArray, (Object[])object);
            case ":dt-cases" -> this.convertDTCases(proofLiteralArray, (Object[])object);
            case ":dt-unique" -> this.convertDTUnique(proofLiteralArray, (Object[])object);
            case ":dt-injective" -> this.convertDTInjective(proofLiteralArray, (Object[])object);
            case ":dt-disjoint" -> this.convertDTDisjoint(proofLiteralArray, (Object[])object);
            case ":dt-cycle" -> this.convertDTCycle(proofLiteralArray, (Object[])object);
            case ":EQ" -> this.convertEQLemma(proofLiteralArray);
            case ":LA" -> this.convertLALemma(proofLiteralArray, (Term[])object);
            case ":trichotomy" -> this.convertTrichotomy(proofLiteralArray);
            default -> throw new IllegalArgumentException("Unknown Lemma");
        };
        assert (this.checkProof(term, proofLiteralArray));
        term = this.annotateProvedClause(term, annotation, proofLiteralArray);
        return term;
    }

    private void convertMP(ProofLiteral[] proofLiteralArray) {
        AnnotatedTerm annotatedTerm = (AnnotatedTerm)this.getConverted();
        ApplicationTerm applicationTerm = (ApplicationTerm)this.provedTerm(annotatedTerm);
        assert (this.isApplication("=", (Term)applicationTerm));
        Term[] termArray = applicationTerm.getParameters();
        Term term = this.res((Term)applicationTerm, this.subproof(annotatedTerm), this.mProofRules.iffElim2((Term)applicationTerm));
        term = this.removeNot(term, termArray[0], false);
        term = this.removeNot(term, termArray[1], true);
        assert (this.checkProof(term, proofLiteralArray));
        this.setResult(term);
    }

    public void convertOracle(AnnotatedTerm annotatedTerm) {
        Annotation[] annotationArray = annotatedTerm.getAnnotations();
        assert (annotationArray.length >= 2);
        Object[] objectArray = (Object[])annotationArray[0].getValue();
        assert (objectArray.length % 2 == 0);
        ProofLiteral[] proofLiteralArray = new ProofLiteral[objectArray.length / 2];
        int n = 0;
        while (n < proofLiteralArray.length) {
            assert (objectArray[2 * n].equals("+") || objectArray[2 * n].equals("-"));
            proofLiteralArray[n] = new ProofLiteral((Term)objectArray[2 * n + 1], objectArray[2 * n].equals("+"));
            ++n;
        }
        switch (annotationArray[1].getKey()) {
            case ":dt-project": 
            case ":dt-constructor": 
            case ":dt-disjoint": 
            case ":read-const-weakeq": 
            case ":weakeq-ext": 
            case ":EQ": 
            case ":LA": 
            case ":cong": 
            case ":trichotomy": 
            case ":read-over-weakeq": 
            case ":trans": 
            case ":dt-tester": 
            case ":dt-unique": 
            case ":dt-cases": 
            case ":dt-cycle": 
            case ":dt-injective": {
                this.setResult(this.convertLemma(proofLiteralArray, annotationArray[1]));
                break;
            }
            case ":termITEBound": 
            case ":divLow": 
            case ":false-": 
            case ":matchDefault": 
            case ":modulo": 
            case ":divHigh": 
            case ":=+1": 
            case ":=+2": 
            case ":=-1": 
            case ":=-2": 
            case ":=>+": 
            case ":=>-": 
            case ":or+": 
            case ":or-": 
            case ":and+": 
            case ":and-": 
            case ":diff": 
            case ":ite+red": 
            case ":ite-red": 
            case ":excludedMiddle1": 
            case ":excludedMiddle2": 
            case ":toIntLow": 
            case ":termITE": 
            case ":exists+": 
            case ":exists-": 
            case ":trueNotFalse": 
            case ":forall+": 
            case ":forall-": 
            case ":ite+1": 
            case ":ite+2": 
            case ":ite-1": 
            case ":ite-2": 
            case ":store": 
            case ":true+": 
            case ":xor+1": 
            case ":xor+2": 
            case ":xor-1": 
            case ":xor-2": 
            case ":toIntHigh": 
            case ":matchCase": {
                this.setResult(this.convertTautology(proofLiteralArray, annotationArray[1]));
                break;
            }
            case ":rewrite": {
                this.enqueueWalker(nonRecursive -> ((ProofSimplifier)nonRecursive).convertMP(proofLiteralArray));
                this.convert((Term)annotationArray[1].getValue());
                break;
            }
            case ":inst": {
                Object[] objectArray2 = (Object[])annotationArray[1].getValue();
                assert (objectArray2[3] == ":subproof");
                this.enqueueWalker(nonRecursive -> ((ProofSimplifier)nonRecursive).convertInstLemma(proofLiteralArray, objectArray2));
                this.convert((Term)objectArray2[4]);
                break;
            }
            default: {
                this.setResult((Term)annotatedTerm);
                return;
            }
        }
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        block17: {
            if (applicationTerm.getSort().getName() != ".EqProof") break block17;
            switch (applicationTerm.getFunction().getName()) {
                case ".trans": {
                    this.setResult(this.convertTrans(termArray));
                    return;
                }
                case ".cong": {
                    this.setResult(this.convertCong(applicationTerm.getFunction(), termArray));
                    return;
                }
                case ".match": {
                    this.setResult(this.convertMatch(termArray));
                    return;
                }
                case ".quant": {
                    this.setResult(this.convertQuant(termArray));
                    return;
                }
            }
            throw new AssertionError((Object)("Cannot translate proof rule: " + String.valueOf(applicationTerm.getFunction())));
        }
        assert (ProofRules.isProof((Term)applicationTerm));
        super.convertApplicationTerm(applicationTerm, termArray);
    }

    public void convert(Term term) {
        block13: {
            block14: {
                block12: {
                    if (term.getSort() != term.getTheory().getBooleanSort()) break block12;
                    this.setResult(term);
                    break block13;
                }
                if (term.getSort().getName() != ".EqProof" || !(term instanceof ApplicationTerm)) break block14;
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                switch (applicationTerm.getFunction().getName()) {
                    case ".refl": {
                        Term term2 = applicationTerm.getParameters()[0];
                        this.setResult(this.annotateProved(term2.getTheory().term("=", new Term[]{term2, term2}), this.mProofRules.refl(term2)));
                        return;
                    }
                    case ".rewrite": {
                        AnnotatedTerm annotatedTerm = (AnnotatedTerm)applicationTerm.getParameters()[0];
                        Annotation annotation = annotatedTerm.getAnnotations()[0];
                        Term term3 = annotatedTerm.getSubterm();
                        Term term4 = applicationTerm.getParameters()[1];
                        this.setResult(this.convertRewrite(term3, term4, annotation));
                        return;
                    }
                }
                super.convert(term);
                break block13;
            }
            if (ProofRules.isOracle(term)) {
                this.convertOracle((AnnotatedTerm)term);
            } else {
                super.convert(term);
            }
        }
    }

    private Term expandAux(ApplicationTerm applicationTerm) {
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        return new FormulaUnLet().unlet(this.mSkript.let(functionSymbol.getDefinitionVars(), applicationTerm.getParameters(), functionSymbol.getDefinition()));
    }

    private Term expandAuxDef(ApplicationTerm applicationTerm) {
        ApplicationTerm applicationTerm2 = (ApplicationTerm)applicationTerm.getParameters()[0];
        return this.expandAux(applicationTerm2);
    }

    private Term negate(Term term) {
        if (this.isApplication("not", term)) {
            return ((ApplicationTerm)term).getParameters()[0];
        }
        return term.getTheory().term("not", new Term[]{term});
    }

    private Rational parseConstant(Term term) {
        return Polynomial.parseConstant(term);
    }

    private boolean isApplication(String string, Term term) {
        ApplicationTerm applicationTerm;
        FunctionSymbol functionSymbol;
        return term instanceof ApplicationTerm && (functionSymbol = (applicationTerm = (ApplicationTerm)term).getFunction()).isIntern() && functionSymbol.getName().equals(string);
    }

    private boolean isZero(Term term) {
        return term == Rational.ZERO.toTerm(term.getSort());
    }

    private AnnotatedTerm substituteInQuantInst(Term[] termArray, QuantifiedFormula quantifiedFormula) {
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        Term term = formulaUnLet.unlet(quantifiedFormula.getTheory().let(quantifiedFormula.getVariables(), termArray, quantifiedFormula.getSubformula()));
        Term term2 = this.mProofRules.forallElim(termArray, quantifiedFormula);
        return (AnnotatedTerm)this.annotateProved(term, term2);
    }

    private Term proveTrivialEquality(Term term, Term term2) {
        if (term == term2) {
            return this.mProofRules.refl(term);
        }
        Theory theory = term.getTheory();
        Term term3 = theory.term("<", new Term[]{term, term2});
        Term term4 = theory.term("<", new Term[]{term2, term});
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.ONE};
        return this.res(term3, this.res(term4, this.mProofRules.trichotomy(term, term2), this.mProofRules.farkas(new Term[]{term4}, bigIntegerArray)), this.mProofRules.farkas(new Term[]{term3}, bigIntegerArray));
    }

    private Term proveTrivialDisequality(Term term, Term term2) {
        Theory theory = term.getTheory();
        Polynomial polynomial = new Polynomial(term);
        polynomial.add(Rational.MONE, term2);
        if (polynomial.isConstant()) {
            if (polynomial.getConstant().signum() > 0) {
                Term term3 = theory.term("=", new Term[]{term, term2});
                return this.mProofRules.farkas(new Term[]{term3}, new BigInteger[]{BigInteger.ONE});
            }
            assert (polynomial.getConstant().signum() < 0);
            Term term4 = theory.term("=", new Term[]{term2, term});
            return this.mProofRules.resolutionRule(term4, this.mProofRules.symm(term2, term), this.mProofRules.farkas(new Term[]{term4}, new BigInteger[]{BigInteger.ONE}));
        }
        Rational rational = polynomial.getGcd();
        polynomial.mul(rational.inverse());
        Rational rational2 = polynomial.getConstant().negate();
        if (!polynomial.isAllIntSummands() || rational2.isIntegral()) {
            return null;
        }
        Sort sort = theory.getSort("Int", new Sort[0]);
        polynomial.add(rational2);
        Term term5 = polynomial.toTerm(sort);
        Term term6 = rational2.floor().toTerm(sort);
        Term term7 = rational2.ceil().toTerm(sort);
        assert (term7 != term6);
        Term term8 = theory.term("<=", new Term[]{term7, term5});
        Term term9 = theory.term("<=", new Term[]{term5, term6});
        Term term10 = this.mProofRules.totalInt(term5, rational2.floor().numerator());
        Term term11 = theory.term("=", new Term[]{term, term2});
        Term term12 = theory.term("=", new Term[]{term2, term});
        Term term13 = this.mProofRules.farkas(new Term[]{term11, term8}, new BigInteger[]{rational.denominator(), rational.numerator()});
        Term term14 = this.mProofRules.resolutionRule(term12, this.mProofRules.symm(term2, term), this.mProofRules.farkas(new Term[]{term12, term9}, new BigInteger[]{rational.denominator(), rational.numerator()}));
        return this.mProofRules.resolutionRule(term9, this.mProofRules.resolutionRule(term8, term10, term13), term14);
    }

    private Term proveAbsEquality(Term term, Term term2) {
        Term term3;
        Theory theory = term.getTheory();
        Term term4 = theory.term("abs", new Term[]{term});
        Term term5 = Rational.ZERO.toTerm(term.getSort());
        Term term6 = theory.term("<", new Term[]{term, term5});
        Term term7 = theory.term("ite", new Term[]{term6, theory.term("-", new Term[]{term}), term});
        if (term != term2) {
            Term term8 = theory.term("-", new Term[]{term});
            term3 = term8 == term2 ? this.mProofRules.trans(term4, term7, term8) : this.mProofRules.trans(term4, term7, term8, term2);
            term3 = this.res(theory.term("=", new Term[]{term7, term8}), this.mProofRules.ite1(term7), term3);
            Term term9 = theory.term("=", new Term[]{term8, term2});
            if (term8 != term2) {
                term3 = this.res(term9, this.convertRewriteCanonicalSum(term8, term2), term3);
            }
        } else {
            term3 = this.mProofRules.trans(term4, term7, term);
            term3 = this.res(theory.term("=", new Term[]{term7, term}), this.mProofRules.ite2(term7), term3);
        }
        term3 = this.res(theory.term("=", new Term[]{term4, term7}), this.mProofRules.expand(term4), term3);
        return term3;
    }

    private Term proveAbsConstant(Rational rational, Sort sort) {
        Theory theory = sort.getTheory();
        Term term = rational.toTerm(sort);
        Term term2 = rational.abs().toTerm(sort);
        Term term3 = Rational.ZERO.toTerm(sort);
        Term term4 = theory.term("<", new Term[]{term, term3});
        Term term5 = this.proveAbsEquality(term, term2);
        if (term == term2) {
            term5 = this.res(term4, term5, this.mProofRules.farkas(new Term[]{term4}, new BigInteger[]{BigInteger.ONE}));
        } else {
            term5 = this.res(term4, this.mProofRules.total(term3, term), term5);
            Term term6 = theory.term("<=", new Term[]{term3, term});
            term5 = this.res(term6, term5, this.mProofRules.farkas(new Term[]{term6}, new BigInteger[]{BigInteger.ONE}));
        }
        return term5;
    }

    private Term resolveNeededEqualities(Term term, Map<SymmetricPair<Term>, Term> map, Map<SymmetricPair<Term>, Term> map2, Set<Term> set, Set<Term> set2) {
        Term term2;
        Term[] termArray;
        for (Term term3 : set) {
            assert (this.isApplication("=", term3));
            termArray = ((ApplicationTerm)term3).getParameters();
            term2 = map.get(new SymmetricPair<Term>(termArray[0], termArray[1]));
            if (term2 != null) {
                if (term2 == term3) continue;
                term = this.res(term3, this.mProofRules.symm(termArray[0], termArray[1]), term);
                continue;
            }
            Term term4 = this.proveTrivialEquality(termArray[0], termArray[1]);
            term = this.res(term3, term4, term);
        }
        for (Term term3 : set2) {
            assert (this.isApplication("=", term3));
            termArray = ((ApplicationTerm)term3).getParameters();
            term2 = map2.get(new SymmetricPair<Term>(termArray[0], termArray[1]));
            if (term2 == term3) continue;
            term = this.res(term3, term, this.mProofRules.symm(termArray[1], termArray[0]));
        }
        return term;
    }

    private Term[] termToClause(Term term) {
        assert (term != null && term.getSort().getName() == "Bool");
        if (this.isApplication("or", term)) {
            return ((ApplicationTerm)term).getParameters();
        }
        if (this.isApplication("false", term)) {
            return new Term[0];
        }
        return new Term[]{term};
    }

    private ProofLiteral[] termArrayToProofLiterals(Term[] termArray) {
        ProofLiteral[] proofLiteralArray = new ProofLiteral[termArray.length];
        int n = 0;
        while (n < proofLiteralArray.length) {
            Term term = termArray[n];
            boolean bl = true;
            while (this.isApplication("not", term)) {
                term = ((ApplicationTerm)term).getParameters()[0];
                boolean bl2 = bl = !bl;
            }
            proofLiteralArray[n] = new ProofLiteral(term, bl);
            ++n;
        }
        return proofLiteralArray;
    }

    private ProofLiteral[] termToProofLiterals(Term term) {
        return this.termArrayToProofLiterals(this.termToClause(term));
    }

    private Term proveIffTrue(Term term, Term term2) {
        assert (this.isApplication("=", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        assert (this.isApplication("true", termArray[1]));
        return this.res(termArray[1], this.mProofRules.trueIntro(), this.res(termArray[0], term2, this.mProofRules.iffIntro2(term)));
    }

    private Term proveIffFalse(Term term, Term term2) {
        assert (this.isApplication("=", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        assert (this.isApplication("false", termArray[1]));
        return this.res(termArray[1], this.res(termArray[0], this.mProofRules.iffIntro1(term), term2), this.mProofRules.falseElim());
    }

    private Term proveIff(Term term, Term term2, Term term3) {
        assert (this.isApplication("=", term));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        assert (termArray.length == 2);
        if (this.isApplication("true", termArray[1])) {
            return this.proveIffTrue(term, term3);
        }
        if (this.isApplication("false", termArray[1])) {
            return this.proveIffFalse(term, term2);
        }
        return this.mProofRules.resolutionRule(termArray[1], this.mProofRules.resolutionRule(termArray[0], this.mProofRules.iffIntro1(term), term2), this.mProofRules.resolutionRule(termArray[0], term3, this.mProofRules.iffIntro2(term)));
    }

    private Term res(Term term, Term term2, Term term3) {
        return term2 == null ? term3 : (term3 == null ? term2 : this.mProofRules.resolutionRule(term, term2, term3));
    }

    private Term proveAuxElim(ApplicationTerm applicationTerm, Term term) {
        ApplicationTerm applicationTerm2 = (ApplicationTerm)applicationTerm.getParameters()[0];
        Term term2 = this.mSkript.term("false", new Term[0]);
        Term term3 = this.mSkript.term("=", new Term[]{applicationTerm2, term});
        return this.res((Term)applicationTerm2, this.res(term2, this.mProofRules.iffIntro1((Term)applicationTerm), this.mProofRules.falseElim()), this.res(term3, this.mProofRules.expand((Term)applicationTerm2), this.mProofRules.iffElim2(term3)));
    }

    private Term proveAuxExpand(ApplicationTerm applicationTerm, Term term) {
        ApplicationTerm applicationTerm2 = (ApplicationTerm)applicationTerm.getParameters()[0];
        Term term2 = this.mSkript.term("true", new Term[0]);
        Term term3 = this.mSkript.term("=", new Term[]{applicationTerm, applicationTerm2});
        Term term4 = this.mSkript.term("=", new Term[]{applicationTerm2, term});
        return this.mProofRules.resolutionRule(term3, this.mProofRules.resolutionRule(term2, this.mProofRules.trueIntro(), this.proveIff(term3, this.mProofRules.iffElim1((Term)applicationTerm), this.mProofRules.iffIntro2((Term)applicationTerm))), this.mProofRules.resolutionRule(term4, this.mProofRules.expand((Term)applicationTerm2), this.mProofRules.trans(new Term[]{applicationTerm, applicationTerm2, term})));
    }

    private Term proveEqWithMultiplier(Term[] termArray, Term[] termArray2, Rational rational) {
        Theory theory = termArray[0].getTheory();
        Term term = theory.term("=", new Term[]{termArray[0], termArray[1]});
        Term term2 = theory.term("=", new Term[]{termArray[1], termArray[0]});
        Term term3 = theory.term("<", new Term[]{termArray2[0], termArray2[1]});
        Term term4 = theory.term("<", new Term[]{termArray2[1], termArray2[0]});
        boolean bl = rational.signum() < 0;
        BigInteger[] bigIntegerArray = new BigInteger[]{rational.numerator().abs(), rational.denominator()};
        Term term5 = this.mProofRules.farkas(new Term[]{bl ? term : term2, term3}, bigIntegerArray);
        Term term6 = this.mProofRules.farkas(new Term[]{bl ? term2 : term, term4}, bigIntegerArray);
        Term term7 = this.res(term3, this.res(term4, this.mProofRules.trichotomy(termArray2[0], termArray2[1]), term6), term5);
        term7 = this.res(term2, this.mProofRules.symm(termArray[1], termArray[0]), term7);
        return term7;
    }

    private Term proveRewriteWithLinEq(Term term, Term term2) {
        boolean bl;
        Theory theory = term.getTheory();
        assert (this.isApplication("=", term) && this.isApplication("=", term2));
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        Term[] termArray2 = ((ApplicationTerm)term2).getParameters();
        Polynomial polynomial = new Polynomial(termArray[0]);
        polynomial.add(Rational.MONE, termArray[1]);
        Polynomial polynomial2 = new Polynomial(termArray2[0]);
        polynomial2.add(Rational.MONE, termArray2[1]);
        assert (!polynomial.isConstant() && !polynomial2.isConstant()) : "A trivial equality was created";
        Rational rational = polynomial.getGcd().div(polynomial2.getGcd());
        polynomial2.mul(rational);
        boolean bl2 = bl = !polynomial.equals(polynomial2);
        if (bl) {
            polynomial2.mul(Rational.MONE);
            rational = rational.negate();
        }
        assert (polynomial.equals(polynomial2));
        return this.proveIff(theory.term("=", new Term[]{term, term2}), this.proveEqWithMultiplier(termArray, termArray2, rational.inverse()), this.proveEqWithMultiplier(termArray2, termArray, rational));
    }

    private Term proveRewriteWithLeq(Term term, Term term2, boolean bl) {
        Polynomial polynomial;
        Polynomial polynomial2;
        Theory theory = term.getTheory();
        boolean bl2 = this.isApplication(">", term) || this.isApplication(">=", term);
        boolean bl3 = this.isApplication("not", term2);
        Term term3 = bl3 ? this.negate(term2) : term2;
        Term[] termArray = ((ApplicationTerm)term).getParameters();
        Term[] termArray2 = ((ApplicationTerm)term3).getParameters();
        boolean bl4 = this.isApplication("<", term) || this.isApplication(">", term);
        boolean bl5 = this.isApplication("<", term3);
        if (bl2) {
            termArray = new Term[]{termArray[1], termArray[0]};
        }
        Term term4 = theory.term(bl4 ? "<" : "<=", new Term[]{termArray[0], termArray[1]});
        Term term5 = theory.term(bl4 ? "<=" : "<", new Term[]{termArray[1], termArray[0]});
        Rational rational = Rational.ONE;
        boolean bl6 = false;
        if (bl) {
            polynomial2 = new Polynomial(termArray[0]);
            polynomial2.add(Rational.MONE, termArray[1]);
            polynomial = new Polynomial(termArray2[0]);
            polynomial.add(Rational.MONE, termArray2[1]);
            assert (!polynomial2.isConstant() && !polynomial.isConstant());
            for (Map<Term, Integer> object2 : polynomial2.getSummands().keySet()) {
                if (object2.size() <= 0) continue;
                rational = polynomial2.getSummands().get(object2).div(polynomial.getSummands().get(object2)).abs();
                break;
            }
            if (termArray[0].getSort().getName().equals("Int")) {
                boolean bl7 = bl6 = !polynomial2.getConstant().div(rational).isIntegral() || bl3;
            }
        }
        if (bl6) {
            assert (this.isZero(termArray2[1]));
            assert (!bl4 && !bl5);
            Term term6 = Rational.ONE.toTerm(termArray2[1].getSort());
            polynomial2 = theory.term("<=", new Term[]{term6, termArray2[0]});
            polynomial = this.mProofRules.totalInt(termArray2[0], BigInteger.ZERO);
        } else {
            polynomial2 = theory.term(bl5 ? "<=" : "<", new Term[]{termArray2[1], termArray2[0]});
            polynomial = this.mProofRules.total(termArray2[bl5 ? 1 : 0], termArray2[bl5 ? 0 : 1]);
        }
        Term term8 = this.mProofRules.farkas(new Term[]{bl3 ? term5 : term4, polynomial2}, new BigInteger[]{rational.denominator(), rational.numerator()});
        term8 = this.mProofRules.resolutionRule((Term)polynomial2, (Term)polynomial, term8);
        Term term6 = this.mProofRules.farkas(new Term[]{bl3 ? term4 : term5, term3}, new BigInteger[]{rational.denominator(), rational.numerator()});
        Term term9 = bl3 ? this.mProofRules.resolutionRule(term3, this.mProofRules.notIntro(term2), term6) : term8;
        Term term10 = bl3 ? this.mProofRules.resolutionRule(term3, term8, this.mProofRules.notElim(term2)) : term6;
        term10 = this.mProofRules.resolutionRule(term5, this.mProofRules.total(termArray[bl4 ? 1 : 0], termArray[bl4 ? 0 : 1]), term10);
        Term term11 = null;
        if (bl2) {
            term11 = theory.term("=", new Term[]{term, term4});
            term9 = this.mProofRules.resolutionRule(term4, this.mProofRules.iffElim2(term11), term9);
            term10 = this.mProofRules.resolutionRule(term4, term10, this.mProofRules.iffElim1(term11));
        }
        Term term12 = this.proveIff(theory.term("=", new Term[]{term, term2}), term9, term10);
        if (bl2) {
            term12 = this.mProofRules.resolutionRule(term11, bl4 ? this.mProofRules.gtDef(term) : this.mProofRules.geqDef(term), term12);
        }
        return term12;
    }

    public Term transformProof(Term term) {
        FunctionSymbol functionSymbol2;
        Object object;
        CollectSkolemAux collectSkolemAux = new CollectSkolemAux();
        term = collectSkolemAux.transform(term);
        this.mAuxDefs = collectSkolemAux.getAuxDef();
        TermVariable[] termVariableArray = (term = super.transform(term)).getFreeVars();
        if (termVariableArray.length > 0) {
            object = term.getTheory();
            functionSymbol2 = new Term[termVariableArray.length];
            int n = 0;
            while (n < termVariableArray.length) {
                functionSymbol2[n] = this.mProofRules.choose(termVariableArray[n], (Term)((Theory)object).mTrue);
                ++n;
            }
            term = new FormulaUnLet().unlet(object.let(termVariableArray, (Term[])functionSymbol2, term));
        }
        object = new ArrayDeque();
        for (FunctionSymbol functionSymbol2 : this.mAuxDefs.keySet()) {
            ((ArrayDeque)object).addFirst(functionSymbol2);
        }
        Iterator<Object> iterator = ((ArrayDeque)object).iterator();
        while (iterator.hasNext()) {
            functionSymbol2 = (FunctionSymbol)iterator.next();
            term = this.mProofRules.defineFun(functionSymbol2, (Term)this.mAuxDefs.get(functionSymbol2), term);
        }
        return term;
    }

    class CollectSkolemAux
    extends TermTransformer {
        private final HashMap<FunctionSymbol, LambdaTerm> mQuantDefinedTerms = new LinkedHashMap<FunctionSymbol, LambdaTerm>();

        CollectSkolemAux() {
        }

        public HashMap<FunctionSymbol, LambdaTerm> getAuxDef() {
            return this.mQuantDefinedTerms;
        }

        public void convert(Term term) {
            FunctionSymbol functionSymbol;
            if ((ProofSimplifier.this.isAuxApplication(term) || ProofSimplifier.this.isSkolem(term)) && !this.mQuantDefinedTerms.containsKey(functionSymbol = ((ApplicationTerm)term).getFunction())) {
                this.enqueueWalker(nonRecursive -> {
                    ((CollectSkolemAux)nonRecursive).getConverted();
                    if (!this.mQuantDefinedTerms.containsKey(functionSymbol)) {
                        this.mQuantDefinedTerms.put(functionSymbol, (LambdaTerm)functionSymbol.getTheory().lambda(functionSymbol.getDefinitionVars(), functionSymbol.getDefinition()));
                    }
                });
                super.convert(functionSymbol.getDefinition());
            }
            super.convert(term);
        }
    }
}

