/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CNamed;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.SymmetricHashRelation;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiFunction;

public final class CompatibleTypes {
    private CompatibleTypes() {
    }

    public static boolean areCompatible(ICType iCType, ICType iCType2) {
        return CompatibleTypes.areCompatible(iCType, iCType2, (SymmetricHashRelation<ICType>)new SymmetricHashRelation());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean areCompatible(ICType iCType, ICType iCType2, SymmetricHashRelation<ICType> symmetricHashRelation) {
        if (iCType == iCType2) {
            return true;
        }
        if (symmetricHashRelation.containsPair((Object)iCType, (Object)iCType2)) {
            return true;
        }
        ICType iCType3 = iCType.getUnderlyingType();
        ICType iCType4 = iCType2.getUnderlyingType();
        ICType iCType5 = iCType3;
        Objects.requireNonNull(iCType5);
        ICType iCType6 = iCType5;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CArray.class, CEnum.class, CFunction.class, CNamed.class, CPointer.class, CPrimitive.class, CStructOrUnion.class}, (Object)iCType6, 0)) {
            case 0: {
                CArray cArray = (CArray)iCType6;
                if (!(iCType4 instanceof CArray)) return false;
                CArray cArray2 = (CArray)iCType4;
                if (!CompatibleTypes.areCompatibleArrayTypes(cArray, cArray2, symmetricHashRelation)) return false;
                return true;
            }
            case 1: {
                CEnum cEnum = (CEnum)iCType6;
                if (iCType4 instanceof CEnum) {
                    CEnum cEnum2 = (CEnum)iCType4;
                    if (CompatibleTypes.areCompatibleEnumTypes(cEnum, cEnum2)) return true;
                }
                if (!(iCType4 instanceof CPrimitive)) return false;
                CPrimitive cPrimitive = (CPrimitive)iCType4;
                if (CompatibleTypes.isCompatiblePrimitiveForEnum(cEnum, cPrimitive)) return true;
                return false;
            }
            case 2: {
                CFunction cFunction = (CFunction)iCType6;
                if (!(iCType4 instanceof CFunction)) return false;
                CFunction cFunction2 = (CFunction)iCType4;
                if (!CompatibleTypes.areCompatibleFunctionTypes(cFunction, cFunction2, symmetricHashRelation)) return false;
                return true;
            }
            case 3: {
                CNamed cNamed = (CNamed)iCType6;
                throw new AssertionError((Object)"getUnderlyingType() must not return CNamed");
            }
            case 4: {
                CPointer cPointer = (CPointer)iCType6;
                if (!(iCType4 instanceof CPointer)) return false;
                CPointer cPointer2 = (CPointer)iCType4;
                if (!CompatibleTypes.areCompatible(cPointer.getPointsToType(), cPointer2.getPointsToType(), symmetricHashRelation)) return false;
                return true;
            }
            case 5: {
                CPrimitive cPrimitive = (CPrimitive)iCType6;
                if (iCType4 instanceof CPrimitive) {
                    CPrimitive cPrimitive2 = (CPrimitive)iCType4;
                    if (cPrimitive.getType() == cPrimitive2.getType()) return true;
                }
                if (!(iCType4 instanceof CEnum)) return false;
                CEnum cEnum = (CEnum)iCType4;
                if (CompatibleTypes.isCompatiblePrimitiveForEnum(cEnum, cPrimitive)) return true;
                return false;
            }
            case 6: {
                CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType6;
                if (!(iCType4 instanceof CStructOrUnion)) return false;
                CStructOrUnion cStructOrUnion2 = (CStructOrUnion)iCType4;
                if (!CompatibleTypes.areCompatibleStructOrUnionTypes(cStructOrUnion, cStructOrUnion2, symmetricHashRelation)) return false;
                return true;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
    }

    private static boolean areCompatibleEnumTypes(CEnum cEnum, CEnum cEnum2) {
        if (!Objects.equals(cEnum.getName(), cEnum2.getName())) {
            return false;
        }
        if (cEnum.isIncomplete() || cEnum2.isIncomplete()) {
            return true;
        }
        if (cEnum.getFieldCount() != cEnum2.getFieldCount()) {
            return false;
        }
        int n = 0;
        while (n < cEnum.getFieldCount()) {
            if (!cEnum.getFieldIds()[n].equals(cEnum2.getFieldIds()[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean isCompatiblePrimitiveForEnum(CEnum cEnum, CPrimitive cPrimitive) {
        return cPrimitive.getType() == CPrimitive.CPrimitives.INT;
    }

    private static boolean areCompatibleFunctionTypes(CFunction cFunction, CFunction cFunction2, SymmetricHashRelation<ICType> symmetricHashRelation) {
        symmetricHashRelation.addPair((Object)cFunction, (Object)cFunction2);
        if (!CompatibleTypes.areCompatible(cFunction.getResultType(), cFunction2.getResultType(), symmetricHashRelation)) {
            return false;
        }
        if (cFunction.getParameterTypes().length != cFunction2.getParameterTypes().length || cFunction.hasVarArgs() != cFunction2.hasVarArgs()) {
            return false;
        }
        int n = 0;
        while (n < cFunction.getParameterTypes().length) {
            if (!CompatibleTypes.areCompatible(cFunction.getParameterTypes()[n].getType(), cFunction2.getParameterTypes()[n].getType(), symmetricHashRelation)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean areCompatibleStructOrUnionTypes(CStructOrUnion cStructOrUnion, CStructOrUnion cStructOrUnion2, SymmetricHashRelation<ICType> symmetricHashRelation) {
        symmetricHashRelation.addPair((Object)cStructOrUnion, (Object)cStructOrUnion2);
        if (cStructOrUnion.isStructOrUnion() != cStructOrUnion2.isStructOrUnion()) {
            return false;
        }
        if (!Objects.equals(cStructOrUnion.getName(), cStructOrUnion2.getName())) {
            return false;
        }
        if (cStructOrUnion.isIncomplete() || cStructOrUnion2.isIncomplete()) {
            return true;
        }
        if (cStructOrUnion.getFieldCount() != cStructOrUnion2.getFieldCount()) {
            return false;
        }
        BiFunction<Integer, String, OptionalInt> biFunction = cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.STRUCT ? CompatibleTypes.makeStructFieldLookup(cStructOrUnion2) : CompatibleTypes.makeUnionFieldLookup(cStructOrUnion2);
        int n = 0;
        while (n < cStructOrUnion.getFieldCount()) {
            String string = cStructOrUnion.getFieldIds()[n];
            OptionalInt optionalInt = biFunction.apply(n, string);
            if (optionalInt.isEmpty()) {
                return false;
            }
            if (!CompatibleTypes.areCompatible(cStructOrUnion.getFieldTypes()[n], cStructOrUnion2.getFieldTypes()[optionalInt.getAsInt()], symmetricHashRelation)) {
                return false;
            }
            if (cStructOrUnion.getBitfieldWidth(string) != cStructOrUnion2.getBitfieldWidth(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static BiFunction<Integer, String, OptionalInt> makeStructFieldLookup(CStructOrUnion cStructOrUnion) {
        assert (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.STRUCT);
        return (n, string) -> {
            if (n >= cStructOrUnion.getFieldCount() || !Objects.equals(string, cStructOrUnion.getFieldIds()[n])) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(n);
        };
    }

    private static BiFunction<Integer, String, OptionalInt> makeUnionFieldLookup(CStructOrUnion cStructOrUnion) {
        assert (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION);
        return (n, string) -> {
            if (n >= cStructOrUnion.getFieldCount()) {
                return OptionalInt.empty();
            }
            if (Objects.equals(string, cStructOrUnion.getFieldIds()[n])) {
                return OptionalInt.of(n);
            }
            int n2 = Arrays.asList(cStructOrUnion.getFieldIds()).indexOf(string);
            return n2 == -1 ? OptionalInt.empty() : OptionalInt.of(n2);
        };
    }

    private static boolean areCompatibleArrayTypes(CArray cArray, CArray cArray2, SymmetricHashRelation<ICType> symmetricHashRelation) {
        if (!CompatibleTypes.areCompatible(cArray.getValueType(), cArray2.getValueType(), symmetricHashRelation)) {
            return false;
        }
        if (cArray.isIncomplete() || cArray2.isIncomplete()) {
            return true;
        }
        BigInteger bigInteger = CTranslationUtil.extractIntegerValue(cArray.getBound().getValue());
        BigInteger bigInteger2 = CTranslationUtil.extractIntegerValue(cArray2.getBound().getValue());
        return bigInteger == null || bigInteger2 == null || bigInteger.equals(bigInteger2);
    }
}

