/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayList;

public class LAEquality
extends DPLLAtom {
    private final LinVar mVar;
    private final Rational mBound;
    private final ArrayList<CCEquality> mDependentEqualities;

    public LAEquality(int n, LinVar linVar, Rational rational) {
        super(HashUtils.hashJenkins((int)(~linVar.hashCode()), (Object)rational), n);
        this.mVar = linVar;
        this.mBound = rational;
        this.mDependentEqualities = new ArrayList();
    }

    public Rational getBound() {
        return this.mBound;
    }

    public LinVar getVar() {
        return this.mVar;
    }

    @Override
    public String toStringNegated() {
        return "[" + this.hashCode() + "]" + String.valueOf(this.mVar) + " != " + String.valueOf(this.mBound);
    }

    @Override
    public String toString() {
        return "[" + this.hashCode() + "]" + String.valueOf(this.mVar) + " == " + String.valueOf(this.mBound);
    }

    @Override
    public Term getSMTFormula(Theory theory) {
        MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
        mutableAffineTerm.add(Rational.ONE, this.mVar);
        mutableAffineTerm.add(this.mBound.negate());
        boolean bl = this.mVar.mIsInt && this.mBound.isIntegral();
        Sort sort = theory.getSort(bl ? "Int" : "Real", new Sort[0]);
        Sort[] sortArray = new Sort[]{sort, sort};
        FunctionSymbol functionSymbol = theory.getFunction("=", sortArray);
        return theory.term(functionSymbol, new Term[]{mutableAffineTerm.toSMTLib(theory, bl), Rational.ZERO.toTerm(sort)});
    }

    public void addDependentAtom(CCEquality cCEquality) {
        this.mDependentEqualities.add(cCEquality);
    }

    public void removeDependentAtom(CCEquality cCEquality) {
        this.mDependentEqualities.remove(cCEquality);
    }

    public Iterable<CCEquality> getDependentEqualities() {
        return this.mDependentEqualities;
    }

    public boolean equals(Object object) {
        if (object instanceof LAEquality) {
            LAEquality lAEquality = (LAEquality)object;
            return lAEquality.mVar == this.mVar && lAEquality.mBound.equals((Object)this.mBound);
        }
        return false;
    }
}

