/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CsvProviderColumnSwapper<T>
implements ICsvProviderTransformer<T> {
    private final Map<String, Integer> mArchetypeColumnTitle2index;
    private final List<String> mArchetypeColumnTitles;

    public CsvProviderColumnSwapper(List<String> list) {
        this(CsvProviderColumnSwapper.list2map(list), list);
    }

    public CsvProviderColumnSwapper(Map<String, Integer> map) {
        this(map, CsvProviderColumnSwapper.map2list(map));
    }

    private CsvProviderColumnSwapper(Map<String, Integer> map, List<String> list) {
        this.mArchetypeColumnTitle2index = map;
        this.mArchetypeColumnTitles = list;
    }

    private static final Map<String, Integer> list2map(List<String> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Iterator<String> iterator = list.iterator();
        int n = 0;
        while (n < list.size()) {
            hashMap.put(iterator.next(), n);
            ++n;
        }
        return hashMap;
    }

    private static final List<String> map2list(Map<String, Integer> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            int n = entry.getValue();
            if (n < 0 || n >= arrayList.size()) {
                throw new IllegalArgumentException("Illegal index, value was " + n + ", allowed range was [0, " + (arrayList.size() - 1) + "].");
            }
            arrayList.set(n, entry.getKey());
        }
        return arrayList;
    }

    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> iCsvProvider) {
        List<String> list = iCsvProvider.getColumnTitles();
        int[] nArray = new int[this.mArchetypeColumnTitle2index.size()];
        int n = 0;
        boolean bl = false;
        for (String object2 : list) {
            int objectArray = this.mArchetypeColumnTitle2index.get(object2);
            if (n != objectArray) {
                bl = true;
            }
            nArray[objectArray] = n++;
        }
        if (!bl) {
            return iCsvProvider;
        }
        SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(new ArrayList<String>(this.mArchetypeColumnTitles));
        int n3 = 0;
        while (n3 < iCsvProvider.getRowHeaders().size()) {
            Object[] objectArray = iCsvProvider.getRow(n3).toArray();
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            int n2 = 0;
            while (n2 < objectArray.length) {
                arrayList.add(objectArray[nArray[n2]]);
                ++n2;
            }
            ++n3;
        }
        return simpleCsvProvider;
    }
}

