/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CStorageClass;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.InitializerResult;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;

public class CDeclaration {
    private final ICType mType;
    private final String mName;
    private InitializerResult mInitializer;
    private final IASTInitializer mCAstInitializer;
    private final boolean mIsOnHeap;
    private boolean mIsInitializerTranslated;
    private CStorageClass mStorageClass;
    private final int mBitfieldSize;

    public CDeclaration(ICType iCType, String string, IASTInitializer iASTInitializer, InitializerResult initializerResult, boolean bl, CStorageClass cStorageClass, int n) {
        this.mType = iCType;
        this.mName = string;
        this.mCAstInitializer = iASTInitializer;
        this.mInitializer = initializerResult;
        assert (iASTInitializer == null || initializerResult == null);
        this.mIsOnHeap = bl;
        this.mIsInitializerTranslated = false;
        this.mStorageClass = cStorageClass;
        this.mBitfieldSize = n;
    }

    public CDeclaration(ICType iCType, String string, CStorageClass cStorageClass) {
        this(iCType, string, null, null, false, cStorageClass, -1);
    }

    public CDeclaration(ICType iCType, String string) {
        this(iCType, string, null, null, false, CStorageClass.UNSPECIFIED, -1);
    }

    public ICType getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public InitializerResult getInitializer() {
        if (!this.mIsInitializerTranslated) {
            throw new AssertionError((Object)"Initializer must have been translated before this is called.");
        }
        return this.mInitializer;
    }

    public boolean hasInitializer() {
        return this.mCAstInitializer != null || this.mInitializer != null;
    }

    public boolean isOnHeap() {
        return this.mIsOnHeap;
    }

    public String toString() {
        return this.mType.toString() + " " + this.mName + " = " + String.valueOf(this.mInitializer);
    }

    public IASTInitializer getIASTInitializer() {
        return this.mCAstInitializer;
    }

    public void setInitializerResult(InitializerResult initializerResult) {
        assert (!this.mIsInitializerTranslated) : "initializer has already been translated";
        if (this.mCAstInitializer != null) {
            assert (this.mInitializer == null);
            this.mInitializer = initializerResult;
        }
        this.mIsInitializerTranslated = true;
    }

    public boolean isStatic() {
        return this.mStorageClass == CStorageClass.STATIC;
    }

    public boolean isExtern() {
        return this.mStorageClass == CStorageClass.EXTERN;
    }

    public void setStorageClass(CStorageClass cStorageClass) {
        this.mStorageClass = cStorageClass;
    }

    public Integer getBitfieldSize() {
        return this.mBitfieldSize;
    }

    public CStorageClass getStorageClass() {
        return this.mStorageClass;
    }
}

