/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.DefaultLassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.LassoAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.DefaultNonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.FixpointCheck;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.FixpointCheck2;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.INonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.DefaultTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.ITerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.NonterminationAnalysisBenchmark;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisBenchmark;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.AffineTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.LexicographicTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.MultiphaseTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.NestedTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.PiecewiseTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BinaryStatePredicateManager;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiAutomizerUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiCegarLoopBenchmarkGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IPostconditionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IPreconditionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.StrategyFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TraceAbstractionRefinementEngine;
import de.uni_freiburg.informatik.ultimate.util.HistogramOfIterable;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LassoCheck<L extends IIcfgTransition<?>> {
    private static final boolean SIMPLIFY_STEM_AND_LOOP = true;
    private static final boolean CHECK_TERMINATION_EVEN_IF_NON_TERMINATING = false;
    private static final boolean AVOID_NONTERMINATION_CHECK_IF_ARRAYS_ARE_CONTAINED = true;
    private static final boolean TRACE_CHECK_BASED_FIXPOINT_CHECK = true;
    private final boolean mTryTwofoldRefinement;
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final AnalysisType mRankAnalysisType;
    private final AnalysisType mGntaAnalysisType;
    private final int mGntaDirections;
    private final boolean mTrySimplificationTerminationArgument;
    private final boolean mTemplateBenchmarkMode;
    private final CfgSmtToolkit mCsToolkit;
    private final BinaryStatePredicateManager mBspm;
    private final NestedLassoRun<L, IPredicate> mCounterexample;
    private final Function<IPredicate, Object> mGetControlConfiguration;
    private final String mLassoCheckIdentifier;
    private IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> mStemCheck;
    private IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> mLoopCheck;
    private IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> mConcatCheck;
    private NestedWord<L> mConcatenatedCounterexample;
    private NonTerminationArgument mNonterminationArgument;
    private final SmtFunctionsAndAxioms mSmtSymbols;
    private final IUltimateServiceProvider mServices;
    private final boolean mRemoveSuperfluousSupportingInvariants = true;
    private final LassoCheckResult mLassoCheckResult;
    private final List<LassoAnalysis.PreprocessingBenchmark> mPreprocessingBenchmarks = new ArrayList<LassoAnalysis.PreprocessingBenchmark>();
    private final List<TerminationAnalysisBenchmark> mTerminationAnalysisBenchmarks = new ArrayList<TerminationAnalysisBenchmark>();
    private final List<NonterminationAnalysisBenchmark> mNonterminationAnalysisBenchmarks = new ArrayList<NonterminationAnalysisBenchmark>();
    private final StrategyFactory<L> mRefinementStrategyFactory;
    private final IAutomaton<L, IPredicate> mAbstraction;
    private final TaskIdentifier mTaskIdentifier;
    private final BuchiCegarLoopBenchmarkGenerator mCegarStatistics;
    private final PredicateFactory mPredicateFactory;
    private final PredicateFactoryForInterpolantAutomata mStateFactoryForInterpolantAutomaton;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;
    private BinaryStatePredicateManager.BspmResult mBspmResult;

    public LassoCheck(CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, SmtFunctionsAndAxioms smtFunctionsAndAxioms, BinaryStatePredicateManager binaryStatePredicateManager, NestedLassoRun<L, IPredicate> nestedLassoRun, Function<IPredicate, Object> function, String string, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique, StrategyFactory<L> strategyFactory, IAutomaton<L, IPredicate> iAutomaton, TaskIdentifier taskIdentifier, BuchiCegarLoopBenchmarkGenerator buchiCegarLoopBenchmarkGenerator) throws IOException {
        this.mServices = iUltimateServiceProvider;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mRankAnalysisType = (AnalysisType)iPreferenceProvider.getEnum("Rank analysis", AnalysisType.class);
        this.mGntaAnalysisType = (AnalysisType)iPreferenceProvider.getEnum("GNTA analysis", AnalysisType.class);
        this.mGntaDirections = iPreferenceProvider.getInt("Number of GNTA directions");
        this.mTemplateBenchmarkMode = iPreferenceProvider.getBoolean("Template benchmark mode");
        this.mTrySimplificationTerminationArgument = iPreferenceProvider.getBoolean("Try to simplify termination arguments");
        this.mTryTwofoldRefinement = iPreferenceProvider.getBoolean("Try twofold refinement");
        this.mCsToolkit = cfgSmtToolkit;
        this.mBspm = binaryStatePredicateManager;
        this.mCounterexample = nestedLassoRun;
        this.mGetControlConfiguration = function;
        IPredicate iPredicate = (IPredicate)nestedLassoRun.getLoop().getStateAtPosition(0);
        this.mModifiableGlobalsAtHonda = PredicateUtils.streamLocations((IPredicate)iPredicate).flatMap(icfgLocation -> this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(icfgLocation.getProcedure()).stream()).collect(Collectors.toSet());
        this.mLassoCheckIdentifier = string;
        this.mSmtSymbols = smtFunctionsAndAxioms;
        this.mRefinementStrategyFactory = strategyFactory;
        this.mAbstraction = iAutomaton;
        this.mTaskIdentifier = taskIdentifier;
        this.mCegarStatistics = buchiCegarLoopBenchmarkGenerator;
        this.mPredicateFactory = predicateFactory;
        this.mStateFactoryForInterpolantAutomaton = new PredicateFactoryForInterpolantAutomata(this.mCsToolkit.getManagedScript(), this.mPredicateFactory, false);
        this.mLassoCheckResult = new LassoCheckResult();
        assert (this.mLassoCheckResult.getStemFeasibility() != TraceCheckResult.UNCHECKED);
        assert (this.mLassoCheckResult.getLoopFeasibility() != TraceCheckResult.UNCHECKED || this.mLassoCheckResult.getLoopFeasibility() != TraceCheckResult.INFEASIBLE && !this.mTryTwofoldRefinement);
        if (this.mLassoCheckResult.getStemFeasibility() == TraceCheckResult.INFEASIBLE) {
            assert (this.mLassoCheckResult.getContinueDirective() == ContinueDirective.REFINE_FINITE || this.mLassoCheckResult.getContinueDirective() == ContinueDirective.REFINE_BOTH);
        } else if (this.mLassoCheckResult.getLoopFeasibility() == TraceCheckResult.INFEASIBLE) {
            assert (this.mLassoCheckResult.getContinueDirective() == ContinueDirective.REFINE_FINITE);
        } else if (this.mLassoCheckResult.getLoopTermination() != SynthesisResult.TERMINATING) {
            assert (this.mConcatCheck != null);
            if (this.mLassoCheckResult.getConcatFeasibility() == TraceCheckResult.INFEASIBLE) {
                assert (this.mLassoCheckResult.getContinueDirective() == ContinueDirective.REFINE_FINITE || this.mLassoCheckResult.getContinueDirective() == ContinueDirective.REFINE_BOTH);
                assert (this.mConcatenatedCounterexample != null);
            } else assert (this.mLassoCheckResult.getContinueDirective() != ContinueDirective.REFINE_FINITE);
        }
    }

    public LassoCheckResult getLassoCheckResult() {
        return this.mLassoCheckResult;
    }

    public IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> getStemCheck() {
        return this.mStemCheck;
    }

    public IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> getLoopCheck() {
        return this.mLoopCheck;
    }

    public IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> getConcatCheck() {
        return this.mConcatCheck;
    }

    public NestedWord<L> getConcatenatedCounterexample() {
        assert (this.mConcatenatedCounterexample != null);
        return this.mConcatenatedCounterexample;
    }

    public BinaryStatePredicateManager.BspmResult getBspmResult() {
        return this.mBspmResult;
    }

    public NonTerminationArgument getNonTerminationArgument() {
        return this.mNonterminationArgument;
    }

    public List<LassoAnalysis.PreprocessingBenchmark> getPreprocessingBenchmarks() {
        return this.mPreprocessingBenchmarks;
    }

    public List<TerminationAnalysisBenchmark> getTerminationAnalysisBenchmarks() {
        return this.mTerminationAnalysisBenchmarks;
    }

    public List<NonterminationAnalysisBenchmark> getNonterminationAnalysisBenchmarks() {
        return this.mNonterminationAnalysisBenchmarks;
    }

    protected UnmodifiableTransFormula computeStemTF() {
        NestedWord nestedWord = this.mCounterexample.getStem().getWord();
        try {
            UnmodifiableTransFormula unmodifiableTransFormula = this.computeTF(nestedWord, true, true, false);
            if (SmtUtils.isFalseLiteral((Term)unmodifiableTransFormula.getFormula())) {
                throw new AssertionError((Object)"stemTF is false but stem analysis said: feasible");
            }
            return unmodifiableTransFormula;
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "constructing stem TransFormula"));
            throw toolchainCanceledException;
        }
    }

    protected UnmodifiableTransFormula computeLoopTF() {
        NestedWord nestedWord = this.mCounterexample.getLoop().getWord();
        try {
            UnmodifiableTransFormula unmodifiableTransFormula = this.computeTF(nestedWord, true, true, false);
            if (SmtUtils.isFalseLiteral((Term)unmodifiableTransFormula.getFormula())) {
                throw new AssertionError((Object)"loopTF is false but loop analysis said: feasible");
            }
            return unmodifiableTransFormula;
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "constructing loop TransFormula"));
            throw toolchainCanceledException;
        }
    }

    private UnmodifiableTransFormula computeTF(NestedWord<L> nestedWord, boolean bl, boolean bl2, boolean bl3) {
        return SequentialComposition.getInterproceduralTransFormula((CfgSmtToolkit)this.mCsToolkit, (boolean)bl, (boolean)bl2, (boolean)false, (boolean)bl3, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (List)nestedWord.asList(), (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
    }

    private String generateFileBasenamePrefix(boolean bl) {
        return this.mLassoCheckIdentifier + "_" + (bl ? "Lasso" : "Loop");
    }

    private ILassoRankerPreferences constructLassoRankerPreferences(final boolean bl, final boolean bl2, final InequalityConverter.NlaHandling nlaHandling, final LassoAnalysis.AnalysisTechnique analysisTechnique) {
        final IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        return new DefaultLassoRankerPreferences(){

            public boolean isDumpSmtSolverScript() {
                return iPreferenceProvider.getBoolean("Dump SMT script to file");
            }

            public String getPathOfDumpedScript() {
                return iPreferenceProvider.getString("To the following directory");
            }

            public String getBaseNameOfDumpedScript() {
                return LassoCheck.this.generateFileBasenamePrefix(bl);
            }

            public boolean isOverapproximateArrayIndexConnection() {
                return bl2;
            }

            public InequalityConverter.NlaHandling getNlaHandling() {
                return nlaHandling;
            }

            public boolean isUseOldMapElimination() {
                return iPreferenceProvider.getBoolean("Use old map elimination");
            }

            public boolean isMapElimAddInequalities() {
                return iPreferenceProvider.getBoolean("Add inequalities as additional conjuncts to the transformula");
            }

            public boolean isMapElimOnlyTrivialImplicationsArrayWrite() {
                return iPreferenceProvider.getBoolean("Use only trivial implications for array writes");
            }

            public boolean isMapElimOnlyTrivialImplicationsIndexAssignment() {
                return iPreferenceProvider.getBoolean("Use only trivial implications for index assignments");
            }

            public boolean isMapElimOnlyIndicesInFormula() {
                return iPreferenceProvider.getBoolean("Add implications only for indices occuring in the current formula");
            }

            public boolean isExternalSolver() {
                switch (analysisTechnique) {
                    case GEOMETRIC_NONTERMINATION_ARGUMENTS: {
                        return iPreferenceProvider.getBoolean("Use external solver (GNTA synthesis)");
                    }
                    case RANKING_FUNCTIONS_SUPPORTING_INVARIANTS: {
                        return iPreferenceProvider.getBoolean("Use external solver (rank synthesis)");
                    }
                }
                throw new UnsupportedOperationException("Analysis type " + String.valueOf(analysisTechnique) + " unknown");
            }

            public String getExternalSolverCommand() {
                switch (analysisTechnique) {
                    case GEOMETRIC_NONTERMINATION_ARGUMENTS: {
                        return iPreferenceProvider.getString("Command for external solver (GNTA synthesis)");
                    }
                    case RANKING_FUNCTIONS_SUPPORTING_INVARIANTS: {
                        return iPreferenceProvider.getString("Command for external solver (rank synthesis)");
                    }
                }
                throw new UnsupportedOperationException("Analysis type " + String.valueOf(analysisTechnique) + " unknown");
            }
        };
    }

    private TerminationAnalysisSettings constructTASettings() {
        return new TerminationAnalysisSettings((ITerminationAnalysisSettings)new DefaultTerminationAnalysisSettings(){

            public AnalysisType getAnalysis() {
                return LassoCheck.this.mRankAnalysisType;
            }

            public int getNumNonStrictInvariants() {
                return 1;
            }

            public int getNumStrictInvariants() {
                return 0;
            }

            public boolean isNonDecreasingInvariants() {
                return true;
            }

            public boolean isSimplifySupportingInvariants() {
                return LassoCheck.this.mTrySimplificationTerminationArgument;
            }

            public boolean isSimplifyTerminationArgument() {
                return LassoCheck.this.mTrySimplificationTerminationArgument;
            }
        });
    }

    private NonTerminationAnalysisSettings constructNTASettings() {
        return new NonTerminationAnalysisSettings((INonTerminationAnalysisSettings)new DefaultNonTerminationAnalysisSettings(){

            public AnalysisType getAnalysis() {
                return LassoCheck.this.mGntaAnalysisType;
            }

            public int getNumberOfGevs() {
                return LassoCheck.this.mGntaDirections;
            }
        });
    }

    private SynthesisResult synthesize(boolean bl, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, boolean bl2) throws IOException {
        List list;
        Object object;
        LassoAnalysis lassoAnalysis;
        FixpointCheck fixpointCheck;
        if (this.mCsToolkit.getManagedScript().isLocked()) {
            throw new AssertionError((Object)"SMTManager must not be locked at the beginning of synthesis");
        }
        if (!bl) {
            unmodifiableTransFormula = TransFormulaBuilder.getTrivialTransFormula((ManagedScript)this.mCsToolkit.getManagedScript());
        }
        if ((fixpointCheck = new FixpointCheck(this.mServices, this.mLogger, this.mCsToolkit.getManagedScript(), this.mModifiableGlobalsAtHonda, (TransFormula)unmodifiableTransFormula, (TransFormula)unmodifiableTransFormula2)).getResult() == FixpointCheck.HasFixpoint.YES) {
            if (bl) {
                if (!BuchiAutomizerUtils.isEmptyStem(this.mCounterexample.getStem())) {
                    FixpointCheck2 fixpointCheck2 = new FixpointCheck2(this.mServices, this.mLogger, this.mCsToolkit, (BasicPredicateFactory)this.mPredicateFactory, this.mCounterexample.getStem().getWord(), unmodifiableTransFormula2);
                    if (fixpointCheck2.getResult() != fixpointCheck.getResult()) {
                        throw new AssertionError((Object)String.format("Contradicting results of nontermination analyses: Old %s, New %s, Stem length %s, Loop length %s", fixpointCheck.getResult(), fixpointCheck2.getResult(), this.mCounterexample.getStem().getLength(), this.mCounterexample.getLoop().getLength()));
                    }
                    this.mNonterminationArgument = fixpointCheck2.getTerminationArgument();
                } else {
                    this.mNonterminationArgument = fixpointCheck.getTerminationArgument();
                }
            }
            return SynthesisResult.NONTERMINATING;
        }
        boolean bl3 = !bl2;
        GeometricNonTerminationArgument geometricNonTerminationArgument = null;
        if (bl3) {
            lassoAnalysis = null;
            try {
                lassoAnalysis = new LassoAnalysis(this.mCsToolkit, unmodifiableTransFormula, unmodifiableTransFormula2, this.mModifiableGlobalsAtHonda, this.mSmtSymbols, this.constructLassoRankerPreferences(bl, false, InequalityConverter.NlaHandling.UNDERAPPROXIMATE, LassoAnalysis.AnalysisTechnique.GEOMETRIC_NONTERMINATION_ARGUMENTS), this.mServices, this.mSimplificationTechnique);
                this.mPreprocessingBenchmarks.add(lassoAnalysis.getPreprocessingBenchmark());
            }
            catch (TermException termException) {
                termException.printStackTrace();
                throw new AssertionError((Object)("TermException " + String.valueOf((Object)termException)));
            }
            try {
                object = this.constructNTASettings();
                geometricNonTerminationArgument = lassoAnalysis.checkNonTermination((NonTerminationAnalysisSettings)object);
                list = lassoAnalysis.getNonterminationAnalysisBenchmarks();
                this.mNonterminationAnalysisBenchmarks.addAll(list);
            }
            catch (SMTLIBException sMTLIBException) {
                sMTLIBException.printStackTrace();
                throw new AssertionError((Object)("SMTLIBException " + String.valueOf((Object)sMTLIBException)));
            }
            catch (TermException termException) {
                termException.printStackTrace();
                throw new AssertionError((Object)("TermException " + String.valueOf((Object)termException)));
            }
            if (bl) {
                this.mNonterminationArgument = geometricNonTerminationArgument;
            }
            if (geometricNonTerminationArgument != null) {
                return SynthesisResult.NONTERMINATING;
            }
        }
        lassoAnalysis = null;
        try {
            lassoAnalysis = new LassoAnalysis(this.mCsToolkit, unmodifiableTransFormula, unmodifiableTransFormula2, this.mModifiableGlobalsAtHonda, this.mSmtSymbols, this.constructLassoRankerPreferences(bl, true, InequalityConverter.NlaHandling.OVERAPPROXIMATE, LassoAnalysis.AnalysisTechnique.RANKING_FUNCTIONS_SUPPORTING_INVARIANTS), this.mServices, this.mSimplificationTechnique);
            this.mPreprocessingBenchmarks.add(lassoAnalysis.getPreprocessingBenchmark());
        }
        catch (TermException termException) {
            termException.printStackTrace();
            throw new AssertionError((Object)("TermException " + String.valueOf((Object)termException)));
        }
        object = new ArrayList();
        object.add(new AffineTemplate());
        object.add(new NestedTemplate(2));
        object.add(new NestedTemplate(3));
        object.add(new NestedTemplate(4));
        if (this.mTemplateBenchmarkMode) {
            object.add(new NestedTemplate(5));
            object.add(new NestedTemplate(6));
            object.add(new NestedTemplate(7));
        }
        object.add(new MultiphaseTemplate(2));
        object.add(new MultiphaseTemplate(3));
        object.add(new MultiphaseTemplate(4));
        if (this.mTemplateBenchmarkMode) {
            object.add(new MultiphaseTemplate(5));
            object.add(new MultiphaseTemplate(6));
            object.add(new MultiphaseTemplate(7));
        }
        object.add(new LexicographicTemplate(2));
        object.add(new LexicographicTemplate(3));
        if (this.mTemplateBenchmarkMode) {
            object.add(new LexicographicTemplate(4));
        }
        if (this.mTemplateBenchmarkMode) {
            object.add(new PiecewiseTemplate(2));
            object.add(new PiecewiseTemplate(3));
            object.add(new PiecewiseTemplate(4));
        }
        list = this.tryTemplatesAndComputePredicates(lassoAnalysis, (List<RankingTemplate>)object, unmodifiableTransFormula, unmodifiableTransFormula2);
        assert (geometricNonTerminationArgument == null || list == null) : " terminating and nonterminating";
        if (list != null) {
            this.mBspmResult = this.mBspm.computePredicates((TerminationArgument)list, true, unmodifiableTransFormula, unmodifiableTransFormula2, this.mModifiableGlobalsAtHonda);
            return SynthesisResult.TERMINATING;
        }
        if (geometricNonTerminationArgument != null) {
            return SynthesisResult.NONTERMINATING;
        }
        return SynthesisResult.UNKNOWN;
    }

    private TerminationArgument tryTemplatesAndComputePredicates(LassoAnalysis lassoAnalysis, List<RankingTemplate> list, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) throws AssertionError, IOException {
        TerminationArgument terminationArgument = null;
        for (RankingTemplate rankingTemplate : list) {
            TerminationArgument terminationArgument2;
            try {
                TerminationAnalysisSettings terminationAnalysisSettings = this.constructTASettings();
                terminationArgument2 = lassoAnalysis.tryTemplate(rankingTemplate, terminationAnalysisSettings);
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), LassoCheck.generateRunningTaskInfo(unmodifiableTransFormula, unmodifiableTransFormula2, rankingTemplate));
                }
                List list2 = lassoAnalysis.getTerminationAnalysisBenchmarks();
                this.mTerminationAnalysisBenchmarks.addAll(list2);
                if (this.mTemplateBenchmarkMode) {
                    for (TerminationAnalysisBenchmark terminationAnalysisBenchmark : list2) {
                        StatisticsResult statisticsResult = new StatisticsResult(Activator.PLUGIN_ID, "LassoTerminationAnalysisBenchmarks", (ICsvProviderProvider)terminationAnalysisBenchmark);
                        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)statisticsResult);
                    }
                }
            }
            catch (TermException | SMTLIBException throwable) {
                throw new ToolchainExceptionWrapper(Activator.PLUGIN_ID, throwable);
            }
            if (terminationArgument2 == null) continue;
            assert (terminationArgument2.getRankingFunction() != null);
            assert (terminationArgument2.getSupportingInvariants() != null);
            if (!this.mTemplateBenchmarkMode) {
                return terminationArgument2;
            }
            if (terminationArgument != null) continue;
            terminationArgument = terminationArgument2;
        }
        if (terminationArgument != null) {
            assert (terminationArgument.getRankingFunction() != null);
            assert (terminationArgument.getSupportingInvariants() != null);
            return terminationArgument;
        }
        return null;
    }

    private static String generateRunningTaskInfo(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, RankingTemplate rankingTemplate) {
        return "applying " + rankingTemplate.getName() + " template (degree " + rankingTemplate.getDegree() + "), stem dagsize " + String.valueOf(new DagSizePrinter(unmodifiableTransFormula.getFormula())) + ", loop dagsize " + String.valueOf(new DagSizePrinter(unmodifiableTransFormula2.getFormula()));
    }

    public static enum ContinueDirective {
        REFINE_FINITE,
        REFINE_BUCHI,
        REPORT_NONTERMINATION,
        REPORT_UNKNOWN,
        REFINE_BOTH;

    }

    public class LassoCheckResult {
        private final TraceCheckResult mStemFeasibility;
        private final TraceCheckResult mLoopFeasibility;
        private final TraceCheckResult mConcatFeasibility;
        private final SynthesisResult mLoopTermination;
        private final SynthesisResult mLassoTermination;
        private final ContinueDirective mContinueDirective;

        public LassoCheckResult() throws IOException {
            NestedWord nestedWord = LassoCheck.this.mCounterexample.getStem().getWord();
            LassoCheck.this.mLogger.info((Object)("Stem: " + String.valueOf(nestedWord)));
            NestedWord nestedWord2 = LassoCheck.this.mCounterexample.getLoop().getWord();
            LassoCheck.this.mLogger.info((Object)("Loop: " + String.valueOf(nestedWord2)));
            this.mStemFeasibility = this.checkStemFeasibility();
            if (this.mStemFeasibility == TraceCheckResult.INFEASIBLE) {
                LassoCheck.this.mLogger.info((Object)"stem already infeasible");
                if (!LassoCheck.this.mTryTwofoldRefinement) {
                    this.mLoopFeasibility = TraceCheckResult.UNCHECKED;
                    this.mConcatFeasibility = TraceCheckResult.UNCHECKED;
                    this.mLoopTermination = SynthesisResult.UNCHECKED;
                    this.mLassoTermination = SynthesisResult.UNCHECKED;
                    this.mContinueDirective = ContinueDirective.REFINE_FINITE;
                    return;
                }
            }
            this.mLoopFeasibility = this.checkLoopFeasibility();
            if (this.mLoopFeasibility == TraceCheckResult.INFEASIBLE) {
                LassoCheck.this.mLogger.info((Object)"loop already infeasible");
                this.mConcatFeasibility = TraceCheckResult.UNCHECKED;
                this.mLoopTermination = SynthesisResult.UNCHECKED;
                this.mLassoTermination = SynthesisResult.UNCHECKED;
                this.mContinueDirective = ContinueDirective.REFINE_FINITE;
                return;
            }
            if (this.mStemFeasibility == TraceCheckResult.INFEASIBLE) {
                assert (LassoCheck.this.mTryTwofoldRefinement);
                UnmodifiableTransFormula unmodifiableTransFormula = LassoCheck.this.computeLoopTF();
                this.mLoopTermination = this.checkLoopTermination(unmodifiableTransFormula);
                this.mConcatFeasibility = TraceCheckResult.UNCHECKED;
                this.mLassoTermination = SynthesisResult.UNCHECKED;
                if (this.mLoopTermination == SynthesisResult.TERMINATING) {
                    this.mContinueDirective = ContinueDirective.REFINE_BOTH;
                    return;
                }
                this.mContinueDirective = ContinueDirective.REFINE_FINITE;
                return;
            }
            this.mConcatFeasibility = this.checkConcatFeasibility();
            if (this.mConcatFeasibility == TraceCheckResult.INFEASIBLE) {
                this.mLassoTermination = SynthesisResult.UNCHECKED;
                if (LassoCheck.this.mTryTwofoldRefinement) {
                    UnmodifiableTransFormula unmodifiableTransFormula = LassoCheck.this.computeLoopTF();
                    this.mLoopTermination = this.checkLoopTermination(unmodifiableTransFormula);
                    if (this.mLoopTermination == SynthesisResult.TERMINATING) {
                        this.mContinueDirective = ContinueDirective.REFINE_BOTH;
                        return;
                    }
                    this.mContinueDirective = ContinueDirective.REFINE_FINITE;
                    return;
                }
                this.mLoopTermination = SynthesisResult.UNCHECKED;
                this.mContinueDirective = ContinueDirective.REFINE_FINITE;
                return;
            }
            UnmodifiableTransFormula unmodifiableTransFormula = LassoCheck.this.computeLoopTF();
            this.mLoopTermination = this.checkLoopTermination(unmodifiableTransFormula);
            if (this.mLoopTermination == SynthesisResult.TERMINATING) {
                this.mLassoTermination = SynthesisResult.UNCHECKED;
                this.mContinueDirective = ContinueDirective.REFINE_BUCHI;
                return;
            }
            UnmodifiableTransFormula unmodifiableTransFormula2 = LassoCheck.this.computeStemTF();
            this.mLassoTermination = this.checkLassoTermination(unmodifiableTransFormula2, unmodifiableTransFormula);
            if (this.mLassoTermination == SynthesisResult.TERMINATING) {
                this.mContinueDirective = ContinueDirective.REFINE_BUCHI;
                return;
            }
            this.mContinueDirective = this.mLassoTermination == SynthesisResult.NONTERMINATING ? ContinueDirective.REPORT_NONTERMINATION : ContinueDirective.REPORT_UNKNOWN;
        }

        private TraceCheckResult checkStemFeasibility() {
            NestedRun nestedRun = LassoCheck.this.mCounterexample.getStem();
            if (BuchiAutomizerUtils.isEmptyStem(nestedRun)) {
                return TraceCheckResult.FEASIBLE;
            }
            LassoCheck.this.mStemCheck = this.checkFeasibilityAndComputeInterpolants(nestedRun, new SubtaskLassoCheckIdentifier(LassoCheck.this.mTaskIdentifier, LassoPart.STEM));
            return this.translateSatisfiabilityToFeasibility(LassoCheck.this.mStemCheck.getCounterexampleFeasibility());
        }

        private TraceCheckResult checkLoopFeasibility() {
            NestedRun nestedRun = LassoCheck.this.mCounterexample.getLoop();
            LassoCheck.this.mLoopCheck = this.checkFeasibilityAndComputeInterpolants(nestedRun, new SubtaskLassoCheckIdentifier(LassoCheck.this.mTaskIdentifier, LassoPart.LOOP));
            return this.translateSatisfiabilityToFeasibility(LassoCheck.this.mLoopCheck.getCounterexampleFeasibility());
        }

        private TraceCheckResult checkConcatFeasibility() {
            NestedRun nestedRun = LassoCheck.this.mCounterexample.getStem();
            NestedRun nestedRun2 = LassoCheck.this.mCounterexample.getLoop();
            NestedRun nestedRun3 = nestedRun.concatenate(nestedRun2);
            LassoCheck.this.mConcatCheck = this.checkFeasibilityAndComputeInterpolants(nestedRun3, new SubtaskLassoCheckIdentifier(LassoCheck.this.mTaskIdentifier, LassoPart.CONCAT));
            if (LassoCheck.this.mConcatCheck.getCounterexampleFeasibility() == Script.LBool.UNSAT) {
                LassoCheck.this.mConcatenatedCounterexample = nestedRun3.getWord();
            }
            return this.translateSatisfiabilityToFeasibility(LassoCheck.this.mConcatCheck.getCounterexampleFeasibility());
        }

        private TraceCheckResult translateSatisfiabilityToFeasibility(Script.LBool lBool) {
            return switch (lBool) {
                case Script.LBool.SAT -> TraceCheckResult.FEASIBLE;
                case Script.LBool.UNKNOWN -> TraceCheckResult.UNKNOWN;
                case Script.LBool.UNSAT -> TraceCheckResult.INFEASIBLE;
                default -> throw new MatchException(null, null);
            };
        }

        private IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> checkFeasibilityAndComputeInterpolants(NestedRun<L, IPredicate> nestedRun, TaskIdentifier taskIdentifier) {
            try {
                Counterexample counterexample = LassoCheck.this.mGetControlConfiguration == null ? new Counterexample((Word)nestedRun.getWord()) : new Counterexample((Word)nestedRun.getWord(), nestedRun.getStateSequence().stream().map(LassoCheck.this.mGetControlConfiguration).collect(Collectors.toList()));
                TraceAbstractionRefinementEngine.ITARefinementStrategy iTARefinementStrategy = LassoCheck.this.mRefinementStrategyFactory.constructStrategy(LassoCheck.this.mServices, counterexample, LassoCheck.this.mAbstraction, taskIdentifier, (IEmptyStackStateFactory)LassoCheck.this.mStateFactoryForInterpolantAutomaton, IPreconditionProvider.constructDefaultPreconditionProvider(), IPostconditionProvider.constructDefaultPostconditionProvider());
                TraceAbstractionRefinementEngine traceAbstractionRefinementEngine = new TraceAbstractionRefinementEngine(LassoCheck.this.mServices, LassoCheck.this.mLogger, iTARefinementStrategy);
                LassoCheck.this.mCegarStatistics.addRefinementEngineStatistics((IStatisticsDataProvider)traceAbstractionRefinementEngine.getRefinementEngineStatistics());
                return traceAbstractionRefinementEngine.getResult();
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                int n = new HistogramOfIterable((Iterable)nestedRun.getWord()).getMax();
                String string = "analyzing trace of length " + nestedRun.getLength() + " with TraceHistMax " + n;
                toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), string));
                throw toolchainCanceledException;
            }
        }

        private SynthesisResult checkLoopTermination(UnmodifiableTransFormula unmodifiableTransFormula) throws IOException {
            boolean bl = SmtUtils.containsArrayVariables((Term[])new Term[]{unmodifiableTransFormula.getFormula()});
            if (bl) {
                return SynthesisResult.UNKNOWN;
            }
            return LassoCheck.this.synthesize(false, null, unmodifiableTransFormula, bl);
        }

        private SynthesisResult checkLassoTermination(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) throws IOException {
            assert (unmodifiableTransFormula2 != null);
            boolean bl = SmtUtils.containsArrayVariables((Term[])new Term[]{unmodifiableTransFormula.getFormula()}) || SmtUtils.containsArrayVariables((Term[])new Term[]{unmodifiableTransFormula2.getFormula()});
            return LassoCheck.this.synthesize(true, unmodifiableTransFormula, unmodifiableTransFormula2, bl);
        }

        public TraceCheckResult getStemFeasibility() {
            return this.mStemFeasibility;
        }

        public TraceCheckResult getLoopFeasibility() {
            return this.mLoopFeasibility;
        }

        public TraceCheckResult getConcatFeasibility() {
            return this.mConcatFeasibility;
        }

        public SynthesisResult getLoopTermination() {
            return this.mLoopTermination;
        }

        public SynthesisResult getLassoTermination() {
            return this.mLassoTermination;
        }

        public ContinueDirective getContinueDirective() {
            return this.mContinueDirective;
        }
    }

    static enum LassoPart {
        STEM,
        LOOP,
        CONCAT;

    }

    private static class SubtaskLassoCheckIdentifier
    extends TaskIdentifier {
        private final LassoPart mLassoPart;

        public SubtaskLassoCheckIdentifier(TaskIdentifier taskIdentifier, LassoPart lassoPart) {
            super(taskIdentifier);
            this.mLassoPart = lassoPart;
        }

        protected String getSubtaskIdentifier() {
            return this.mLassoPart.toString();
        }
    }

    static enum SynthesisResult {
        TERMINATING,
        NONTERMINATING,
        UNKNOWN,
        UNCHECKED;

    }

    public static enum TraceCheckResult {
        FEASIBLE,
        INFEASIBLE,
        UNKNOWN,
        UNCHECKED;

    }
}

